package com.ibm.ims.dli;

/**
 * Object that represents the output from a Statistics (STAT) call.
 *
 */
public interface STATCallResult extends DLICallResult {

	/**
	 * Retrieves database statistics that can be used for performance
	 * monitoring.
	 * <p>
	 * For more details about the values returned by this method, see the topic
	 * <a href=
	 * "http://www.ibm.com/support/knowledgecenter/SSEPH2_14.1.0/com.ibm.ims14.doc.apr/ims_statcall.htm"
	 * target="_blank">STAT call</a> in the IMS Application Programming APIs
	 * reference documentation.
	 * 
	 * @return the database statistics.
	 */
	public String getStatistics();
}
