package com.ibm.ims.dli.converters;

import java.util.Collection;

import com.ibm.ims.dli.types.ConversionException;

/**
 * The <code>DoubleTypeConverter</code> interface is a converter for the Java
 * double data type.
 *
 */
public interface DoubleTypeConverter {

	/**
	 * Retrieves the designated double value from the input/output byte array.
	 * 
	 * @param ioArea
	 *            The input/output byte array to be read from
	 * @param start
	 *            The starting offset in the input/output byte array to read
	 *            from
	 * @param length
	 *            The number of bytes that will be read from the input/output
	 *            byte array
	 * @param warningStrings
	 *            The associated warnings for the conversion
	 * 
	 * @return the double value associated to the bytes in the input/output area
	 * @exception ConversionException
	 *                if the bytes could not be converted to a double
	 * 
	 * @deprecated length param is not needed
	 */
	public Double getDouble(byte[] ioArea, int start, int length, Collection<String> warningStrings)
			throws ConversionException;

	/**
	 * Sets the designated double value into the input/output byte array.
	 * 
	 * @param ioArea
	 *            The input/output byte array to be written to
	 * @param start
	 *            The starting offset in the input/output byte array to write to
	 * @param length
	 *            The number of bytes that will be written in the input/output
	 *            byte array
	 * @param object
	 *            The value of the double
	 * @param warningStrings
	 *            The associated warnings for the conversion
	 * 
	 * @exception ConversionException
	 *                if the double value could not be converted to bytes
	 * 
	 * @deprecated length param is not needed
	 */
	public void setDouble(byte[] ioArea, int start, int length, Double object, Collection<String> warningStrings)
			throws ConversionException;

	/**
	 * Retrieves the designated double value from the input/output byte array.
	 * 
	 * @param ioArea
	 *            The input/output byte array to be read from
	 * @param start
	 *            The starting offset in the input/output byte array to read
	 *            from
	 * @param warningStrings
	 *            The associated warnings for the conversion
	 * 
	 * @return the double value associated to the bytes in the input/output area
	 * @exception ConversionException
	 *                if the bytes could not be converted to a double
	 */
	public Double getDouble(byte[] ioArea, int start, Collection<String> warningStrings) throws ConversionException;

	/**
	 * Sets the designated double value into the input/output byte array.
	 * 
	 * @param ioArea
	 *            The input/output byte array to be written to
	 * @param start
	 *            The starting offset in the input/output byte array to write to
	 * @param object
	 *            The value of the double
	 * @param warningStrings
	 *            The associated warnings for the conversion
	 * 
	 * @exception ConversionException
	 *                if the double value could not be converted to bytes
	 */
	public void setDouble(byte[] ioArea, int start, Double object, Collection<String> warningStrings)
			throws ConversionException;
}
