package com.ibm.ims.dli.converters;

import java.util.Collection;

import com.ibm.ims.dli.types.ConversionException;

/**
 * The <code>ShortTypeConverter</code> interface is a converter for the Java
 * short data type.
 *
 */
public interface ShortTypeConverter {

	/**
	 * Retrieves the designated short value from the input/output byte array.
	 * 
	 * @param ioArea
	 *            The input/output byte array to be read from
	 * @param start
	 *            The starting offset in the input/output byte array to read
	 *            from
	 * @param length
	 *            The number of bytes that will be read from the input/output
	 *            byte array
	 * @param warningStrings
	 *            The associated warnings for the conversion
	 * 
	 * @return the short value associated to the bytes in the input/output area
	 * @exception ConversionException
	 *                if the bytes could not be converted to a short
	 * 
	 * @deprecated length param is not needed
	 */
	public Short getShort(byte[] ioArea, int start, int length, Collection<String> warningStrings)
			throws ConversionException;

	/**
	 * Sets the designated short value into the input/output byte array.
	 * 
	 * @param ioArea
	 *            The input/output byte array to be written to
	 * @param start
	 *            The starting offset in the input/output byte array to write to
	 * @param length
	 *            The number of bytes that will be written in the input/output
	 *            byte array
	 * @param object
	 *            The value of the short
	 * @param warningStrings
	 *            The associated warnings for the conversion
	 * 
	 * @exception ConversionException
	 *                if the short value could not be converted to bytes
	 * 
	 * @deprecated length param is not needed
	 */
	public void setShort(byte[] ioArea, int start, int length, Short object, Collection<String> warningStrings)
			throws ConversionException;

	/**
	 * Retrieves the designated short value from the input/output byte array.
	 * 
	 * @param ioArea
	 *            The input/output byte array to be read from
	 * @param start
	 *            The starting offset in the input/output byte array to read
	 *            from
	 * @param warningStrings
	 *            The associated warnings for the conversion
	 * 
	 * @return the short value associated to the bytes in the input/output area
	 * @exception ConversionException
	 *                if the bytes could not be converted to a short
	 */
	public Short getShort(byte[] ioArea, int start, Collection<String> warningStrings) throws ConversionException;

	/**
	 * Sets the designated short value into the input/output byte array.
	 * 
	 * @param ioArea
	 *            The input/output byte array to be written to
	 * @param start
	 *            The starting offset in the input/output byte array to write to
	 * @param object
	 *            The value of the short
	 * @param warningStrings
	 *            The associated warnings for the conversion
	 * 
	 * @exception ConversionException
	 *                if the short value could not be converted to bytes
	 */
	public void setShort(byte[] ioArea, int start, Short object, Collection<String> warningStrings)
			throws ConversionException;
}
