package com.ibm.ims.dli.converters;

import java.util.Collection;

import com.ibm.ims.dli.types.ConversionException;

public interface UByteTypeConverter {

	/**
	 * Retrieves the designated unsigned byte value from the input/output byte
	 * array as a integer.
	 * 
	 * @param ioArea
	 *            The input/output byte array to be read from
	 * @param start
	 *            The starting offset in the input/output byte array to read
	 *            from
	 * @param warningStrings
	 *            The associated warnings for the conversion
	 * 
	 * @return the short value representing the unsigned byte value associated
	 *         to the bytes in the input/output area
	 * @exception ConversionException
	 *                if the bytes could not be converted to a integer
	 */
	public Short getShortFromUByte(byte[] ioArea, int start, Collection<String> warningStrings)
			throws ConversionException;

	/**
	 * Sets the designated signed byte value into the input/output byte array as
	 * an unsigned byte
	 * 
	 * @param ioArea
	 *            The input/output byte array to be written to
	 * @param start
	 *            The starting offset in the input/output byte array to write to
	 * @param object
	 *            The value of the byte
	 * @param warningStrings
	 *            The associated warnings for the conversion
	 * 
	 * @exception ConversionException
	 *                if the byte value could not be converted to bytes or if
	 *                there are data integrity issues
	 */
	public void setUByte(byte[] ioArea, int start, Byte object, Collection<String> warningStrings)
			throws ConversionException;

	/**
	 * Sets the designated signed short value into the input/output byte array
	 * as an unsigned byte
	 * 
	 * @param ioArea
	 *            The input/output byte array to be written to
	 * @param start
	 *            The starting offset in the input/output byte array to write to
	 * @param object
	 *            The value of the byte
	 * @param warningStrings
	 *            The associated warnings for the conversion
	 * 
	 * @exception ConversionException
	 *                if the byte value could not be converted to bytes or if
	 *                there are data integrity issues
	 */
	public void setUByte(byte[] ioArea, int start, Short object, Collection<String> warningStrings)
			throws ConversionException;
}
