package com.ibm.ims.dli.tm;

/**
 * The <code>MessageDestinationSpec</code> class stores message destination data attributes
 * for routing messages.  These data attributes includes the message destination transaction or LTERM name, 
 * the MFS message output descriptor (MOD) name, and the alternate PCB name. 
 * <p>To specify how messages are routed, you must set these values in the client application when inserting 
 * a message in the message queue. 
 * <p>
 * An alternate PCB can be of two types: fixed or modifiable.  For a fixed alternate PCB, the 
 * message destination (LTERM or transaction) is defined in the PSB source itself and cannot be changed.  
 * For a modifiable alternate PCB, set the message destination by using the {@link MessageDestinationSpec#setDestination(String)} method.  
 * To change the message destination, use the {@link MessageDestinationSpec#setAlternatePCBName(String)} method.
 * <p>The MOD is an MFS output message format descriptor that defines the structure of the output fields.  
 * To change the MOD name, use the {@link MessageDestinationSpec#setMODName(String)} method.
 * 
 */
public class MessageDestinationSpec {

    final static String IOPCB = "IOPCB   ";

    final static String DEFINED_DESTINATION = null;

    final static String NO_MOD_NAME = null;

    private String alternatePCBName = null;

    private String definedDestination = null;

    private String modName = null;

    /**
     * Sets the name of the alternate PCB.
     * 
     * @param alternatePCBName
     *            the name of the alternate PCB
     */
    public void setAlternatePCBName(String alternatePCBName) {
        this.alternatePCBName = alternatePCBName;
    }

    /**
     * Retrieves the name of the alternate PCB.
     * 
     * @return the name of the alternate PCB
     */
    public String getAlternatePCBName() {
        return this.alternatePCBName;
    }

    /**
     * Sets the destination to route the message to. This is either the LTERM
     * name or the transaction name. Use this method only to change the message destination
     * for a modifiable alternate PCB.  
     * 
     * @param definedDestination
     *            the name of the destination
     */
    public void setDestination(String definedDestination) {
        this.definedDestination = definedDestination;
    }

    /**
     * Retrieves the defined destination to route the message to.
     * 
     * @return the defined destination (LTERM or transaction) name
     */
    public String getDefinedDestination() {
        return this.definedDestination;
    }

    /**
     * 
     * Sets the message output descriptor (MOD) name. Use this method to change the MFS message
     * output descriptor to format the output message content.
     * 
     * @param MODName
     *            the message output descriptor name
     */
    public void setMODName(String MODName) {
        this.modName = MODName;
    }

    /**
     * Retrieves the message output descriptor (MOD) name.
     * 
     * @return MODName the message output descriptor name
     */
    public String getMODName() {
        return this.modName;
    }
}
