/*
 * Decompiled with CFR 0.152.
 */
package com.informix.stream.cdc;

import com.informix.jdbc.ComplexTypeParser;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.stream.api.IfmxStreamRecord;
import com.informix.stream.api.IfmxStreamRecordType;
import com.informix.stream.cdc.records.IfxCDCBeginTransactionRecord;
import com.informix.stream.cdc.records.IfxCDCCommitTransactionRecord;
import com.informix.stream.cdc.records.IfxCDCErrorRecord;
import com.informix.stream.cdc.records.IfxCDCMetaDataRecord;
import com.informix.stream.cdc.records.IfxCDCOperationRecord;
import com.informix.stream.cdc.records.IfxCDCRollbackTransactionRecord;
import com.informix.stream.cdc.records.IfxCDCTimeoutRecord;
import com.informix.stream.cdc.records.IfxCDCTruncateRecord;
import com.informix.stream.impl.IfxStreamException;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IfxCDCRecordBuilder
implements AutoCloseable {
    private final Logger logger = LoggerFactory.getLogger(IfxCDCRecordBuilder.class);
    private final Connection con;
    private final Map<String, List<IfxColumnInfo>> columnMap = new HashMap<String, List<IfxColumnInfo>>();

    public IfxCDCRecordBuilder(Connection c) {
        this.con = c;
    }

    public IfmxStreamRecord buildRecord(byte[] bytes) throws SQLException, IfxStreamException {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int headerSize = buffer.getInt() - 16;
        int payloadSize = buffer.getInt();
        buffer.getInt();
        int recordType = buffer.getInt();
        byte[] header = new byte[headerSize];
        byte[] payload = new byte[payloadSize];
        buffer.get(header);
        buffer.get(payload);
        this.logger.trace("Record type [{}]", (Object)recordType);
        switch (recordType) {
            case 200: {
                ArrayList<IfxColumnInfo> columns = new ArrayList<IfxColumnInfo>();
                ComplexTypeParser parser = new ComplexTypeParser((IfxConnection)this.con);
                Vector c = parser.parseTypeInfo("row(" + new String(payload).trim() + ")");
                IfxColumnInfo info = (IfxColumnInfo)c.get(0);
                columns.addAll(info.getChildren());
                IfxCDCMetaDataRecord record = new IfxCDCMetaDataRecord(columns, header);
                this.columnMap.put(record.getLabel(), columns);
                return record;
            }
            case 40: {
                return new IfxCDCOperationRecord(IfmxStreamRecordType.INSERT, header, payload, this.columnMap, this.con);
            }
            case 43: {
                return new IfxCDCOperationRecord(IfmxStreamRecordType.AFTER_UPDATE, header, payload, this.columnMap, this.con);
            }
            case 42: {
                return new IfxCDCOperationRecord(IfmxStreamRecordType.BEFORE_UPDATE, header, payload, this.columnMap, this.con);
            }
            case 41: {
                return new IfxCDCOperationRecord(IfmxStreamRecordType.DELETE, header, payload, this.columnMap, this.con);
            }
            case 1: {
                return new IfxCDCBeginTransactionRecord(header);
            }
            case 2: {
                return new IfxCDCCommitTransactionRecord(header);
            }
            case 3: {
                return new IfxCDCRollbackTransactionRecord(header);
            }
            case 201: {
                return new IfxCDCTimeoutRecord(header);
            }
            case 119: {
                return new IfxCDCTruncateRecord(header);
            }
            case 202: {
                return new IfxCDCErrorRecord(header);
            }
        }
        throw new IfxStreamException("Record type:" + recordType + " not defined.");
    }

    @Override
    public void close() throws SQLException {
        this.con.close();
    }
}

