/*
 * Decompiled with CFR 0.152.
 */
package com.informix.stream.cdc.records;

import com.informix.jdbc.IfmxReadableType;
import com.informix.jdbc.IfxBigInt;
import com.informix.jdbc.IfxBoolean;
import com.informix.jdbc.IfxChar;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDate;
import com.informix.jdbc.IfxDateTime;
import com.informix.jdbc.IfxDecimal;
import com.informix.jdbc.IfxFloat;
import com.informix.jdbc.IfxInteger;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxLvarchar;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxSmBlob;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxValue;
import com.informix.jdbc.IfxVarChar;
import com.informix.stream.api.IfmxStreamOperationRecord;
import com.informix.stream.api.IfmxStreamRecordType;
import com.informix.stream.cdc.records.IfxCDCRecord;
import com.informix.stream.impl.IfxStreamException;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IfxCDCOperationRecord
extends IfxCDCRecord
implements IfmxStreamOperationRecord {
    private final Logger logger = LoggerFactory.getLogger(IfxCDCOperationRecord.class);
    private final byte[] buffer;
    private final List<IfxColumnInfo> columns;
    private final Connection con;
    private final Map<String, IfmxReadableType> objects = new LinkedHashMap<String, IfmxReadableType>();

    public IfxCDCOperationRecord(IfmxStreamRecordType type, byte[] header, byte[] buffer, Map<String, List<IfxColumnInfo>> columns, Connection con) {
        super(type);
        this.buffer = buffer;
        this.con = con;
        ByteBuffer headerBuffer = ByteBuffer.wrap(header);
        this.sequence = headerBuffer.getLong();
        this.transaction = headerBuffer.getInt();
        this.label = Integer.toString(headerBuffer.getInt());
        this.columns = columns.get(this.label);
        this.logger.debug("New IfxCDCOperationRecord created. Label: {}", (Object)this.label);
    }

    @Override
    public synchronized Map<String, IfmxReadableType> getData() throws IfxStreamException {
        if (!this.objects.isEmpty()) {
            return this.objects;
        }
        try {
            int offset = 0;
            for (IfxColumnInfo column : this.columns) {
                IfxObject o = IfxValue.makeInstance((IfxConnection)((IfxSqliConnect)this.con), (IfxColumnInfo)column);
                this.logger.debug("Column type: {}", (Object)o.getClass().getSimpleName());
                if (o instanceof IfxInteger || o instanceof IfxDate) {
                    o.fromIfx(this.buffer, offset, 4);
                    offset += 4;
                } else if (o instanceof IfxChar) {
                    int colLength = column.getColumnLength();
                    o.fromIfx(this.buffer, offset, colLength);
                    offset += colLength;
                } else if (o instanceof IfxLvarchar) {
                    o.fromIfx(this.buffer);
                } else if (o instanceof IfxVarChar) {
                    byte varcharLength = this.buffer[offset];
                    o.fromIfx(this.buffer, offset, (int)varcharLength);
                    offset += varcharLength + 1;
                } else if (o instanceof IfxBigInt || o instanceof IfxFloat) {
                    o.fromIfx(this.buffer, offset, 8);
                    offset += 8;
                } else if (o instanceof IfxDecimal) {
                    short encodedLength = (short)column.getColumnLength();
                    int length = ((encodedLength >> 8 & 0xFF) + (encodedLength & 0xFF & 1) + 3) / 2 - 1 + 1;
                    o.fromIfx(this.buffer, offset, length, encodedLength);
                    offset += length;
                } else if (o instanceof IfxDateTime) {
                    o.fromIfx(this.buffer, offset, column.getNumberOfBytes(), (short)column.getColumnLength());
                    offset += column.getNumberOfBytes();
                } else if (o instanceof IfxBoolean) {
                    ((IfxBoolean)o).fromIfx(this.buffer, offset);
                    offset += 2;
                } else if (o instanceof IfxSmBlob) {
                    byte[] locBytes = new byte[72];
                    System.arraycopy(this.buffer, offset + 4, locBytes, 0, 72);
                    o = new IfxSmBlob((IfxConnection)this.con, new IfxLocator(locBytes, this.con));
                    offset += 76;
                } else {
                    this.logger.error("Unsupported type: {}", (Object)column);
                }
                this.objects.put(column.getColumnName(), (IfmxReadableType)o);
            }
        }
        catch (Exception e) {
            throw new IfxStreamException("Error parsing operation bytes", e);
        }
        return this.objects;
    }

    @Override
    public boolean hasOperationData() {
        return true;
    }
}

