/*
 * Decompiled with CFR 0.152.
 */
package com.informix.stream.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class ChangeStreamVersion {
    private final int majorVersion;
    private final int minorVersion;
    private final int serviceVersion;
    private final Date buildDate;
    private final int buildNumber;
    private final int betaVersion;
    private final String commit;
    private final String supportVersion;

    public static void main(String[] args) throws IOException, ParseException {
        System.out.println(new ChangeStreamVersion().getVersionAsString() + "\n");
    }

    public ChangeStreamVersion() throws IOException, ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        int major = 1;
        int minor = 0;
        int service = 0;
        int build = 0;
        int beta = 0;
        Date date = null;
        String commitLine = "";
        String supportVersionId = "";
        Properties p = new Properties();
        URL url = ChangeStreamVersion.class.getClassLoader().getResource("com/informix/stream/ifx-changestream-version.properties");
        if (url != null) {
            try (InputStream is = ChangeStreamVersion.class.getClassLoader().getResource("com/informix/stream/ifx-changestream-version.properties").openStream();){
                String[] versionSplit;
                p.load(is);
                String version = p.getProperty("version", "-1.-1.-1");
                if (version.indexOf(45) > -1) {
                    version = version.substring(0, version.indexOf(45));
                }
                if ((versionSplit = version.split("\\.")).length != 3) {
                    throw new ParseException("Invalid version string '" + version + "'", 0);
                }
                major = Integer.parseInt(versionSplit[0]);
                minor = Integer.parseInt(versionSplit[1]);
                service = Integer.parseInt(versionSplit[2]);
                date = dateFormat.parse(p.getProperty("build-date"));
                build = Integer.parseInt(p.getProperty("build-number", "0"));
                beta = Integer.parseInt(p.getProperty("beta-version", "0"));
                commitLine = p.getProperty("commit", "");
                supportVersionId = p.getProperty("support-version", "");
            }
        }
        this.majorVersion = major;
        this.minorVersion = minor;
        this.serviceVersion = service;
        this.buildDate = date;
        this.buildNumber = build;
        this.betaVersion = beta;
        this.commit = commitLine;
        this.supportVersion = supportVersionId;
    }

    public String getVersionAsString() {
        StringBuilder sb = new StringBuilder("Informix changestream client\n");
        sb.append("Build-Version: " + this.majorVersion + '.' + this.minorVersion + '.' + this.serviceVersion + '\n');
        sb.append("Build-Number: " + this.buildNumber + '\n');
        sb.append("Build-Date: " + (this.buildDate == null ? "" : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(this.buildDate)) + '\n');
        if (this.betaVersion > 0) {
            sb.append("Beta-Version: " + this.betaVersion + '\n');
        }
        if (!this.supportVersion.isEmpty()) {
            sb.append("Support-Version: " + this.supportVersion + '\n');
        }
        if (!this.commit.isEmpty()) {
            sb.append("Commit: " + this.commit);
        }
        return sb.toString().trim();
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getServiceVersion() {
        return this.serviceVersion;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public Date getBuildDate() {
        return this.buildDate;
    }
}

