/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import com.informix.asf.ASFException;
import com.informix.asf.ConnectionHeaders;
import com.informix.asf.IfxDataInputStream;
import com.informix.asf.IfxDataOutputStream;
import com.informix.asf.IfxDebugDataInputStream;
import com.informix.asf.IfxDebugDataOutputStream;
import com.informix.asf.JnsObject;
import com.informix.asf.SqliDbg;
import com.informix.jdbcx.AbstractDataSource;
import com.informix.jns.ServerGroup;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.lang.Messages;
import com.informix.util.AdvancedUppercaseProperties;
import com.informix.util.JdbcLogger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class Connection {
    private static final JdbcLogger log = JdbcLogger.getLogger(Connection.class);
    private static final short SQ_EXIT = 56;
    private static final short SQ_EOT = 12;
    private static final short SQ_XACTSTAT = 99;
    private static final short SQ_ASSOC = 100;
    private static final short SQ_ASCBINARY = 101;
    private static final short SQ_ASCINITRESP = 102;
    private static final short SQ_ASCDBLIST = 103;
    private static final short SQ_ASCBPARMS = 108;
    private static final short SQ_ASCEOT = 127;
    private static final short SL_PROT_SQLI_0600 = 60;
    private static final short SLTYPE_CONREQ = 1;
    private static final short SLTYPE_CONACC = 2;
    private static final short SLTYPE_CONREJ = 3;
    private static final short SLTYPE_REDIRECT = 13;
    private static final int STREAM_BUF_SIZE = 4096;
    private static final int PFCONREQ_BUF_SIZE = 2048;
    private static final int SL_HEADER_SIZE = 6;
    private String redSrvDetail = null;
    private final boolean SSLconnection;
    private final boolean sslCertificateVerification;
    private String[] sslProtocols = null;
    private Socket asfSocket = null;
    private InputStream asfSocketIs = null;
    private OutputStream asfSocketOs = null;
    private IfxDataInputStream asfIfxIs = null;
    private IfxDataOutputStream asfIfxOs = null;
    private String sqliFile;
    public SqliDbg sqliTrace = null;
    private final String ClientLocale;
    public String VersionNumber = null;
    public int Cap_1;
    public int Cap_2;
    public int Cap_3;
    public short Warnings = 0;
    private short svcError;
    private short osError;
    private String errMsg = "";
    private int retryCount = 0;
    private String ipAddr = null;
    private String portNo = null;
    private int PortNumber = 0;
    private ServerGroup myGroup = null;
    private boolean sqlhGroup = false;
    private boolean isTrustedContext = false;
    private final AdvancedUppercaseProperties optProps;
    private String servername = "";
    private int socTimeout = 0;
    private boolean socKeepAlive = false;
    private boolean encoption = false;
    private final int socketConnectionTimeout;
    private final AbstractDataSource userProperties;

    public Connection(ConnectionHeaders.ConnectionTarget ct, String dbname, AdvancedUppercaseProperties envlist, int retryCount, AbstractDataSource userProperties) throws SQLException {
        long startTime = System.currentTimeMillis();
        this.userProperties = userProperties;
        this.optProps = userProperties;
        this.retryCount = retryCount;
        this.encoption = this.optProps.asBool("replaceUnmappableCharacterSequences");
        this.isTrustedContext = this.optProps.asBool("trustedContext");
        this.SSLconnection = this.optProps.asBool("encrypt");
        this.sslCertificateVerification = this.optProps.asBool("certificateVerification");
        this.sslProtocols = this.optProps.getProperty("encryptionProtocols").split(",");
        for (int i = 0; i < this.sslProtocols.length; ++i) {
            this.sslProtocols[i] = this.sslProtocols[i].trim();
        }
        this.socketConnectionTimeout = this.optProps.asInt("loginTimeout", "0");
        this.ClientLocale = envlist.getProperty("CLIENT_LOCALE");
        this.socTimeout = this.optProps.asInt("socketTimeout", "0");
        this.servername = ct.serverName;
        this.socKeepAlive = this.optProps.asBool("socketKeepalive", false);
        this.sqliFile = this.optProps.getProperty("protocolTraceFile");
        this.prepareIP_PortInfo(ct.host, ct.port);
        if (this.sqlhGroup) {
            this.connectToPrimary(dbname, envlist, this.servername);
        } else {
            this.connect(this.servername, dbname, envlist);
        }
        if (log.isDebugEnabled()) {
            log.debug("Connection established: {} ms", System.currentTimeMillis() - startTime);
        }
    }

    private void connect(String serverName, String dbname, Properties envlist) throws SQLException {
        try {
            this.openSocket();
            this.establishConnection(this.servername, dbname, envlist);
        }
        catch (SQLException e) {
            this.disconnectAbortive();
            throw e;
        }
        catch (Exception e) {
            this.disconnectAbortive();
            throw new ASFException("An unexpected error occurred", e);
        }
    }

    public synchronized void sOOBSocket() throws ASFException {
        int MSG_OOB = 66;
        if (null == this.asfSocket) {
            return;
        }
        try {
            this.asfSocket.sendUrgentData(MSG_OOB);
        }
        catch (IOException e) {
            throw Messages.getLocASFException(-908, this.getAddress(), this.ClientLocale, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnectOrderly() throws ASFException {
        try {
            short lastbyte = 0;
            if (null == this.asfSocket) {
                return;
            }
            byte[] b = JavaToIfxType.JavaToIfxSmallInt((short)56);
            try {
                this.asfIfxOs.write(b);
                this.asfIfxOs.flush();
                if (this.sqliTrace != null) {
                    this.sqliTrace.recordC2S();
                }
            }
            catch (IOException e) {
                throw Messages.getLocASFException(-908, this.getAddress(), this.ClientLocale, e);
            }
            this.asfIfxIs.read(b);
            lastbyte = IfxToJavaType.IfxToJavaSmallInt(b);
            while (lastbyte == 99) {
                lastbyte = this.asfIfxIs.readSmallInt();
                lastbyte = this.asfIfxIs.readSmallInt();
                lastbyte = this.asfIfxIs.readSmallInt();
                this.asfIfxIs.read(b);
                lastbyte = IfxToJavaType.IfxToJavaSmallInt(b);
            }
            if (lastbyte != 56 && lastbyte != 12) {
                throw Messages.getLocASFException(-408, this.ClientLocale);
            }
            if (this.sqliTrace != null) {
                this.sqliTrace.recordS2C();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.disconnect();
        }
    }

    public synchronized void disconnectAbortive() throws ASFException {
        if (null == this.asfSocket) {
            return;
        }
        try {
            if (this.asfIfxOs != null) {
                this.asfIfxOs.flush();
            }
            if (this.sqliTrace != null) {
                this.sqliTrace.recordC2S();
            }
        }
        catch (IOException e) {
            throw Messages.getLocASFException(-908, this.getAddress(), this.ClientLocale, e);
        }
        finally {
            this.disconnect();
        }
    }

    public IfxDataInputStream getIfxDataInputStream() {
        return this.asfIfxIs;
    }

    public IfxDataOutputStream getIfxDataOutputStream() {
        return this.asfIfxOs;
    }

    private void sendConnectionRequest(String servername, String dbname, Properties envlist) throws IOException, SQLException {
        ByteArrayOutputStream pfByteArrayOs = new ByteArrayOutputStream(2048);
        ByteArrayOutputStream slByteArrayOs = new ByteArrayOutputStream(6);
        ConnectionHeaders.encodeAscBinary(new IfxDataOutputStream(pfByteArrayOs), this.userProperties, servername, dbname, envlist);
        ConnectionHeaders.encodeSLheader(new IfxDataOutputStream(slByteArrayOs), pfByteArrayOs.size(), 1, 60, 0);
        slByteArrayOs.writeTo(this.asfIfxOs);
        this.asfIfxOs.writeWithMangledTrace(pfByteArrayOs.toByteArray());
        this.asfIfxOs.flush();
        if (this.sqliTrace != null) {
            this.sqliTrace.clearC2S();
        }
    }

    private void recvConnectionResponse() throws IOException, SQLException {
        byte[] byteArrayInput = new byte[4096];
        IfxDataInputStream in = null;
        short length = this.asfIfxIs.readShort();
        this.asfIfxIs.read(byteArrayInput, 0, length - 2);
        in = new IfxDataInputStream(new ByteArrayInputStream(byteArrayInput));
        byte SLType = in.readByte();
        switch (SLType) {
            case 2: {
                in.skipBytes(3);
                short junk = in.readShort();
                if (100 != junk || 101 != (junk = in.readShort())) break;
                this.DecodeAscBinary(in);
                if (this.sqliTrace != null) {
                    this.sqliTrace.clearS2C();
                }
                return;
            }
            case 3: {
                in.skipBytes(3);
                short junk = in.readShort();
                if (100 != junk) {
                    if (this.sqliTrace == null) break;
                    this.sqliTrace.recordS2C();
                    break;
                }
                junk = in.readShort();
                if (101 != junk) {
                    if (this.sqliTrace == null) break;
                    this.sqliTrace.recordS2C();
                    break;
                }
                this.DecodeAscBinary(in);
                if (this.svcError == 0) break;
                SQLException e = Messages.getSQLException((int)this.svcError, this.userProperties.asString("user"));
                if (this.osError != 0) {
                    e.initCause(new ASFException((int)this.svcError, this.osError, this.errMsg));
                }
                throw e;
            }
            case 13: {
                in.skipBytes(3);
                short lredJunk = in.readShort();
                if (100 != lredJunk || 101 != (lredJunk = in.readShort())) break;
                this.DecodeAscBinary(in);
                if (this.sqliTrace != null) {
                    this.sqliTrace.recordS2C();
                }
                throw new ASFException(-79998, this.redSrvDetail);
            }
        }
        throw Messages.getLocASFException(-408, this.ClientLocale);
    }

    private void disconnect() {
        if (this.asfIfxIs != null) {
            try {
                this.asfIfxIs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.asfIfxOs != null) {
            try {
                this.asfIfxOs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.asfSocketIs != null) {
            try {
                this.asfSocketIs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.asfSocketOs != null) {
            try {
                this.asfSocketOs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.asfSocket != null) {
            try {
                this.asfSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.sqliTrace != null) {
            this.sqliTrace.close();
        }
        this.asfIfxIs = null;
        this.asfIfxOs = null;
        this.asfSocketIs = null;
        this.asfSocketOs = null;
        this.asfSocket = null;
    }

    private void DecodeAscBinary(IfxDataInputStream in) throws IOException, ASFException {
        byte[] Tempbyte = new byte[4096];
        in.skipBytes(4);
        short length = in.readShort();
        in.skipBytes(length);
        short junk = in.readShort();
        if (108 != junk) {
            throw Messages.getLocASFException(-408, this.ClientLocale);
        }
        in.skipBytes(12);
        junk = in.readShort();
        in.readFully(Tempbyte, 0, junk);
        this.VersionNumber = IfxToJavaType.IfxToJavaChar(Tempbyte, false);
        int index95 = this.VersionNumber.indexOf("9.5");
        if (this.VersionNumber.indexOf("9.50") > 0) {
            String newVersion;
            this.VersionNumber = newVersion = this.VersionNumber.substring(0, index95) + "10.00" + this.VersionNumber.substring(index95 + 4);
        }
        junk = in.readShort();
        in.readFully(Tempbyte, 0, junk);
        junk = in.readShort();
        in.readFully(Tempbyte, 0, junk);
        this.Cap_1 = in.readInt();
        this.Cap_2 = in.readInt();
        this.Cap_3 = in.readInt();
        in.skipBytes(2);
        junk = in.readShort();
        if (junk > 0) {
            in.skipBytes(junk);
        }
        if ((junk = in.readShort()) > 0) {
            in.skipBytes(junk);
        }
        in.skipBytes(24);
        junk = in.readShort();
        switch (junk) {
            case 102: {
                short offset;
                in.skipBytes(6);
                this.svcError = in.readShort();
                this.osError = in.readShort();
                this.Warnings = in.readShort();
                int numErrors = in.readShort();
                if (numErrors < 0) break;
                for (int i = 0; i < numErrors && (offset = in.readShort()) >= 0; ++i) {
                    this.errMsg = in.readChar();
                }
                return;
            }
            case 103: {
                junk = in.readShort();
                this.redSrvDetail = in.readChar();
                return;
            }
            case 127: {
                return;
            }
        }
        throw Messages.getLocASFException(-408, this.ClientLocale);
    }

    private void establishConnection(String srvrname, String dbname, Properties envlist) throws SQLException {
        try {
            this.sendConnectionRequest(srvrname, dbname, envlist);
            this.recvConnectionResponse();
        }
        catch (IOException e) {
            this.disconnect();
            throw Messages.getAsfException(-908, this.getAddress(), e);
        }
        catch (SQLException e) {
            this.disconnect();
            throw e;
        }
    }

    private String getAddress() {
        StringBuilder sb = new StringBuilder();
        if (!this.servername.isEmpty()) {
            sb.append(this.servername);
            sb.append("@");
        }
        sb.append(this.ipAddr + ":" + this.portNo);
        return sb.toString();
    }

    private void openSocket() throws SQLException {
        for (int retryNumber = 0; retryNumber <= this.retryCount; ++retryNumber) {
            try {
                this.asfSocket = null;
                if (this.SSLconnection) {
                    log.debug("Encrypted connection");
                    String FIPS = System.getProperty("com.ibm.jsse2.JSSEFIPS");
                    String javaVendor = System.getProperty("java.vendor");
                    String sslTrustStorePassword = this.userProperties.asString("SSL_TRUSTSTORE_PASSWORD", this.userProperties.asString("trustStorePassword", System.getProperty("javax.net.ssl.trustStorePassword")));
                    String sslTrustStoreLocation = this.userProperties.asString("SSL_TRUSTSTORE", this.userProperties.asString("trustStore", System.getProperty("javax.net.ssl.trustStore")));
                    if (sslTrustStoreLocation == null) {
                        SSLSocketFactory sslsocketfactory;
                        if (this.sslCertificateVerification) {
                            sslsocketfactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                        } else {
                            SSLContext sslContext = SSLContext.getInstance("TLS");
                            SSLContext.getDefault();
                            TrustManager[] allTrustingTrustManager = new TrustManager[]{new X509TrustManager(){

                                @Override
                                public X509Certificate[] getAcceptedIssuers() {
                                    return new X509Certificate[0];
                                }

                                @Override
                                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                                }

                                @Override
                                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                                }
                            }};
                            sslContext.init(null, allTrustingTrustManager, new SecureRandom());
                            sslsocketfactory = sslContext.getSocketFactory();
                        }
                        SSLSocket sslSocket = (SSLSocket)sslsocketfactory.createSocket();
                        this.asfSocket = sslSocket;
                        if (javaVendor != null && javaVendor.substring(0, 3).equalsIgnoreCase("IBM")) {
                            String[] protocol = new String[]{FIPS != null && FIPS.equalsIgnoreCase("TRUE") ? "TLS" : "SSL_TLS"};
                            sslSocket.setEnabledProtocols(this.getSupportedSSLProtocols(protocol));
                        } else {
                            sslSocket.setEnabledProtocols(this.getSupportedSSLProtocols(sslSocket.getSupportedProtocols()));
                        }
                    } else {
                        try {
                            SSLContext sslContext = null;
                            sslContext = javaVendor != null && javaVendor.substring(0, 3).equalsIgnoreCase("IBM") ? (FIPS != null && FIPS.equalsIgnoreCase("TRUE") ? SSLContext.getInstance("TLS") : SSLContext.getInstance("SSL_TLS")) : SSLContext.getInstance("SSL");
                            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                            char[] passwordCharArray = null;
                            if (sslTrustStorePassword != null) {
                                passwordCharArray = sslTrustStorePassword.toCharArray();
                            }
                            ks.load(new FileInputStream(sslTrustStoreLocation), passwordCharArray);
                            String algorithm = TrustManagerFactory.getDefaultAlgorithm();
                            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                            tmf.init(ks);
                            TrustManager[] tm = tmf.getTrustManagers();
                            sslContext.init(null, tm, null);
                            SSLSocketFactory sslsocketfactory = sslContext.getSocketFactory();
                            SSLSocket sslSocket = (SSLSocket)sslsocketfactory.createSocket();
                            this.asfSocket = sslSocket;
                            sslSocket.setEnabledProtocols(this.getSupportedSSLProtocols(sslSocket.getSupportedProtocols()));
                        }
                        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                            throw Messages.getSQLException(e, -28014);
                        }
                    }
                }
                if (this.asfSocket == null) {
                    log.debug("Unencrypted connection");
                    this.asfSocket = new Socket();
                }
                InetSocketAddress inetSocketAddress = new InetSocketAddress(this.ipAddr, this.PortNumber);
                this.asfSocket.connect(inetSocketAddress, this.socketConnectionTimeout);
                if (this.socTimeout > 0) {
                    this.asfSocket.setSoTimeout(this.socTimeout);
                }
                this.asfSocket.setTcpNoDelay(true);
                this.asfSocket.setKeepAlive(this.socKeepAlive);
                break;
            }
            catch (Exception e) {
                if (retryNumber < this.retryCount) {
                    if (!this.sqlhGroup) continue;
                    this.getServerInfoFromSqlhost();
                    continue;
                }
                throw Messages.getSQLException((Throwable)e, -908, this.getAddress());
            }
        }
        try {
            this.asfSocketIs = this.asfSocket.getInputStream();
            this.asfSocketOs = this.asfSocket.getOutputStream();
            BufferedInputStream asfBufIs = new BufferedInputStream(this.asfSocketIs);
            BufferedOutputStream asfBufOs = new BufferedOutputStream(this.asfSocketOs, 4096);
            if (this.sqliFile == null) {
                this.asfIfxIs = new IfxDataInputStream(asfBufIs, this.encoption);
                this.asfIfxOs = new IfxDataOutputStream(asfBufOs, this.encoption);
            } else {
                this.asfIfxIs = new IfxDebugDataInputStream(asfBufIs, this.encoption);
                this.asfIfxOs = new IfxDebugDataOutputStream(asfBufOs, this.encoption);
                this.sqliTrace = new SqliDbg((IfxDebugDataInputStream)this.asfIfxIs, (IfxDebugDataOutputStream)this.asfIfxOs, this.sqliFile);
            }
        }
        catch (IOException e) {
            this.disconnect();
            throw Messages.getAsfException(-908, this.servername, e);
        }
    }

    private void prepareIP_PortInfo(String host, String port) throws SQLException {
        if (this.userProperties.containsKey("sqlHostPath")) {
            this.getServerInfoFromSqlhost();
        } else {
            this.ipAddr = host;
            this.portNo = port;
            this.PortNumber = Integer.parseInt(this.portNo);
        }
    }

    private void getServerInfoFromSqlhost() throws SQLException {
        if (this.sqlhGroup && this.myGroup.hasMoreElements()) {
            this.servername = this.myGroup.nextElement();
        }
        JnsObject jnsobj = new JnsObject();
        jnsobj.JnsLookup(this.servername, this.optProps);
        this.ipAddr = jnsobj.getIPAddr();
        this.portNo = jnsobj.getPortNo();
        this.PortNumber = jnsobj.getPortNumber();
        if (this.myGroup == null) {
            this.myGroup = jnsobj.getServerGroup();
            if (this.myGroup != null) {
                this.servername = jnsobj.getServerName();
                this.retryCount = jnsobj.getGroupCount();
                this.sqlhGroup = true;
            }
        }
    }

    private void connectToPrimary(String dbname, Properties envlist, String groupName) throws SQLException {
        int sqlcode = 0;
        do {
            try {
                log.debug("Trying connection to [{}:{}]", (Object)this.ipAddr, (Object)this.portNo);
                sqlcode = 0;
                this.connect(this.servername, dbname, envlist);
            }
            catch (SQLException ex) {
                sqlcode = ex.getErrorCode();
                this.sqlhGroup = false;
                if (sqlcode == -79998) {
                    log.debug("Redirect detected");
                    this.processGroupRedirectRequest(ex.toString());
                    continue;
                }
                if (this.myGroup.hasMoreElements()) {
                    log.error("Error establishing connection, trying next server.", ex);
                    this.sqlhGroup = true;
                    this.getServerInfoFromSqlhost();
                    continue;
                }
                log.error("Error establishing connection to servers in the group.", ex);
                throw ex;
            }
        } while (sqlcode != 0);
    }

    private void processGroupRedirectRequest(String errtxt) throws SQLException {
        String ipAddr = null;
        String portNo = null;
        String servername = null;
        StringTokenizer st = new StringTokenizer(errtxt, ":=|");
        if (st.hasMoreTokens()) {
            st.nextToken();
            if (st.hasMoreTokens()) {
                servername = st.nextToken().trim();
                if (st.hasMoreTokens()) {
                    ipAddr = st.nextToken().trim();
                    if (st.hasMoreTokens()) {
                        portNo = st.nextToken().trim();
                    }
                }
            }
        }
        try {
            this.PortNumber = Integer.parseInt(portNo);
        }
        catch (NumberFormatException nfe) {
            int poNo = -1;
            poNo = JnsObject.getServiceByName(portNo);
            if (poNo == -1) {
                throw Messages.getSQLException(-79759, portNo);
            }
            this.PortNumber = poNo;
            portNo = "" + poNo;
        }
        this.ipAddr = ipAddr;
        this.portNo = portNo;
        this.servername = servername;
    }

    private String[] getSupportedSSLProtocols(String[] defaultProtocols) {
        if (this.sslProtocols != null && this.sslProtocols.length > 0 && defaultProtocols != null && defaultProtocols.length > 0) {
            String[] allProtocols = new String[this.sslProtocols.length + defaultProtocols.length];
            System.arraycopy(this.sslProtocols, 0, allProtocols, 0, this.sslProtocols.length);
            System.arraycopy(defaultProtocols, 0, allProtocols, this.sslProtocols.length, defaultProtocols.length);
            log.debug("Encryption protocols: {}", allProtocols);
            return allProtocols;
        }
        log.debug("Encryption protocols: {}", defaultProtocols);
        return defaultProtocols;
    }

    public void setNetworkTimeout(int timeout) throws SocketException {
        this.asfSocket.setSoTimeout(timeout);
    }

    public int getNetworkTimeout() throws SocketException {
        return this.asfSocket.getSoTimeout();
    }

    public boolean isValid() {
        return !this.asfSocket.isClosed();
    }
}

