/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import com.informix.asf.IfxDataOutputStream;
import com.informix.asf.JnsObject;
import com.informix.lang.JavaToIfxType;
import com.informix.lang.Messages;
import com.informix.util.AdvancedUppercaseProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class ConnectionHeaders {
    private static final int PFCONREQ_BUF_SIZE = 2048;
    private static final int SL_HEADER_SIZE = 6;
    private static final short PF_PROT_SQLI_0600 = 60;
    private static final short SL_PROT_SQLI_0600 = 60;
    private static final short PF_PROT_SQLI_WITH_CSS = 61;
    private static final String floatType = "IEEEM";
    private static final String applType = "sqlexec\u0000\u0000\u0000\u0000\u0000";
    private static final String applID = "sqli";
    private static final short UTYPE_INTERNET = 1;
    private static final String PROT_SQLIOL = "ol\u0000\u0000\u0000\u0000\u0000\u0000";
    private static final String NET_TLITCP = "tlitcp\u0000\u0000";
    private static final short NET_LEV_1 = 1;
    private static final short ASF_XCONNECT = 11;
    private static final int ASF_AMBIG_SEOL = 3;
    private static final int ASF_GRPREF = 0x2000000;
    private static final short SLTYPE_CONREQ = 1;
    private static final short SLTYPE_CONACC = 2;
    private static final short SLTYPE_CONREJ = 3;
    private static final short SLTYPE_REDIRECT = 13;
    private static final int ASF_TRUSTCTXT = 0x4000000;
    private static final short ASSOCBIND_ACCEPT = 0;
    private static final short ASSOCBIND_REJECT = 1;
    private static final short SQ_DONE = 15;
    private static final short SQ_COST = 55;
    private static final short SQ_EXIT = 56;
    private static final short SQ_EOT = 12;
    private static final short SQ_ERR = 13;
    private static final short SQ_VERSION_REQ = 203;
    private static final short SQ_VERSION_REPLY = 204;
    private static final short SQ_XACTSTAT = 99;
    private static final short SQ_ASSOC = 100;
    private static final short SQ_ASCBINARY = 101;
    private static final short SQ_ASCINITRESP = 102;
    private static final short SQ_ASCDBLIST = 103;
    private static final short SQ_ASCINITREQ = 104;
    private static final short SQ_ASCENV = 106;
    private static final short SQ_ASCPINFO = 107;
    private static final short SQ_ASCBPARMS = 108;
    private static final short SQ_ASCMISC_60 = 116;
    private static final short SQ_ASCEOT = 127;
    public static final String SERIAL_NUMBER = "RDS#R000000";

    public static byte[] getHeaderBytes(AdvancedUppercaseProperties prop, Properties environment, String dbName, String serverName) throws SQLException, IOException {
        ByteArrayOutputStream pfByteArrayOs = new ByteArrayOutputStream(2048);
        ByteArrayOutputStream slByteArrayOs = new ByteArrayOutputStream(6);
        String dbname = null;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ConnectionHeaders.encodeAscBinary(new IfxDataOutputStream(pfByteArrayOs), prop, dbname, serverName, environment);
        ConnectionHeaders.encodeSLheader(new IfxDataOutputStream(slByteArrayOs), pfByteArrayOs.size(), 1, 60, 0);
        slByteArrayOs.writeTo(outputStream);
        pfByteArrayOs.writeTo(outputStream);
        return outputStream.toByteArray();
    }

    public static void encodeSLheader(IfxDataOutputStream o, int pfPDUsize, int slType, int slAttribute, int slOptions) throws IOException {
        o.writeShort(pfPDUsize + 6);
        o.writeByte(slType);
        o.writeByte(slAttribute);
        o.writeShort(slOptions);
    }

    public static void encodeAscBinary(IfxDataOutputStream o, AdvancedUppercaseProperties prop, String Servername, String Dbname, Properties envlist) throws SQLException, IOException {
        byte[] appNameBytes;
        String dbenc = prop.asString("DBENC");
        boolean sqlhGroup = false;
        String user = prop.asString("user");
        byte[] userNameBytes = JavaToIfxType.JavaToIfxChar(user, false);
        byte[] servernameBytes = JavaToIfxType.JavaToIfxChar(Servername, false);
        o.writeShort((short)100);
        o.writeShort((short)101);
        o.writeInt(61);
        o.writeShort(floatType.length() + 1);
        o.writeBytesConstant(floatType);
        o.writeByte(0);
        o.writeShort((short)108);
        o.writeBytesConstant(applType);
        o.writeShort("9.280".length() + 1);
        o.writeBytesConstant("9.280");
        o.writeByte(0);
        o.writeShort(SERIAL_NUMBER.length() + 1);
        o.writeBytesConstant(SERIAL_NUMBER);
        o.writeByte(0);
        o.writeShort(applID.length() + 1);
        o.writeBytesConstant(applID);
        o.writeByte(0);
        o.writeInt(316);
        o.writeInt(0);
        o.writeInt(0);
        o.writeShort((short)1);
        o.writeShort(user.length() + 1);
        o.writeBytes(userNameBytes);
        o.writeByte(0);
        if (!prop.containsKey("password")) {
            o.writeShort(0);
        } else {
            String password = prop.asString("password");
            byte[] passwordBytes = JavaToIfxType.JavaToIfxChar(password, false);
            o.writeShort(password.length() + 1);
            o.writeBytes(passwordBytes);
            o.writeByte(0);
        }
        o.writeBytesConstant(PROT_SQLIOL);
        o.writeInt(61);
        o.writeBytesConstant(NET_TLITCP);
        o.writeInt(1);
        o.writeShort((short)104);
        o.writeShort((short)11);
        int stmtoptions = 0;
        stmtoptions |= 3;
        if (sqlhGroup) {
            stmtoptions |= 0x2000000;
        }
        if (prop.asBool("trustedContext")) {
            stmtoptions |= 0x4000000;
        }
        o.writeInt(stmtoptions);
        o.writeShort(Servername.length() + 1);
        o.writeBytes(servernameBytes);
        o.writeByte(0);
        if (Dbname == null) {
            o.writeShort(0);
        } else {
            byte[] dbnameBytes = JavaToIfxType.JavaToIfxChar(Dbname, dbenc, false);
            o.writeBytes(dbnameBytes);
            o.writeByte(0);
        }
        o.writeShort(0);
        o.writeShort(0);
        o.writeShort(0);
        o.writeShort(0);
        ConnectionHeaders.encodeEnv(o, dbenc, envlist);
        ConnectionHeaders.encodeEnvPInfo(o);
        String AppName = "Thread[id:" + Thread.currentThread().getId() + ", name:" + Thread.currentThread().getName() + ", path:" + ConnectionHeaders.class.getProtectionDomain().getCodeSource().getLocation().getPath() + ']';
        try {
            appNameBytes = JavaToIfxType.JavaToIfxChar(AppName, "ASCII", false);
        }
        catch (SQLException e) {
            AppName = "Thread[id:" + Thread.currentThread().getId() + ", name:jdbc_thread, path:unkwown]";
            appNameBytes = o.getJavaToIfxChar(AppName);
        }
        o.writeShort((short)116);
        o.writeShort(10 + AppName.length() + 1);
        o.writeInt(0);
        o.writeInt(0);
        o.writeShort(AppName.length() + 1);
        o.writeBytes(appNameBytes);
        o.writeByte(0);
        o.writeShort((short)127);
    }

    public static void encodeEnv(IfxDataOutputStream o, String dbEncoding, Properties EnvVars) throws IOException, SQLException {
        int NumEnvVar = 0;
        String name = null;
        String value = null;
        o.writeShort((short)106);
        Enumeration<?> e = EnvVars.propertyNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            ++NumEnvVar;
        }
        o.writeShort(NumEnvVar);
        e = EnvVars.propertyNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value = EnvVars.getProperty(name);
            byte[] nameBytes = JavaToIfxType.JavaToIfxChar(name, false);
            byte[] valueBytes = JavaToIfxType.JavaToIfxChar(value, dbEncoding, false);
            o.writeShort(name.length() + 1);
            o.writeBytes(nameBytes);
            o.writeByte(0);
            o.writeShort(value.length() + 1);
            o.writeBytes(valueBytes);
            o.writeByte(0);
        }
    }

    public static void encodeEnvPInfo(IfxDataOutputStream o) throws IOException, SQLException {
        o.writeShort((short)107);
        o.writeInt(0);
        String procName = ManagementFactory.getRuntimeMXBean().getName();
        int procId = 0;
        if (procName != null) {
            procName = procName.split("@")[0];
            try {
                if (procName != null) {
                    procId = Integer.valueOf(procName);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        o.writeInt(procId);
        long tId = Thread.currentThread().getId();
        int thId = 0;
        try {
            thId = Integer.valueOf(Long.toString(tId));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        o.writeInt(thId);
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            hostName = "";
        }
        o.writeShort(hostName.length() + 1);
        o.writeBytesConstant(hostName);
        o.writeByte(0);
        o.writeShort(0);
        String cwd = "";
        try {
            cwd = System.getProperty("user.dir");
        }
        catch (Exception exception) {
            // empty catch block
        }
        o.writeShort(cwd.length() + 1);
        o.writeBytesConstant(cwd);
        o.writeByte(0);
    }

    private ConnectionHeaders() {
    }

    public static class ConnectionTarget {
        public String host;
        public String port;
        public String serverName;

        public ConnectionTarget(String host, String port, String serverName) {
            this.host = host;
            this.port = port;
            this.serverName = serverName;
        }

        public ConnectionTarget(String redirectMessage) throws SQLException {
            String portNo = "";
            StringTokenizer st = new StringTokenizer(redirectMessage, ":=|");
            if (st.hasMoreTokens()) {
                st.nextToken();
                if (st.hasMoreTokens()) {
                    this.serverName = st.nextToken().trim();
                    if (st.hasMoreTokens()) {
                        this.host = st.nextToken().trim();
                        if (st.hasMoreTokens()) {
                            portNo = st.nextToken().trim();
                        }
                    }
                }
            }
            try {
                Integer.parseInt(portNo);
                this.port = portNo;
            }
            catch (NumberFormatException nfe) {
                int poNo = -1;
                poNo = JnsObject.getServiceByName(portNo);
                if (poNo == -1) {
                    throw Messages.getLocSQLException(-79759, ": '" + portNo + "'");
                }
                this.port = Integer.toString(poNo);
            }
        }
    }
}

