/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxCallableStatement;
import com.informix.jdbc.IfxClientResultSet;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDriver;
import com.informix.jdbc.IfxParameterMetaData;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.IfxUDTInfo;
import com.informix.jdbc.Version;
import com.informix.jdbc.mdinfo;
import com.informix.jdbc.rowinfo;
import com.informix.lang.IfxTypes;
import com.informix.lang.Interval;
import com.informix.lang.Messages;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.PseudoColumnUsage;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class IfxDatabaseMetaData
implements DatabaseMetaData {
    private static final Object logger;
    private final IfxConnection conn;
    private final Trace trace;
    private static int nextTempTableId;
    private static int nMdInfoRows;
    private static int nStdRowTypes;
    private static int nXtdRowTypes;
    private static int nXtdRowTypesSupported;
    private static mdinfo[] lmd;
    private static rowinfo[] lrow;
    private static rowinfo[] lrowLvc32k;
    private int maxlogicalvchar = 127;

    private static synchronized String nextTempTableName() {
        return "dbmd" + nextTempTableId++;
    }

    IfxDatabaseMetaData(IfxConnection thisconn) throws SQLException {
        if (thisconn == null) {
            throw new NullPointerException("IfxConnection cannot be null!");
        }
        this.conn = thisconn;
        lrow = lrowLvc32k;
        this.maxlogicalvchar = 255 / (this.conn.getSqlLogicalChar() > 1 ? this.conn.getSqlLogicalChar() : 2);
        this.trace = this.conn.getTrace();
    }

    int getMaxLvarcharSize() {
        int lvarcharIndex = 0;
        for (lvarcharIndex = 0; lvarcharIndex < lrow.length && !IfxDatabaseMetaData.lrow[lvarcharIndex].tname.equalsIgnoreCase("lvarchar"); ++lvarcharIndex) {
        }
        return IfxDatabaseMetaData.lrow[lvarcharIndex].precision;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        return this.conn.getURL();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.conn.getUserName();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.conn.isReadOnly();
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return true;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return this.conn.getDbProductName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDatabaseProductVersion() throws SQLException {
        if (((IfxSqliConnect)this.conn).getDatabaseProductVersion() != null) {
            return ((IfxSqliConnect)this.conn).getDatabaseProductVersion();
        }
        String sql = this.getDatabaseProductName().equalsIgnoreCase("onedb") ? "select dbinfo('onedb','full') from  table (set{1});" : "select dbinfo('version','full') from  table (set{1});";
        try (Statement stmt = this.conn.createStatement();){
            ((IfxSqliConnect)this.conn).startMetaDataQuery();
            try (ResultSet rs = stmt.executeQuery(sql);){
                if (rs.next()) {
                    String tmp = rs.getString(1);
                    if (this.getDatabaseProductName().equalsIgnoreCase("onedb")) {
                        String temp1;
                        int split = tmp.indexOf("Server");
                        ((IfxSqliConnect)this.conn).externalVersion = temp1 = tmp.substring(split + 7).trim();
                        ((IfxSqliConnect)this.conn).setDatabaseProductVersion(temp1);
                    } else {
                        String temp1;
                        int split = tmp.indexOf("Version");
                        ((IfxSqliConnect)this.conn).externalVersion = temp1 = tmp.substring(split + 7).trim();
                        ((IfxSqliConnect)this.conn).setDatabaseProductVersion(temp1);
                    }
                }
            }
        }
        finally {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
        }
        return ((IfxSqliConnect)this.conn).getDatabaseProductVersion();
    }

    @Override
    public String getDriverName() {
        return "Informix JDBC Driver for Informix Dynamic Server";
    }

    @Override
    public String getDriverVersion() {
        return IfxDriver.getJDBCVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        return Version.getMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return Version.getMinorVersion();
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return this.conn.isDelimIdentSet();
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return !this.conn.isDelimIdentSet();
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return this.conn.isDelimIdentSet();
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        if (!this.conn.isDelimIdentSet()) {
            return " ";
        }
        return "\"";
    }

    @Override
    public String getSQLKeywords() {
        return "after,ansi,append,attach,audit,before,bitmap,boolean,buffered,byte,cache,call,cluster,clustersize,codeset,database,datafiles,dataskip,datetime,dba,dbdate,dbmoney,debug,define,delimiter,deluxe,detach,dirty,distributions,document,each,elif,exclusive,exit,explain,express,expression,extend,extent,file,fillfactor,foreach,format,fraction,fragment,gk,hash,high,hold,hybrid,if,index,init,labeleq,labelge,labelgt,labelle,labellt,let,listing,lock,log,low,matches,maxerrors,medium,mode,modify,money,mounting,new,nvarchar,off,old,operational,optical,optimization,page,pdqpriority,pload,private,raise,range,raw,recordend,recover,referencing,rejectfile,release,remainder,rename,reserve,resolution,resource,resume,return,returning,returns,ridlist,robin,rollforward,round,row,rowids,sameas,samples,schedule,scratch,serial,share,skall,skinhibit,skshow,smallfloat,stability,standard,start,static,statistics,stdev,step,sync,synonym,system,temp,text,timeout,trace,trigger,units,unlock,variance,wait,while,xload,xunload";
    }

    @Override
    public String getNumericFunctions() {
        return "abs,mod,pow,root,round,sqrt,exp,logn,log10,cos,sin,tan,asin,acos,atan,atan2";
    }

    @Override
    public String getStringFunctions() {
        return "trunc,length";
    }

    @Override
    public String getSystemFunctions() {
        return "avg,max,min,sum,count,range,stdev,variance,trim,hex,filetoblob,filetoclob,lotofile,lotocopy";
    }

    @Override
    public String getTimeDateFunctions() {
        return "date,day,month,weekday,year,extend,mdy";
    }

    @Override
    public String getSearchStringEscape() {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() {
        return "$";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    @Override
    public boolean supportsConvert() {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    @Override
    public String getSchemaTerm() {
        return "user";
    }

    @Override
    public String getProcedureTerm() {
        return "function";
    }

    @Override
    public String getCatalogTerm() {
        return "database";
    }

    private String getTmpTableTerm() {
        return "temp";
    }

    private String getNoLogTerm() {
        return "with no log";
    }

    @Override
    public boolean isCatalogAtStart() {
        return true;
    }

    @Override
    public String getCatalogSeparator() {
        return ":";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return true;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    @Override
    public boolean supportsUnion() {
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 256;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 128;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return Short.MAX_VALUE;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 16;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return Short.MAX_VALUE;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return Short.MAX_VALUE;
    }

    @Override
    public int getMaxColumnsInTable() {
        return Short.MAX_VALUE;
    }

    @Override
    public int getMaxConnections() {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 128;
    }

    @Override
    public int getMaxIndexLength() {
        return 255;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 128;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 128;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 128;
    }

    @Override
    public int getMaxRowSize() {
        return Short.MAX_VALUE;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return false;
    }

    @Override
    public int getMaxStatementLength() {
        if (((IfxSqliConnect)this.conn).isRemove64KLimitSupported()) {
            return Integer.MAX_VALUE;
        }
        return Short.MAX_VALUE;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 128;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() {
        return 32;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        int type = this.conn.getDatabaseType();
        if (type == 1) {
            return 4;
        }
        if (type == 2) {
            return 2;
        }
        return 0;
    }

    @Override
    public boolean supportsTransactions() {
        return this.conn.getDatabaseType() != 3;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) {
        if (!(level == 1 || level == 2 || level == 4 || level == 8 || level == 0 || level == 5 && this.conn.IsLastCommittedSupported())) {
            return false;
        }
        int type = this.conn.getDatabaseType();
        if ((type == 1 || type == 2) && level != 0) {
            return true;
        }
        return type == 3 && (level == 1 || level == 0);
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    /*
     * Loose catch block
     */
    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        schemaPattern = this.toSchemaCaseLikeServer(schemaPattern);
        procedureNamePattern = this.processPattern(procedureNamePattern);
        String dbName = this.getMetaDbName(catalog);
        String query = "select unique '" + dbName + "', owner, procname, '' as RESERVED1, '' as RESERVED2, '' as RESERVED3, '' as REMARKS, isproc, specificname  from " + dbName + ":informix.sysprocedures where procname like ? and owner like ? order by 2, 3";
        try {
            try (IfxPreparedStatement stmt = (IfxPreparedStatement)this.conn.prepareStatement(query);){
                stmt.setString(1, procedureNamePattern);
                stmt.setString(2, schemaPattern);
                ResultSet results = stmt.executeQuery(this.useWithHold());
                IfxResultSetMetaData rsmd1 = new IfxResultSetMetaData(9, this.conn);
                int vCharColSize = this.maxlogicalvchar;
                int colPos = 0;
                int currCol = 1;
                int colLen = vCharColSize;
                rsmd1.setColumnName(currCol, this.conn.retCapName("PROCEDURE_CAT"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("PROCEDURE_SCHEM"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("PROCEDURE_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("RESERVED1"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("RESERVED2"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("RESERVED3"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("REMARKS"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("PROCEDURE_TYPE"));
                rsmd1.setIfxColumnType(currCol, 1);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("SPECIFIC_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                ++currCol;
                IfxClientResultSet crs = new IfxClientResultSet(this.conn, rsmd1);
                int columnCount = rsmd1.getColumnCount();
                Object obj = null;
                crs.moveToInsertRow();
                while (results.next()) {
                    for (int i1 = 1; i1 <= columnCount; ++i1) {
                        if (rsmd1.getColumnName(i1).equalsIgnoreCase("PROCEDURE_CAT")) {
                            obj = results.getString(1);
                        } else if (rsmd1.getColumnName(i1).equalsIgnoreCase("PROCEDURE_SCHEM")) {
                            obj = results.getString(2).trim();
                        } else if (rsmd1.getColumnName(i1).equalsIgnoreCase("PROCEDURE_NAME")) {
                            obj = results.getString(3);
                        } else if (rsmd1.getColumnName(i1).equalsIgnoreCase("RESERVED1")) {
                            obj = "null";
                        } else if (rsmd1.getColumnName(i1).equalsIgnoreCase("RESERVED2")) {
                            obj = "null";
                        } else if (rsmd1.getColumnName(i1).equalsIgnoreCase("RESERVED3")) {
                            obj = "null";
                        } else if (rsmd1.getColumnName(i1).equalsIgnoreCase("REMARKS")) {
                            obj = results.getString(7);
                        } else if (rsmd1.getColumnName(i1).equalsIgnoreCase("PROCEDURE_TYPE")) {
                            obj = 0;
                            String isProc = results.getString(8);
                            if (isProc.equals("t")) {
                                obj = 1;
                            } else if (isProc.equals("f")) {
                                obj = 2;
                            }
                        } else {
                            String str;
                            obj = rsmd1.getColumnName(i1).equalsIgnoreCase("SPECIFIC_NAME") ? ((str = results.getString(9)) == null ? "null" : results.getString(9).trim()) : results.getObject(1);
                        }
                        crs.updateObject(i1, obj);
                    }
                    if (!((IfxSqliConnect)this.conn).isReplCheckColumnEnabled() && results.getObject("column_name").toString().equals("ifx_replcheck")) continue;
                    crs.insertRow();
                }
                results.close();
                crs.beforeFirst();
                crs.setType(1003);
                crs.setFetchDirection(1000);
                crs.setConcurrency(1007);
                IfxClientResultSet ifxClientResultSet = crs;
                return ifxClientResultSet;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void processProcName(String procedureNamePattern, String schemaPattern, String dbName, String tempTable) throws SQLException {
        boolean withHold = this.conn.isANSI() && this.conn.getAutoCommit();
        Statement instmt = null;
        String owner = null;
        String procname = null;
        String paramtypes = null;
        String rettypes = null;
        String isproc = null;
        String remark = null;
        String prepareSP = null;
        boolean onerow = false;
        int in_cnt = 0;
        int out_cnt = 0;
        String typename = null;
        boolean rettypeend = false;
        List<String> type_vec = null;
        String query = "select  procid from " + dbName + ":informix.sysprocedures where procname like ? and owner like ?";
        try (IfxPreparedStatement procidStatement = (IfxPreparedStatement)this.conn.prepareStatement(query);
             IfxStatement typesStatement = (IfxStatement)this.conn.createStatement();){
            procidStatement.setString(1, procedureNamePattern);
            procidStatement.setString(2, schemaPattern);
            ResultSet procidrs = procidStatement.executeQuery(withHold);
            while (procidrs.next()) {
                in_cnt = 0;
                out_cnt = 0;
                rettypeend = false;
                if (!onerow) {
                    onerow = true;
                    instmt = this.conn.prepareStatement("insert into " + tempTable + "(PROCEDURE_CAT, PROCEDURE_SCHEM,PROCEDURE_NAME, COLUMN_NAME, COLUMN_TYPE, DATA_TYPE, TYPE_NAME,PRECISION, LENGTH, SCALE, RADIX,NULLABLE, REMARKS,COLUMN_DEF, SQL_DATA_TYPE, SQL_DATETIME_SUB,CHAR_OCTET_LENGTH, ORDINAL_POSITION,IS_NULLABLE, SPECIFIC_NAME )values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);");
                }
                int procid = procidrs.getInt(1);
                query = " select  trim(p.owner) ,  p.procname ,  p.isproc ,  pc.paramname ,  pc.paramattr ,  get_data_type(pc.paramtype, pc.paramxid, 0) ,  schema_coltypename(pc.paramtype,pc.paramxid) ,  schema_precision(pc.paramtype,pc.paramxid,pc.paramlen) ,  schema_bufflen(pc.paramtype,pc.paramlen) ,  schema_numscale(pc.paramtype,pc.paramlen) ,  schema_numprecradix(pc.paramtype) ,  schema_isnullable(pc.paramtype)::SMALLINT ,  pc.paramtype ,  informix.schema_datetype(pc.paramtype, pc.paramlen) ,  informix.schema_charlen(pc.paramtype,pc.paramxid,pc.paramlen) ,  pc.paramid ,  informix.schema_nullable(pc.paramtype)::VARCHAR(3) , " + dbName + ":ifx_param_types(" + procid + ")," + dbName + ":ifx_ret_types(" + procid + "),  p.specificname,  pc.paramxid from " + dbName + ":informix.sysprocedures p, " + dbName + ":informix.sysprocbody b, " + dbName + ":informix.sysproccolumns pc  where p.procid = " + procid + " and p.procid=b.procid and p.procid=pc.procid and b.datakey='T' and b.seqno=1 and p.langid = 2  order by 1,2,3,16; ";
                ResultSet typesrs = this.conn.isANSI() && this.conn.getAutoCommit() ? typesStatement.executeQuery(query, true) : typesStatement.executeQuery(query, false);
                while (typesrs.next()) {
                    typename = null;
                    procname = typesrs.getString(2);
                    isproc = typesrs.getString(3);
                    remark = isproc.equals("t") ? "create procedure " : "create function ";
                    remark = remark + owner + "." + procname.trim() + "(";
                    prepareSP = isproc.equals("t") ? "execute procedure " : "execute function ";
                    prepareSP = prepareSP + owner + "." + procname.trim() + "(";
                    paramtypes = typesrs.getString(18);
                    rettypes = typesrs.getString(19);
                    type_vec = this.parseTypes(rettypes);
                    if (!rettypes.equals("")) {
                        remark = !paramtypes.equals("") ? remark + paramtypes + ") returning " + rettypes + ";" : remark + ") returning " + rettypes + ";";
                        if (out_cnt < type_vec.size()) {
                            typename = type_vec.get(out_cnt);
                        }
                    }
                    if (out_cnt > type_vec.size() || out_cnt == type_vec.size() || type_vec.size() == 0) {
                        rettypeend = true;
                    }
                    if (!paramtypes.equals("")) {
                        if (rettypes.equals("")) {
                            remark = remark + paramtypes + ")";
                        }
                        if (rettypeend && in_cnt < (type_vec = this.parseTypes(paramtypes)).size()) {
                            int s = type_vec.get(in_cnt).indexOf(32);
                            String[] x = type_vec.get(in_cnt).split(" ");
                            if (x.length > 0 && (x[0].equalsIgnoreCase("datetime") || x[0].equalsIgnoreCase("interval")) && x.length > 1 && x[2].equalsIgnoreCase("to")) {
                                s = 0;
                            }
                            typename = s > 0 ? type_vec.get(in_cnt).substring(s + 1) : type_vec.get(in_cnt);
                        }
                    }
                    if (paramtypes.equals("") && rettypes.equals("")) {
                        remark = remark + ")";
                        typename = "NULL";
                    }
                    instmt.setString(1, dbName);
                    instmt.setString(2, typesrs.getString(1).trim());
                    instmt.setString(3, typesrs.getString(2));
                    String str = typesrs.getString(4);
                    if (str == null) {
                        str = "NULL";
                    }
                    instmt.setString(4, str);
                    instmt.setString(5, typesrs.getString(5));
                    if (typesrs.getInt(6) == 93) {
                        int colLen = typesrs.getInt(8);
                        int tu_start = colLen >> 4 & 0xF;
                        int tu_end = colLen & 0xF;
                        if (tu_start >= 6 && tu_end <= 15) {
                            instmt.setString(6, String.valueOf(92));
                        } else {
                            instmt.setString(6, String.valueOf(93));
                        }
                    } else {
                        instmt.setString(6, typesrs.getString(6));
                    }
                    try {
                        short umaskcoltype = (short)(typesrs.getInt(15) & 0xFF);
                        if (umaskcoltype == 41 || umaskcoltype == 40) {
                            IfxUDTInfo udtInfo = this.conn.getUDTInfo(typesrs.getInt(21), true);
                            if (udtInfo != null && udtInfo.getName().length() > 0) {
                                instmt.setString(7, udtInfo.getName().toUpperCase());
                            }
                        } else {
                            instmt.setString(7, typename.trim());
                        }
                    }
                    catch (Exception udtexception) {
                        instmt.setString(7, typename.trim());
                    }
                    instmt.setString(8, typesrs.getString(8));
                    instmt.setString(9, typesrs.getString(9));
                    instmt.setString(10, typesrs.getString(10));
                    instmt.setString(11, typesrs.getString(11));
                    instmt.setString(12, typesrs.getString(12));
                    instmt.setString(13, remark);
                    instmt.setString(14, "NULL");
                    instmt.setString(15, typesrs.getString(13));
                    instmt.setString(16, typesrs.getString(14));
                    instmt.setString(17, typesrs.getString(15));
                    instmt.setString(18, typesrs.getString(16));
                    instmt.setString(19, typesrs.getString(17));
                    instmt.setString(20, typesrs.getString(20));
                    instmt.executeUpdate();
                    if (rettypeend) {
                        ++in_cnt;
                    }
                    ++out_cnt;
                }
            }
            if (instmt != null) {
                instmt.close();
            }
        }
    }

    private List<String> parseTypes(String types) {
        StringTokenizer st = new StringTokenizer(types, ",");
        ArrayList<String> v = new ArrayList<String>(20);
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        return v;
    }

    Vector<String> parseParameterNames(String prepareSP, Vector<String> type_vec, String tempTable, int ret_cnt) throws SQLException {
        String argString = "";
        Vector<String> nameVec = null;
        int vSize = type_vec.size();
        if (!this.supportsNamedParameters()) {
            nameVec = new Vector<String>(vSize);
            for (int i = 0; i < vSize; ++i) {
                nameVec.add("null");
            }
            return nameVec;
        }
        for (int i = 0; i < vSize; ++i) {
            String argumentType = type_vec.elementAt(i);
            int startType = argumentType.lastIndexOf(46) + 1;
            if (startType == 0) {
                startType = argumentType.lastIndexOf(32) + 1;
            }
            String[] x = argumentType.split(" ");
            x[0] = x[0].substring(1);
            String argType = (x[0].equalsIgnoreCase("datetime") || x[0].equalsIgnoreCase("interval")) && x[2].equalsIgnoreCase("to") ? x[0] : argumentType.substring(startType);
            argString = argType.equalsIgnoreCase("datetime") || argType.equalsIgnoreCase("interval") ? argString + (i == 0 ? "?" : ",?") : argString + (i == 0 ? "?::" : ",?::") + argType;
        }
        try {
            CallableStatement cstmt = this.conn.prepareCall(prepareSP + argString + ");");
            ParameterMetaData pmd = cstmt.getParameterMetaData();
            int count = pmd.getParameterCount();
            nameVec = new Vector(count);
            for (int i = 1; i <= count; ++i) {
                if (((IfxParameterMetaData)pmd).getArgumentName(i).length() >= 4) {
                    if (((IfxParameterMetaData)pmd).getArgumentName(i).substring(0, 4).equals("arg[")) {
                        nameVec.add("null");
                        continue;
                    }
                    nameVec.add(((IfxParameterMetaData)pmd).getArgumentName(i));
                    continue;
                }
                nameVec.add(((IfxParameterMetaData)pmd).getArgumentName(i));
            }
            if (ret_cnt > 0 && ((IfxCallableStatement)cstmt).rsmd != null) {
                Vector<IfxColumnInfo> retVec = ((IfxCallableStatement)cstmt).rsmd.getColumnInfoVector();
                Statement updstmt = this.conn.createStatement();
                for (int i = 1; i <= ret_cnt; ++i) {
                    IfxColumnInfo ci = retVec.get(i - 1);
                    if (ci.ColName.equals("(expression)")) continue;
                    String str = "update " + tempTable + " set COLUMN_NAME='" + ci.ColName + "' where ser=" + i;
                    updstmt.executeUpdate(str);
                }
                updstmt.close();
            }
            cstmt.close();
            return nameVec;
        }
        catch (SQLException e) {
            if (e.getErrorCode() == -201 || e.getErrorCode() == -9963 || e.getErrorCode() == -9628 || e.getErrorCode() == -674) {
                nameVec = new Vector(vSize);
                for (int i = 0; i < vSize; ++i) {
                    nameVec.add("null");
                }
                return nameVec;
            }
            throw e;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        boolean t = false;
        boolean v = false;
        boolean s = false;
        boolean p = false;
        int cnt = 0;
        boolean syst = false;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxDatabaseMetaData:getTables() : call IfxConnection:isDbOpen()");
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        if (schemaPattern == null || schemaPattern.length() == 0) {
            schemaPattern = "%";
        }
        if (tableNamePattern == null || tableNamePattern.length() == 0) {
            tableNamePattern = "%";
        }
        if (!this.conn.isDelimIdentSet()) {
            tableNamePattern = tableNamePattern.toLowerCase();
            schemaPattern = this.toSchemaCaseLikeServer(schemaPattern);
        }
        if (types != null) {
            for (int i = 0; i < types.length && types[i] != null; ++i) {
                if (types[i].trim().equalsIgnoreCase("SYSTEM TABLE")) {
                    syst = true;
                    ++cnt;
                }
                if (types[i].trim().equalsIgnoreCase("TABLE")) {
                    t = true;
                    ++cnt;
                    continue;
                }
                if (types[i].trim().equalsIgnoreCase("VIEW")) {
                    v = true;
                    ++cnt;
                    continue;
                }
                if (types[i].trim().equalsIgnoreCase("SYNONYM") && this.conn.isANSI()) {
                    p = true;
                    ++cnt;
                    continue;
                }
                if (!types[i].trim().equalsIgnoreCase("SYNONYM")) continue;
                p = true;
                ++cnt;
                s = true;
                ++cnt;
            }
        }
        String dbName = this.getMetaDbName(catalog);
        try {
            try (IfxStatement getTablesStatement1 = (IfxStatement)this.conn.createStatement();){
                boolean whereclause;
                String table_typeString = " CASE WHEN tabtype = 'T' AND tabid <= 99 THEN 'SYSTEM TABLE' WHEN tabtype = 'T' AND tabid > 99 THEN 'TABLE' WHEN tabtype = 'V' THEN 'VIEW' WHEN tabtype = 'S' OR tabtype = 'P' THEN 'SYNONYM' WHEN tabtype = 'L' THEN 'LOG' WHEN tabtype = 'E' THEN 'TABLE' ELSE 'UNKNOWN' END ";
                String table_typeStringAlias = "TABLE_TYPE ";
                String sql = "select tabname," + table_typeString + table_typeStringAlias + ", owner from " + dbName + ":informix.systables ";
                int origCnt = cnt;
                if (cnt > 0) {
                    sql = sql + "where " + table_typeString + " in (";
                }
                if (syst) {
                    sql = sql + "'SYSTEM TABLE'";
                    if (--cnt > 0) {
                        sql = sql + ",";
                    }
                }
                if (t) {
                    sql = sql + "'TABLE'";
                    if (--cnt > 0) {
                        sql = sql + ",";
                    }
                }
                if (v) {
                    sql = sql + "'VIEW'";
                    if (--cnt > 0) {
                        sql = sql + ",";
                    }
                }
                if (s) {
                    sql = sql + "'SYNONYM'";
                    if (--cnt > 0) {
                        sql = sql + ",";
                    }
                }
                if (p) {
                    sql = sql + "'SYNONYM'";
                }
                if (origCnt > 0) {
                    sql = sql + ")";
                }
                boolean bl = whereclause = origCnt > 0;
                if (tableNamePattern != null) {
                    if (whereclause) {
                        sql = sql + " and tabname like '" + tableNamePattern + "'";
                    } else {
                        whereclause = true;
                        sql = sql + " where tabname like '" + tableNamePattern + "'";
                    }
                }
                if (schemaPattern != null) {
                    sql = whereclause ? sql + " and owner like '" + schemaPattern + "'" : sql + " where owner like '" + schemaPattern + "'";
                }
                sql = sql + " order by 2, 3, 1";
                ResultSet rs = this.conn.isANSI() && this.conn.getAutoCommit() ? getTablesStatement1.executeQuery(sql, true) : getTablesStatement1.executeQuery(sql, false);
                ResultSetMetaData rsmd = rs.getMetaData();
                IfxResultSetMetaData rsmd1 = new IfxResultSetMetaData(10, this.conn);
                IfxResultSetMetaData rsmd2 = (IfxResultSetMetaData)rs.getMetaData();
                int vCharColSize = this.maxlogicalvchar;
                int nullable = 1;
                int colPos = 0;
                rsmd1.setColInfo(1, rsmd2.getColumnInfo((int)1).MaxWidth, this.conn.retCapName("TABLE_CAT"), rsmd2.getTableName(1), 13, IfxTypes.IfxTypeToName(13), rsmd2.getSourceType(1), vCharColSize, rsmd2.getColumnExtendedId(1), rsmd2.getExtendedName(1), rsmd2.getExtendedOwnerName(1), rsmd2.isNullable(1), rsmd2.getDelimIdent() ? 1 : 0);
                rsmd1.setColtitle(1, null);
                rsmd1.setColumnStartPosition(1, colPos);
                rsmd1.setColInfo(2, rsmd2.getColumnInfo((int)3).MaxWidth, this.conn.retCapName("TABLE_SCHEM"), rsmd2.getTableName(3), 13, IfxTypes.IfxTypeToName(13), rsmd2.getSourceType(3), vCharColSize, rsmd2.getColumnExtendedId(3), rsmd2.getExtendedName(3), rsmd2.getExtendedOwnerName(3), rsmd2.isNullable(3), rsmd2.getDelimIdent() ? 1 : 0);
                rsmd1.setColtitle(2, null);
                rsmd1.setColumnStartPosition(2, colPos += vCharColSize + 1);
                rsmd1.setColInfo(3, rsmd2.getColumnInfo((int)1).MaxWidth, this.conn.retCapName("TABLE_NAME"), rsmd2.getTableName(1), 13, IfxTypes.IfxTypeToName(13), rsmd2.getSourceType(1), vCharColSize, rsmd2.getColumnExtendedId(1), rsmd2.getExtendedName(1), rsmd2.getExtendedOwnerName(1), rsmd2.isNullable(1), rsmd2.getDelimIdent() ? 1 : 0);
                rsmd1.setColtitle(3, null);
                rsmd1.setColumnStartPosition(3, colPos += vCharColSize + 1);
                rsmd1.setColInfo(4, rsmd2.getColumnInfo((int)2).MaxWidth, this.conn.retCapName("TABLE_TYPE"), rsmd2.getTableName(2), 13, IfxTypes.IfxTypeToName(13), rsmd2.getSourceType(2), vCharColSize, rsmd2.getColumnExtendedId(2), rsmd2.getExtendedName(2), rsmd2.getExtendedOwnerName(2), rsmd2.isNullable(2), rsmd2.getDelimIdent() ? 1 : 0);
                rsmd1.setColtitle(4, null);
                rsmd1.setColumnStartPosition(4, colPos += vCharColSize + 1);
                rsmd1.setColInfo(5, rsmd2.getColumnInfo((int)1).MaxWidth, this.conn.retCapName("REMARKS"), rsmd2.getTableName(1), 13, IfxTypes.IfxTypeToName(13), rsmd2.getSourceType(1), vCharColSize, rsmd2.getColumnExtendedId(1), rsmd2.getExtendedName(1), rsmd2.getExtendedOwnerName(1), nullable, rsmd2.getDelimIdent() ? 1 : 0);
                rsmd1.setColtitle(5, null);
                rsmd1.setColumnStartPosition(5, colPos += vCharColSize + 1);
                rsmd1.setColInfo(6, rsmd2.getColumnInfo((int)1).MaxWidth, this.conn.retCapName("TYPE_CAT"), rsmd2.getTableName(1), 13, IfxTypes.IfxTypeToName(13), rsmd2.getSourceType(1), vCharColSize, rsmd2.getColumnExtendedId(1), rsmd2.getExtendedName(1), rsmd2.getExtendedOwnerName(1), nullable, rsmd2.getDelimIdent() ? 1 : 0);
                rsmd1.setColtitle(6, null);
                rsmd1.setColumnStartPosition(6, colPos += vCharColSize + 1);
                rsmd1.setColInfo(7, rsmd2.getColumnInfo((int)1).MaxWidth, this.conn.retCapName("TYPE_SCHEM"), rsmd2.getTableName(1), 13, IfxTypes.IfxTypeToName(13), rsmd2.getSourceType(1), vCharColSize, rsmd2.getColumnExtendedId(1), rsmd2.getExtendedName(1), rsmd2.getExtendedOwnerName(1), nullable, rsmd2.getDelimIdent() ? 1 : 0);
                rsmd1.setColtitle(7, null);
                rsmd1.setColumnStartPosition(7, colPos += vCharColSize + 1);
                rsmd1.setColInfo(8, rsmd2.getColumnInfo((int)1).MaxWidth, this.conn.retCapName("TYPE_NAME"), rsmd2.getTableName(1), 13, IfxTypes.IfxTypeToName(13), rsmd2.getSourceType(1), vCharColSize, rsmd2.getColumnExtendedId(1), rsmd2.getExtendedName(1), rsmd2.getExtendedOwnerName(1), nullable, rsmd2.getDelimIdent() ? 1 : 0);
                rsmd1.setColtitle(8, null);
                rsmd1.setColumnStartPosition(8, colPos += vCharColSize + 1);
                rsmd1.setColInfo(9, rsmd2.getColumnInfo((int)1).MaxWidth, this.conn.retCapName("SELF_REFERENCING_COL_NAME"), rsmd2.getTableName(1), 13, IfxTypes.IfxTypeToName(13), rsmd2.getSourceType(1), vCharColSize, rsmd2.getColumnExtendedId(1), rsmd2.getExtendedName(1), rsmd2.getExtendedOwnerName(1), nullable, rsmd2.getDelimIdent() ? 1 : 0);
                rsmd1.setColtitle(9, null);
                rsmd1.setColumnStartPosition(9, colPos += vCharColSize + 1);
                rsmd1.setColInfo(10, rsmd2.getColumnInfo((int)1).MaxWidth, this.conn.retCapName("REF_GENERATION"), rsmd2.getTableName(1), 13, IfxTypes.IfxTypeToName(13), rsmd2.getSourceType(1), vCharColSize, rsmd2.getColumnExtendedId(1), rsmd2.getExtendedName(1), rsmd2.getExtendedOwnerName(1), nullable, rsmd2.getDelimIdent() ? 1 : 0);
                rsmd1.setColtitle(10, null);
                rsmd1.setColumnStartPosition(10, colPos += vCharColSize + 1);
                colPos += vCharColSize + 1;
                rsmd = rsmd1;
                IfxClientResultSet crs = new IfxClientResultSet(this.conn, rsmd);
                int columnCount = rsmd.getColumnCount();
                Object obj = null;
                crs.moveToInsertRow();
                while (rs.next()) {
                    for (int i1 = 1; i1 <= columnCount; ++i1) {
                        obj = rsmd.getColumnName(i1).equalsIgnoreCase("TABLE_CAT") ? dbName : (rsmd.getColumnName(i1).equalsIgnoreCase("TABLE_SCHEM") ? rs.getString(3).trim() : (rsmd.getColumnName(i1).equalsIgnoreCase("TABLE_NAME") ? rs.getObject(1) : (rsmd.getColumnName(i1).equalsIgnoreCase("TABLE_TYPE") ? rs.getString(2).trim() : (rsmd.getColumnName(i1).equalsIgnoreCase("REMARKS") ? null : (rsmd.getColumnName(i1).equalsIgnoreCase("TYPE_CAT") ? null : (rsmd.getColumnName(i1).equalsIgnoreCase("TYPE_SCHEM") ? null : (rsmd.getColumnName(i1).equalsIgnoreCase("TYPE_NAME") ? null : (rsmd.getColumnName(i1).equalsIgnoreCase("SELF_REFERENCING_COL_NAME") ? null : (rsmd.getColumnName(i1).equalsIgnoreCase("REF_GENERATION") ? null : rs.getObject(i1))))))))));
                        crs.updateObject(i1, obj);
                    }
                    if (!((IfxSqliConnect)this.conn).isReplCheckColumnEnabled() && rs.getObject("column_name").toString().equals("ifx_replcheck")) continue;
                    crs.insertRow();
                }
                crs.beforeFirst();
                crs.setType(1003);
                crs.setFetchDirection(1000);
                crs.setConcurrency(1007);
                IfxClientResultSet ifxClientResultSet = crs;
                return ifxClientResultSet;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
        }
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    /*
     * Loose catch block
     */
    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        String query = "select unique owner,'" + this.getMetaDbName(null) + "' from informix.systables where tabtype != '' AND owner LIKE ? order by 1";
        schemaPattern = schemaPattern != null ? "%" + schemaPattern.toLowerCase() + "%" : "%";
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        try {
            try (IfxPreparedStatement schemaStatement = (IfxPreparedStatement)this.conn.prepareStatement(query);){
                schemaStatement.setString(1, schemaPattern);
                ResultSet results = schemaStatement.executeQuery(this.useWithHold());
                ResultSetMetaData rsmd = results.getMetaData();
                IfxResultSetMetaData rsmd1 = new IfxResultSetMetaData(2, this.conn);
                int colPos = 0;
                int currCol = 1;
                rsmd1.setColumnName(currCol, this.conn.retCapName("TABLE_SCHEM"));
                rsmd1.setIfxColumnType(currCol, 13);
                int colLen = 85;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("TABLE_CATALOG"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = 85;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                ++currCol;
                rsmd = rsmd1;
                IfxClientResultSet crs = new IfxClientResultSet(this.conn, rsmd);
                int columnCount = rsmd.getColumnCount();
                Object obj = null;
                crs.moveToInsertRow();
                while (results.next()) {
                    for (int i1 = 1; i1 <= columnCount; ++i1) {
                        obj = rsmd.getColumnName(i1).equalsIgnoreCase("TABLE_SCHEM") ? results.getString(1).trim() : (rsmd.getColumnName(i1).equalsIgnoreCase("TABLE_CATALOG") ? results.getString(2) : results.getObject(1));
                        crs.updateObject(i1, obj);
                    }
                    if (!((IfxSqliConnect)this.conn).isReplCheckColumnEnabled() && results.getObject("column_name").toString().equals("ifx_replcheck")) continue;
                    crs.insertRow();
                }
                crs.beforeFirst();
                crs.setType(1003);
                crs.setFetchDirection(1000);
                crs.setConcurrency(1007);
                results.close();
                IfxClientResultSet ifxClientResultSet = crs;
                return ifxClientResultSet;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
        }
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        IfxClientResultSet dbCrs;
        int numDbs = 0;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "getCatalogs called");
        }
        IfxProtocol prot = this.conn.createProto();
        try {
            prot.executeGetDBList();
            IfxResultSetMetaData dbRsmd = new IfxResultSetMetaData(1, this.conn);
            dbRsmd.setEncodedLength(1, 128);
            dbRsmd.setNullable(1, 0);
            dbRsmd.setMaxWidth(1, 128);
            dbRsmd.setColtitle(1, "DB Name");
            dbRsmd.setColumnName(1, this.conn.retCapName("TABLE_CAT"));
            dbRsmd.setIfxColumnType(1, 0);
            dbCrs = new IfxClientResultSet(this.conn, dbRsmd);
            List<String> tDBlist = prot.getDBList();
            numDbs = tDBlist.size();
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "Number of databases is " + numDbs);
            }
            if (numDbs > 0) {
                dbCrs.newRow(numDbs);
                for (int i = 0; i < numDbs; ++i) {
                    dbCrs.updateString(i + 1, 1, tDBlist.get(i) != null ? tDBlist.get(i).trim() : null);
                    if (!TraceFlag.isTraceEnabled()) continue;
                    this.trace.writeTrace(logger, 3, "dbname put in resultset " + tDBlist.get(i));
                }
                dbCrs.beforeFirst();
                dbCrs.setFetchDirection(1000);
                dbCrs.setConcurrency(1007);
                dbCrs.setType(1003);
            }
        }
        catch (SQLException ex) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "Error in accessing vector of db names");
            }
            throw ex;
        }
        prot.clear();
        prot = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, " getCatalogs exitted ");
        }
        return dbCrs;
    }

    /*
     * Loose catch block
     */
    @Override
    public ResultSet getTableTypes() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxDatabaseMetaData:getTableTypes() : call IfxConnection:isDbOpen()");
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        try {
            try (IfxStatement tableTypeStatement = (IfxStatement)this.conn.createStatement();){
                String q1 = this.conn.getDatabaseType() == 1 ? "select unique trim('SYNONYM') as TABLE_TYPE from informix.systables where tabtype = 'P'" : "select unique trim('PRIVATE_SYNONYM') as TABLE_TYPE from informix.systables where tabtype = 'P'";
                String query = "select unique trim('TABLE') as TABLE_TYPE from informix.systables where tabtype = 'T' union select unique trim('SYSTEM TABLE') as TABLE_TYPE from informix.systables where tabtype = 'T' and tabid <= 99 union select unique trim('VIEW') as TABLE_TYPE from informix.systables where tabtype = 'V' union select unique trim('SYNONYM') as TABLE_TYPE from informix.systables where tabtype = 'S' union " + q1;
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "IfxDatabaseMetaData:getTableTypes() : call IfxStatement:executeQuery(" + query + ")");
                }
                ResultSet rs = this.conn.isANSI() && this.conn.getAutoCommit() ? tableTypeStatement.executeQuery(query, true) : tableTypeStatement.executeQuery(query, false);
                ResultSetMetaData rsmd = rs.getMetaData();
                IfxResultSetMetaData rsmd1 = new IfxResultSetMetaData(1, this.conn);
                int vCharColSize = this.maxlogicalvchar;
                int colPos = 0;
                int currCol = 1;
                int colLen = vCharColSize;
                rsmd1.setColumnName(currCol, this.conn.retCapName("TABLE_TYPE"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                ++currCol;
                ResultSet resultSet = this.populateClientResultSet(rs, rsmd1);
                return resultSet;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        IfxUDTInfo udtInfo = null;
        if (!this.conn.isDbOpen()) {
            return null;
        }
        String dbName = this.getMetaDbName(catalog);
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        schemaPattern = this.toSchemaCaseLikeServer(schemaPattern == null ? "%" : schemaPattern);
        tableNamePattern = this.processPattern(tableNamePattern);
        columnNamePattern = this.processPattern(columnNamePattern);
        String sql = "SELECT trim(t.owner), t.tabname, c.colname,informix.get_data_type(c.coltype, c.extended_id, 0), trim(informix.schema_coltypename(c.coltype,c.extended_id)),informix.schema_precision(c.coltype, c.extended_id, c.collength), 0,informix.schema_numscale(c.coltype, c.collength), informix.schema_numprecradix(c.coltype),informix.schema_isnullable(c.coltype), NULL::VARCHAR(1),CASE d.type   WHEN 'L' THEN informix.get_default_value(c.coltype, c.extended_id, c.collength, d.default)   WHEN 'C' THEN 'current'   WHEN 'S' THEN 'dbservername'   WHEN 'U' THEN 'user'   WHEN 'T' THEN 'today'  ELSE    NULL::VARCHAR(1) END,c.coltype, informix.schema_datetype(c.coltype, c.collength), informix.schema_charlen(c.coltype, c.extended_id, c.collength),c.colno, informix.schema_nullable(c.coltype)::VARCHAR(3), NULL::VARCHAR(1), NULL::VARCHAR(1), NULL::VARCHAR(1), NULL::smallint, informix.schema_isautoincr(c.coltype)::VARCHAR(3),c.extended_id FROM " + dbName + ":informix.systables t,    OUTER " + dbName + ":informix.sysdefaults d, " + dbName + ":informix.syscolumns c     WHERE t.tabid = c.tabid and d.tabid = t.tabid      AND c.colno = d.colno      AND (t.tabtype not in ('P', 'S'))      AND (d.class in ('T'))      AND t.tabname like ?     AND t.owner like ?     AND c.colname like ?";
        sql = sql + " union SELECT    trim(st.owner),    st.tabname,    c.colname,   informix.get_data_type(c.coltype,c.extended_id, 0),    trim(informix.schema_coltypename(c.coltype,c.extended_id)),   informix.schema_precision(c.coltype, c.extended_id, c.collength),   0,   informix.schema_numscale(c.coltype, c.collength),    informix.schema_numprecradix(c.coltype),   informix.schema_isnullable(c.coltype),    NULL::VARCHAR(1),   CASE d.type      WHEN 'L' THEN informix.get_default_value(c.coltype, c.extended_id, c.collength, d.default)      WHEN 'C' THEN 'current' WHEN 'S' THEN 'dbservername' WHEN 'U' THEN 'user'      WHEN 'T' THEN 'today'      ELSE        NULL::VARCHAR(1)    END,   c.coltype,    informix.schema_datetype(c.coltype, c.collength),    informix.schema_charlen(c.coltype, c.extended_id, c.collength),   c.colno,    informix.schema_nullable(c.coltype)::VARCHAR(3),    NULL::VARCHAR(1),    NULL::VARCHAR(1),    NULL::VARCHAR(1),    NULL::smallint,    informix.schema_isautoincr(c.coltype)::VARCHAR(3),    c.extended_id    FROM " + dbName + ":informix.systables st, " + dbName + ":informix.syssyntable s, " + dbName + ":informix.systables t,     OUTER  " + dbName + ":informix.sysdefaults d,  " + dbName + ":informix.syscolumns c       WHERE st.tabid = s.tabid       AND s.btabid = t.tabid       AND t.tabid = c.tabid       AND d.tabid = t.tabid       AND c.colno = d.colno       AND (st.tabtype in ('P', 'S'))       AND (d.class in ('T'))       AND st.tabname LIKE ?      AND st.owner LIKE ?      AND c.colname LIKE ?";
        sql = sql + " order by 1,2,16 ";
        try {
            try (IfxPreparedStatement stmt = (IfxPreparedStatement)this.conn.prepareStatement(sql);){
                stmt.setString(1, tableNamePattern);
                stmt.setString(2, schemaPattern);
                stmt.setString(3, columnNamePattern);
                stmt.setString(4, tableNamePattern);
                stmt.setString(5, schemaPattern);
                stmt.setString(6, columnNamePattern);
                ResultSet rs = stmt.executeQuery(this.useWithHold());
                ResultSetMetaData rsmd = rs.getMetaData();
                IfxResultSetMetaData rsmd1 = new IfxResultSetMetaData(23, this.conn);
                int vCharColSize = this.maxlogicalvchar;
                int colPos = 0;
                int currCol = 1;
                int colLen = vCharColSize;
                rsmd1.setColumnName(currCol, this.conn.retCapName("TABLE_CAT"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("TABLE_SCHEM"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("TABLE_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("COLUMN_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("DATA_TYPE"));
                rsmd1.setIfxColumnType(currCol, 1);
                colLen = 2;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("TYPE_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("COLUMN_SIZE"));
                rsmd1.setIfxColumnType(currCol, 2);
                colLen = 4;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("BUFFER_LENGTH"));
                rsmd1.setIfxColumnType(currCol, 1);
                colLen = 2;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("DECIMAL_DIGITS"));
                rsmd1.setIfxColumnType(currCol, 2);
                colLen = 4;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("NUM_PREC_RADIX"));
                rsmd1.setIfxColumnType(currCol, 2);
                colLen = 4;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("NULLABLE"));
                rsmd1.setIfxColumnType(currCol, 2);
                colLen = 4;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("REMARKS"));
                rsmd1.setIfxColumnType(currCol, 0);
                colLen = 18;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("COLUMN_DEF"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = 255;
                rsmd1.setEncodedLength(currCol, 257);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("SQL_DATA_TYPE"));
                rsmd1.setIfxColumnType(currCol, 2);
                colLen = 4;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("SQL_DATETIME_SUB"));
                rsmd1.setIfxColumnType(currCol, 2);
                colLen = 4;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("CHAR_OCTET_LENGTH"));
                rsmd1.setIfxColumnType(currCol, 2);
                colLen = 4;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("ORDINAL_POSITION"));
                rsmd1.setIfxColumnType(currCol, 2);
                colLen = 4;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("IS_NULLABLE"));
                rsmd1.setIfxColumnType(currCol, 0);
                colLen = 3;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("SCOPE_CATALOG"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = 255;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("SCOPE_SCHEMA"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = 255;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("SCOPE_TABLE"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = 255;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("SOURCE_DATA_TYPE"));
                rsmd1.setIfxColumnType(currCol, 1);
                colLen = 2;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("IS_AUTOINCREMENT"));
                rsmd1.setIfxColumnType(currCol, 0);
                colLen = 3;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                ++currCol;
                rsmd = rsmd1;
                IfxClientResultSet crs = new IfxClientResultSet(this.conn, rsmd);
                int columnCount = rsmd.getColumnCount();
                Object obj = null;
                crs.moveToInsertRow();
                while (rs.next()) {
                    short umaskcoltype = (short)(rs.getInt(13) & 0xFF);
                    int extendedId = rs.getInt(23);
                    boolean isExtendedType = false;
                    int dType = rs.getInt(4);
                    boolean isDistinct = false;
                    boolean isOpaque = false;
                    if (umaskcoltype == 41 || umaskcoltype == 40 || extendedId > 0) {
                        isExtendedType = true;
                        udtInfo = this.conn.getUDTInfo(extendedId, true);
                        if (udtInfo != null) {
                            if (udtInfo.JDBCtype == 2001) {
                                isDistinct = true;
                            } else if (umaskcoltype == 40) {
                                isOpaque = true;
                            }
                        }
                    }
                    for (int i1 = 1; i1 <= columnCount; ++i1) {
                        int tu_end;
                        int tu_start2;
                        if (rsmd.getColumnName(i1).equalsIgnoreCase("TABLE_CAT")) {
                            obj = dbName;
                        } else if (rsmd.getColumnName(i1).equalsIgnoreCase("TABLE_SCHEM")) {
                            obj = rs.getString(1).trim();
                        } else if (rsmd.getColumnName(i1).equalsIgnoreCase("TABLE_NAME")) {
                            obj = rs.getString(2);
                        } else if (rsmd.getColumnName(i1).equalsIgnoreCase("COLUMN_NAME")) {
                            obj = rs.getString(3);
                        } else if (rsmd.getColumnName(i1).equalsIgnoreCase("DATA_TYPE")) {
                            if (isDistinct) {
                                obj = udtInfo.JDBCtype;
                            } else if (dType == 93) {
                                colLen = rs.getInt(6);
                                tu_start2 = colLen >> 4 & 0xF;
                                tu_end = colLen & 0xF;
                                obj = tu_start2 >= 6 && tu_end <= 15 ? Integer.valueOf(92) : Integer.valueOf(93);
                            } else {
                                obj = isOpaque && udtInfo.name.startsWith("st_") ? Integer.valueOf(2000) : Integer.valueOf(dType);
                            }
                        } else if (rsmd.getColumnName(i1).equalsIgnoreCase("TYPE_NAME")) {
                            obj = rs.getString(5).toLowerCase();
                            try {
                                if (isExtendedType && udtInfo != null && udtInfo.getName().length() > 0) {
                                    obj = udtInfo.getName().toLowerCase();
                                } else if (((String)obj).equalsIgnoreCase("INTERVAL")) {
                                    colLen = rs.getInt(6);
                                    obj = Interval.getIfxTypeName(14, (short)colLen);
                                } else if (((String)obj).equalsIgnoreCase("DATETIME")) {
                                    colLen = rs.getInt(6);
                                    obj = Interval.getIfxTypeName(10, (short)colLen);
                                }
                            }
                            catch (Exception tu_start2) {}
                        } else if (rsmd.getColumnName(i1).equalsIgnoreCase("COLUMN_SIZE")) {
                            if (rs.getInt(4) == 92 || rs.getInt(4) == 93) {
                                colLen = rs.getInt(6);
                                int tu_len = colLen >> 8 & 0xFF;
                                int tu_start3 = colLen >> 4 & 0xF;
                                int tu_end2 = colLen & 0xF;
                                colLen = tu_len + ((tu_end2 > 10 ? 12 : tu_end2) - tu_start3) / 2 + (tu_start3 == 12 ? 1 : 0);
                                obj = colLen;
                            } else {
                                obj = rs.getInt(6);
                            }
                        } else if (rsmd.getColumnName(i1).equalsIgnoreCase("BUFFER_LENGTH")) {
                            obj = rs.getInt(7);
                        } else if (rsmd.getColumnName(i1).equalsIgnoreCase("DECIMAL_DIGITS")) {
                            obj = rs.getInt(8);
                        } else if (rsmd.getColumnName(i1).equalsIgnoreCase("NUM_PREC_RADIX")) {
                            obj = rs.getInt(9);
                        } else if (rsmd.getColumnName(i1).equalsIgnoreCase("NULLABLE")) {
                            obj = rs.getInt(10);
                        } else if (rsmd.getColumnName(i1).equalsIgnoreCase("REMARKS")) {
                            obj = rs.getString(11);
                        } else if (rsmd.getColumnName(i1).equalsIgnoreCase("COLUMN_DEF")) {
                            obj = rs.getString(12);
                            if (obj != null) {
                                obj = obj.toString().trim();
                                if (IfxTypes.isString(umaskcoltype)) {
                                    obj = "'" + obj + "'";
                                }
                            }
                        } else if (rsmd.getColumnName(i1).equalsIgnoreCase("SQL_DATA_TYPE")) {
                            obj = isDistinct ? Integer.valueOf(udtInfo.SQLtype) : Integer.valueOf(IfxTypes.FromJDBCToIfxType(rs.getInt(4)));
                        } else if (rsmd.getColumnName(i1).equalsIgnoreCase("SQL_DATETIME_SUB")) {
                            obj = 0;
                        } else if (rsmd.getColumnName(i1).equalsIgnoreCase("CHAR_OCTET_LENGTH")) {
                            obj = rs.getInt(15);
                        } else if (rsmd.getColumnName(i1).equalsIgnoreCase("ORDINAL_POSITION")) {
                            obj = rs.getInt(16);
                        } else if (rsmd.getColumnName(i1).equalsIgnoreCase("IS_NULLABLE")) {
                            obj = rs.getString(17);
                        } else if (rsmd.getColumnName(i1).equalsIgnoreCase("SCOPE_CATALOG")) {
                            obj = rs.getString(18);
                        } else if (rsmd.getColumnName(i1).equalsIgnoreCase("SCOPE_SCHEMA")) {
                            obj = rs.getString(19);
                        } else if (rsmd.getColumnName(i1).equalsIgnoreCase("SCOPE_TABLE")) {
                            obj = rs.getString(20);
                        } else if (rsmd.getColumnName(i1).equalsIgnoreCase("SOURCE_DATA_TYPE")) {
                            if (isDistinct) {
                                if (rs.getInt(4) == 93) {
                                    colLen = rs.getInt(6);
                                    tu_start2 = colLen >> 4 & 0xF;
                                    tu_end = colLen & 0xF;
                                    obj = tu_start2 >= 6 && tu_end <= 15 ? Integer.valueOf(92) : Integer.valueOf(93);
                                } else if (udtInfo != null) {
                                    if (udtInfo.JDBCtype == 2001 && udtInfo.SQLtype == 41) {
                                        switch (udtInfo.source) {
                                            case 10: {
                                                obj = 2004;
                                                break;
                                            }
                                            case 11: {
                                                obj = 2005;
                                                break;
                                            }
                                            case 5: {
                                                obj = 16;
                                                break;
                                            }
                                            default: {
                                                obj = IfxTypes.FromIfxToJDBCType(udtInfo.SQLtype);
                                                break;
                                            }
                                        }
                                    } else {
                                        obj = IfxTypes.FromIfxToJDBCType(udtInfo.SQLtype);
                                    }
                                } else {
                                    obj = rs.getShort(21);
                                }
                            } else {
                                obj = null;
                            }
                        } else if (rsmd.getColumnName(i1).equalsIgnoreCase("IS_AUTOINCREMENT")) {
                            obj = rs.getString(22);
                        }
                        crs.updateObject(i1, obj);
                    }
                    if (!((IfxSqliConnect)this.conn).isReplCheckColumnEnabled() && rs.getObject("column_name").toString().equals("ifx_replcheck")) continue;
                    crs.insertRow();
                }
                rs.close();
                crs.beforeFirst();
                crs.setType(1003);
                crs.setFetchDirection(1000);
                crs.setConcurrency(1007);
                IfxClientResultSet ifxClientResultSet = crs;
                return ifxClientResultSet;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public ResultSet getColumnPrivileges(String catalog, String schemaName, String table, String column) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        String dbName = this.getMetaDbName(catalog);
        schema = this.toSchemaCaseLikeServer(schema);
        table = this.processPattern(table);
        String sql = "SELECT sc.colname, sc.colno, sc.coltype, sc.collength  FROM " + dbName + ":informix.systables st, " + dbName + ":informix.sysconstraints so, " + dbName + ":informix.sysindexes si, " + dbName + ":informix.syscolumns sc  WHERE (st.tabname LIKE ? ) AND  st.tabid = so.tabid AND so.constrtype = 'P' AND so.idxname = si.idxname AND sc.tabid = st.tabid AND st.owner LIKE ? AND   (sc.colno = si.part1 OR    sc.colno = si.part2 OR    sc.colno = si.part3 OR    sc.colno = si.part4 OR    sc.colno = si.part5 OR    sc.colno = si.part6 OR    sc.colno = si.part7 OR    sc.colno = si.part8 OR   sc.colno = si.part9 OR    sc.colno = si.part10 OR    sc.colno = si.part11 OR    sc.colno = si.part12 OR    sc.colno = si.part13 OR    sc.colno = si.part14 OR    sc.colno = si.part15 OR    sc.colno = si.part16 ";
        sql = sql + ")";
        sql = sql + " order by 2";
        try {
            try (IfxPreparedStatement pStmt = (IfxPreparedStatement)this.conn.prepareStatement(sql);){
                pStmt.setString(1, table);
                pStmt.setString(2, schema);
                ResultSet rs = pStmt.executeQuery(this.useWithHold());
                ResultSetMetaData rsmd = rs.getMetaData();
                IfxResultSetMetaData rsmd1 = new IfxResultSetMetaData(8, this.conn);
                int vCharColSize = this.maxlogicalvchar;
                int colPos = 0;
                int currCol = 1;
                int colLen = vCharColSize;
                rsmd1.setColumnName(currCol, this.conn.retCapName("SCOPE"));
                rsmd1.setIfxColumnType(currCol, 1);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("COLUMN_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("DATA_TYPE"));
                rsmd1.setIfxColumnType(currCol, 1);
                colLen = 2;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("TYPE_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("COLUMN_SIZE"));
                rsmd1.setIfxColumnType(currCol, 2);
                colLen = 4;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("BUFFER_LENGTH"));
                rsmd1.setIfxColumnType(currCol, 1);
                colLen = 2;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("DECIMAL_DIGITS"));
                rsmd1.setIfxColumnType(currCol, 1);
                colLen = 2;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("PSEUDO_COLUMN"));
                rsmd1.setIfxColumnType(currCol, 1);
                colLen = 2;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                ++currCol;
                rsmd = rsmd1;
                IfxClientResultSet crs = new IfxClientResultSet(this.conn, rsmd);
                int columnCount = rsmd.getColumnCount();
                Object obj = null;
                crs.moveToInsertRow();
                while (rs.next()) {
                    short coltype = rs.getShort(3);
                    short umaskcoltype = (short)(coltype & 0xFF);
                    umaskcoltype = (short)(coltype & 0xFF);
                    short data_type = (short)IfxTypes.FromIfxToJDBCType(umaskcoltype);
                    for (int i1 = 1; i1 <= columnCount; ++i1) {
                        obj = rsmd.getColumnName(i1).equalsIgnoreCase("scope") ? Short.valueOf((short)2) : (rsmd.getColumnName(i1).equalsIgnoreCase("COLUMN_NAME") ? rs.getString(1) : (rsmd.getColumnName(i1).equalsIgnoreCase("DATA_TYPE") ? Short.valueOf(data_type) : (rsmd.getColumnName(i1).equalsIgnoreCase("TYPE_NAME") ? IfxTypes.IfxTypeToName(umaskcoltype) : (rsmd.getColumnName(i1).equalsIgnoreCase("COLUMN_SIZE") ? Integer.valueOf(rs.getShort(4)) : (rsmd.getColumnName(i1).equalsIgnoreCase("BUFFER_LENGTH") ? Integer.valueOf(0) : (rsmd.getColumnName(i1).equalsIgnoreCase("DECIMAL_DIGITS") ? Short.valueOf((short)0) : (rsmd.getColumnName(i1).equalsIgnoreCase("PSEUDO_COLUMN") ? Short.valueOf((short)1) : rs.getObject(i1))))))));
                        crs.updateObject(i1, obj);
                    }
                    if (!((IfxSqliConnect)this.conn).isReplCheckColumnEnabled() && rs.getObject("column_name").toString().equals("ifx_replcheck")) continue;
                    crs.insertRow();
                }
                rs.close();
                crs.beforeFirst();
                crs.setType(1003);
                crs.setFetchDirection(1000);
                crs.setConcurrency(1007);
                IfxClientResultSet ifxClientResultSet = crs;
                return ifxClientResultSet;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        String dbName = this.getMetaDbName(catalog);
        schema = this.toSchemaCaseLikeServer(schema);
        table = this.processPattern(table);
        String query = "select 0 as SCOPE, c.colname as COLUMN_NAME, c.coltype as DATA_TYPE, schema_coltypename(c.coltype,c.extended_id), c.collength as COLUMN_SIZE, c.collength as BUFFER_LENGTH, informix.schema_precision(c.coltype, c.extended_id, c.collength) as DECIMAL_DIGITS, 1 as PSEUDO_COLUMN from " + dbName + ":informix.systables t, " + dbName + ":informix.syscolumns c where t.tabid = c.tabid and t.owner like ? and t.tabname like ? and mod(c.coltype,256) = 6";
        try {
            try (IfxPreparedStatement versionColumnStatement = (IfxPreparedStatement)this.conn.prepareStatement(query);){
                versionColumnStatement.setString(1, schema);
                versionColumnStatement.setString(2, table);
                ResultSet results = versionColumnStatement.executeQuery(this.useWithHold());
                IfxResultSetMetaData rsmd1 = new IfxResultSetMetaData(8, this.conn);
                int vCharColSize = this.maxlogicalvchar;
                int colPos = 0;
                int currCol = 1;
                int colLen = vCharColSize;
                rsmd1.setColumnName(currCol, this.conn.retCapName("SCOPE"));
                rsmd1.setIfxColumnType(currCol, 1);
                colLen = 2;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("COLUMN_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("DATA_TYPE"));
                rsmd1.setIfxColumnType(currCol, 2);
                colLen = 4;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("TYPE_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("COLUMN_SIZE"));
                rsmd1.setIfxColumnType(currCol, 2);
                colLen = 4;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("BUFFER_LENGTH"));
                rsmd1.setIfxColumnType(currCol, 1);
                colLen = 2;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("DECIMAL_DIGITS"));
                rsmd1.setIfxColumnType(currCol, 2);
                colLen = 4;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("PSEUDO_COLUMN"));
                rsmd1.setIfxColumnType(currCol, 1);
                colLen = 2;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                ++currCol;
                ResultSet resultSet = this.populateClientResultSet(results, rsmd1);
                return resultSet;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        String dbName = this.getMetaDbName(catalog);
        schema = this.toSchemaCaseLikeServer(schema);
        table = this.processPattern(table);
        String sql = "  select   sc.colname,  so.constrname,   st.tabname,   st.owner,   sc.colno,   ABS(si.part1),ABS(si.part2),ABS(si.part3),ABS(si.part4),  ABS(si.part5),ABS(si.part6),ABS(si.part7),ABS(si.part8)  ,ABS(si.part9),ABS(si.part10),ABS(si.part11),ABS(si.part12), ABS(si.part13),ABS(si.part14),ABS(si.part15),ABS(si.part16)  from " + dbName + ":informix.systables st," + dbName + ":informix.sysconstraints so," + dbName + ":informix.sysindexes si," + dbName + ":informix.syscolumns sc   where   ( st.tabname like ?) and  st.tabid = so.tabid and  so.constrtype = 'P' and  so.idxname = si.idxname and  sc.tabid = st.tabid and  st.owner like ? and  (sc.colno = ABS(si.part1) or    sc.colno = ABS(si.part2) or    sc.colno = ABS(si.part3) or    sc.colno = ABS(si.part4) or    sc.colno = ABS(si.part5) or    sc.colno = ABS(si.part6) or    sc.colno = ABS(si.part7) or    sc.colno = ABS(si.part8) ";
        sql = sql + " or sc.colno = ABS(si.part9) or     sc.colno = ABS(si.part10) or     sc.colno = ABS(si.part11) or     sc.colno = ABS(si.part12) or     sc.colno = ABS(si.part13) or     sc.colno = ABS(si.part14) or     sc.colno = ABS(si.part15) or     sc.colno = ABS(si.part16) ";
        sql = sql + ") order by 1";
        try {
            try (IfxPreparedStatement primaryKey1Statement = (IfxPreparedStatement)this.conn.prepareStatement(sql);){
                primaryKey1Statement.setString(1, table);
                primaryKey1Statement.setString(2, schema);
                ResultSet rs = primaryKey1Statement.executeQuery(this.useWithHold());
                ResultSetMetaData rsmd = rs.getMetaData();
                IfxResultSetMetaData rsmd1 = new IfxResultSetMetaData(6, this.conn);
                int vCharColSize = this.maxlogicalvchar;
                int colPos = 0;
                int currCol = 1;
                int colLen = vCharColSize;
                rsmd1.setColumnName(currCol, this.conn.retCapName("TABLE_CAT"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("TABLE_SCHEM"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("TABLE_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("COLUMN_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("KEY_SEQ"));
                rsmd1.setIfxColumnType(currCol, 1);
                colLen = 2;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("PK_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                ++currCol;
                rsmd = rsmd1;
                IfxClientResultSet crs = new IfxClientResultSet(this.conn, rsmd);
                int columnCount = rsmd.getColumnCount();
                Object obj = null;
                crs.moveToInsertRow();
                int maxPartNum = 16;
                while (rs.next()) {
                    String colname = rs.getString(1);
                    String constrname = rs.getString(2);
                    String tabname = rs.getString(3);
                    String owner = rs.getString(4);
                    if (colname != null) {
                        colname = colname.trim();
                    }
                    if (constrname != null) {
                        constrname = constrname.trim();
                    }
                    if (tabname != null) {
                        tabname = tabname.trim();
                    }
                    if (owner != null) {
                        owner = owner.trim();
                    }
                    int colno = rs.getInt(5);
                    short keySeq = 0;
                    for (int i = 0; i < maxPartNum; ++i) {
                        if (colno != rs.getInt(6 + i)) continue;
                        keySeq = (short)(i + 1);
                        break;
                    }
                    for (int i1 = 1; i1 <= columnCount; ++i1) {
                        obj = rsmd.getColumnName(i1).equalsIgnoreCase("TABLE_CAT") ? dbName : (rsmd.getColumnName(i1).equalsIgnoreCase("TABLE_SCHEM") ? owner : (rsmd.getColumnName(i1).equalsIgnoreCase("TABLE_NAME") ? tabname : (rsmd.getColumnName(i1).equalsIgnoreCase("COLUMN_NAME") ? colname : (rsmd.getColumnName(i1).equalsIgnoreCase("KEY_SEQ") ? Short.valueOf(keySeq) : (rsmd.getColumnName(i1).equalsIgnoreCase("PK_NAME") ? constrname : rs.getObject(i1))))));
                        crs.updateObject(i1, obj);
                    }
                    if (!((IfxSqliConnect)this.conn).isReplCheckColumnEnabled() && rs.getObject("column_name").toString().equals("ifx_replcheck")) continue;
                    crs.insertRow();
                }
                rs.close();
                crs.beforeFirst();
                crs.setType(1003);
                crs.setFetchDirection(1000);
                crs.setConcurrency(1007);
                IfxClientResultSet ifxClientResultSet = crs;
                return ifxClientResultSet;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public ResultSet getImportedKeys(String catalog, String schemaName, String table) throws SQLException {
        short keyseq = 0;
        if (!this.conn.isDbOpen()) {
            return null;
        }
        String dbName = this.getMetaDbName(catalog);
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        schemaName = this.toSchemaCaseLikeServer(schemaName);
        table = this.processPattern(table);
        String sqlStr = "select pt.tabname, pc.colname, ft.owner, ft.tabname, fc.colname, fk.constrname, pk.constrname, r.delrule, pt.owner, fc.colno,   ABS(fi.part1),ABS(fi.part2),ABS(fi.part3),ABS(fi.part4),ABS(fi.part5),ABS(fi.part6),ABS(fi.part7),ABS(fi.part8) ,ABS(fi.part9),ABS(fi.part10),ABS(fi.part11),ABS(fi.part12),ABS(fi.part13),ABS(fi.part14),ABS(fi.part15),ABS(fi.part16), CASE WHEN fc.colno=ABS(fi.part1) THEN 1  WHEN fc.colno=ABS(fi.part2) THEN 2  WHEN fc.colno=ABS(fi.part3) THEN 3  WHEN fc.colno=ABS(fi.part4) THEN 4  WHEN fc.colno=ABS(fi.part5) THEN 5  WHEN fc.colno=ABS(fi.part6) THEN 6  WHEN fc.colno=ABS(fi.part7) THEN 7  WHEN fc.colno=ABS(fi.part8) THEN 8  WHEN fc.colno=ABS(fi.part9) THEN 9  WHEN fc.colno=ABS(fi.part10) THEN 10  WHEN fc.colno=ABS(fi.part11) THEN 11  WHEN fc.colno=ABS(fi.part12) THEN 12  WHEN fc.colno=ABS(fi.part13) THEN 13  WHEN fc.colno=ABS(fi.part14) THEN 14  WHEN fc.colno=ABS(fi.part15) THEN 15  WHEN fc.colno=ABS(fi.part16) THEN 16 END AS KeySeq, '" + dbName + "' AS DBName  from " + dbName + ":informix.systables pt, " + dbName + ":informix.syscolumns pc, " + dbName + ":informix.sysindexes pi, " + dbName + ":informix.sysconstraints pk, " + dbName + ":informix.systables ft, " + dbName + ":informix.syscolumns fc, " + dbName + ":informix.sysindexes fi, " + dbName + ":informix.sysconstraints fk, " + dbName + ":informix.sysreferences r where pt.tabid=pc.tabid and pc.tabid=pi.tabid and pt.tabid=pk.tabid and pk.constrid=r.primary and r.constrid=fk.constrid and pi.idxname=pk.idxname and fi.idxname=fk.idxname and ft.tabid=fc.tabid and fc.tabid=fi.tabid and ft.tabid=fk.tabid and pt.owner like ? and (pc.colno=ABS(pi.part1) and fc.colno=ABS(fi.part1) or pc.colno=ABS(pi.part2) and fc.colno=ABS(fi.part2) or pc.colno=ABS(pi.part3) and fc.colno=ABS(fi.part3) or pc.colno=ABS(pi.part4) and fc.colno=ABS(fi.part4) or pc.colno=ABS(pi.part5) and fc.colno=ABS(fi.part5) or pc.colno=ABS(pi.part6) and fc.colno=ABS(fi.part6) or pc.colno=ABS(pi.part7) and fc.colno=ABS(fi.part7) or pc.colno=ABS(pi.part8) and fc.colno=ABS(fi.part8)";
        sqlStr = sqlStr + "or pc.colno=ABS(pi.part9) and fc.colno=ABS(fi.part9) or pc.colno=ABS(pi.part10) and fc.colno=ABS(fi.part10) or pc.colno=ABS(pi.part11) and fc.colno=ABS(fi.part11) or pc.colno=ABS(pi.part12) and fc.colno=ABS(fi.part12) or pc.colno=ABS(pi.part13) and fc.colno=ABS(fi.part13) or pc.colno=ABS(pi.part14) and fc.colno=ABS(fi.part14) or pc.colno=ABS(pi.part15) and fc.colno=ABS(fi.part15) or pc.colno=ABS(pi.part16) and fc.colno=ABS(fi.part16)) ";
        sqlStr = sqlStr + "and ft.owner like ? and ft.tabname like ? order by DBName ,pt.owner, pt.tabname, KeySeq;";
        try {
            try (IfxPreparedStatement importedKeyStatement1 = (IfxPreparedStatement)this.conn.prepareStatement(sqlStr);){
                importedKeyStatement1.setString(1, schemaName);
                importedKeyStatement1.setString(2, schemaName);
                importedKeyStatement1.setString(3, table);
                ResultSet rs = importedKeyStatement1.executeQuery(this.useWithHold());
                ResultSetMetaData rsmd = rs.getMetaData();
                IfxResultSetMetaData rsmd1 = new IfxResultSetMetaData(14, this.conn);
                int vCharColSize = this.maxlogicalvchar;
                int colPos = 0;
                int currCol = 1;
                int colLen = vCharColSize;
                rsmd1.setColumnName(currCol, this.conn.retCapName("PKTABLE_CAT"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("PKTABLE_SCHEM"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("PKTABLE_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("PKCOLUMN_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("FKTABLE_CAT"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("FKTABLE_SCHEM"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("FKTABLE_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("FKCOLUMN_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("KEY_SEQ"));
                rsmd1.setIfxColumnType(currCol, 1);
                colLen = 2;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("UPDATE_RULE"));
                rsmd1.setIfxColumnType(currCol, 1);
                colLen = 2;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("DELETE_RULE"));
                rsmd1.setIfxColumnType(currCol, 1);
                colLen = 2;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("FK_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("PK_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("DEFERRABILITY"));
                rsmd1.setIfxColumnType(currCol, 1);
                colLen = 2;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                ++currCol;
                rsmd = rsmd1;
                IfxClientResultSet crs = new IfxClientResultSet(this.conn, rsmd);
                int columnCount = rsmd.getColumnCount();
                Object obj = null;
                crs.moveToInsertRow();
                while (rs.next()) {
                    String ptabname = rs.getString(1).trim();
                    String pcolname = rs.getString(2).trim();
                    String fowner = rs.getString(3).trim();
                    String ftabname = rs.getString(4).trim();
                    String fcolname = rs.getString(5).trim();
                    String fconstrname = rs.getString(6).trim();
                    String pconstrname = rs.getString(7).trim();
                    String delrule = rs.getString(8);
                    String powner = rs.getString(9).trim();
                    int colno = rs.getInt(10);
                    keyseq = rs.getShort(27);
                    short drule = delrule.equals("C") ? (short)0 : 1;
                    for (int i1 = 1; i1 <= columnCount; ++i1) {
                        obj = rsmd.getColumnName(i1).equalsIgnoreCase("PKTABLE_CAT") ? dbName : (rsmd.getColumnName(i1).equalsIgnoreCase("PKTABLE_SCHEM") ? powner : (rsmd.getColumnName(i1).equalsIgnoreCase("PKTABLE_NAME") ? ptabname : (rsmd.getColumnName(i1).equalsIgnoreCase("PKCOLUMN_NAME") ? pcolname : (rsmd.getColumnName(i1).equalsIgnoreCase("FKTABLE_CAT") ? dbName : (rsmd.getColumnName(i1).equalsIgnoreCase("FKTABLE_SCHEM") ? fowner : (rsmd.getColumnName(i1).equalsIgnoreCase("FKTABLE_NAME") ? ftabname : (rsmd.getColumnName(i1).equalsIgnoreCase("FKCOLUMN_NAME") ? fcolname : (rsmd.getColumnName(i1).equalsIgnoreCase("KEY_SEQ") ? new Short(keyseq) : (rsmd.getColumnName(i1).equalsIgnoreCase("UPDATE_RULE") ? new Short(1) : (rsmd.getColumnName(i1).equalsIgnoreCase("DELETE_RULE") ? new Short(drule) : (rsmd.getColumnName(i1).equalsIgnoreCase("FK_NAME") ? fconstrname : (rsmd.getColumnName(i1).equalsIgnoreCase("PK_NAME") ? pconstrname : (rsmd.getColumnName(i1).equalsIgnoreCase("DEFERRABILITY") ? new Short(7) : rs.getObject(i1))))))))))))));
                        crs.updateObject(i1, obj);
                    }
                    if (!((IfxSqliConnect)this.conn).isReplCheckColumnEnabled() && rs.getObject("column_name").toString().equals("ifx_replcheck")) continue;
                    crs.insertRow();
                }
                rs.close();
                crs.beforeFirst();
                crs.setType(1003);
                crs.setFetchDirection(1000);
                crs.setConcurrency(1007);
                IfxClientResultSet ifxClientResultSet = crs;
                return ifxClientResultSet;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public ResultSet getExportedKeys(String catalog, String schemaName, String table) throws SQLException {
        short keyseq = 0;
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        String dbName = this.getMetaDbName(catalog);
        schemaName = this.toSchemaCaseLikeServer(schemaName);
        table = this.processPattern(table);
        String sqlStr = "select pt.tabname, pc.colname, ft.owner, ft.tabname, fc.colname, fk.constrname, pk.constrname, r.delrule, pt.owner, fc.colno, ABS(fi.part1),ABS(fi.part2),ABS(fi.part3),ABS(fi.part4),ABS(fi.part5),ABS(fi.part6),ABS(fi.part7),ABS(fi.part8) ,ABS(fi.part9),ABS(fi.part10),ABS(fi.part11),ABS(fi.part12),ABS(fi.part13),ABS(fi.part14),ABS(fi.part15),ABS(fi.part16) , CASE WHEN fc.colno=ABS(fi.part1) THEN 1  WHEN fc.colno=ABS(fi.part2) THEN 2  WHEN fc.colno=ABS(fi.part3) THEN 3  WHEN fc.colno=ABS(fi.part4) THEN 4  WHEN fc.colno=ABS(fi.part5) THEN 5  WHEN fc.colno=ABS(fi.part6) THEN 6  WHEN fc.colno=ABS(fi.part7) THEN 7  WHEN fc.colno=ABS(fi.part8) THEN 8  WHEN fc.colno=ABS(fi.part9) THEN 9  WHEN fc.colno=ABS(fi.part10) THEN 10  WHEN fc.colno=ABS(fi.part11) THEN 11  WHEN fc.colno=ABS(fi.part12) THEN 12  WHEN fc.colno=ABS(fi.part13) THEN 13  WHEN fc.colno=ABS(fi.part14) THEN 14  WHEN fc.colno=ABS(fi.part15) THEN 15  WHEN fc.colno=ABS(fi.part16) THEN 16 END AS KeySeq, '" + dbName + "' AS DBName  from " + dbName + ":informix.systables pt, " + dbName + ":informix.syscolumns pc, " + dbName + ":informix.sysindexes pi, " + dbName + ":informix.sysconstraints pk, " + dbName + ":informix.systables ft, " + dbName + ":informix.syscolumns fc, " + dbName + ":informix.sysindexes fi, " + dbName + ":informix.sysconstraints fk, " + dbName + ":informix.sysreferences r where pt.tabid=pc.tabid and pc.tabid=pi.tabid and pt.tabid=pk.tabid and pk.constrid=r.primary and r.constrid=fk.constrid and pi.idxname=pk.idxname and fi.idxname=fk.idxname and ft.tabid=fc.tabid and fc.tabid=fi.tabid and ft.tabid=fk.tabid and (pc.colno=ABS(pi.part1) and fc.colno=ABS(fi.part1) or pc.colno=ABS(pi.part2) and fc.colno=ABS(fi.part2) or pc.colno=ABS(pi.part3) and fc.colno=ABS(fi.part3) or pc.colno=ABS(pi.part4) and fc.colno=ABS(fi.part4) or pc.colno=ABS(pi.part5) and fc.colno=ABS(fi.part5) or pc.colno=ABS(pi.part6) and fc.colno=ABS(fi.part6) or pc.colno=ABS(pi.part7) and fc.colno=ABS(fi.part7) or pc.colno=ABS(pi.part8) and fc.colno=ABS(fi.part8) ";
        sqlStr = sqlStr + "or pc.colno=ABS(pi.part9) and fc.colno=ABS(fi.part9) or pc.colno=ABS(pi.part10) and fc.colno=ABS(fi.part10) or pc.colno=ABS(pi.part11) and fc.colno=ABS(fi.part11) or pc.colno=ABS(pi.part12) and fc.colno=ABS(fi.part12) or pc.colno=ABS(pi.part13) and fc.colno=ABS(fi.part13) or pc.colno=ABS(pi.part14) and fc.colno=ABS(fi.part14) or pc.colno=ABS(pi.part15) and fc.colno=ABS(fi.part15) or pc.colno=ABS(pi.part16) and fc.colno=ABS(fi.part16)) ";
        sqlStr = sqlStr + "and pt.owner like ? and pt.tabname like ? order by DBName, ft.owner, ft.tabname, KeySeq;";
        try {
            try (IfxPreparedStatement exportedKeyStatement1 = (IfxPreparedStatement)this.conn.prepareStatement(sqlStr);){
                exportedKeyStatement1.setString(1, schemaName);
                exportedKeyStatement1.setString(2, table);
                ResultSet rs = exportedKeyStatement1.executeQuery(this.useWithHold());
                ResultSetMetaData rsmd = rs.getMetaData();
                IfxResultSetMetaData rsmd1 = new IfxResultSetMetaData(14, this.conn);
                int vCharColSize = this.maxlogicalvchar;
                int colPos = 0;
                int currCol = 1;
                int colLen = vCharColSize;
                rsmd1.setColumnName(currCol, this.conn.retCapName("PKTABLE_CAT"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("PKTABLE_SCHEM"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("PKTABLE_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("PKCOLUMN_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("FKTABLE_CAT"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("FKTABLE_SCHEM"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("FKTABLE_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("FKCOLUMN_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("KEY_SEQ"));
                rsmd1.setIfxColumnType(currCol, 1);
                colLen = 2;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("UPDATE_RULE"));
                rsmd1.setIfxColumnType(currCol, 1);
                colLen = 2;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("DELETE_RULE"));
                rsmd1.setIfxColumnType(currCol, 1);
                colLen = 2;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("FK_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("PK_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("DEFERRABILITY"));
                rsmd1.setIfxColumnType(currCol, 1);
                colLen = 2;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                ++currCol;
                rsmd = rsmd1;
                IfxClientResultSet crs = new IfxClientResultSet(this.conn, rsmd);
                int columnCount = rsmd.getColumnCount();
                Object obj = null;
                crs.moveToInsertRow();
                while (rs.next()) {
                    String ptabname = rs.getString(1);
                    String pcolname = rs.getString(2);
                    String fowner = rs.getString(3).trim();
                    String ftabname = rs.getString(4);
                    String fcolname = rs.getString(5);
                    String fconstrname = rs.getString(6);
                    String pconstrname = rs.getString(7);
                    String delrule = rs.getString(8);
                    String powner = rs.getString(9).trim();
                    int colno = rs.getInt(10);
                    keyseq = rs.getShort(27);
                    short drule = delrule.equals("C") ? (short)0 : 1;
                    for (int i1 = 1; i1 <= columnCount; ++i1) {
                        obj = rsmd.getColumnName(i1).equalsIgnoreCase("PKTABLE_CAT") ? dbName : (rsmd.getColumnName(i1).equalsIgnoreCase("PKTABLE_SCHEM") ? powner : (rsmd.getColumnName(i1).equalsIgnoreCase("PKTABLE_NAME") ? ptabname : (rsmd.getColumnName(i1).equalsIgnoreCase("PKCOLUMN_NAME") ? pcolname : (rsmd.getColumnName(i1).equalsIgnoreCase("FKTABLE_CAT") ? dbName : (rsmd.getColumnName(i1).equalsIgnoreCase("FKTABLE_SCHEM") ? fowner : (rsmd.getColumnName(i1).equalsIgnoreCase("FKTABLE_NAME") ? ftabname : (rsmd.getColumnName(i1).equalsIgnoreCase("FKCOLUMN_NAME") ? fcolname : (rsmd.getColumnName(i1).equalsIgnoreCase("KEY_SEQ") ? new Short(keyseq) : (rsmd.getColumnName(i1).equalsIgnoreCase("UPDATE_RULE") ? new Short(1) : (rsmd.getColumnName(i1).equalsIgnoreCase("DELETE_RULE") ? new Short(drule) : (rsmd.getColumnName(i1).equalsIgnoreCase("FK_NAME") ? fconstrname : (rsmd.getColumnName(i1).equalsIgnoreCase("PK_NAME") ? pconstrname : (rsmd.getColumnName(i1).equalsIgnoreCase("DEFERRABILITY") ? new Short(7) : rs.getObject(i1))))))))))))));
                        crs.updateObject(i1, obj);
                    }
                    if (!((IfxSqliConnect)this.conn).isReplCheckColumnEnabled() && rs.getObject("column_name").toString().equals("ifx_replcheck")) continue;
                    crs.insertRow();
                }
                rs.close();
                crs.beforeFirst();
                crs.setType(1003);
                crs.setFetchDirection(1000);
                crs.setConcurrency(1007);
                IfxClientResultSet ifxClientResultSet = crs;
                return ifxClientResultSet;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        short keyseq = 0;
        if (!this.conn.isDbOpen()) {
            return null;
        }
        if (primaryTable == null || primaryTable.length() == 0) {
            throw Messages.getSQLException(-79708);
        }
        primarySchema = this.toSchemaCaseLikeServer(primarySchema);
        foreignSchema = this.toSchemaCaseLikeServer(foreignSchema);
        primaryTable = this.processPattern(primaryTable);
        foreignTable = this.processPattern(foreignTable);
        String dbName = this.getMetaDbName(primaryCatalog);
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        String query = "select pt.tabname, pc.colname, ft.owner, ft.tabname, fc.colname, fk.constrname, pk.constrname, r.delrule, pt.owner, fc.colno,  ABS(fi.part1),ABS(fi.part2),ABS(fi.part3),ABS(fi.part4),ABS(fi.part5),ABS(fi.part6),ABS(fi.part7),ABS(fi.part8) ,ABS(fi.part9),ABS(fi.part10),ABS(fi.part11),ABS(fi.part12),ABS(fi.part13),ABS(fi.part14),ABS(fi.part15),ABS(fi.part16) , CASE WHEN fc.colno=ABS(fi.part1) THEN 1  WHEN fc.colno=ABS(fi.part2) THEN 2  WHEN fc.colno=ABS(fi.part3) THEN 3  WHEN fc.colno=ABS(fi.part4) THEN 4  WHEN fc.colno=ABS(fi.part5) THEN 5  WHEN fc.colno=ABS(fi.part6) THEN 6  WHEN fc.colno=ABS(fi.part7) THEN 7  WHEN fc.colno=ABS(fi.part8) THEN 8  WHEN fc.colno=ABS(fi.part9) THEN 9  WHEN fc.colno=ABS(fi.part10) THEN 10  WHEN fc.colno=ABS(fi.part11) THEN 11  WHEN fc.colno=ABS(fi.part12) THEN 12  WHEN fc.colno=ABS(fi.part13) THEN 13  WHEN fc.colno=ABS(fi.part14) THEN 14  WHEN fc.colno=ABS(fi.part15) THEN 15  WHEN fc.colno=ABS(fi.part16) THEN 16 END AS KeySeq, '" + dbName + "' AS DBName  from " + dbName + ":informix.systables pt, " + dbName + ":informix.syscolumns pc, " + dbName + ":informix.sysindexes pi, " + dbName + ":informix.sysconstraints pk, " + dbName + ":informix.systables ft, " + dbName + ":informix.syscolumns fc, " + dbName + ":informix.sysindexes fi, " + dbName + ":informix.sysconstraints fk, " + dbName + ":informix.sysreferences r where pt.tabid=pc.tabid and pc.tabid=pi.tabid and pt.tabid=pk.tabid and pk.constrid=r.primary and r.constrid=fk.constrid and pi.idxname=pk.idxname and fi.idxname=fk.idxname and ft.tabid=fc.tabid and fc.tabid=fi.tabid and ft.tabid=fk.tabid and ((pc.colno=ABS(pi.part1) and fc.colno=ABS(fi.part1)) or  (pc.colno=ABS(pi.part2) and fc.colno=ABS(fi.part2)) or  (pc.colno=ABS(pi.part3) and fc.colno=ABS(fi.part3)) or  (pc.colno=ABS(pi.part4) and fc.colno=ABS(fi.part4)) or  (pc.colno=ABS(pi.part5) and fc.colno=ABS(fi.part5)) or  (pc.colno=ABS(pi.part6) and fc.colno=ABS(fi.part6)) or  (pc.colno=ABS(pi.part7) and fc.colno=ABS(fi.part7)) or  (pc.colno=ABS(pi.part8) and fc.colno=ABS(fi.part8))  ";
        query = query + " or (pc.colno=ABS(pi.part9) and fc.colno=ABS(fi.part9))  or (pc.colno=ABS(pi.part10) and fc.colno=ABS(fi.part10))  or (pc.colno=ABS(pi.part11) and fc.colno=ABS(fi.part11))  or (pc.colno=ABS(pi.part12) and fc.colno=ABS(fi.part12))  or (pc.colno=ABS(pi.part13) and fc.colno=ABS(fi.part13))  or (pc.colno=ABS(pi.part14) and fc.colno=ABS(fi.part14))  or (pc.colno=ABS(pi.part15) and fc.colno=ABS(fi.part15))  or (pc.colno=ABS(pi.part16) and fc.colno=ABS(fi.part16)) ";
        query = query + ") and pt.owner like ? and ft.owner like ? and pt.tabname like ? and ft.tabname like ? order by DBName, ft.owner, ft.tabname,KeySeq;";
        try {
            try (IfxPreparedStatement crossRefStatement1 = (IfxPreparedStatement)this.conn.prepareStatement(query);){
                crossRefStatement1.setString(1, primarySchema);
                crossRefStatement1.setString(2, foreignSchema);
                crossRefStatement1.setString(3, primaryTable);
                crossRefStatement1.setString(4, foreignTable);
                ResultSet rs = crossRefStatement1.executeQuery(this.useWithHold());
                ResultSetMetaData rsmd = rs.getMetaData();
                IfxResultSetMetaData rsmd1 = new IfxResultSetMetaData(14, this.conn);
                int vCharColSize = this.maxlogicalvchar;
                int colPos = 0;
                int currCol = 1;
                int colLen = vCharColSize;
                rsmd1.setColumnName(currCol, this.conn.retCapName("PKTABLE_CAT"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("PKTABLE_SCHEM"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("PKTABLE_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("PKCOLUMN_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("FKTABLE_CAT"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("FKTABLE_SCHEM"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("FKTABLE_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("FKCOLUMN_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("KEY_SEQ"));
                rsmd1.setIfxColumnType(currCol, 1);
                colLen = 2;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("UPDATE_RULE"));
                rsmd1.setIfxColumnType(currCol, 1);
                colLen = 2;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("DELETE_RULE"));
                rsmd1.setIfxColumnType(currCol, 1);
                colLen = 2;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("FK_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("PK_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("DEFERRABILITY"));
                rsmd1.setIfxColumnType(currCol, 1);
                colLen = 2;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen;
                ++currCol;
                rsmd = rsmd1;
                IfxClientResultSet crs = new IfxClientResultSet(this.conn, rsmd);
                int columnCount = rsmd.getColumnCount();
                Object obj = null;
                crs.moveToInsertRow();
                while (rs.next()) {
                    String ptabname = rs.getString(1);
                    String pcolname = rs.getString(2);
                    String fowner = rs.getString(3);
                    String ftabname = rs.getString(4);
                    String fcolname = rs.getString(5);
                    String fconstrname = rs.getString(6);
                    String pconstrname = rs.getString(7);
                    String delrule = rs.getString(8);
                    String powner = rs.getString(9);
                    int colno = rs.getInt(10);
                    keyseq = rs.getShort(27);
                    short drule = delrule.equals("C") ? (short)0 : 1;
                    for (int i1 = 1; i1 <= columnCount; ++i1) {
                        obj = rsmd.getColumnName(i1).equalsIgnoreCase("PKTABLE_CAT") ? dbName : (rsmd.getColumnName(i1).equalsIgnoreCase("PKTABLE_SCHEM") ? powner.trim() : (rsmd.getColumnName(i1).equalsIgnoreCase("PKTABLE_NAME") ? ptabname : (rsmd.getColumnName(i1).equalsIgnoreCase("PKCOLUMN_NAME") ? pcolname : (rsmd.getColumnName(i1).equalsIgnoreCase("FKTABLE_CAT") ? dbName : (rsmd.getColumnName(i1).equalsIgnoreCase("FKTABLE_SCHEM") ? fowner.trim() : (rsmd.getColumnName(i1).equalsIgnoreCase("FKTABLE_NAME") ? ftabname : (rsmd.getColumnName(i1).equalsIgnoreCase("FKCOLUMN_NAME") ? fcolname : (rsmd.getColumnName(i1).equalsIgnoreCase("KEY_SEQ") ? Short.valueOf(keyseq) : (rsmd.getColumnName(i1).equalsIgnoreCase("UPDATE_RULE") ? Short.valueOf((short)1) : (rsmd.getColumnName(i1).equalsIgnoreCase("DELETE_RULE") ? Short.valueOf(drule) : (rsmd.getColumnName(i1).equalsIgnoreCase("FK_NAME") ? fconstrname : (rsmd.getColumnName(i1).equalsIgnoreCase("PK_NAME") ? pconstrname : (rsmd.getColumnName(i1).equalsIgnoreCase("DEFERRABILITY") ? Short.valueOf((short)7) : rs.getObject(i1))))))))))))));
                        crs.updateObject(i1, obj);
                    }
                    if (!((IfxSqliConnect)this.conn).isReplCheckColumnEnabled() && rs.getObject("column_name").toString().equals("ifx_replcheck")) continue;
                    crs.insertRow();
                }
                rs.close();
                crs.beforeFirst();
                crs.setType(1003);
                crs.setFetchDirection(1000);
                crs.setConcurrency(1007);
                IfxClientResultSet ifxClientResultSet = crs;
                return ifxClientResultSet;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
        }
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxDatabaseMetaData:getTypeInfo() : create the ResultSetMetaData object");
        }
        IfxResultSetMetaData md = new IfxResultSetMetaData(lmd.length, this.conn);
        for (int i = 0; i < lmd.length; ++i) {
            int j = i + 1;
            md.setTableName(j, "SQL_TYPES");
            md.setColumnName(j, this.conn.retCapName(IfxDatabaseMetaData.lmd[i].colname));
            md.setIfxColumnType(j, IfxDatabaseMetaData.lmd[i].coltype & 0xFF);
            md.setEncodedLength(j, IfxDatabaseMetaData.lmd[i].collen);
            md.setNullable(j, IfxDatabaseMetaData.lmd[i].nullable ? 1 : 0);
            md.setColumnStartPosition(j, IfxDatabaseMetaData.lmd[i].stpos);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxDatabaseMetaData:getTypeInfo() : create the ClientResultSet object");
        }
        IfxClientResultSet crs = new IfxClientResultSet(this.conn, md);
        int nRows = nXtdRowTypesSupported;
        crs.newRow(nRows);
        for (int i = 0; i < nRows; ++i) {
            int j = i + 1;
            crs.updateString(j, 1, IfxDatabaseMetaData.lrow[i].tname);
            crs.updateShort(j, 2, (short)IfxDatabaseMetaData.lrow[i].jsqltype);
            crs.updateInt(j, 3, IfxDatabaseMetaData.lrow[i].precision);
            crs.updateString(j, 4, IfxDatabaseMetaData.lrow[i].lprefix);
            crs.updateString(j, 5, IfxDatabaseMetaData.lrow[i].lsuffix);
            crs.updateString(j, 6, IfxDatabaseMetaData.lrow[i].cparams);
            crs.updateShort(j, 7, (short)IfxDatabaseMetaData.lrow[i].nullable);
            crs.updateBoolean(j, 8, IfxDatabaseMetaData.lrow[i].casesen);
            crs.updateShort(j, 9, (short)IfxDatabaseMetaData.lrow[i].searchable);
            crs.updateBoolean(j, 10, IfxDatabaseMetaData.lrow[i].unsign);
            crs.updateBoolean(j, 11, IfxDatabaseMetaData.lrow[i].money);
            crs.updateBoolean(j, 12, IfxDatabaseMetaData.lrow[i].autoincrement);
            crs.updateString(j, 13, IfxDatabaseMetaData.lrow[i].ltname);
            crs.updateShort(j, 14, (short)IfxDatabaseMetaData.lrow[i].minscale);
            crs.updateShort(j, 15, (short)IfxDatabaseMetaData.lrow[i].maxscale);
            crs.updateInt(j, 16, IfxDatabaseMetaData.lrow[i].sqldatatype);
            crs.updateInt(j, 17, IfxDatabaseMetaData.lrow[i].sqldatetime);
            crs.updateInt(j, 18, IfxDatabaseMetaData.lrow[i].numradix);
        }
        crs.beforeFirst();
        crs.setFetchDirection(1000);
        crs.setConcurrency(1007);
        crs.setType(1003);
        return crs;
    }

    /*
     * Exception decompiling
     */
    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean supportsResultSetType(int type) {
        return type == 1004 || type == 1003;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return concurrency == 1007;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    private void dropTempTable(String tempTableName) {
        try (Statement stmt = this.conn.createStatement();){
            stmt.executeUpdate("drop table " + tempTableName);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private ResultSet populateClientResultSet(ResultSet rs, ResultSetMetaData rsmd) throws SQLException {
        IfxClientResultSet crs = new IfxClientResultSet(this.conn, rsmd);
        int columnCount = rsmd.getColumnCount();
        Object obj = null;
        crs.moveToInsertRow();
        while (rs.next()) {
            for (int i = 1; i <= columnCount; ++i) {
                obj = rs.getObject(i);
                if (rs.wasNull()) {
                    crs.updateNull(i);
                    continue;
                }
                crs.updateObject(i, obj);
            }
            if (!((IfxSqliConnect)this.conn).isReplCheckColumnEnabled() && rs.getObject("column_name").toString().equals("ifx_replcheck")) continue;
            crs.insertRow();
        }
        crs.beforeFirst();
        crs.setType(1003);
        crs.setFetchDirection(1000);
        crs.setConcurrency(1007);
        rs.close();
        return crs;
    }

    @Override
    public boolean supportsStatementPooling() {
        return this.conn.getPreparedStatementCache().getMaximumEntries() > 0;
    }

    @Override
    public boolean supportsSavepoints() {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() {
        if (this.conn != null) {
            return ((IfxSqliConnect)this.conn).isNamedParametersSupported();
        }
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return true;
    }

    /*
     * Loose catch block
     */
    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        if (!this.conn.isDbOpen()) {
            return null;
        }
        String dbName = this.getMetaDbName(catalog);
        if (schemaPattern == null || schemaPattern.equals("")) {
            schemaPattern = "%";
        }
        if (typeNamePattern == null || typeNamePattern.equals("")) {
            typeNamePattern = "%";
        } else {
            int ix_colon = typeNamePattern.indexOf(58);
            int ix_period = typeNamePattern.indexOf(46);
            if (ix_colon != -1) {
                dbName = typeNamePattern.substring(0, ix_colon);
                if (ix_period > ix_colon) {
                    schemaPattern = typeNamePattern.substring(ix_colon + 1, ix_period);
                    typeNamePattern = typeNamePattern.substring(ix_period + 1);
                }
            } else if (ix_period != -1) {
                schemaPattern = typeNamePattern.substring(0, ix_period);
                typeNamePattern = typeNamePattern.substring(ix_period + 1);
            }
        }
        if (!this.conn.isDelimIdentSet()) {
            typeNamePattern = typeNamePattern.toLowerCase();
            schemaPattern = this.toSchemaCaseLikeServer(schemaPattern);
        }
        String qry = "SELECT '" + dbName + "' AS  TYPE_CAT, s1.owner  as TYPE_SCHEM, s1.name  as TYPE_NAME,'" + dbName + "' as SUPERTYPE_CAT , s2.owner as SUPERTYPE_SCHEM , s2.name as  SUPERTYPE_NAME  FROM " + dbName + ":informix.sysxtdtypes s1, " + dbName + ":informix.sysxtdtypes s2 , " + dbName + ":informix.sysinherits s3  WHERE s1.name like ?and s1.owner like ? and s1.extended_id =  s3.child and s1.name != s2.name and s2.extended_id = s3.parent order by TYPE_NAME , TYPE_SCHEM";
        try {
            try (IfxPreparedStatement getUDTsStatement1 = (IfxPreparedStatement)this.conn.prepareStatement(qry);){
                ((IfxSqliConnect)this.conn).startMetaDataQuery();
                getUDTsStatement1.setString(1, typeNamePattern);
                getUDTsStatement1.setString(2, schemaPattern);
                ResultSet result = getUDTsStatement1.executeQuery(this.useWithHold());
                IfxResultSetMetaData rsmd1 = new IfxResultSetMetaData(6, this.conn);
                int vCharColSize = this.maxlogicalvchar;
                int colPos = 0;
                int currCol = 1;
                int colLen = vCharColSize;
                rsmd1.setColumnName(currCol, this.conn.retCapName("TYPE_CAT"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("TYPE_SCHEM"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("TYPE_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("SUPERTYPE_CAT"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("SUPERYTPE_SCHEM"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("SUPERTYPE_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                ++currCol;
                ResultSet resultSet = this.populateClientResultSet(result, rsmd1);
                return resultSet;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        if (!this.conn.isDbOpen()) {
            return null;
        }
        String dbName = this.getMetaDbName(catalog);
        if (schemaPattern == null || schemaPattern.equals("")) {
            schemaPattern = "%";
        }
        if (tableNamePattern == null || tableNamePattern.equals("")) {
            tableNamePattern = "%";
        } else {
            int ix_colon = tableNamePattern.indexOf(58);
            int ix_period = tableNamePattern.indexOf(46);
            if (ix_colon != -1) {
                dbName = tableNamePattern.substring(0, ix_colon);
                if (ix_period > ix_colon) {
                    schemaPattern = tableNamePattern.substring(ix_colon + 1, ix_period);
                    tableNamePattern = tableNamePattern.substring(ix_period + 1);
                }
            } else if (ix_period != -1) {
                schemaPattern = tableNamePattern.substring(0, ix_period);
                tableNamePattern = tableNamePattern.substring(ix_period + 1);
            }
        }
        if (!this.conn.isDelimIdentSet()) {
            tableNamePattern = tableNamePattern.toLowerCase();
            schemaPattern = this.toSchemaCaseLikeServer(schemaPattern);
        }
        String qry = "select '" + dbName + "' as  TABLE_CAT,s1.owner  as TABLE_SCHEM,s1.tabname  as TABLE_NAME,s2.tabname as  SUPERTABLE_NAME from " + dbName + ":informix.systables s1, " + dbName + ":informix.systables s2 , " + dbName + ":informix.sysinherits s3 where s1.tabname like ?and s1.owner like ? and s1.tabid =  s3.child and s1.tabname != s2.tabname and s2.tabid = s3.parent order by  TABLE_NAME , TABLE_SCHEM";
        try {
            try (IfxPreparedStatement getUDTsStatement1 = (IfxPreparedStatement)this.conn.prepareStatement(qry);){
                ((IfxSqliConnect)this.conn).startMetaDataQuery();
                getUDTsStatement1.setString(1, tableNamePattern);
                getUDTsStatement1.setString(2, schemaPattern);
                ResultSet result = getUDTsStatement1.executeQuery(this.useWithHold());
                IfxResultSetMetaData rsmd1 = new IfxResultSetMetaData(4, this.conn);
                int vCharColSize = this.maxlogicalvchar;
                int colPos = 0;
                int currCol = 1;
                int colLen = vCharColSize;
                rsmd1.setColumnName(currCol, this.conn.retCapName("TABLE_CAT"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("TABLE_SCHEM"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("TABLE_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                rsmd1.setColumnName(++currCol, this.conn.retCapName("SUPERTABLE_NAME"));
                rsmd1.setIfxColumnType(currCol, 13);
                colLen = vCharColSize;
                rsmd1.setEncodedLength(currCol, colLen);
                rsmd1.setTableName(currCol, "");
                rsmd1.setColtitle(currCol, null);
                rsmd1.setColumnStartPosition(currCol, colPos);
                colPos += colLen + 1;
                ++currCol;
                ResultSet resultSet = this.populateClientResultSet(result, rsmd1);
                return resultSet;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
        }
    }

    private int getNumberParentColumns(int extended_id, String dbName) throws SQLException {
        int numberParentColumns = 0;
        boolean done = false;
        String query = "select parent from " + dbName + ":informix.sysinherits where class = 't' and child = ?";
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 9, "IfxDatabaseMetaData:getNumberParentColumns query - " + query);
        }
        PreparedStatement s = this.conn.prepareStatement(query);
        s.setInt(1, extended_id);
        ResultSet rs = s.executeQuery();
        if (rs.next()) {
            extended_id = rs.getInt(1);
        } else {
            done = true;
        }
        rs.close();
        s.close();
        if (!done) {
            query = "select mode, source from " + dbName + ":informix.sysxtdtypes where extended_id=?";
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 9, "IfxDatabaseMetaData:getNumberParentColumns query - " + query);
            }
            PreparedStatement ps = this.conn.prepareStatement(query);
            while (!done) {
                ps.setInt(1, extended_id);
                rs = ps.executeQuery();
                if (rs.next()) {
                    if (!rs.getString(1).equals("D")) {
                        done = true;
                    } else {
                        extended_id = rs.getInt(2);
                    }
                }
                rs.close();
            }
            ps.close();
            query = "select count(*) from " + dbName + ":informix.sysattrtypes where extended_id=?";
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 9, "IfxDatabaseMetaData:getNumberParentColumns final query - " + query);
            }
            s = this.conn.prepareStatement(query);
            s.setInt(1, extended_id);
            rs = s.executeQuery();
            if (rs.next()) {
                numberParentColumns = rs.getInt(1);
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 9, "IfxDatabaseMetaData:getNumberParentColumns number parent columns - " + numberParentColumns);
                }
            }
            rs.close();
            s.close();
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxDatabaseMetaData:getNumberParentColumns exit");
        }
        return numberParentColumns;
    }

    /*
     * Exception decompiling
     */
    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 9 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) {
        return holdability == 1 || holdability == 2;
    }

    @Override
    public int getResultSetHoldability() {
        return 2;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        String vers = this.getDatabaseProductVersion();
        return IfxDriver.extractMajorVersion(vers);
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        String vers = this.getDatabaseProductVersion();
        return IfxDriver.extractMinorVersion(vers);
    }

    @Override
    public int getJDBCMajorVersion() {
        return IfxDriver.getJDBCMajorVersion();
    }

    @Override
    public int getJDBCMinorVersion() {
        return IfxDriver.getJDBCMinorVersion();
    }

    @Override
    public int getSQLStateType() {
        return 1;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return false;
    }

    private String checkSynonym(String tabname, String dbName) throws SQLException {
        String table_name;
        block67: {
            String type = "T";
            int tabid = 0;
            table_name = tabname;
            String sql = "select tabid, tabtype from " + dbName + ":informix.systables where (tabname like ? and owner like '%')";
            try (IfxPreparedStatement pStmt = (IfxPreparedStatement)this.conn.prepareStatement(sql);){
                pStmt.setString(1, tabname);
                try (ResultSet rs = pStmt.executeQuery();){
                    if (rs.next()) {
                        tabid = rs.getInt(1);
                        type = rs.getString(2);
                    }
                }
            }
            if (type.equalsIgnoreCase("S") || type.equalsIgnoreCase("P")) {
                int btabid = 0;
                String servername = null;
                String dbname = null;
                String owner = null;
                String tab_name = null;
                sql = "select btabid, servername, dbname, owner, tabname from " + dbName + ":informix.syssyntable where tabid = " + tabid;
                try (Statement stmt = this.conn.createStatement();){
                    try (ResultSet rs = stmt.executeQuery(sql);){
                        if (rs.next()) {
                            btabid = rs.getInt(1);
                            servername = rs.getString(2);
                            dbname = rs.getString(3);
                            owner = rs.getString(4);
                            tab_name = rs.getString(5);
                        }
                    }
                    if (btabid != 0) {
                        sql = "select tabname from " + dbName + ":informix.systables where tabid = " + btabid;
                        rs = stmt.executeQuery(sql);
                        var15_26 = null;
                        try {
                            if (rs.next()) {
                                table_name = rs.getString(1);
                            }
                            break block67;
                        }
                        catch (Throwable throwable) {
                            var15_26 = throwable;
                            throw throwable;
                        }
                        finally {
                            if (rs != null) {
                                if (var15_26 != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable) {
                                        var15_26.addSuppressed(throwable);
                                    }
                                } else {
                                    rs.close();
                                }
                            }
                        }
                    }
                    table_name = dbname + "@" + servername + ":" + owner + "." + tab_name;
                }
            }
        }
        return table_name;
    }

    private String getMetaDbName(String catalog) throws SQLException {
        if (catalog == null || catalog.length() == 0) {
            return this.conn.getCatalog();
        }
        if (catalog.contains(";")) {
            throw new SQLException("catalog names cannot have special characters");
        }
        return catalog;
    }

    protected static int getJDBCColumnSize(short ifxColType, short ifxXtdType, int collLength) {
        switch (ifxColType) {
            case 5: 
            case 8: {
                return collLength >>> 8;
            }
            case 11: 
            case 12: {
                if (lrow == null) {
                    return collLength;
                }
                return rowinfo.getPrecisionForIfxType(lrow, ifxColType, ifxXtdType);
            }
            case 41: {
                if (lrow != null && (ifxXtdType == 10 || ifxXtdType == 11)) {
                    return rowinfo.getPrecisionForIfxType(lrow, ifxColType, ifxXtdType);
                }
                return collLength;
            }
            case 17: 
            case 18: 
            case 52: 
            case 53: {
                return 19;
            }
            case 3: {
                return 17;
            }
            case 4: {
                return 7;
            }
            case 2: 
            case 6: 
            case 7: {
                return 10;
            }
            case 1: {
                return 5;
            }
            case 10: 
            case 14: {
                int tu_len = collLength >> 8 & 0xFF;
                int tu_start = collLength >> 4 & 0xF;
                int tu_end = collLength & 0xF;
                int width = tu_len + ((tu_end > 10 ? 12 : tu_end) - tu_start) / 2 + (tu_start == 12 ? 1 : 0);
                return width;
            }
        }
        return collLength;
    }

    private String toSchemaCaseLikeServer(String schemaPattern) {
        if (schemaPattern == null || schemaPattern.isEmpty()) {
            return "%";
        }
        if (!this.conn.getAutoCaseSchema() || this.conn.isDelimIdentSet()) {
            return schemaPattern;
        }
        if (this.conn.isANSI() && !schemaPattern.equalsIgnoreCase("INFORMIX")) {
            return schemaPattern.toUpperCase();
        }
        return schemaPattern.toLowerCase();
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return new IfxClientResultSet(this.conn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        IfxResultSetMetaData rsmd = new IfxResultSetMetaData(17, this.conn);
        rsmd.setColumnInfo(1, this.conn.retCapName("FUNCTION_CAT"), 13, 255);
        rsmd.setColumnInfo(2, this.conn.retCapName("FUNCTION_SCHEM"), 13, 255);
        rsmd.setColumnInfo(3, this.conn.retCapName("FUNCTION_NAME"), 13, 255);
        rsmd.setColumnInfo(4, this.conn.retCapName("COLUMN_NAME"), 13, 255);
        rsmd.setColumnInfo(5, this.conn.retCapName("COLUMN_TYPE"), 2, 4);
        rsmd.setColumnInfo(6, this.conn.retCapName("DATA_TYPE"), 2, 4);
        rsmd.setColumnInfo(7, this.conn.retCapName("TYPE_NAME"), 13, 255);
        rsmd.setColumnInfo(8, this.conn.retCapName("PRECISION"), 2, 4);
        rsmd.setColumnInfo(9, this.conn.retCapName("LENGTH"), 2, 4);
        rsmd.setColumnInfo(10, this.conn.retCapName("SCALE"), 2, 4);
        rsmd.setColumnInfo(11, this.conn.retCapName("RADIX"), 2, 4);
        rsmd.setColumnInfo(12, this.conn.retCapName("NULLABLE"), 2, 4);
        rsmd.setColumnInfo(13, this.conn.retCapName("REMARKS"), 13, 255);
        rsmd.setColumnInfo(14, this.conn.retCapName("CHAR_OCTET_LENGTH"), 2, 4);
        rsmd.setColumnInfo(15, this.conn.retCapName("ORDINAL_POSITION"), 2, 4);
        rsmd.setColumnInfo(16, this.conn.retCapName("IS_NULLABLE"), 13, 255);
        rsmd.setColumnInfo(17, this.conn.retCapName("SPECIFIC_NAME"), 13, 255);
        IfxClientResultSet crs = new IfxClientResultSet(this.conn, rsmd);
        crs.moveToInsertRow();
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        try (IfxStatement stmt = (IfxStatement)this.conn.createStatement();){
            String sql = "SELECT owner, procname, paramname, paramattr, paramtype, paramlen, p.procid,  schema_coltypename(pc.paramtype,pc.paramxid), schema_precision(pc.paramtype, pc.paramxid, pc.paramlen), schema_numscale(pc.paramtype,pc.paramlen), schema_numprecradix(pc.paramtype), schema_isnullable(pc.paramtype)::SMALLINT, informix.schema_charlen(pc.paramtype,pc.paramxid,pc.paramlen), informix.schema_nullable(pc.paramtype)::VARCHAR(3), pc.paramid FROM SYSPROCEDURES p, SYSPROCCOLUMNS pc WHERE p.procid = pc.procid";
            if (functionNamePattern != null && !functionNamePattern.isEmpty()) {
                sql = sql + " AND procname LIKE '%" + functionNamePattern + "%'";
            }
            if (schemaPattern != null && !schemaPattern.isEmpty()) {
                sql = sql + " AND owner LIKE '%" + schemaPattern + "%'";
            }
            if (columnNamePattern != null && !columnNamePattern.isEmpty()) {
                sql = sql + " AND paramname LIKE '%" + columnNamePattern + "%'";
            }
            sql = sql + " ORDER by procid";
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                crs.updateObject(1, (Object)((IfxSqliConnect)this.conn).getDbName());
                crs.updateObject(2, (Object)rs.getString(1).trim());
                crs.updateObject(3, (Object)rs.getString(2).trim());
                rs.getString(3);
                if (rs.wasNull()) {
                    crs.updateNull(4);
                } else {
                    crs.updateObject(4, (Object)rs.getString(3).trim());
                }
                switch (rs.getInt(4)) {
                    case 0: {
                        crs.updateObject(5, (Object)0);
                        break;
                    }
                    case 1: {
                        crs.updateObject(5, (Object)1);
                        break;
                    }
                    case 2: {
                        crs.updateObject(5, (Object)2);
                        break;
                    }
                    case 3: {
                        crs.updateObject(5, (Object)3);
                        break;
                    }
                    case 4: {
                        crs.updateObject(5, (Object)3);
                        break;
                    }
                    case 5: {
                        crs.updateObject(5, (Object)5);
                        break;
                    }
                    default: {
                        crs.updateObject(5, (Object)0);
                    }
                }
                crs.updateObject(6, (Object)IfxTypes.FromIfxToJDBCType(rs.getInt(5)));
                crs.updateObject(7, (Object)rs.getString(8).trim().toLowerCase());
                crs.updateObject(8, (Object)rs.getInt(9));
                crs.updateObject(9, (Object)rs.getInt(6));
                crs.updateObject(10, (Object)rs.getInt(10));
                crs.updateObject(11, (Object)rs.getInt(11));
                crs.updateObject(12, (Object)rs.getInt(12));
                crs.updateNull(13);
                crs.updateObject(14, rs.getObject(13));
                crs.updateObject(15, (Object)rs.getInt(15));
                crs.updateString(16, rs.getString(14));
                crs.updateObject(17, (Object)(rs.getString(1).trim() + '.' + rs.getString(2).trim()));
                crs.insertRow();
            }
            rs.close();
        }
        finally {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
        }
        crs.beforeFirst();
        crs.setType(1003);
        crs.setFetchDirection(1000);
        crs.setConcurrency(1007);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxDatabaseMetaData:getFunctionColumns(String, String , String, String): exit");
        }
        return crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxDatabaseMetaData:getFunctions(String, String, String): entry");
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        IfxResultSetMetaData rsmd = new IfxResultSetMetaData(6, this.conn);
        rsmd.setColumnInfo(1, this.conn.retCapName("FUNCTION_CAT"), 13, 255);
        rsmd.setColumnInfo(2, this.conn.retCapName("FUNCTION_SCHEM"), 13, 255);
        rsmd.setColumnInfo(3, this.conn.retCapName("FUNCTION_NAME"), 13, 255);
        rsmd.setColumnInfo(4, this.conn.retCapName("REMARKS"), 13, 255);
        rsmd.setColumnInfo(5, this.conn.retCapName("FUNCTION_TYPE"), 2, 8);
        rsmd.setColumnInfo(6, this.conn.retCapName("SPECIFIC_NAME"), 13, 255);
        IfxClientResultSet crs = new IfxClientResultSet(this.conn, rsmd);
        crs.moveToInsertRow();
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        try (IfxStatement stmt = (IfxStatement)this.conn.createStatement();){
            String sql = "SELECT owner, procname, isproc from sysprocedures";
            boolean useAnd = false;
            if (functionNamePattern != null && !functionNamePattern.isEmpty()) {
                sql = sql + " WHERE procname LIKE '%" + functionNamePattern + "%'";
                useAnd = true;
            }
            if (schemaPattern != null && !schemaPattern.isEmpty()) {
                sql = useAnd ? sql + " AND" : sql + " WHERE";
                sql = sql + " owner LIKE '%" + schemaPattern + "%'";
            }
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                crs.updateObject(1, (Object)((IfxSqliConnect)this.conn).getDbName());
                crs.updateObject(2, (Object)rs.getString(1).trim());
                crs.updateObject(3, (Object)rs.getString(2).trim());
                crs.updateNull(4);
                if (rs.getString(3).trim().toLowerCase().equals("t")) {
                    crs.updateObject(5, (Object)1);
                } else {
                    crs.updateObject(5, (Object)0);
                }
                crs.updateObject(6, (Object)(rs.getString(1).trim() + '.' + rs.getString(2).trim()));
                crs.insertRow();
            }
            rs.close();
        }
        finally {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
        }
        crs.beforeFirst();
        crs.setType(1003);
        crs.setFetchDirection(1000);
        crs.setConcurrency(1007);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxDatabaseMetaData:getFunctions(String, String, String): exit");
        }
        return crs;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw Messages.getSQLException(-80053, this.conn, this.getClass().getCanonicalName(), iface.getClass().getCanonicalName());
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "getPseudoColumns(String, String, String, String): entry");
        }
        IfxResultSetMetaData rsmd = new IfxResultSetMetaData(12, this.conn);
        rsmd.setColumnInfo(1, this.conn.retCapName("TABLE_CAT"), 13, 255);
        rsmd.setColumnInfo(2, this.conn.retCapName("TABLE_SCHEM"), 13, 255);
        rsmd.setColumnInfo(3, this.conn.retCapName("TABLE_NAME"), 13, 255);
        rsmd.setColumnInfo(4, this.conn.retCapName("COLUMN_NAME"), 13, 255);
        rsmd.setColumnInfo(5, this.conn.retCapName("DATA_TYPE"), 2, 4);
        rsmd.setColumnInfo(6, this.conn.retCapName("COLUMN_SIZE"), 2, 4);
        rsmd.setColumnInfo(7, this.conn.retCapName("DECIMAL_DIGITS"), 2, 4);
        rsmd.setColumnInfo(8, this.conn.retCapName("NUM_PREC_RADIX"), 13, 255);
        rsmd.setColumnInfo(9, this.conn.retCapName("COLUMN_USAGE"), 13, 255);
        rsmd.setColumnInfo(10, this.conn.retCapName("REMARKS"), 13, 255);
        rsmd.setColumnInfo(11, this.conn.retCapName("CHAR_OCTET_LENGTH"), 2, 4);
        rsmd.setColumnInfo(12, this.conn.retCapName("IS_NULLABLE"), 13, 255);
        IfxClientResultSet crs = new IfxClientResultSet(this.conn, rsmd);
        if (this.conn.isDbOpen()) {
            crs.moveToInsertRow();
            ((IfxSqliConnect)this.conn).startMetaDataQuery();
            schemaPattern = this.processSchemaPattern(schemaPattern);
            tableNamePattern = this.processTablePattern(tableNamePattern);
            columnNamePattern = this.processColumnPattern(columnNamePattern);
            catalog = this.processCatalog(catalog);
            String sql = "SELECT owner, tabname, colname, informix.get_data_type(coltype, extended_id, 0) as DATA_TYPE, collength, informix.schema_numprecradix(coltype) as num_prec_radix, informix.schema_charlen(coltype, extended_id, collength) AS char_octet_length, coltype FROM informix.systables, informix.syscolumns WHERE informix.syscolumns.tabid = informix.systables.tabid AND informix.systables.owner LIKE ? AND informix.systables.tabname LIKE ? AND informix.syscolumns.colname LIKE ? AND colattr IN (1, 8, 16, 32, 64)";
            try (PreparedStatement stmt = this.conn.prepareStatement(sql);){
                stmt.setString(1, schemaPattern);
                stmt.setString(2, tableNamePattern);
                stmt.setString(3, columnNamePattern);
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        crs.updateString("TABLE_CAT", catalog);
                        crs.updateString("TABLE_SCHEM", rs.getString("owner"));
                        crs.updateString("TABLE_NAME", rs.getString("colname"));
                        crs.updateString("COLUMN_NAME", rs.getString("colname"));
                        crs.updateInt("DATA_TYPE", rs.getInt("DATA_TYPE"));
                        crs.updateInt("COLUMN_SIZE", rs.getInt("collength"));
                        crs.updateInt("DECIMAL_DIGITS", rs.getInt("collength"));
                        crs.updateString("COLUMN_USAGE", PseudoColumnUsage.NO_USAGE_RESTRICTIONS.name());
                        crs.updateInt("NUM_PREC_RADIX", rs.getInt("num_prec_radix"));
                        crs.updateNull("REMARKS");
                        crs.updateInt("CHAR_OCTET_LENGTH", rs.getInt("char_octet_length"));
                        crs.updateString("IS_NULLABLE", this.isNullable(rs.getInt("coltype")) ? "YES" : "NO");
                        crs.insertRow();
                    }
                }
            }
            finally {
                ((IfxSqliConnect)this.conn).endMetaDataQuery();
            }
        }
        crs.beforeFirst();
        crs.setType(1003);
        crs.setFetchDirection(1000);
        crs.setConcurrency(1007);
        return crs;
    }

    private boolean isNullable(int coltype) {
        return (coltype & 0x100) == 256;
    }

    private String processCatalog(String catalog) throws SQLException {
        return catalog == null || catalog.isEmpty() ? this.conn.getCatalog() : catalog;
    }

    private String processSchemaPattern(String schemaPattern) {
        schemaPattern = (schemaPattern == null || schemaPattern.isEmpty() ? "%" : schemaPattern).trim();
        if (!this.conn.isDelimIdentSet()) {
            return this.toSchemaCaseLikeServer(schemaPattern);
        }
        return schemaPattern;
    }

    private String processTablePattern(String tablePattern) {
        tablePattern = (tablePattern == null || tablePattern.isEmpty() ? "%" : tablePattern).trim();
        return !this.conn.isDelimIdentSet() ? tablePattern.toLowerCase() : tablePattern;
    }

    private String processColumnPattern(String columnPattern) {
        return columnPattern == null || columnPattern.isEmpty() ? "%" : columnPattern;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return false;
    }

    @Override
    public long getMaxLogicalLobSize() {
        return 4000000000000L;
    }

    @Override
    public boolean supportsRefCursors() {
        return false;
    }

    private boolean useWithHold() {
        try {
            return this.conn.isANSI() && this.conn.getAutoCommit();
        }
        catch (SQLException e) {
            throw new RuntimeException("This cannot be thrown", e);
        }
    }

    private String processPattern(String pattern) {
        if (pattern == null || pattern.length() == 0) {
            return "%";
        }
        if (!this.conn.isDelimIdentSet()) {
            return pattern.trim().toLowerCase();
        }
        return pattern.trim();
    }

    static {
        int i;
        logger = Trace.getLoggerForClass(IfxDatabaseMetaData.class);
        nextTempTableId = 1;
        nMdInfoRows = 18;
        nStdRowTypes = 19;
        nXtdRowTypes = 31;
        nXtdRowTypesSupported = 27;
        lmd = null;
        lrow = null;
        lrowLvc32k = null;
        if (lmd == null) {
            i = 0;
            lmd = new mdinfo[nMdInfoRows];
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("TYPE_NAME", 0, 128, true, 0);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("DATA_TYPE", 1, 2, true, 128);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("PRECISION", 2, 4, true, 130);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("LITERAL_PREFIX", 0, 128, true, 134);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("LITERAL_SUFFIX", 0, 128, true, 262);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("CREATE_PARAMS", 0, 128, true, 390);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("NULLABLE", 1, 2, true, 518);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("CASE_SENSITIVE", 1, 2, true, 520);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("SEARCHABLE", 2, 4, true, 522);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("UNSIGNED_ATTRIBUTE", 1, 2, true, 526);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("FIXED_PREC_SCALE", 1, 2, true, 528);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("AUTO_INCREMENT", 1, 2, true, 530);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("LOCAL_TYPE_NAME", 0, 128, true, 532);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("MINIMUM_SCALE", 1, 2, true, 660);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("MAXIMUM_SCALE", 1, 2, true, 662);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("SQL_DATA_TYPE", 2, 4, true, 664);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("SQL_DATETIME_SUB", 2, 4, true, 668);
            IfxDatabaseMetaData.lmd[i++] = new mdinfo("NUM_PREC_RADIX", 2, 4, true, 672);
        }
        i = 0;
        lrowLvc32k = new rowinfo[nXtdRowTypes];
        lrow = lrowLvc32k;
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("byte", -4, 11, 0, Integer.MAX_VALUE, "<Null>", "<Null>", 1, false, 0, false, false, 0, Short.MAX_VALUE, 0);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("char", 1, 0, 0, Short.MAX_VALUE, "'", "'", 1, true, 3, false, false, 0, Short.MAX_VALUE, 0);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("character varying", 12, 13, 0, 255, "'", "'", 1, true, 3, false, false, 0, 0, 0);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("date", 91, 7, 0, 10, "{d'", "'}", 1, false, 2, false, false, 0, 0, 0);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("datetime year to fraction(5)", 93, 10, 0, 0, "{ts'", "'}", 1, false, 2, false, false, 0, 0, 0);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("decimal", 3, 5, 0, 32, "<Null>", "<Null>", 1, false, 2, true, false, 1, 32, 10);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("double precision", 6, 3, 0, 15, "<Null>", "<Null>", 1, false, 2, false, false, 0, 0, 10);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("float", 6, 3, 0, 15, "<Null>", "<Null>", 1, false, 2, false, false, 1, 8, 10);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("integer", 4, 2, 0, 10, "<Null>", "<Null>", 1, false, 2, false, false, 0, 0, 10);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("interval", 1111, 14, 0, 0, "'", "'", 1, false, 2, false, false, 0, 0, 0);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("nchar", -15, 15, 0, Short.MAX_VALUE, "'", "'", 1, true, 3, false, false, 0, 0, 0);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("nvarchar", -9, 16, 0, 255, "'", "'", 1, true, 3, false, false, 0, 0, 0);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("money", 3, 8, 0, 32, "<Null>", "<Null>", 1, false, 2, true, false, 16, 32, 10);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("numeric", 2, 5, 0, 32, "<Null>", "<Null>", 1, false, 2, true, false, 1, 32, 10);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("serial", 4, 6, 0, 10, "<Null>", "<Null>", 0, false, 2, false, true, 0, 0, 10);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("smallint", 5, 1, 0, 4, "<Null>", "<Null>", 1, false, 2, false, false, 0, 0, 10);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("smallfloat", 7, 4, 0, 6, "<Null>", "<Null>", 1, false, 2, false, false, 1, 6, 10);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("text", -1, 12, 0, Integer.MAX_VALUE, "'", "'", 1, false, 0, false, false, 0, 0, 0);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("varchar", 12, 13, 0, 255, "'", "'", 1, true, 3, false, false, 0, 255, 0);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("boolean", 16, 45, 5, 1, "<Null>", "<Null>", 1, false, 2, false, false, 0, 0, 2);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("int8", -5, 17, 0, 19, "<Null>", "<Null>", 1, false, 2, false, false, 0, 0, 10);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("serial8", -5, 18, 0, 19, "<Null>", "<Null>", 0, false, 2, false, true, 0, 0, 10);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("clob", 2005, 41, 11, Integer.MAX_VALUE, "<Null>", "<Null>", 1, false, 0, false, false, 0, 0, 0);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("blob", 2004, 41, 10, Integer.MAX_VALUE, "<Null>", "<Null>", 1, false, 0, false, false, 0, 0, 0);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("lvarchar", -1, 43, 1, 32739, "'", "'", 1, true, 3, false, false, 0, 0, 0);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("bigint", -5, 52, 0, 19, "<Null>", "<Null>", 1, false, 2, false, false, 0, 0, 10);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("bigserial", -5, 53, 0, 19, "<Null>", "<Null>", 0, false, 2, false, false, 0, 0, 10);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("list", 1111, 21, 0, 0, "'", "'", 1, false, 3, false, false, 0, 0, 0);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("multiset", 1111, 20, 0, 0, "'", "'", 1, false, 3, false, false, 0, 0, 0);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("set", 1111, 19, 0, 0, "'", "'", 1, false, 3, false, false, 0, 0, 0);
        IfxDatabaseMetaData.lrowLvc32k[i++] = new rowinfo("unnamed row", 1111, 22, 0, 0, "'", "'", 1, false, 3, false, false, 0, 0, 0);
    }
}

