/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxUDTInput;
import com.informix.jdbc.IfxUDTOutput;
import com.informix.lang.Messages;
import java.sql.Connection;
import java.sql.SQLException;

public class IfxLobDescriptor {
    static final short LO_DESCRIPTOR_SIZE = 596;
    static final short DISK_DESCRIPTOR_SIZE = 168;
    static final short PRE_LONG_ID_DISK_DESCRIPTOR_SIZE = 58;
    public static final short LO_LOG = 1;
    public static final short LO_NOLOG = 2;
    public static final short LO_DELAY_LOG = 4;
    public static final short LO_KEEP_LASTACCESS_TIME = 8;
    public static final short LO_NOKEEP_LASTACCESS_TIME = 16;
    public static final short LO_HIGH_INTEG = 32;
    public static final short LO_MODERATE_INTEG = 64;
    public static final short LO_TEMP = 128;
    private final int idSize = 128;
    private int MagicNumber;
    private int CreateTimeFlags;
    private int CreateTimeFlags1;
    private long estimatedNoBytes;
    private long sizeLimit;
    private int extentSize;
    private String spaceName;
    byte[] rawColDescriptor = null;
    private IfxConnection conn;

    public IfxLobDescriptor(Connection conn) throws SQLException {
        byte[] someName = null;
        this.conn = (IfxConnection)conn;
        IfxUDTOutput os = new IfxUDTOutput(this.conn);
        someName = new byte[128];
        this.MagicNumber = -623182099;
        this.CreateTimeFlags = 0;
        this.CreateTimeFlags1 = 0;
        this.estimatedNoBytes = -1L;
        this.sizeLimit = -1L;
        this.extentSize = -1;
        this.spaceName = "";
        try {
            os.writeInt(0);
            os.writeBytes(someName, someName.length);
            os.writeInt(0);
            os.writeBytes(someName, someName.length);
            os.writeInt(0);
            os.writeBytes(someName, someName.length);
            os.writeShort((short)0);
            os.writeShort((short)0);
            os.writeInt(0);
            os.writeInt(-1);
            os.writeInt(-1);
            os.writeInt(0);
            os.writeInt(0);
            os.writeInt(0);
            os.writeInt(0);
            this.rawColDescriptor = os.toByteArray();
        }
        catch (SQLException se) {
            throw se;
        }
        catch (Exception e) {
            this.rawColDescriptor = null;
            throw Messages.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    IfxLobDescriptor(IfxConnection conn, byte[] loDesc) throws SQLException {
        this.conn = conn;
        int colDescLength = 428;
        try {
            IfxUDTInput is = new IfxUDTInput(this.conn, loDesc, 0, loDesc.length);
            this.MagicNumber = is.readInt();
            this.CreateTimeFlags = is.readInt();
            this.CreateTimeFlags1 = is.readInt();
            this.estimatedNoBytes = is.readLong();
            this.sizeLimit = is.readLong();
            this.extentSize = is.readInt();
            this.spaceName = is.readString(128);
            int i = this.spaceName.indexOf(0);
            if (i != -1) {
                this.spaceName = this.spaceName.substring(0, i);
            }
            this.rawColDescriptor = is.readBytes(colDescLength);
        }
        catch (SQLException se) {
            throw se;
        }
        catch (Exception e) {
            throw Messages.getSQLException(-79716, e.toString(), conn);
        }
    }

    public void setCreateFlags(int flags) {
        this.CreateTimeFlags = flags;
    }

    public void setEstBytes(long estSize) {
        this.estimatedNoBytes = estSize;
    }

    public void setMaxBytes(long maxSize) {
        this.sizeLimit = maxSize;
    }

    public void setExtSize(int extSize) {
        this.extentSize = extSize;
    }

    public void setSbspace(String name) {
        this.spaceName = name;
    }

    public int getCreateFlags() {
        return this.CreateTimeFlags;
    }

    public long getEstSize() {
        return this.estimatedNoBytes;
    }

    public long getMaxBytes() {
        return this.sizeLimit;
    }

    public int getExtSize() {
        return this.extentSize;
    }

    public String getSbspace() {
        return this.spaceName;
    }

    static int size(IfxConnection conn) {
        return 596;
    }

    byte[] getRawLobDescriptor() throws SQLException {
        IfxUDTOutput os = new IfxUDTOutput(this.conn);
        os.setAutoAlignment(false);
        os.writeInt(this.MagicNumber);
        os.writeInt(this.CreateTimeFlags);
        os.writeInt(this.CreateTimeFlags1);
        os.writeLong(this.estimatedNoBytes);
        os.writeShort((short)0);
        os.writeLong(this.sizeLimit);
        os.writeShort((short)0);
        os.writeInt(this.extentSize);
        os.setAutoAlignment(true);
        os.writeString(this.spaceName, 128);
        os.writeBytes(this.rawColDescriptor);
        return os.toByteArray();
    }

    public String toString() {
        String s = "mag: " + this.MagicNumber;
        s = s + " f0: " + this.CreateTimeFlags;
        s = s + " f1: " + this.CreateTimeFlags1;
        s = s + " est: " + this.estimatedNoBytes;
        s = s + " lim: " + this.sizeLimit;
        s = s + " ext: " + this.extentSize;
        s = s + " nm: " + this.spaceName;
        return s;
    }
}

