/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxPreparedStatement;
import com.informix.jdbc.IfxBSONObject;
import com.informix.jdbc.IfxBlob;
import com.informix.jdbc.IfxCallableStatement;
import com.informix.jdbc.IfxCancelQueryImpl;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDateTime;
import com.informix.jdbc.IfxFloat;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxParameterMetaData;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSet;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxSmBlob;
import com.informix.jdbc.IfxSqli;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.IfxValue;
import com.informix.jdbc.NativeSQL;
import com.informix.jdbc.PreparedStatementCache;
import com.informix.jdbc.STREAMS_FETCHING;
import com.informix.lang.IfxSQLType;
import com.informix.lang.IfxTypes;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.lang.Messages;
import com.informix.util.BsonUtils;
import com.informix.util.IfxByteArrayOutputStream;
import com.informix.util.JdbcLogger;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class IfxPreparedStatement
extends IfxStatement
implements IfmxPreparedStatement {
    private static final JdbcLogger log = JdbcLogger.getLogger(IfxPreparedStatement.class);
    String baseStatement = null;
    protected Vector<IfxObject> vector = new Vector();
    IfxResultSetMetaData rsmd = null;
    private boolean canUsePut = false;
    private boolean usePut = false;
    private IfxByteArrayOutputStream bStream = null;
    int batchCount = 0;
    private static final int ONE = 1;
    private static final int MAX_CHARCOL_SIZE = Short.MAX_VALUE;
    private int[] putIndexArray;
    private int curRow = 0;
    private int numRowsCurrBatch = 0;
    private Vector<IfxObject> textObjArray = new Vector();
    private int textObjArrayIdx;
    private IfxResultSetMetaData outputRsmd = null;
    private static final int INIT_IDX_SIZE = 1000;
    private static final int INC_IDX_SIZE = 1000;
    int inputvals;
    boolean hasOutParameter = false;
    protected long ordinalCalls = 0L;
    protected long namedCalls = 0L;
    IfxResultSetMetaData inputParamMeta = null;
    private final String dbname;
    private static String cstr = null;

    static void initializeCstr() {
        char[] bstr = new char[Short.MAX_VALUE];
        for (int i = 0; i < Short.MAX_VALUE; ++i) {
            bstr[i] = 32;
        }
        cstr = new String(bstr);
    }

    IfxPreparedStatement(IfxConnection myconn) throws SQLException {
        super(myconn);
        this.poolable = true;
        this.dbname = null;
    }

    IfxPreparedStatement(IfxConnection myconn, String sql) throws SQLException {
        this(myconn, sql, 2);
    }

    IfxPreparedStatement(IfxConnection myconn, String sql, int autoGeneratedKeys) throws SQLException {
        super(myconn);
        if (autoGeneratedKeys == 2) {
            this.SGK_returnGeneratedKeys = 0;
        } else if (autoGeneratedKeys == 1) {
            this.SGK_returnGeneratedKeys = 1;
        } else {
            throw Messages.getSQLException(-19841, ": IfxPreparedStatement(String, int)", this.jconn);
        }
        this.processSQL(myconn, sql);
        this.poolable = true;
        this.dbname = IfxSqli.parseDbName(sql);
    }

    IfxPreparedStatement(IfxConnection myconn, String sql, int[] columnIndexes) throws SQLException {
        super(myconn);
        if (columnIndexes == null || columnIndexes.length <= 0) {
            throw Messages.getSQLException(-19841, ": IfxPreparedStatement(String, int[])", this.jconn);
        }
        this.SGK_indexes = (int[])columnIndexes.clone();
        this.SGK_returnGeneratedKeys = (short)2;
        this.processSQL(myconn, sql);
        this.poolable = true;
        this.dbname = IfxSqli.parseDbName(sql);
    }

    IfxPreparedStatement(IfxConnection myconn, String sql, String[] columnNames) throws SQLException {
        super(myconn);
        if (columnNames == null || columnNames.length <= 0) {
            throw Messages.getSQLException(-19841, ": IfxPreparedStatement(String, String[])", this.jconn);
        }
        this.SGK_names = (String[])columnNames.clone();
        this.SGK_returnGeneratedKeys = (short)3;
        this.processSQL(myconn, sql);
        this.poolable = true;
        this.dbname = IfxSqli.parseDbName(sql);
    }

    void setSqlString(String sql) throws SQLException {
        if (sql == null) {
            throw Messages.getSQLException(-79726, this.jconn);
        }
        this.baseStatement = sql;
        if (this instanceof IfxCallableStatement) {
            this.setqmarks(this.cntqmarks(sql, "="));
        } else {
            this.setqmarks(this.cntqmarks(sql));
        }
        this.commandString = NativeSQL.parseSQLString(this.jconn, sql);
        if (this.numqmarks > 0) {
            this.vector.setSize(this.numqmarks);
        }
        if (this.BatchVector.size() > 0) {
            this.clearBatch();
        }
    }

    private void processSQL(IfxConnection myconn, String sql) throws SQLException {
        if (sql == null) {
            throw Messages.getSQLException(-79726, myconn);
        }
        this.baseStatement = sql;
        if (this instanceof IfxCallableStatement) {
            this.setqmarks(this.cntqmarks(sql, "="));
        } else {
            this.setqmarks(this.cntqmarks(sql));
        }
        this.commandString = this.escapeProcessing ? NativeSQL.parseSQLString(this.jconn, sql) : sql;
        this.setupExecutePrepare();
        if (this.BatchVector.size() > 0) {
            this.clearBatch();
        }
        log.debug("Statement #{} prepared. SQL: {}", this.statementId, (Object)this.commandString);
    }

    void setupExecutePrepare() throws SQLException {
        this.prot.executePrepare(this);
        this.rsmd = (IfxResultSetMetaData)this.prot.getMetaData();
        if (!this.jconn.isDirect()) {
            this.setInputParameterMetaData();
        }
        if (this.numqmarks > 0 && !this.executeBatchInProgress) {
            this.vector.setSize(this.numqmarks);
        }
        if (!this.jconn.isDirect() && ((IfxSqliConnect)this.jconn).getUsePut() && this.getStatementType() == 6 && this.rsmd != null && this.numqmarks > 0 && this.numqmarks == this.rsmd.getColumnCount()) {
            this.canUsePut = true;
            this.outputRsmd = new IfxResultSetMetaData(this.rsmd);
        }
    }

    List<IfxObject> getVector() {
        return this.vector;
    }

    List<IfxObject> getBatchParamVector() {
        return this.BatchParamVector;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(this.isRsHoldable);
    }

    @Override
    public ResultSet executeQuery(boolean withHold) throws SQLException {
        return this.executeQuery(withHold, false);
    }

    @Override
    public int executeUpdate() throws SQLException {
        return super.executeUpdateImpl();
    }

    @Override
    public boolean execute() throws SQLException {
        return this.execute(this.isRsHoldable);
    }

    boolean execute(boolean holdable) throws SQLException {
        boolean returnValue;
        if (this.jconn.isClosed()) {
            throw Messages.getSQLException(-79730);
        }
        this.clearWarnings();
        this.resetMethodCalledFlags();
        this.prot.clearSerialValues();
        log.debug("Executing Statement #{}", this.statementId);
        IfxCancelQueryImpl cancelTask = null;
        if (this.timeoutSeconds > 0) {
            cancelTask = new IfxCancelQueryImpl(this);
            this.statementTimer.schedule((TimerTask)cancelTask, (long)this.timeoutSeconds * 1000L);
        }
        try {
            returnValue = this.executeExecuteImpl(holdable);
        }
        catch (SQLException e) {
            try {
                if (e.getErrorCode() == -710) {
                    this.poolable = false;
                }
                throw e;
            }
            catch (Throwable throwable) {
                if (this.timeoutSeconds > 0 && cancelTask != null && !cancelTask.cancel()) {
                    throw new SQLTimeoutException(Messages.getErrorMessage(-80505, this.timeoutSeconds), Messages.getSQLSTATE(-80505), -80505);
                }
                throw throwable;
            }
        }
        if (this.timeoutSeconds > 0 && cancelTask != null && !cancelTask.cancel()) {
            throw new SQLTimeoutException(Messages.getErrorMessage(-80505, this.timeoutSeconds), Messages.getSQLSTATE(-80505), -80505);
        }
        return returnValue;
    }

    boolean executeExecuteImpl(boolean holdable) throws SQLException {
        if (this instanceof IfxPreparedStatement && !((IfxSqliConnect)this.jconn).usePut) {
            for (IfxObject ival : this.getVector()) {
                if (!(ival instanceof IfxSmBlob)) continue;
                IfxSmBlob sval = (IfxSmBlob)ival;
                short type = sval.blobType;
                if (sval.sm_size < -1L) continue;
                switch (type) {
                    case 1: {
                        sval.createBlobOnServer(sval.blobBuffer, sval.sm_size);
                        break;
                    }
                    case 2: {
                        sval.createBlobOnServer(sval.BlobInputStream, sval.sm_size);
                        break;
                    }
                    case 3: {
                        sval.createBlobOnServer(sval.BlobCharInputStream, sval.sm_size);
                    }
                }
            }
        }
        try {
            this.prot.executeExecute(this, holdable, false, this.outputMetaData);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == -710) {
                this.poolable = false;
            }
            throw e;
        }
        if (this.prot.isResultSet()) {
            if (this.currentResult == null) {
                this.currentResult = new IfxResultSet(this, this.jconn, this.prot);
            } else {
                this.currentResult.reset();
                log.debug("ResultSet #{} reused for Statement #{}", this.currentResult.getId(), (Object)this.statementId);
            }
            return true;
        }
        this.rowsUpdated = this.prot.getNumberOfRowsProcessed();
        return false;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw Messages.getSQLException(-79729, this.jconn);
    }

    @Override
    public boolean execute(String sql, int returnKeys) throws SQLException {
        throw Messages.getSQLException(-79729, this.jconn);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw Messages.getSQLException(-79729, this.jconn);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw Messages.getSQLException(-79729, this.jconn);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw Messages.getSQLException(-79729, this.jconn);
    }

    @Override
    public ResultSet executeQuery(String sql, boolean withhold) throws SQLException {
        throw Messages.getSQLException(-79729, this.jconn);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw Messages.getSQLException(-79729, this.jconn);
    }

    @Override
    public int executeUpdate(String sql, int returnKeys) throws SQLException {
        throw Messages.getSQLException(-79729, this.jconn);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw Messages.getSQLException(-79729, this.jconn);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw Messages.getSQLException(-79729, this.jconn);
    }

    @Override
    public void setNull(int i, int sqlType) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.get(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                val.clear();
            } else {
                val = IfxValue.makeNullInstance(this.jconn, this.getColumnInfo(i), sqlType);
                this.set(i, val);
            }
        }
        catch (Exception e) {
            throw Messages.getSQLException((Throwable)e, -79716, this.jconn);
        }
    }

    @Override
    public void setNull(int i, int sqlType, int ifxType) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.get(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                val.clear();
            } else {
                val = ifxType == 14 ? IfxValue.makeInstanceFromIfxType(this.jconn, ifxType, "YM") : IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                this.set(i, val);
            }
        }
        catch (Exception e) {
            throw Messages.getSQLException((Throwable)e, -79716, this.jconn);
        }
    }

    @Override
    public void setNull(int i, int sqlType, String name) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                val.clear();
            } else {
                val = IfxValue.makeNullInstance(this.jconn, this.getColumnInfo(i), sqlType, name);
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw Messages.getSQLException((Throwable)e, -79716, this.jconn);
        }
    }

    protected void setNull(int i, int sqlType, int ifxType, String name) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                val.clear();
            } else {
                val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                val.setExtendedTypeName(name);
                this.set(i, val);
            }
        }
        catch (Exception e) {
            throw Messages.getSQLException((Throwable)e, -79716, this.jconn);
        }
    }

    @Override
    public void setBigDecimal(int i, BigDecimal x) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        this.checkParameterIndex(i, this.numqmarks);
        IfxObject val = this.vector.elementAt(i - 1);
        if (this.usePut && val != null) {
            val.clear();
            val.fromDecimal(x);
        } else {
            val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
            this.set(i, val);
        }
    }

    @Override
    public void setBigDecimal(int i, BigDecimal x, int ifxType) throws SQLException {
        this.setBigDecimal(i, x);
    }

    @Override
    public void setBoolean(int i, boolean x) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        this.checkParameterIndex(i, this.numqmarks);
        IfxObject val = this.vector.elementAt(i - 1);
        if (this.usePut && val != null) {
            val.fromBoolean(x);
        } else {
            val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
            this.set(i, val);
        }
    }

    @Override
    public void setBoolean(int i, boolean x, int ifxType) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        this.checkParameterIndex(i, this.numqmarks);
        IfxObject val = this.vector.elementAt(i - 1);
        if (this.usePut && val != null) {
            val.fromBoolean(x);
        } else {
            val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
            val.fromBoolean(x);
            this.set(i, val);
        }
    }

    @Override
    public void setByte(int i, byte x) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        this.checkParameterIndex(i, this.numqmarks);
        IfxObject val = this.vector.elementAt(i - 1);
        if (this.usePut && val != null && !(val instanceof IfxBlob)) {
            val.fromByte(x);
        } else {
            val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
            this.set(i, val);
        }
    }

    @Override
    public void setByte(int i, byte x, int ifxType) throws SQLException {
        this.setByte(i, x);
    }

    @Override
    public void setShort(int i, short x) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        this.checkParameterIndex(i, this.numqmarks);
        IfxObject val = this.vector.elementAt(i - 1);
        if (val == null || !this.BatchParamVector.isEmpty()) {
            val = IfxValue.createIfxObject(this.jconn, this.getColumnInfo(i), Short.class);
            this.set(i, val);
        }
        val.fromShort(x);
    }

    @Override
    public void setShort(int i, short x, int ifxType) throws SQLException {
        this.setShort(i, x);
    }

    @Override
    public void setInt(int i, int x) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        this.checkParameterIndex(i, this.numqmarks);
        IfxObject val = this.vector.get(i - 1);
        if (val == null || !this.BatchParamVector.isEmpty()) {
            val = IfxValue.createIfxObject(this.jconn, this.getColumnInfo(i), Integer.class);
            this.set(i, val);
        }
        val.fromInt(x);
    }

    @Override
    public void setInt(int i, int x, int ifxType) throws SQLException {
        this.setInt(i, x);
    }

    @Override
    public void setLong(int i, long x) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        this.checkParameterIndex(i, this.numqmarks);
        IfxObject val = this.vector.elementAt(i - 1);
        if (val == null || !this.BatchParamVector.isEmpty()) {
            val = IfxValue.createIfxObject(this.jconn, this.getColumnInfo(i), Long.class);
            this.set(i, val);
        }
        val.fromLong(x);
    }

    @Override
    public void setLong(int i, long x, int ifxType) throws SQLException {
        this.setLong(i, x);
    }

    @Override
    public void setFloat(int i, float x) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        this.checkParameterIndex(i, this.numqmarks);
        IfxObject val = this.vector.elementAt(i - 1);
        if (this.usePut && val != null) {
            val.clear();
            val.fromFloat(x);
        } else {
            val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
            this.set(i, val);
        }
    }

    @Override
    public void setFloat(int i, float x, int ifxType) throws SQLException {
        this.setFloat(i, x);
    }

    @Override
    public void setDouble(int i, double x) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        this.checkParameterIndex(i, this.numqmarks);
        IfxObject val = this.vector.get(i - 1);
        if (this.usePut && val != null) {
            val.fromDouble(x);
        } else {
            IfxColumnInfo info = this.getColumnInfo(i);
            val = info == null ? new IfxFloat() : IfxValue.makeInstanceFromIfxType(this.jconn, info.SQLtype);
            val.fromDouble(x);
            this.set(i, val);
        }
    }

    @Override
    public void setDouble(int i, double x, int ifxType) throws SQLException {
        this.setDouble(i, x);
    }

    @Override
    public void setString(int i, String x) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        this.checkParameterIndex(i, this.numqmarks);
        IfxObject val = this.vector.elementAt(i - 1);
        if (this.usePut && val != null && !(val instanceof IfxBlob)) {
            val.clear();
            val.fromString(x);
        } else {
            IfxColumnInfo ci = this.getColumnInfo(i);
            val = this.usePut || ci != null && (ci.SQLtype == 12 || ci.SQLtype > 18) ? IfxValue.makeInstance(this.jconn, x, ci) : IfxValue.makeInstance(this.jconn, x, null);
            this.set(i, val);
        }
    }

    @Override
    public void setString(int i, String x, int ifxType) throws SQLException {
        if (ifxType == 46 || ifxType == 43 || ifxType == 13) {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                val.clear();
                val.fromString(x);
            } else {
                val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                val.fromString(x);
                this.set(i, val);
            }
        } else {
            this.setString(i, x);
        }
    }

    @Override
    public void setBytes(int i, byte[] x) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        this.checkParameterIndex(i, this.numqmarks);
        IfxObject val = this.vector.elementAt(i - 1);
        if (this.usePut && val != null && !(val instanceof IfxBlob)) {
            val.clear();
            val.fromBytes(x);
        } else {
            val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
            this.set(i, val);
        }
    }

    @Override
    public void setBytes(int i, byte[] x, int ifxType) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        this.checkParameterIndex(i, this.numqmarks);
        IfxObject val = this.vector.elementAt(i - 1);
        if (this.usePut && val != null && !(val instanceof IfxBlob)) {
            val.clear();
            val.fromBytes(x);
        } else {
            val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
            val.fromBytes(x);
            this.set(i, val);
        }
    }

    @Override
    public void setDate(int i, Date x) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        this.checkParameterIndex(i, this.numqmarks);
        IfxObject val = this.vector.elementAt(i - 1);
        if (this.usePut && val != null) {
            val.fromDate(x);
        } else {
            val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
            this.set(i, val);
        }
    }

    @Override
    public void setDate(int i, Date x, int ifxType) throws SQLException {
        this.setDate(i, x);
    }

    @Override
    public void setTime(int i, Time x) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        this.checkParameterIndex(i, this.numqmarks);
        IfxObject val = this.vector.elementAt(i - 1);
        if (this.usePut && val != null) {
            val.clear();
            val.fromTime(x);
        } else {
            val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
            this.set(i, val);
        }
    }

    @Override
    public void setTime(int i, Time x, int ifxType) throws SQLException {
        this.setTime(i, x);
    }

    @Override
    public void setTimestamp(int i, Timestamp x) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        this.checkParameterIndex(i, this.numqmarks);
        IfxColumnInfo colInfo = this.getColumnInfo(i);
        IfxObject val = this.vector.elementAt(i - 1);
        if (this.usePut && val != null) {
            val.clear();
            val.fromTimestamp(x);
        } else {
            val = IfxValue.makeInstance(this.jconn, x, colInfo);
            this.set(i, val);
        }
        this.checkDateTimeTruncation(colInfo, val, i);
    }

    private void checkDateTimeTruncation(IfxColumnInfo colInfo, IfxObject val, int i) {
        if (!(this.statementType != 6 && this.statementType != 4 || this.usePut && !this.canUsePut || val.ifxType != 10 || colInfo == null || this.jconn.isDirect())) {
            IfxDateTime dt = (IfxDateTime)val;
            byte dataDefEndCode = IfxDateTime.getEndCode(dt.getEncodedLength());
            byte colDefEndCode = IfxDateTime.getEndCode((short)colInfo.ColLength);
            if (dt.truncateDataForPut(colDefEndCode)) {
                this.chainWarnings(new DataTruncation(i, true, true, dataDefEndCode, colDefEndCode));
            }
        }
    }

    @Override
    public void setTimestamp(int i, Timestamp x, int ifxType) throws SQLException {
        this.setTimestamp(i, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setAsciiStream(parameterIndex, x, (long)length);
    }

    @Override
    public void setAsciiStream(int i, InputStream x, int length, int ifxType) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        this.checkParameterIndex(i, this.numqmarks);
        IfxObject val = this.vector.elementAt(i - 1);
        if (this.usePut && val != null && !(val instanceof IfxBlob)) {
            val.clear();
            val.fromAsciiStream(x, length);
        } else {
            val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
            val.fromAsciiStream(x, length);
            this.set(i, val);
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int i, InputStream x, int length) throws SQLException {
        throw Messages.getSQLException(-79700, ": PreparedStatement.setUnicodeStream(int,InputStream,int).", this.jconn);
    }

    @Override
    public void setBinaryStream(int paramterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(paramterIndex, x, length, -1);
    }

    @Override
    public void setBinaryStream(int i, InputStream x, int length, int ifxType) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        if (x == null) {
            IfxObject val = this.vector.elementAt(i - 1);
            if (val == null) {
                this.setNull(i, -2);
            } else {
                this.setNull(i, val.getJDBCType());
            }
            return;
        }
        IfxObject val = this.vector.elementAt(i - 1);
        if (this.usePut && val != null && !(val instanceof IfxBlob)) {
            val.clear();
            val.fromBinaryStream(x, length);
        } else {
            if (ifxType < 0) {
                val = IfxValue.makeInstance(this.jconn, x, length, this.getColumnInfo(i));
            } else {
                val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                val.fromBinaryStream(x, length);
            }
            this.set(i, val);
        }
    }

    @Override
    public void setInterval(int i, Interval x) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        if (x instanceof IntervalYM) {
            this.setIntervalYM(i, (IntervalYM)x);
        } else if (x instanceof IntervalDF) {
            this.setIntervalDF(i, (IntervalDF)x);
        }
    }

    @Override
    public void setIntervalYM(int i, IntervalYM x) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        this.checkParameterIndex(i, this.numqmarks);
        IfxObject val = this.vector.elementAt(i - 1);
        if (this.usePut && val != null) {
            val.clear();
            val.fromIntervalYM(x);
        } else {
            val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
            this.set(i, val);
        }
    }

    @Override
    public void setIntervalDF(int i, IntervalDF x) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        this.checkParameterIndex(i, this.numqmarks);
        IfxObject val = this.vector.elementAt(i - 1);
        if (this.usePut && val != null) {
            val.clear();
            val.fromIntervalDF(x);
        } else {
            val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
            this.set(i, val);
        }
    }

    @Override
    public void clearParameters() {
        this.vector = new Vector(this.numqmarks);
        this.vector.setSize(this.numqmarks);
        this.inputvals = 0;
    }

    @Override
    public void setObject(int i, Object x, int targetSqlType) throws SQLException {
        this.setObject(i, x, targetSqlType, -1);
    }

    @Override
    public void setObject(int i, Object x, int targetSqlType, int scale) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            IfxColumnInfo colinfo = this.getColumnInfo(i);
            if (colinfo != null) {
                String str = colinfo.ExtendedName;
                String afterToken = "";
                int index = str.indexOf(40);
                if (index > 0) {
                    str = str.substring(index + 1, str.length() - 1);
                    StringTokenizer strToken = new StringTokenizer(str);
                    while (strToken.hasMoreElements()) {
                        afterToken = strToken.nextToken();
                        if (afterToken.equalsIgnoreCase("int8") || afterToken.equalsIgnoreCase("serial8")) {
                            this.jconn.setIsBigInt(false);
                            this.jconn.setIsBigSerial(false);
                            break;
                        }
                        if (afterToken.equalsIgnoreCase("bigint")) {
                            this.jconn.setIsBigInt(true);
                            this.jconn.setIsBigSerial(false);
                            break;
                        }
                        if (!afterToken.equalsIgnoreCase("bigserial")) continue;
                        this.jconn.setIsBigInt(false);
                        this.jconn.setIsBigSerial(true);
                        break;
                    }
                }
            }
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                val.fromObject(x);
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i), scale, targetSqlType);
            }
            DataTruncation dt = val.getWarning();
            if (dt != null) {
                this.chainWarnings(new DataTruncation(i, false, true, dt.getDataSize(), dt.getTransferSize()));
            }
            this.set(i, val);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    @Override
    public void setObject(int i, Object x) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        this.checkParameterIndex(i, this.numqmarks);
        IfxColumnInfo colInfo = this.getColumnInfo(i);
        IfxObject val = this.vector.elementAt(i - 1);
        if (this.usePut && val != null && !(val instanceof IfxBlob)) {
            val.fromObject(x);
        } else {
            DataTruncation dt;
            val = IfxValue.makeInstance(this.jconn, x, colInfo);
            if (val instanceof IfxDateTime && this.usePut || this.canUsePut) {
                val.encodedLength = 0;
            }
            if ((dt = val.getWarning()) != null) {
                this.chainWarnings(new DataTruncation(i, false, true, dt.getDataSize(), dt.getTransferSize()));
            }
            this.set(i, val);
        }
        this.checkDateTimeTruncation(colInfo, val, i);
    }

    protected void setObject(int i, Object x, String name) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        this.checkParameterIndex(i, this.numqmarks);
        IfxObject val = this.vector.elementAt(i - 1);
        if (this.usePut && val != null && !(val instanceof IfxBlob)) {
            val.fromObject(x, name);
        } else {
            val = IfxValue.makeInstance(this.jconn, x, name, this.getColumnInfo(i));
            DataTruncation dt = val.getWarning();
            if (dt != null) {
                this.chainWarnings(new DataTruncation(i, false, true, dt.getDataSize(), dt.getTransferSize()));
            }
            this.set(i, val);
        }
    }

    @Override
    public void IfxSetObject(int i, Object x, int ifxType) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                val.clear();
                val.fromObject(x);
            } else {
                val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                val.fromObject(x);
                DataTruncation dt = val.getWarning();
                if (dt != null) {
                    this.chainWarnings(new DataTruncation(i, false, true, dt.getDataSize(), dt.getTransferSize()));
                }
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw Messages.getSQLException((Throwable)e, -79716, this.jconn);
        }
    }

    void set(int i, IfxObject v) throws SQLException {
        boolean hadvalue = false;
        IfxObject obj = this.vector.get(i - 1);
        if (!(obj == null || this.usePut && obj instanceof IfxBlob)) {
            hadvalue = true;
        }
        this.vector.setElementAt(v, i - 1);
        if (!hadvalue) {
            ++this.inputvals;
        }
        if (this.canUsePut) {
            if (this.rsmd.needSvrConv(i)) {
                this.setIfxColumnInfo(i, v);
            }
            if (this.rsmd.isDistinct(i) && v.ifxType == 46) {
                this.setIfxColumnInfo(i, v);
                this.outputRsmd.setSourceType(i, v.extendedID);
            }
        }
    }

    protected void checkParameterIndex(int i, int qmarks) throws SQLException {
        if (i > qmarks || i < 1) {
            throw Messages.getSQLException(-79749);
        }
        ++this.ordinalCalls;
        if (this.namedCalls != this.ordinalCalls && this.namedCalls != 0L) {
            throw Messages.getSQLException(-79888);
        }
    }

    private int cntqmarks(String s) {
        return (int)s.chars().filter(i -> i == 63).count();
    }

    private int cntqmarks(String s, String separator) {
        int sepIdx;
        s = this.parsedSql(s);
        if (separator != null && (sepIdx = s.indexOf(separator)) != -1) {
            s = s.substring(sepIdx);
        }
        boolean S_NORMAL = false;
        boolean S_SINGLE_QUOTES = true;
        int S_DBL_QUOTES = 2;
        int S_ERROR = 3;
        int scanState = 0;
        int numQmarks = 0;
        block16: for (int scanIdx = 0; scanIdx < s.length() && scanState != 3; ++scanIdx) {
            char chr = s.charAt(scanIdx);
            int nextChr = 32;
            if (scanIdx + 1 < s.length()) {
                nextChr = s.charAt(scanIdx + 1);
            }
            switch (scanState) {
                case 0: {
                    switch (chr) {
                        case '?': {
                            ++numQmarks;
                            continue block16;
                        }
                        case '\'': {
                            scanState = 1;
                            continue block16;
                        }
                        case '\"': {
                            scanState = 2;
                            continue block16;
                        }
                    }
                    continue block16;
                }
                case 1: {
                    switch (chr) {
                        case '\'': {
                            if (nextChr == 39) {
                                ++scanIdx;
                                continue block16;
                            }
                            scanState = 0;
                            continue block16;
                        }
                    }
                    continue block16;
                }
                case 2: {
                    switch (chr) {
                        case '\"': {
                            if (nextChr == 34) {
                                ++scanIdx;
                                continue block16;
                            }
                            scanState = 0;
                            continue block16;
                        }
                    }
                    continue block16;
                }
                default: {
                    scanState = 3;
                }
            }
        }
        if (scanState != 0) {
            scanState = 3;
        }
        if (scanState == 3) {
            log.error("SQL statement format is incorrect/invalid, cannot scan for '?' in statement: {}", (Object)s);
        }
        return numQmarks;
    }

    private String parsedSql(String s) {
        char nextchr;
        char chr;
        int scanIdx;
        boolean start_comment_found = false;
        boolean end_comment_found = false;
        int startIdx = 0;
        int endIdx = 0;
        for (scanIdx = 0; scanIdx < s.length() - 1; ++scanIdx) {
            chr = s.charAt(scanIdx);
            nextchr = s.charAt(scanIdx + 1);
            if (chr != '/' || nextchr != '*') continue;
            start_comment_found = true;
            startIdx = scanIdx;
            break;
        }
        if (start_comment_found) {
            for (scanIdx = startIdx + 2; scanIdx < s.length() - 1; ++scanIdx) {
                chr = s.charAt(scanIdx);
                nextchr = s.charAt(scanIdx + 1);
                if (chr != '*' || nextchr != '/') continue;
                endIdx = scanIdx;
                end_comment_found = true;
                break;
            }
        }
        if (start_comment_found && end_comment_found) {
            return s.substring(0, startIdx) + s.substring(endIdx + 2);
        }
        return s;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw Messages.getSQLException(-79700, ": PreparedStatement.addBatch(String).");
    }

    @Override
    public void addBatch() throws SQLException {
        int blob_rec_cnt = 0;
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        if (this.hasOutParameter) {
            throw Messages.getSQLException(-79820);
        }
        if (!this.canUsePut) {
            this.commandString = this.commandString.trim();
            if (!this.commandString.endsWith(";")) {
                this.commandString = this.commandString + ";";
            }
            this.BatchVector.addElement(this.commandString);
            if (this.jconn.isDirect()) {
                int inputcount = this.vector.size();
                for (int i = inputcount - this.numqmarks; i < inputcount; ++i) {
                    this.BatchParamVector.addElement(this.vector.get(i));
                }
                return;
            }
            IfxObject ival = null;
            for (int i = 0; i < this.numqmarks; ++i) {
                ival = this.vector.get(i);
                if (!(ival != null || this instanceof IfxCallableStatement && this.namedCalls != 0L && this.inputParamMeta.hasDefaultValue(i + 1))) {
                    throw Messages.getSQLException(-79823, "index = " + (i + 1), this.jconn);
                }
                this.BatchParamVector.add(ival);
            }
        } else {
            IfxObject ival;
            int i;
            if (!this.usePut) {
                this.usePut = true;
                this.bStream = new IfxByteArrayOutputStream(((IfxSqli)this.prot).getTupleBufferSize(this.getFetchSize()));
                this.batchCount = 0;
                if (this.rsmd.hasVariableLengthColumns || this.rsmd.textByteColumnCount > 0) {
                    this.putIndexArray = new int[1000];
                    this.putIndexArray[0] = 0;
                }
                if (this.rsmd.textByteColumnCount > 0) {
                    this.textObjArray.setSize(100);
                    this.textObjArrayIdx = 0;
                }
                for (i = 0; i < this.inputvals; ++i) {
                    int ifxTargetType;
                    ival = this.vector.get(i);
                    int ifxSourceType = ival.getIfxType();
                    if (ifxSourceType != 0 || ifxSourceType == (ifxTargetType = this.rsmd.getIfxColumnType(i + 1))) continue;
                    IfxObject newVal = IfxValue.makeInstance(this.jconn, ival.toString(), this.rsmd.getColumnInfo(i + 1));
                    if (this.rsmd.isDistinct(i + 1) && newVal.extendedID == 1) {
                        this.outputRsmd.setExtendedOwnerName(i + 1, "informix");
                    }
                    this.set(i + 1, newVal);
                    this.vector.setElementAt(newVal, i);
                }
            }
            if (this.inputvals != this.numqmarks) {
                throw Messages.getSQLException(-79749, this.jconn, this.inputvals, this.numqmarks);
            }
            for (i = 0; i < this.inputvals; ++i) {
                ival = this.vector.get(i);
                int type = this.outputRsmd.getIfxColumnType(i + 1);
                if (ival instanceof IfxBlob) {
                    ++blob_rec_cnt;
                }
                switch (type) {
                    case 0: 
                    case 13: 
                    case 15: 
                    case 16: {
                        String s = ival.toString();
                        if (s == null && this.outputRsmd.getColumnLength(i + 1) == 1 && !this.rsmd.hasVariableLengthColumns && this.rsmd.textByteColumnCount <= 0) {
                            ival.fromString(" ");
                        }
                        if (s == null) break;
                        String str = s;
                        int colLen = this.outputRsmd.getColumnLength(i + 1);
                        if (s.length() > colLen && this.jconn.isANSI()) {
                            throw Messages.getSQLException(-1279, this.jconn);
                        }
                        if ((type == 13 || type == 16) && ((IfxSqliConnect)this.jconn).isVarcharVarLenSupported()) {
                            if (s.length() > colLen) {
                                str = s.substring(0, colLen);
                            }
                        } else if (s.length() > colLen) {
                            str = s.substring(0, colLen);
                        } else {
                            if (cstr == null) {
                                IfxPreparedStatement.initializeCstr();
                            }
                            str = str + cstr.substring(0, colLen - str.length());
                        }
                        ival.fromString(str);
                        break;
                    }
                    case 11: 
                    case 12: {
                        if (this.textObjArray.size() <= this.textObjArrayIdx) {
                            this.textObjArray.setSize(this.textObjArrayIdx + 100);
                        }
                        if (((IfxBlob)ival).isBlobLoaded() || ival.isNull()) {
                            this.textObjArray.setElementAt(null, this.textObjArrayIdx++);
                            break;
                        }
                        this.textObjArray.setElementAt(ival, this.textObjArrayIdx++);
                        break;
                    }
                }
                short len = (short)this.outputRsmd.getEncodedLength(i + 1);
                ival.setEncodedLength(len);
                byte[] bData = ival.toIfxTuple();
                this.bStream.write(bData, 0, bData.length);
                if (this.rsmd.hasVariableLengthColumns || this.rsmd.textByteColumnCount > 0) continue;
                int startPos = this.outputRsmd.getColumnStartPosition(i + 1);
                int colLength = 0;
                colLength = i + 1 < this.inputvals ? this.outputRsmd.getColumnStartPosition(i + 2) - startPos : this.rsmd.getTupleSize() - startPos;
                for (int j = bData.length; j < colLength; ++j) {
                    this.bStream.write(0);
                }
            }
            if (this.outputRsmd.hasVariableLengthColumns || this.outputRsmd.textByteColumnCount > 0) {
                if (this.putIndexArray.length < this.batchCount + 2) {
                    int[] temp = new int[this.putIndexArray.length + 1000];
                    System.arraycopy(this.putIndexArray, 0, temp, 0, this.putIndexArray.length);
                    this.putIndexArray = temp;
                }
                this.putIndexArray[++this.batchCount] = this.bStream.getCount();
            } else {
                if ((this.prot.getTupleSize() & 1) >= 1) {
                    this.bStream.write(0);
                }
                ++this.batchCount;
            }
            this.inputvals -= blob_rec_cnt;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int retval;
        int[] statusArray = null;
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        this.executeBatchInProgress = true;
        int outputNumber = 0;
        if (this.rsmd != null) {
            outputNumber = this.rsmd.getColumnCount();
        }
        if (this.statementType == 2 || this.statementType == 56 && outputNumber > 0) {
            SQLException e = Messages.getSQLException(-260, this.jconn);
            this.executeBatchInProgress = false;
            this.clearBatch();
            throw new BatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), new int[0]);
        }
        if (!this.usePut) {
            String cmdString = this.commandString;
            this.commandString = "";
            if (this.BatchVector.isEmpty()) {
                return new int[0];
            }
            if (this.jconn.isDirect()) {
                this.vector.clear();
                this.vector.addAll(this.BatchParamVector);
                this.BatchParamVector.clear();
            }
            this.commandString = cmdString;
        } else {
            if (this.batchCount == 0) {
                return new int[0];
            }
            this.curRow = 0;
        }
        try {
            retval = this.executeUpdateImpl();
        }
        catch (SQLException e) {
            IfxSqli prot = (IfxSqli)this.prot;
            ArrayList<Integer> BatchRowStatus = prot.batchRowStatus;
            if (BatchRowStatus != null) {
                statusArray = new int[BatchRowStatus.size()];
                for (int k = 0; k < BatchRowStatus.size(); ++k) {
                    statusArray[k] = BatchRowStatus.get(k);
                }
                prot.batchRowStatus.clear();
                this.clearBatch();
                throw new BatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), statusArray, e.getCause());
            }
            statusArray = new int[prot.getPutErrRowCount()];
            for (int k = 0; k < statusArray.length; ++k) {
                statusArray[k] = 1;
            }
            prot.clearPutErrRowCount();
            this.clearBatch();
            throw new BatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), statusArray, e.getCause());
        }
        if (this.jconn.isDirect()) {
            statusArray = new int[this.BatchVector.size()];
            statusArray[0] = retval;
            for (int k = 1; k < this.BatchVector.size(); ++k) {
                statusArray[k] = -2;
            }
            this.clearBatch();
            this.executeBatchInProgress = false;
            return statusArray;
        }
        IfxSqli prot = (IfxSqli)this.prot;
        ArrayList<Integer> BatchRowStatus = prot.batchRowStatus;
        if (!this.usePut) {
            if (BatchRowStatus != null) {
                statusArray = new int[BatchRowStatus.size()];
                for (int k = 0; k < BatchRowStatus.size(); ++k) {
                    statusArray[k] = BatchRowStatus.get(k);
                }
            }
        } else {
            int k;
            statusArray = new int[this.batchCount];
            int rowCount = 0;
            for (k = 0; k < BatchRowStatus.size(); ++k) {
                rowCount += BatchRowStatus.get(k).intValue();
            }
            statusArray[0] = rowCount;
            for (k = 1; k < this.batchCount; ++k) {
                statusArray[k] = -2;
            }
        }
        if (BatchRowStatus != null) {
            BatchRowStatus.clear();
        }
        this.clearBatch();
        return statusArray;
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        if (this.usePut) {
            this.bStream.reset();
            this.batchCount = 0;
            this.curRow = 0;
            this.textObjArrayIdx = 0;
        } else {
            this.BatchVector.clear();
            if (this.vector.size() > this.numqmarks) {
                int i;
                int vsize = this.vector.size();
                for (i = vsize - this.numqmarks; i < vsize; ++i) {
                    IfxObject val = this.vector.get(i);
                    this.vector.setElementAt(val, i + this.numqmarks - vsize);
                }
                for (i = vsize; i > this.numqmarks; --i) {
                    this.vector.removeElementAt(i - 1);
                }
            }
        }
        if (this.BatchParamVector != null) {
            this.BatchParamVector.clear();
        }
        this.scrubBatch();
    }

    @Override
    public void setCharacterStream(int i, Reader x, int length) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                val.clear();
                val.fromCharacterStream(x, length);
            } else {
                val = IfxValue.makeInstance(this.jconn, x, length, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    @Override
    public void setCharacterStream(int i, Reader x, int length, int ifxType) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                val.clear();
                val.fromCharacterStream(x, length);
            } else {
                val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                val.fromCharacterStream(x, length);
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        throw Messages.getSQLException(-79700, ": PreparedStatement.setRef(int,Ref).", this.jconn);
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                val.clear();
                val.fromBlob(x);
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    @Override
    public void setBlob(int i, Blob x, int ifxType) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                val.clear();
                val.fromBlob(x);
            } else {
                val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                val.fromBlob(x);
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                val.clear();
                val.fromClob(x);
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    @Override
    public void setClob(int i, Clob x, int ifxType) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                val.clear();
                val.fromClob(x);
            } else {
                val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                val.fromClob(x);
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                val.clear();
                val.fromObject(x);
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (Exception e) {
            throw Messages.getSQLException((Throwable)e, -79716, this.jconn);
        }
    }

    @Override
    public void setArray(int i, Array x, int ifxType) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                val.clear();
                val.fromObject(x);
            } else {
                val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                val.fromObject(x);
                this.set(i, val);
            }
        }
        catch (Exception e) {
            throw Messages.getSQLException((Throwable)e, -79716, this.jconn);
        }
    }

    protected void setArray(int i, Array x, String collectionType) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                val.clear();
                val.fromObject((Object)x, collectionType);
            } else {
                val = IfxValue.makeInstanceFromIfxType(this.jconn, 21);
                val.fromObject((Object)x, collectionType);
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        long tm = x.getTime();
        Time gwt = new Time(tm - (long)cal.get(15) - (long)cal.get(16));
        this.setTime(parameterIndex, gwt);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal, int ifxType) throws SQLException {
        long tm = x.getTime();
        Time gwt = new Time(tm - (long)cal.get(15) - (long)cal.get(16));
        this.setTime(parameterIndex, gwt, ifxType);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        return this.rsmd;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        long tm = x.getTime();
        Calendar ltc = Calendar.getInstance();
        ltc.setTime(x);
        if (cal == null) {
            cal = ltc;
        }
        long ut = tm + (long)cal.get(15) + (long)cal.get(16);
        long lt = ut - (long)ltc.get(15) - (long)ltc.get(16);
        Date gwt = new Date(lt);
        this.setDate(parameterIndex, gwt);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal, int ifxType) throws SQLException {
        this.setDate(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        this.setTimestamp(parameterIndex, x);
        int indexBatch = this.vector.size() - this.getqmarks() + parameterIndex - 1;
        IfxDateTime val = (IfxDateTime)this.vector.elementAt(indexBatch);
        val.dbCalendar = cal;
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal, int ifxType) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        long tm = x.getTime();
        Timestamp gwt = new Timestamp(tm - (long)cal.get(15) - (long)cal.get(16));
        this.setTimestamp(parameterIndex, gwt, ifxType);
    }

    private IfxColumnInfo getColumnInfo(int colindex) throws SQLException {
        if (this.canUsePut) {
            if (this.outputRsmd.getColumnInfo(colindex) == null) {
                throw Messages.getSQLException(-79716, ": IfxPreparedStatement.getColumnInfo()", this.jconn);
            }
            return this.outputRsmd.getColumnInfo(colindex);
        }
        if (!this.jconn.isDirect()) {
            try {
                if (this.inputParamMeta == null && !this.hasOutParameter) {
                    this.setInputParameterMetaData();
                    if (this.inputParamMeta == null) {
                        throw Messages.getSQLException(-79716, ": IfxPreparedStatement.getColumnInfo() -- inputmetadata is null");
                    }
                }
                if (this.inputParamMeta == null || colindex > this.inputParamMeta.getColumnCount()) {
                    return null;
                }
                IfxColumnInfo columnInfo = this.inputParamMeta.getColumnInfo(colindex);
                if (columnInfo.SQLtype == 51) {
                    columnInfo = null;
                }
                return columnInfo;
            }
            catch (Exception ex) {
                SQLException sqlException = Messages.getSQLException(-79716, ex.toString(), this.jconn);
                sqlException = Messages.setSQLExceptionCause(sqlException, ex);
                throw sqlException;
            }
        }
        if (this.getStatementType() != 6 && this.getStatementType() != 33 && this.getStatementType() != 7 && this.getStatementType() != 4) {
            return null;
        }
        if (this.rsmd == null || colindex > this.rsmd.getColumnCount()) {
            return null;
        }
        try {
            return this.rsmd.getColumnInfo(colindex);
        }
        catch (SQLException e) {
            return null;
        }
    }

    boolean usePut() {
        return this.usePut;
    }

    byte[] getAllRows() {
        return this.bStream.toByteArray();
    }

    byte[] getNextRow() {
        int begin = this.putIndexArray[this.curRow];
        int end = this.putIndexArray[this.curRow + 1];
        ++this.curRow;
        return this.bStream.toByteArray(begin, end - begin);
    }

    byte[] getNextRowBatch(byte[] bData) {
        byte[] currBatchArray = null;
        this.numRowsCurrBatch = 0;
        if (this.curRow >= this.batchCount) {
            return null;
        }
        int bytesPerRow = bData.length / this.batchCount;
        this.numRowsCurrBatch = this.batchCount - this.curRow;
        if (this.numRowsCurrBatch * bytesPerRow > ((IfxSqliConnect)this.jconn).getMaxFetchBufSize()) {
            this.numRowsCurrBatch = ((IfxSqliConnect)this.jconn).getMaxFetchBufSize() / bytesPerRow;
        }
        if (this.numRowsCurrBatch > Short.MAX_VALUE) {
            this.numRowsCurrBatch = Short.MAX_VALUE;
        }
        currBatchArray = this.bStream.toByteArray(this.curRow * bytesPerRow, this.numRowsCurrBatch * bytesPerRow);
        this.curRow += this.numRowsCurrBatch;
        return currBatchArray;
    }

    int getNumRowsCurrBatch() {
        return this.numRowsCurrBatch;
    }

    IfxBlob getIfxBlobAt(int i) {
        return (IfxBlob)this.textObjArray.elementAt(i);
    }

    int getBatchCount() {
        return this.batchCount;
    }

    int getIfxBlobArraySize() {
        return this.textObjArray.size();
    }

    void setIfxColumnInfo(int column, IfxObject obj) throws SQLException {
        this.outputRsmd.setIfxColumnType(column, obj.ifxType);
        this.outputRsmd.setExtendedName(column, obj.extendedName);
        this.outputRsmd.setColumnExtendedId(column, obj.extendedID);
        this.outputRsmd.setEncodedLength(column, obj.encodedLength);
    }

    ResultSetMetaData getOutPutMetaData() {
        return this.outputRsmd;
    }

    protected boolean ambiguousSQLType(int sqltype) {
        return sqltype == 2001 || sqltype == 2000 || sqltype == 0 || sqltype == 2003;
    }

    public IfxProtocol getResultSetProtocol() {
        return this.prot;
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw Messages.getSQLException(-79700, ": IfxPreparedStatement.setURL(int, URL)");
    }

    private void setInputParameterMetaData() throws SQLException {
        if (this.inputParamMeta == null) {
            this.inputParamMeta = this.prot.executeDescribeInput();
        }
        if (this.rsmd != null) {
            for (int i = 1; i <= this.inputParamMeta.getColumnCount() && i <= this.rsmd.getColumnCount(); ++i) {
                IfxColumnInfo infoFromRsmd = this.rsmd.getColumnInfo(i);
                IfxColumnInfo infoFromInpmd = this.inputParamMeta.getColumnInfo(i);
                if (infoFromInpmd.ExtendedName.indexOf("lob") == -1 || !infoFromInpmd.ExtendedName.equals(infoFromRsmd.ExtendedName)) continue;
                infoFromInpmd.setTableName(infoFromRsmd.getTableName());
                infoFromInpmd.ColName = infoFromRsmd.ColName;
            }
        }
        log.debug("Resetting column count to: {}", this.inputParamMeta.getColumnCount());
        this.setqmarks(this.inputParamMeta.getColumnCount());
    }

    private void setOutputParameterMetaData(String signature, boolean isProc, String procName, int numParams) throws SQLException {
        this.inputParamMeta = this.prot.executeFPDescribe(signature, isProc, procName, numParams);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            if (this.inputParamMeta == null) {
                this.setInputParameterMetaData();
            }
            return new IfxParameterMetaData(this.inputParamMeta);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception ex) {
            throw Messages.getSQLException((Throwable)ex, -79716, this.jconn);
        }
    }

    protected ParameterMetaData getParameterMetaData(String signature, boolean isProc, String procName, int numParams) throws SQLException {
        try {
            if (this.inputParamMeta == null) {
                this.setOutputParameterMetaData(signature, isProc, procName, numParams);
            }
            IfxParameterMetaData parameterMetaDataClassInstance = new IfxParameterMetaData(this.inputParamMeta);
            return parameterMetaDataClassInstance;
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == -674) {
                throw ex;
            }
            throw Messages.getSQLException(-79700, ": IfxPreparedStatement.getParameterMetaData() " + ex.getErrorCode());
        }
        catch (Exception ex) {
            throw Messages.getSQLException(-79700, ": IfxPreparedStatement.getParameterMetaData()");
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setAsciiStream(parameterIndex, x, -1);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        try {
            this.checkParameterIndex(parameterIndex, this.numqmarks);
            IfxObject val = this.vector.elementAt(parameterIndex - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                val.clear();
                val.fromAsciiStream(x, length);
            } else {
                val = IfxValue.makeInstance(this.jconn, x, length, this.getColumnInfo(parameterIndex));
                this.set(parameterIndex, val);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.setBinaryStream(parameterIndex, x, -1);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        if (x == null) {
            IfxObject val = this.vector.elementAt(parameterIndex - 1);
            if (val == null) {
                this.setNull(parameterIndex, -2);
            } else {
                this.setNull(parameterIndex, val.getJDBCType());
            }
            return;
        }
        try {
            this.checkParameterIndex(parameterIndex, this.numqmarks);
            IfxObject val = this.vector.elementAt(parameterIndex - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                val.clear();
                val.fromBinaryStream(x, length);
            } else {
                val = IfxValue.makeInstance(this.jconn, x, length, this.getColumnInfo(parameterIndex));
                this.set(parameterIndex, val);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.setBlob(parameterIndex, inputStream, -1L);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        if (inputStream == null) {
            IfxObject val = this.vector.elementAt(parameterIndex - 1);
            if (val == null) {
                this.setNull(parameterIndex, -2);
            } else {
                this.setNull(parameterIndex, val.getJDBCType());
            }
            return;
        }
        try {
            this.checkParameterIndex(parameterIndex, this.numqmarks);
            IfxObject val = this.vector.elementAt(parameterIndex - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                val.clear();
                val.fromBinaryStream(inputStream, length);
            } else {
                val = IfxValue.makeInstance(this.jconn, inputStream, length, this.getColumnInfo(parameterIndex));
                this.set(parameterIndex, val);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, -1);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        try {
            this.checkParameterIndex(parameterIndex, this.numqmarks);
            IfxObject val = this.vector.elementAt(parameterIndex - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                val.clear();
                val.fromCharacterStream(reader, length);
            } else {
                val = IfxValue.makeInstance(this.jconn, reader, length, this.getColumnInfo(parameterIndex));
                this.set(parameterIndex, val);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.setClob(parameterIndex, reader, -1L);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        try {
            this.checkParameterIndex(parameterIndex, this.numqmarks);
            IfxObject val = this.vector.elementAt(parameterIndex - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                val.clear();
                val.fromCharacterStream(reader, length);
            } else {
                val = IfxValue.makeInstance(this.jconn, reader, length, this.getColumnInfo(parameterIndex));
                this.set(parameterIndex, val);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw Messages.getSQLException(-79882, ": IfxPreparedStatement.setNCharacterStream(int,Reader)");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw Messages.getSQLException(-79882, ": IfxPreparedStatement.setNCharacterStream(int,Reader,long)");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw Messages.getSQLException(-79882, ": IfxPreparedStatement.setNClob(int,NClob)");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw Messages.getSQLException(-79882, ": IfxPreparedStatement.setNClob(int,Reader)");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw Messages.getSQLException(-79882, ": IfxPreparedStatement.setNClob(int,Reader, long)");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw Messages.getSQLException(-79882, ": IfxPreparedStatement.setNString(int,String)");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw Messages.getSQLException(-79882, ": IfxPreparedStatement.setRowId(int, RowId)");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw Messages.getSQLException(-79882, ": IfxPreparedStatement.setSQLXML(int, SQLXML)");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw Messages.getSQLException(-80053, this.jconn, this.getClass().getCanonicalName(), iface.getClass().getCanonicalName());
    }

    @Override
    public void close() throws SQLException {
        this.closeWithKey(null);
    }

    protected void superClose() throws SQLException {
        super.close();
    }

    @Override
    public void setIfxBSONObject(int i, IfxBSONObject x) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                val.clear();
                val.fromObject(x);
            } else {
                IfxColumnInfo ifxColumnInfo = this.getColumnInfo(i);
                val = IfxValue.makeInstance(this.jconn, (Object)x, ifxColumnInfo);
                DataTruncation dt = val.getWarning();
                if (dt != null) {
                    this.chainWarnings(new DataTruncation(i, false, true, dt.getDataSize(), dt.getTransferSize()));
                }
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    @Override
    public ResultSet executeQuery(boolean withHold, boolean withReOptimization) throws SQLException {
        if (this.currentResult == null) {
            this.currentResult = new IfxResultSet(this, this.jconn, this.prot);
        } else {
            this.currentResult.reset();
            log.debug("ResultSet #{} reused for Statement #{}", this.currentResult.getId(), (Object)this.statementId);
        }
        return super.executeQuery(withHold, withReOptimization);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeWithKey(String key) throws SQLException {
        if (this.Closed) {
            return;
        }
        if (!this.poolable || this.pool.getMaximumEntries() == 0) {
            super.close();
            return;
        }
        IfxPreparedStatement previous = null;
        PreparedStatementCache preparedStatementCache = this.pool;
        synchronized (preparedStatementCache) {
            if (this.Closed) {
                return;
            }
            this.clearParameters();
            if (this.currentResult != null) {
                this.currentResult.close();
            }
            log.debug("Caching statement #{}", this.statementId);
            previous = this.pool.put(key == null ? this.baseStatement : key, this);
            if (previous != null && previous != this) {
                previous.setPoolable(false);
            } else {
                previous = null;
            }
        }
        if (previous != null) {
            previous.superClose();
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, this.getSqlType(targetSqlType));
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, x, this.getSqlType(targetSqlType), scaleOrLength);
    }

    int getSqlType(SQLType sqlType) throws SQLException {
        if (sqlType.getVendor().equals(JDBCType.ARRAY.getVendor())) {
            return sqlType.getVendorTypeNumber();
        }
        if (sqlType.getVendor().equals(IfxSQLType.ARRAY.getVendor())) {
            return IfxTypes.FromIfxToJDBCType(sqlType.getVendorTypeNumber());
        }
        throw Messages.getSQLException(80504, this.jconn, sqlType.getVendor());
    }

    @Override
    public Stream<IfxBSONObject> stream() throws SQLException {
        return this.stream(STREAMS_FETCHING.USE_SPLITERATOR);
    }

    @Override
    public Stream<IfxBSONObject> stream(STREAMS_FETCHING fetchOption) throws SQLException {
        if (fetchOption == STREAMS_FETCHING.USE_SPLITERATOR) {
            return StreamSupport.stream(new IfxStatement.ResultSetSpliterator(this.executeQuery()), false);
        }
        ArrayList<IfxBSONObject> results = new ArrayList<IfxBSONObject>();
        try (ResultSet rs = this.executeQuery();){
            while (rs.next()) {
                results.add(BsonUtils.convertCurrentResultSetRowToDocument(rs, rs.getMetaData(), -1));
            }
        }
        return results.stream();
    }

    @Override
    public Stream<IfxBSONObject> stream(String sql, STREAMS_FETCHING fetchOption) throws SQLException {
        throw Messages.getSQLException(-79700, ": IfxPreparedStatement.stream(...)");
    }

    String getDBName() {
        return this.dbname;
    }
}

