/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxComplex;
import com.informix.jdbc.IfxComplexOutput;
import com.informix.jdbc.IfxConnection;
import com.informix.lang.Messages;
import com.informix.util.TraceFlag;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;

public class IfxRow
extends IfxComplex {
    IfxRow() throws SQLException {
        this.outputStream = new IfxComplexOutput(true, false);
    }

    @Override
    public Object toObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        if (this.inputStream == null) {
            throw Messages.getSQLException(-79716, this.conn);
        }
        this.inputStream.setTypeMap(this.typeMap);
        return this.inputStream.readRow();
    }

    @Override
    public void fromObject(Object data) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxRow.fromObject() entered ");
            if (data != null) {
                this.writeTrace(2, "    data class: " + data.getClass().getName());
            }
        }
        if (this.outputStream == null) {
            if (TraceFlag.isTraceEnabled()) {
                this.writeTrace(2, "    fromObject(): outputStream is null");
            }
            throw Messages.getSQLException(-79716, this.conn);
        }
        this.clear();
        this.outputStream.setConnection(this.conn);
        this.outputStream.reset();
        if (data == null) {
            this.nullify();
        } else {
            this.outputStream.clear();
            this.outputStream.setTypeMap(this.typeMap);
            if (data instanceof Struct) {
                if (TraceFlag.isTraceEnabled()) {
                    this.writeTrace(2, "    fromObject(): before call to outputStream.Row()");
                }
                this.outputStream.writeRow((Struct)data);
            } else if (data instanceof SQLData) {
                if (TraceFlag.isTraceEnabled()) {
                    this.writeTrace(2, "    fromObject(): before call to outputStream.writeRow()");
                }
                this.outputStream.writeRow((SQLData)data);
            } else {
                if (TraceFlag.isTraceEnabled()) {
                    this.writeTrace(2, "    fromObject(): Object class unknow");
                }
                throw Messages.getSQLException(-79728, this.conn);
            }
            if (this.outputStream.isNull()) {
                this.nullify();
            } else {
                this.unnullify();
            }
        }
        if (!this.conn.isDirect()) {
            this.setIfxType(44);
        }
        super.setExtendedTypeName(this.outputStream.getExtendedName());
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxRow.fromObject() exited ");
        }
    }

    public void fromObject(Object data, String type, IfxConnection conn) throws SQLException {
        this.outputStream = new IfxComplexOutput(true, type, conn);
        this.fromObject(data);
    }
}

