/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.asf.IfxDataInputStream;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxValue;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.IfxTypes;
import com.informix.lang.Messages;
import com.informix.util.JdbcLogger;
import com.informix.util.Trace;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Vector;

class IfxRowColumn {
    private static final JdbcLogger logger = JdbcLogger.getLogger(IfxRowColumn.class);
    private final IfxConnection conn;
    private byte[] tuple;
    private IfxResultSetMetaData rsmd;
    private int offset;
    private Vector<ColumnInfo> colInfoVector;
    private int currDataSize;

    IfxRowColumn(IfxConnection thisConn, IfxResultSetMetaData metaData, int initialSize) {
        this.rsmd = metaData;
        this.conn = thisConn;
        this.tuple = new byte[1024];
        logger.debug("Creating row structure size={}", 1024);
    }

    public int readTuple(IfxDataInputStream is) throws SQLException {
        int size = 0;
        try {
            size = is.readInt();
            logger.trace(Trace.S_C_MARKER, "SQ_TUPLE size: {}", (Object)size);
            int newSize = this.currDataSize + size;
            if (this.tuple.length < newSize) {
                newSize = this.tuple.length + (size < 1024 ? 1024 : size + 1024);
                logger.debug("Resizing row structure to: {}.", newSize);
                if (this.currDataSize == 0) {
                    this.tuple = new byte[newSize];
                } else {
                    byte[] tuple2 = new byte[newSize];
                    System.arraycopy(this.tuple, 0, tuple2, 0, this.currDataSize);
                    this.tuple = tuple2;
                }
            }
            is.readPadded(this.tuple, this.currDataSize, size);
            this.currDataSize += size;
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
        return size;
    }

    void setOffsetInTuple(int offset) throws SQLException {
        this.offset = offset;
        if (this.rsmd.hasVariableLengthColumns || this.rsmd.hasVariableLengthCharColumns) {
            int rowOffset = offset;
            int colOffset = 0;
            if (this.colInfoVector == null) {
                this.colInfoVector = new Vector();
                this.colInfoVector.setSize(this.rsmd.getColumnCount());
            }
            for (int i = 1; i <= this.rsmd.getColumnCount(); ++i) {
                int colType = this.rsmd.getIfxColumnType(i);
                int colLen = this.rsmd.getColumnLength(i);
                if (colType == 40 || colType == 41 || colType == 45 || colType == 43 || colType == 46) {
                    colLen = 5 + IfxToJavaType.IfxToJavaInt(this.tuple, rowOffset + 1);
                } else if (colType == 13 || colType == 16) {
                    colLen = ((IfxSqliConnect)this.conn).isVarcharVarLenSupported() ? 1 + (this.tuple[rowOffset] & 0xFF) : ++colLen;
                } else if (IfxTypes.isComplexType(colType)) {
                    int dataLen = IfxToJavaType.IfxToJavaInt(this.tuple, rowOffset);
                    colLen = dataLen + 4;
                }
                rowOffset += colLen;
                ColumnInfo ci = new ColumnInfo(colOffset, colLen);
                this.colInfoVector.setElementAt(ci, i - 1);
                colOffset += colLen;
            }
        }
    }

    public void setMetaData(IfxResultSetMetaData metaData) {
        this.rsmd = metaData;
        this.colInfoVector = null;
    }

    public IfxObject getColumn(int idx) throws SQLException {
        return this.getColumn(idx, null);
    }

    public IfxObject getColumn(int idx, Calendar cal) throws SQLException {
        IfxObject obj = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(idx), cal);
        this.loadColumnData(idx, obj);
        return obj;
    }

    public void loadColumnData(int idx, IfxObject val) throws SQLException {
        int columnOffset;
        int ifxColLen;
        int columnType = this.rsmd.getIfxColumnType(idx);
        val.clear();
        if (this.colInfoVector != null) {
            if (idx > this.colInfoVector.size()) {
                throw Messages.getSQLException(-79703, this.conn);
            }
            ColumnInfo ci = this.colInfoVector.get(idx - 1);
            ifxColLen = ci.len;
            columnOffset = ci.startPos;
            if (!(this.rsmd.hasVariableLengthColumns || columnType != 13 && columnType != 16)) {
                ++ifxColLen;
            }
        } else {
            IfxColumnInfo ifxColumnInfo = this.rsmd.getColumnInfo(idx);
            if (ifxColumnInfo.isIfxColLenSet) {
                ifxColLen = ifxColumnInfo.ifxColLen;
                columnOffset = ifxColumnInfo.ColStartPos;
            } else {
                columnOffset = this.rsmd.getColumnStartPosition(idx);
                switch (columnType) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 17: 
                    case 52: {
                        ifxColLen = 1;
                        break;
                    }
                    default: {
                        ifxColLen = this.rsmd.getColumnLength(idx);
                    }
                }
                if (!(this.rsmd.hasVariableLengthColumns || columnType != 13 && columnType != 16)) {
                    ++ifxColLen;
                }
                ifxColumnInfo.ifxColLen = ifxColLen;
                ifxColumnInfo.isIfxColLenSet = true;
            }
        }
        if (this.tuple != null && ifxColLen > 0) {
            try {
                switch (columnType) {
                    case 5: 
                    case 8: 
                    case 10: 
                    case 14: {
                        val.fromIfx(this.tuple, this.offset + columnOffset, ifxColLen, (short)this.rsmd.getEncodedLength(idx));
                        break;
                    }
                    default: {
                        val.fromIfx(this.tuple, this.offset + columnOffset, ifxColLen);
                        break;
                    }
                }
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw Messages.getSQLException(-79716, e.toString(), this.conn);
            }
        }
    }

    public void reset() {
        this.currDataSize = 0;
    }

    public void clear() {
        this.reset();
        this.rsmd = null;
    }

    class ColumnInfo {
        final int startPos;
        final int len;

        ColumnInfo(int startPos, int len) {
            this.startPos = startPos;
            this.len = len;
        }

        public String toString() {
            return "Position: " + this.startPos + "\tLength: " + this.len;
        }
    }
}

