/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import java.math.BigDecimal;
import java.sql.SQLException;

public class IfxShort
extends IfxObject {
    private short value;
    public static final short IFX_SMINT_NULL = Short.MIN_VALUE;

    IfxShort() {
        this.setIfxType(1);
    }

    @Override
    public byte[] toIfx() {
        return JavaToIfxType.JavaToIfxSmallInt(this.value);
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] b = new byte[]{-128, 0};
            return b;
        }
        return JavaToIfxType.JavaToIfxSmallInt(this.value);
    }

    @Override
    public void fromIfx(byte[] b) {
        this.fromIfx(b, 0, b.length);
    }

    @Override
    public void fromIfx(byte[] b, int offset, int length) {
        this.value = IfxToJavaType.IfxToJavaSmallInt(b, offset);
        if (this.isIfxNull()) {
            this.nullify();
        } else {
            this.unnullify();
        }
    }

    @Override
    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public byte toByte() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (byte)this.value;
    }

    @Override
    public void fromByte(byte val) throws SQLException {
        this.value = val;
        this.unnullify();
    }

    @Override
    public void fromByte(Byte val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.shortValue();
            this.unnullify();
        }
    }

    @Override
    public short toShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return this.value;
    }

    @Override
    public void fromShort(short val) throws SQLException {
        this.value = val;
        this.unnullify();
    }

    @Override
    public void fromShort(Short val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val;
            this.unnullify();
        }
    }

    @Override
    public int toInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return this.value;
    }

    @Override
    public void fromInt(int val) {
        this.value = (short)val;
        this.unnullify();
    }

    @Override
    public void fromInt(Integer val) {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.shortValue();
            this.unnullify();
        }
    }

    @Override
    public long toLong() {
        if (this.isNull()) {
            return 0L;
        }
        return this.value;
    }

    @Override
    public void fromLong(long val) {
        this.value = (short)val;
        this.unnullify();
    }

    @Override
    public void fromLong(Long val) {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.shortValue();
            this.unnullify();
        }
    }

    @Override
    public float toFloat() {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.value;
    }

    @Override
    public void fromFloat(float val) {
        this.value = (short)val;
        this.unnullify();
    }

    @Override
    public void fromFloat(Float val) {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.shortValue();
            this.unnullify();
        }
    }

    @Override
    public double toDouble() {
        if (this.isNull()) {
            return 0.0;
        }
        return this.value;
    }

    @Override
    public void fromDouble(double val) {
        this.value = (short)val;
        this.unnullify();
    }

    @Override
    public void fromDouble(Double val) {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.shortValue();
            this.unnullify();
        }
    }

    @Override
    public BigDecimal toDecimal() {
        if (this.isNull()) {
            return null;
        }
        return BigDecimal.valueOf(this.value);
    }

    @Override
    public void fromDecimal(BigDecimal val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = (short)val.intValue();
            this.unnullify();
        }
    }

    @Override
    public boolean toBoolean() {
        if (this.isNull()) {
            return false;
        }
        return this.value != 0;
    }

    @Override
    public void fromBoolean(boolean val) {
        this.value = (short)(val ? 1 : 0);
        this.unnullify();
    }

    @Override
    public void fromBoolean(Boolean val) {
        if (val == null) {
            this.nullify();
        } else {
            this.value = (short)(val != false ? 1 : 0);
            this.unnullify();
        }
    }

    @Override
    public String toString() {
        if (this.isNull()) {
            return null;
        }
        return Short.toString(this.value);
    }

    @Override
    public void fromString(String str) throws SQLException {
        if (str == null) {
            this.nullify();
        } else {
            this.value = Short.parseShort(str.trim());
            this.unnullify();
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this.isNull() || other == null) {
            return false;
        }
        return other instanceof IfxShort && this.value == ((IfxShort)other).value;
    }

    @Override
    public short getEncodedLength() {
        return 1280;
    }

    public boolean isIfxNull() {
        return this.value == Short.MIN_VALUE;
    }
}

