/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.asf.IfxDataInputStream;
import com.informix.asf.IfxDataOutputStream;
import com.informix.asf.SqliDbg;
import com.informix.jdbc.IfmxStatement;
import com.informix.jdbc.IfxBlob;
import com.informix.jdbc.IfxByteArrayInputStream;
import com.informix.jdbc.IfxCollection;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDateTime;
import com.informix.jdbc.IfxDecimal;
import com.informix.jdbc.IfxDistinct;
import com.informix.jdbc.IfxFParam;
import com.informix.jdbc.IfxLobInputStream;
import com.informix.jdbc.IfxMessageTypes;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSet;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxRow;
import com.informix.jdbc.IfxRowColumn;
import com.informix.jdbc.IfxSmBlob;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.IfxTmpFile;
import com.informix.jdbc.IfxValue;
import com.informix.jdbcx.IfxPAMChallenge;
import com.informix.jdbcx.IfxPAMResponse;
import com.informix.jdbcx.PAM;
import com.informix.jdbcx.PAMChallengeImpl;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.IfxTypes;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.lang.JavaToIfxType;
import com.informix.lang.Messages;
import com.informix.lang.WarningMessages;
import com.informix.util.JdbcLogger;
import com.informix.util.Trace;
import com.informix.util.stringUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class IfxSqli
implements IfxProtocol {
    private static final JdbcLogger log = JdbcLogger.getLogger(IfxSqli.class);
    private static final Object logger = Trace.getLoggerForClass(IfxSqli.class);
    private String routineDbName = null;
    private boolean descTrue = false;
    IfxResultSetMetaData desc;
    IfxResultSetMetaData idesc;
    private OutputStream BlobFd;
    private byte[] BlobBuffer;
    private short BufferOrStream;
    private int BlobWriteFailure;
    private int BlobWriteOffset;
    private int BlobRequestSize;
    private int amountRW;
    private String copyToFileName;
    private int copyToFileFlags;
    private int copyToFileMode;
    private int copyToFileOffset;
    private File copyToFileFd;
    private RandomAccessFile loFile;
    private short statementID = (short)-1;
    private short statementType;
    protected final IfxSqliConnect conn;
    protected final Trace protoTrace;
    protected final SqliDbg sqliTrace;
    private String dbEncoding;
    private boolean isText;
    private boolean convText;
    private long serial8Inserted;
    private long bigSerialInserted;
    private short xcEvent = (short)-1;
    private short xcNewLevel = (short)-1;
    private short xcOldLevel = (short)-1;
    private boolean isReleased = true;
    private int tupleBufferSize = -1;
    private boolean typeSent = false;
    private int sqlcode;
    private int isamcode;
    private String SQLState;
    private String message;
    private SQLWarning warn;
    private SQLException exception;
    private final long[] sqlerrd = new long[6];
    private short serverWarningsShort;
    private boolean OpenDBStmt;
    private String serverVersion;
    private byte[] serverProtocol = null;
    private final ArrayList<Integer> offsetList = new ArrayList(200);
    private int totalTupleSize;
    private int totalTuplesInBuffer;
    private int firstTuple;
    private int lastTuple;
    private int curRow = -1;
    private boolean doneCommit;
    private int Tupid;
    private int numberOfFetches = 0;
    private int numberOfTuplesReceived = 0;
    private int tupleSizeReceived = 0;
    private int fpHandle;
    private Vector<IfxObject> fpRet;
    private Vector<IfxObject> fpInput;
    private IfxFParam fparam;
    private boolean partialFParam;
    private int totalOutValues = 0;
    private int totalOutParams = 0;
    static final int IN = 0;
    static final int OUT = 1;
    static final int INOUT = 2;
    private short TxStmt;
    private static final short NON_TX_STMT = 0;
    private static final short BEG_TX_STMT = 1;
    private static final short END_TX_STMT = 2;
    protected static final int INFX_BUFSIZE = 4096;
    protected static final int INFX_MAXBUFSIZE = Short.MAX_VALUE;
    protected static final int INFX_MAX_BIGBUFSIZE = Integer.MAX_VALUE;
    private static final int INFX_MAXQUOTEDSTRINGSIZE = 65535;
    private IfxRowColumn rowColumn;
    private IfxResultSetMetaData SGK_desc = null;
    protected IfxRowColumn SGK_rowColumn;
    private final Vector<Integer> SGK_offsetVector = new Vector();
    private int SGK_totalTupleSize;
    private int SGK_curOffset;
    private int SGK_totalTuples;
    private int SGK_curRow = -1;
    protected final IfxDataOutputStream os;
    protected final IfxDataInputStream is;
    protected boolean SQ_CLOSERecvd;
    private boolean SQ_CLOSESent;
    private boolean first = true;
    private Vector<String> DBList;
    boolean executeBatchInProgress;
    public ArrayList<Integer> batchRowStatus;
    private int batchCount;
    private boolean userPAMAuthorized = false;
    private long putErrRowCount = 0L;
    private int cursorType = 1003;

    public IfxSqli(IfxSqliConnect connection) {
        if (connection == null) {
            throw new NullPointerException("Internal connection object cannot be null");
        }
        this.conn = connection;
        this.sqliTrace = this.conn.asfconn.sqliTrace;
        this.protoTrace = this.conn.getProtoTrace();
        this.os = this.conn.Ifxproto_send();
        this.is = this.conn.Ifxproto_receive();
        this.dbEncoding = this.conn.getdbEncoding();
        this.convText = this.conn.isConvText();
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return this.desc;
    }

    ResultSetMetaData getSGK_metaData() {
        return this.SGK_desc;
    }

    @Override
    public int getStatementType() {
        return this.statementType;
    }

    @Override
    public void clearBatch() {
        this.batchCount = 0;
        this.batchRowStatus = null;
        this.executeBatchInProgress = false;
    }

    @Override
    public void clearSerialValues() {
        this.serial8Inserted = 0L;
        this.bigSerialInserted = 0L;
    }

    @Override
    public void clear() {
        this.serial8Inserted = 0L;
        this.bigSerialInserted = 0L;
        this.xcEvent = (short)-1;
        this.xcNewLevel = (short)-1;
        this.xcOldLevel = (short)-1;
        this.sqlcode = 0;
        this.isamcode = 0;
        this.SQLState = null;
        this.message = null;
        this.OpenDBStmt = false;
        for (int i = 0; i < 6; i = (int)((short)(i + 1))) {
            this.sqlerrd[i] = 0L;
        }
        this.serverWarningsShort = 0;
        this.tupleBufferSize = -1;
        this.resetTuples();
        this.doneCommit = false;
        this.warn = null;
        if (this.rowColumn != null) {
            this.rowColumn.clear();
        }
    }

    private void resetTuples() {
        this.totalTupleSize = 0;
        this.curRow = -1;
        this.totalTuplesInBuffer = 0;
        this.Tupid = 0;
        if (this.rowColumn != null) {
            this.rowColumn.reset();
        }
    }

    private void resetSGKTuples() {
        this.SGK_offsetVector.removeAllElements();
        this.SGK_offsetVector.setSize(10);
        this.SGK_offsetVector.setElementAt(0, 0);
        this.SGK_totalTupleSize = 0;
        this.SGK_curOffset = 0;
        this.SGK_curRow = -1;
        this.SGK_totalTuples = 0;
        if (this.SGK_rowColumn != null) {
            this.SGK_rowColumn.reset();
        }
    }

    private void clearAll() {
        this.clear();
        this.isReleased = true;
        this.desc = null;
        this.idesc = null;
    }

    @Override
    public void executeBegin() throws SQLException {
        this.conn.lockSession();
        try {
            this.sendBegin();
            this.receiveMessage();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        finally {
            this.conn.unlockSession();
        }
    }

    private void sendBegin() throws SQLException {
        try {
            log.trace(Trace.C_S_MARKER, "SQ_BEGIN");
            this.os.writeSmallInt((short)35);
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    @Override
    public void executeCommit() throws SQLException {
        this.conn.lockSession();
        try {
            this.sendCommit();
            this.receiveMessage();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        finally {
            this.conn.unlockSession();
        }
        this.conn.markCursorsToClosed(true);
    }

    private void sendCommit() throws SQLException {
        try {
            log.trace(Trace.C_S_MARKER, "SQ_CMMTWORK");
            this.os.writeSmallInt((short)19);
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    @Override
    public void executeSavepoint(String savepointname, boolean uniqflag) throws SQLException {
        this.conn.lockSession();
        try {
            if (!this.conn.autoCommit) {
                this.initiateTransaction();
            }
            this.sendSavepoint(savepointname, uniqflag);
            this.receiveMessage();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        finally {
            this.conn.unlockSession();
        }
    }

    private void sendSavepoint(String savepointname, boolean uniqflag) throws SQLException {
        try {
            byte[] savePointNameBytes = this.os.getJavaToIfxChar(savepointname, this.dbEncoding);
            log.trace(Trace.C_S_MARKER, "SQ_SQLISETSVPT: {}", (Object)savepointname);
            this.os.writeSmallInt((short)137);
            this.os.writeChar(savePointNameBytes);
            if (uniqflag) {
                this.os.writeSmallInt((short)1);
            } else {
                this.os.writeSmallInt((short)0);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    @Override
    public void executeReleaseSavepoint(String savepointname) throws SQLException {
        if (!this.conn.lockSession()) {
            throw Messages.getSQLMinorException(-79748, -80033, this.conn);
        }
        if (!this.conn.autoCommit) {
            this.initiateTransaction();
        }
        try {
            this.sendReleaseSavepoint(savepointname);
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
    }

    private void sendReleaseSavepoint(String savepointname) throws SQLException {
        try {
            byte[] savePointNameBytes = this.os.getJavaToIfxChar(savepointname, this.dbEncoding);
            log.trace(Trace.C_S_MARKER, "SQ_SQLIRELSVPT: {}", (Object)savepointname);
            this.os.writeSmallInt((short)138);
            this.os.writeChar(savePointNameBytes);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    @Override
    public void executeRollbackSavepoint(String savepointname) throws SQLException {
        if (!this.conn.lockSession()) {
            throw Messages.getSQLMinorException(-79748, -80033, this.conn);
        }
        if (!this.conn.autoCommit) {
            this.initiateTransaction();
        }
        try {
            this.sendRollbackSavepoint(savepointname);
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
    }

    private void sendRollbackSavepoint(String savepointname) throws SQLException {
        try {
            byte[] savePointNameBytes = this.os.getJavaToIfxChar(savepointname, this.dbEncoding);
            log.trace(Trace.C_S_MARKER, "SQ_SQLIRBACKSVPT: {}", (Object)savepointname);
            this.os.writeSmallInt((short)139);
            this.os.writeChar(savePointNameBytes);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    @Override
    public void executeRollback() throws SQLException {
        if (!this.conn.lockSession()) {
            throw Messages.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendRollback();
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
        this.conn.markCursorsToClosed(false);
    }

    @Override
    public void executeGetDBList() throws SQLException {
        if (!this.conn.lockSession()) {
            throw Messages.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendGetDBList();
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
    }

    public Vector<String> getDBList() {
        return this.DBList;
    }

    private void sendGetDBList() throws SQLException {
        try {
            log.trace(Trace.C_S_MARKER, "SQ_DBLIST");
            this.os.writeSmallInt((short)26);
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private void receiveDBList() throws SQLException {
        try {
            String dbName;
            this.DBList = new Vector();
            while ((dbName = this.is.readChar(this.dbEncoding)).length() != 0) {
                boolean inserted = false;
                for (int i = 0; i < this.DBList.size(); ++i) {
                    String lastDBname = this.DBList.get(i);
                    if (dbName.compareToIgnoreCase(lastDBname) >= 0) continue;
                    this.DBList.insertElementAt(dbName, i);
                    inserted = true;
                    break;
                }
                if (inserted) continue;
                this.DBList.insertElementAt(dbName, this.DBList.size());
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private void sendRollback() throws SQLException {
        try {
            log.trace(Trace.C_S_MARKER, "SQ_RBWORK");
            this.os.writeSmallInt((short)20);
            this.os.writeSmallInt((short)0);
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    @Override
    public void executeCommand(Statement stmt) throws SQLException {
        this.conn.lockSession();
        try {
            if (stmt instanceof IfxPreparedStatement && ((IfxPreparedStatement)stmt).usePut()) {
                this.initiateTransaction();
                this.sendPut((IfxPreparedStatement)stmt);
            } else {
                this.sendCommand((IfxStatement)stmt);
            }
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            if (this.TxStmt == 2) {
                if (this.sqlcode != -255) {
                    this.conn.setTxEndState();
                }
            } else if (stmt instanceof IfxPreparedStatement && ((IfxPreparedStatement)stmt).usePut() && this.conn.TxState == 2 && this.conn.autoCommit && this.sqlcode != -255) {
                this.sendCommit();
                this.conn.setTxEndState();
            }
            throw e;
        }
        try {
            this.receiveMessage();
            if (this.SGK_desc != null && stmt.getConnection().unwrap(IfxConnection.class).processTableNameForResultSet()) {
                String SGK_tabnm = IfxResultSetMetaData.parseTableName(((IfxStatement)stmt).commandString);
                for (int i = 1; i <= this.SGK_desc.getColumnCount(); ++i) {
                    this.SGK_desc.setTableName(i, SGK_tabnm);
                }
            }
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            if (this.TxStmt == 2) {
                if (this.sqlcode != -255) {
                    this.conn.setTxEndState();
                }
            } else if (!this.conn.inXATransaction() && this.conn.db_use_log && this.conn.autoCommit) {
                try {
                    this.executeCommit();
                    this.conn.setTxEndState();
                }
                catch (Exception e1) {
                    throw e;
                }
            }
            throw e;
        }
        this.conn.unlockSession();
        this.callsetDatabaseOpen(IfxSqli.getDbName(stmt));
        if (this.TxStmt == 1) {
            this.conn.setTxBeginState();
        } else if (this.TxStmt == 2) {
            this.conn.setTxEndState();
        } else if (!this.conn.inXATransaction() && (this.conn.isCommitNeeded() || this.conn.db_use_log && this.conn.autoCommit && stmt instanceof IfxPreparedStatement && ((IfxPreparedStatement)stmt).usePut())) {
            this.executeCommit();
            this.conn.setTxEndState();
            this.doneCommit = true;
        }
        if (this.desc != null) {
            this.desc.parseSetTableName(((IfxStatement)stmt).commandString);
        }
    }

    private void sendCommand(IfxStatement stmt) throws SQLException {
        boolean tmpFlag = true;
        if (!this.conn.autoCommit && !stmt.commandString.trim().toLowerCase().startsWith("begin")) {
            this.initiateTransaction();
        }
        int batchRowSize = stmt.BatchVector.size();
        if (stmt.executeBatchInProgress) {
            this.executeBatchInProgress = true;
        }
        if (stmt instanceof IfxPreparedStatement) {
            this.sendExecute(stmt);
        } else {
            String[] str = null;
            if (batchRowSize > 0 && this.executeBatchInProgress) {
                str = new String[batchRowSize];
                for (int k = 0; k < batchRowSize; ++k) {
                    str[k] = stmt.BatchVector.get(k);
                }
            } else {
                str = new String[]{stmt.commandString};
                tmpFlag = false;
            }
            try {
                if (!this.conn.isRemove64KLimitSupported() && stmt.commandString.length() > 65535) {
                    throw Messages.getSQLException(-79864, this.conn);
                }
                int j = 0;
                do {
                    String cmdString = str[j];
                    byte[] b = this.getJavaToIfxCharBytes(str[j++]);
                    log.trace(Trace.C_S_MARKER, "SQ_COMMAND: {}", (Object)cmdString);
                    this.os.writeSmallInt((short)1);
                    this.os.writeSmallInt((short)0);
                    this.os.writeChar(b);
                    this.SGK_desc = null;
                    this.SGK_rowColumn = null;
                    if (stmt.SGK_returnGeneratedKeys != 0) {
                        this.sendSGKPrepare(stmt);
                    }
                    log.trace(Trace.C_S_MARKER, "SQ_NDESCRIBE");
                    this.os.writeSmallInt((short)22);
                    this.resetSGKTuples();
                    if (j == 1 && this.conn.isSQBatchSupported() && this.conn.isANSI() && tmpFlag) {
                        this.sendSQBatchStart();
                    }
                    log.trace(Trace.C_S_MARKER, "SQ_EXECUTE");
                    this.os.writeSmallInt((short)7);
                    if (j == batchRowSize && this.conn.isSQBatchSupported() && this.conn.isANSI() && tmpFlag) {
                        this.sendSQBatchEnd();
                    }
                    log.trace(Trace.C_S_MARKER, "SQ_RELEASE");
                    this.os.write(IfxMessageTypes.SQ_RELEASE_BYTES);
                    this.isReleased = true;
                } while (j < batchRowSize && this.executeBatchInProgress);
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw this.handleSocketException(e, this.conn);
            }
        }
    }

    private boolean sendBind(List<IfxObject> vector, ResultSetMetaData pmd, int inputvals, int si, int ei) throws SQLException {
        int blobCount = 0;
        int ord = 0;
        boolean sentIMPEXP = false;
        boolean checkIfxValException = false;
        SQLException IfxValException = null;
        try {
            if (log.isTraceEnabled() && si == 0) {
                log.trace(Trace.C_S_MARKER, "SQ_BIND - Input Value Count: {}", (Object)inputvals);
            }
            this.os.write(IfxMessageTypes.SQ_BIND_BYTES);
            this.os.writeSmallInt((short)inputvals);
            for (int i = si; i < ei; ++i) {
                short type;
                IfxObject ival = null;
                if (i < vector.size()) {
                    ival = vector.get(i);
                }
                if (ival == null) {
                    ord = i % inputvals + 1;
                    type = 0;
                    if (pmd == null || !((IfxResultSetMetaData)pmd).hasDefaultValue(ord)) {
                        if (pmd != null) {
                            throw Messages.getSQLException(-79823, ((IfxResultSetMetaData)pmd).getArgumentName(ord), (IfxConnection)this.conn);
                        }
                        throw Messages.getSQLException(-79823, this.conn);
                    }
                    type = (short)((IfxResultSetMetaData)pmd).getIfxColumnType(ord);
                    this.os.writeSmallInt(type);
                    log.trace(Trace.C_S_MARKER, "SQ_BIND Type: {}, Null setting: -2", (Object)type);
                    this.os.writeSmallInt((short)-2);
                    this.os.writeSmallInt((short)0);
                    continue;
                }
                type = (short)ival.getIfxType();
                if (type == 11 || type == 12) {
                    if (((IfxBlob)ival).isIfxTextType()) {
                        type = 12;
                    }
                    if (!ival.isNull()) {
                        ++blobCount;
                    }
                }
                if (type == 46) {
                    sentIMPEXP = true;
                }
                this.os.writeSmallInt(type);
                String owner = null;
                String name = null;
                if (type > 18 && type != 52 && type != 53) {
                    owner = ival.getExtendedOwner();
                    name = ival.getExtendedTypeName();
                    if (owner == null) {
                        this.os.writeSmallInt((short)0);
                    } else {
                        this.os.writeChar(this.os.getJavaToIfxChar(owner));
                    }
                    this.os.writeChar(this.os.getJavaToIfxChar(name));
                }
                if (ival.isNull()) {
                    this.os.writeSmallInt((short)-1);
                    this.os.writeSmallInt((short)0);
                    log.trace(Trace.C_S_MARKER, "SQ_BIND Type: {}, IsNull: true, Name: {}.{}", type, owner, name);
                    continue;
                }
                byte[] bData = null;
                try {
                    bData = ival.toIfx();
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == -79783 || e.getErrorCode() == -23103) {
                        this.os.writeSmallInt((short)-1);
                        this.os.writeSmallInt((short)0);
                        checkIfxValException = true;
                        IfxValException = e;
                        continue;
                    }
                    throw e;
                }
                this.os.writeSmallInt((short)0);
                short shortVal = ival.getIfxType() != 5 || ival.getIfxType() == 5 && ival instanceof IfxDistinct ? ival.getEncodedLength() : (short)((IfxDecimal)ival).getScale();
                this.os.writeSmallInt(shortVal);
                log.trace(Trace.C_S_MARKER, "SQ_BIND Type: {}, IsNull: false, Name: {}.{}, Precision: {}, Size: {}", type, owner, name, shortVal, bData.length);
                this.os.writePadded(bData);
                if (this.statementType == 1 || this.statementType == 12 || this.statementType == 38) {
                    this.conn.setDbName(ival.toString());
                }
                if (this.statementType != 31) continue;
                this.conn.setDbName(null);
            }
            if (checkIfxValException) {
                throw IfxValException;
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (blobCount > 0 && sentIMPEXP) {
            this.receiveMessage();
        }
        if (blobCount > 0) {
            this.sendBlob(vector, blobCount, si, inputvals);
        }
        return sentIMPEXP;
    }

    @Override
    public void executePrepare(Statement stmt) throws SQLException {
        if (!this.conn.lockSession()) {
            throw Messages.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendPrepare((IfxStatement)stmt);
            this.receiveMessage();
            ((IfxStatement)stmt).setStatementType(this.statementType);
            if (this.SGK_desc != null) {
                this.SGK_desc.parseSetTableName(((IfxStatement)stmt).commandString);
            }
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
        if (this.desc != null) {
            this.desc.parseSetTableName(((IfxStatement)stmt).commandString);
        }
    }

    private void sendPrepare(IfxStatement stmt) throws SQLException {
        String s = stmt.commandString;
        try {
            byte[] b = this.getJavaToIfxCharBytes(s);
            if (!this.conn.isRemove64KLimitSupported() && s.length() > 65535) {
                throw Messages.getSQLException(-79864, this.conn);
            }
            if (this.conn.db_use_log && !this.conn.autoCommit && stmt instanceof IfxPreparedStatement) {
                IfxPreparedStatement pstmt = (IfxPreparedStatement)stmt;
                if (pstmt.BatchVector.size() > 0 && !pstmt.usePut()) {
                    this.initiateTransaction();
                }
            }
            log.trace(Trace.C_S_MARKER, "SQ_PREPARE Param count: {} SQL: {}", stmt.numqmarks, s);
            this.os.writeSmallInt((short)2);
            this.os.writeSmallInt((short)stmt.numqmarks);
            this.os.writeChar(b);
            this.SGK_desc = null;
            this.SGK_rowColumn = null;
            if (stmt.SGK_returnGeneratedKeys != 0) {
                this.sendSGKPrepare(stmt);
            }
            log.trace(Trace.C_S_MARKER, "SQ_NDESCRIBE");
            this.os.writeSmallInt((short)22);
            log.trace(Trace.C_S_MARKER, "SQ_WANTDONE");
            this.os.writeSmallInt((short)49);
            this.isReleased = false;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private void sendStatementExecute(IfxStatement stmt) throws SQLException {
        this.sendExecute(stmt);
        this.receiveMessage();
    }

    private void sendExecute(IfxStatement stmt) throws SQLException {
        try {
            this.sendStatementID();
            if (!(stmt instanceof IfxPreparedStatement)) {
                this.resetSGKTuples();
                log.trace(Trace.C_S_MARKER, "SQ_EXECUTE");
                this.os.writeSmallInt((short)7);
                return;
            }
            IfxPreparedStatement pstmt = (IfxPreparedStatement)stmt;
            IfxResultSetMetaData pmd = pstmt.inputParamMeta;
            int qmarks = pstmt.getqmarks();
            if (!stmt.executeBatchInProgress && (pstmt.BatchVector.size() <= 0 || pstmt.executeBatchInProgress)) {
                Vector setValues = null;
                setValues = pstmt.BatchVector.isEmpty() ? pstmt.getVector() : pstmt.BatchParamVector;
                for (int i = 0; i < qmarks && pstmt.BatchVector.isEmpty(); ++i) {
                    IfxObject ival = null;
                    if (i < setValues.size()) {
                        ival = (IfxObject)setValues.get(i);
                    }
                    if (ival != null) continue;
                    int ord = i % qmarks + 1;
                    if (pmd != null && pmd.hasDefaultValue(ord)) continue;
                    throw Messages.getSQLException(-79823, pstmt.namedCalls == 0L ? " index = " + ord : pmd.getArgumentName(ord));
                }
                if (qmarks > 0) {
                    this.sendBind(setValues, pmd, qmarks, 0, qmarks);
                }
            } else {
                if (stmt.executeBatchInProgress) {
                    int batchCnt = pstmt.BatchVector.size();
                    for (int j = 0; j < batchCnt; ++j) {
                        int startIdx = j * qmarks;
                        int endIdx = startIdx + qmarks;
                        boolean sentIMPEXP = false;
                        if (qmarks > 0) {
                            sentIMPEXP = this.sendBind(pstmt.BatchParamVector, pmd, qmarks, startIdx, endIdx);
                        }
                        if (j == 0 && this.conn.isSQBatchSupported() && this.conn.isANSI()) {
                            this.sendSQBatchStart();
                        }
                        log.trace(Trace.C_S_MARKER, "SQ_EXECUTE");
                        this.os.writeSmallInt((short)7);
                        if (j == batchCnt - 1 && this.conn.isSQBatchSupported() && this.conn.isANSI()) {
                            this.sendSQBatchEnd();
                        }
                        if (sentIMPEXP) {
                            this.receiveMessage();
                        }
                        if (!this.executeBatchInProgress || this.os.getBytesSentSinceLastEOT() < Short.MAX_VALUE) continue;
                        this.receiveMessage();
                        this.sendStatementID();
                    }
                    return;
                }
                int numVals = pstmt.BatchParamVector.size();
                this.sendBind(pstmt.BatchParamVector, pmd, 0, numVals, numVals);
            }
            this.resetSGKTuples();
            log.trace(Trace.C_S_MARKER, "SQ_EXECUTE");
            this.os.writeSmallInt((short)7);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    @Override
    public void executeStatementQuery(Statement stmt) throws SQLException {
        this.executeStatementQuery(stmt, false, false, null);
    }

    @Override
    public void executeStatementQuery(Statement stmt, boolean withHold, boolean withReOptimization) throws SQLException {
        this.executeStatementQuery(stmt, withHold, withReOptimization, null);
    }

    @Override
    public void executeStatementQuery(Statement stmt, boolean withHold, boolean withReOptimization, ResultSetMetaData outputDesc) throws SQLException {
        this.resetTuples();
        this.doneCommit = false;
        if (!this.conn.lockSession()) {
            throw Messages.getSQLMinorException(-79748, -80033, this.conn);
        }
        if (!(stmt instanceof IfxPreparedStatement)) {
            try {
                this.sendPrepare((IfxStatement)stmt);
                this.receiveMessage();
                if (this.desc != null) {
                    this.desc.parseSetTableName(((IfxStatement)stmt).commandString);
                }
            }
            catch (SQLException e) {
                this.conn.unlockSession();
                throw e;
            }
            catch (Exception e) {
                this.conn.unlockSession();
                throw this.handleSocketException(e, this.conn);
            }
        }
        int outputNumber = 0;
        if (this.desc != null) {
            outputNumber = this.desc.getColumnCount();
        }
        if (this.statementType == 2 || this.statementType == 56 && outputNumber > 0) {
            try {
                if (!this.conn.autoCommit) {
                    this.initiateTransaction();
                }
                this.sendStatementQuery((IfxStatement)stmt, withHold, withReOptimization, (IfxResultSetMetaData)outputDesc);
            }
            catch (SQLException e) {
                this.conn.unlockSession();
                throw e;
            }
            catch (Exception e) {
                this.conn.unlockSession();
                throw this.handleSocketException(e, this.conn);
            }
        } else {
            this.conn.unlockSession();
            throw Messages.getSQLException(-79750, this.conn);
        }
        this.conn.unlockSession();
    }

    private void sendStatementQuery(IfxStatement stmt, boolean withHold, boolean withReOptimization, IfxResultSetMetaData outputDesc) throws SQLException {
        this.sendQuery(stmt, withHold, withReOptimization, outputDesc);
        if (stmt.getResultSetType() == 1003) {
            boolean useOptofc = stmt instanceof IfxPreparedStatement && this.conn.optofc && stmt.getStatementType() == 2;
            IfxResultSetMetaData fetchRsmd = null;
            if (stmt instanceof IfxPreparedStatement) {
                IfxPreparedStatement pstmt = (IfxPreparedStatement)stmt;
                fetchRsmd = (IfxResultSetMetaData)pstmt.getOutPutMetaData();
            }
            if (this.desc.hasVariableLengthColumns && !useOptofc) {
                this.receiveMessage();
            }
            if (fetchRsmd != null) {
                this.sendFetch(this.desc.hasVariableLengthColumns, fetchRsmd, stmt);
            } else if (useOptofc) {
                log.trace("OPTOFC enabled, skipping fetch phase");
            } else {
                this.sendFetch(this.desc.hasVariableLengthColumns, this.desc, stmt);
            }
            stmt.cursorOpen = true;
        }
        this.receiveMessage();
    }

    private void sendType(IfxResultSetMetaData outputDesc, short direction, boolean typeSentCheck) throws SQLException {
        if (typeSentCheck && this.typeSent) {
            return;
        }
        try {
            this.os.writeSmallInt((short)100);
            this.os.writeSmallInt(direction);
            this.os.writeSmallInt((short)this.desc.getColumnCount());
            log.trace(Trace.C_S_MARKER, "SQ_RET_TYPE Direction (1-FETCH, 0-PUT): {}, Count: {}", direction, this.desc.getColumnCount());
            for (int i = 1; i <= this.desc.getColumnCount(); ++i) {
                IfxResultSetMetaData md;
                if (outputDesc != null && outputDesc != this.desc && outputDesc.getColumnCount() >= i && outputDesc.getIfxColumnType(i) != 49) {
                    md = outputDesc;
                    this.desc.setIfxColumnType(i, outputDesc.getIfxColumnType(i));
                    this.desc.setExtendedName(i, outputDesc.getExtendedName(i));
                    this.desc.setColumnExtendedId(i, outputDesc.getColumnExtendedId(i));
                    this.desc.setEncodedLength(i, outputDesc.getEncodedLength(i));
                } else {
                    md = this.desc;
                }
                int sqltype = md.getIfxColumnType(i);
                boolean isVariableLength = md.isVariableLengthType(i);
                if (isVariableLength && sqltype != 13 && sqltype != 16) {
                    short xid = md.isDistinct(i) ? (short)md.getSourceType(i) : (short)md.getColumnExtendedId(i);
                    sqltype = xid == 3 ? 46 : (xid == 4 ? 47 : (xid == 1 ? 43 : (xid == 5 ? 45 : 44)));
                }
                if (log.isTraceEnabled()) {
                    log.trace(Trace.C_S_MARKER, "SQ_RET_TYPE\tSQLtype: {}, Length: {}", (short)sqltype, md.getEncodedLength(i));
                }
                this.os.writeSmallInt((short)sqltype);
                if (sqltype == 43) {
                    this.os.writeChar(this.os.getJavaToIfxChar(""));
                    this.os.writeChar(this.os.getJavaToIfxChar(""));
                } else if (isVariableLength && sqltype != 13 && sqltype != 16) {
                    log.trace(Trace.C_S_MARKER, "SQ_RET_TYPE\tName: {}.{}", md.getExtendedOwnerName(i), md.getExtendedName(i));
                    this.os.writeChar(this.os.getJavaToIfxChar(md.getExtendedOwnerName(i)));
                    this.os.writeChar(this.os.getJavaToIfxChar(md.getExtendedName(i)));
                }
                this.os.writeInt(md.getEncodedLength(i));
            }
            this.typeSent = true;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private void sendQuery(IfxStatement stmt, boolean withHold, boolean withReOptimization, IfxResultSetMetaData outputDesc) throws SQLException {
        try {
            IfxPreparedStatement pstmt;
            String cursorname = stmt.getCursorName();
            this.sendStatementID();
            log.trace(Trace.C_S_MARKER, "SQ_CURNAME: {}", (Object)cursorname);
            this.os.writeSmallInt((short)3);
            this.os.writeChar(stmt.getIfxEncodedCursorName());
            if (stmt instanceof IfxPreparedStatement && !(pstmt = (IfxPreparedStatement)stmt).usePut() && pstmt.inputvals > 0) {
                if (pstmt.inputvals == pstmt.numqmarks) {
                    this.sendBind(pstmt.getVector(), pstmt.inputParamMeta, pstmt.numqmarks, 0, pstmt.numqmarks);
                } else {
                    throw Messages.getSQLException(-79823, this.conn);
                }
            }
            this.SQ_CLOSERecvd = false;
            this.SQ_CLOSESent = false;
            this.first = true;
            if (stmt.getAutoFree()) {
                log.trace(Trace.C_S_MARKER, "SQ_AUTOFREE");
                this.os.writeSmallInt((short)108);
            }
            this.cursorType = stmt.getResultSetType();
            if (this.cursorType == 1004) {
                log.trace(Trace.C_S_MARKER, "SQ_SCROLL");
                this.os.writeSmallInt((short)24);
            }
            if (withHold && this.statementType != 56) {
                log.trace(Trace.C_S_MARKER, "SQ_HOLD");
                this.os.writeSmallInt((short)43);
            }
            if (withReOptimization) {
                log.trace(Trace.C_S_MARKER, "SQ_REOPTOPEN");
                this.os.writeSmallInt((short)87);
            } else {
                log.trace(Trace.C_S_MARKER, "SQ_OPEN");
                this.os.write(IfxMessageTypes.SQ_OPEN_BYTES);
            }
            if (this.conn.optofc && stmt instanceof IfxPreparedStatement && stmt.getStatementType() == 2 && this.cursorType == 1003 && stmt.getResultSetConcurrency() == 1007) {
                if (this.statementType != 0 && this.statementID != -1) {
                    this.os.write(IfxMessageTypes.SQ_ID_BYTES);
                    log.trace(Trace.C_S_MARKER, "SQ_ID: {}", (Object)this.statementID);
                    this.os.writeSmallInt(this.statementID);
                }
                if (this.desc.hasVariableLengthColumns) {
                    this.sendType(this.desc, (short)1, true);
                }
                log.trace(Trace.C_S_MARKER, "SQ_NFETCH");
                this.os.write(IfxMessageTypes.SQ_NFETCH_BYTES);
                int tupleBufferSize = this.getTupleBufferSize(stmt.getFetchBufferSize());
                log.trace(Trace.C_S_MARKER, "Tuple buffer size: {}", (Object)tupleBufferSize);
                this.os.writeInt(tupleBufferSize);
                log.trace(Trace.C_S_MARKER, "Fetch array size: 0");
                this.os.write(IfxMessageTypes.IFX_SHORT_ZERO);
                if (this.rowColumn == null) {
                    this.rowColumn = new IfxRowColumn(this.conn, this.desc, tupleBufferSize);
                } else if (this.desc != null) {
                    this.rowColumn.setMetaData(this.desc);
                }
                this.rowColumn.reset();
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        stmt.cursorOpen = true;
    }

    @Override
    public void executeOpenDatabase(String dbName, int flags) throws SQLException {
        if (dbName == null) {
            return;
        }
        log.debug("Connecting to database: {}", (Object)dbName);
        if (!this.conn.lockSession()) {
            throw Messages.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            log.trace(Trace.C_S_MARKER, "SQ_DBOPEN: {}", (Object)dbName);
            byte[] dbNameBytes = this.os.getJavaToIfxChar(dbName, this.dbEncoding);
            this.os.writeSmallInt((short)36);
            this.os.writeChar(dbNameBytes);
            this.os.writeSmallInt((short)flags);
            this.statementType = 1;
            this.receiveMessage();
        }
        catch (Exception e) {
            this.conn.unlockSession();
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
        this.callsetDatabaseOpen(dbName);
    }

    @Override
    public void executeClose(Statement stmt) throws SQLException {
        block10: {
            if (this.conn.isCommitNeeded() && !this.doneCommit) {
                this.executeCommit();
                this.doneCommit = true;
            }
            if (((IfxStatement)stmt).cursorOpen) {
                this.conn.lockSession();
                try {
                    ((IfxStatement)stmt).cursorOpen = false;
                    if (this.SQ_CLOSERecvd) break block10;
                    try {
                        this.sendClose();
                        this.receiveMessage();
                    }
                    catch (SQLException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw this.handleSocketException(e, this.conn);
                    }
                }
                finally {
                    this.conn.unlockSession();
                }
            }
        }
        if (((IfxStatement)stmt).getAutoFree()) {
            this.clearAll();
        } else {
            this.clear();
        }
    }

    @Override
    public void executeRelease(int id) throws SQLException {
        this.statementID = (short)id;
        this.conn.lockSession();
        try {
            if (this.statementID != -1) {
                this.sendRelease(null);
                this.receiveMessage();
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        finally {
            this.conn.unlockSession();
        }
    }

    @Override
    public void executeRelease(Statement stmt) throws SQLException {
        if (!this.conn.lockSession()) {
            throw Messages.getSQLMinorException(-79748, -80033, this.conn);
        }
        if (!((IfxStatement)stmt).getAutoFree() || this.conn.getAutoFree() && !this.SQ_CLOSERecvd && !this.SQ_CLOSESent || ((IfxStatement)stmt).getAutoFree() && !this.SQ_CLOSERecvd && !this.SQ_CLOSESent) {
            try {
                if (!this.isReleased && this.statementID != -1) {
                    this.sendRelease((IfxStatement)stmt);
                    this.statementID = (short)-1;
                    this.receiveMessage();
                }
            }
            catch (SQLException e) {
                this.conn.unlockSession();
                throw e;
            }
            catch (Exception e) {
                this.conn.unlockSession();
                throw this.handleSocketException(e, this.conn);
            }
        }
        this.conn.unlockSession();
        ((IfxStatement)stmt).cursorOpen = false;
        this.clearAll();
    }

    void executeFetch(Statement stmt) throws SQLException {
        this.resetTuples();
        this.conn.lockSession();
        try {
            this.sendFetch(false, this.desc, stmt);
            this.receiveMessage();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        finally {
            this.conn.unlockSession();
        }
    }

    private void sendFetch(boolean sendRetType, IfxResultSetMetaData desc, Statement stmt) throws SQLException {
        int tupleBufferSize = this.getTupleBufferSize(((IfmxStatement)stmt).getFetchBufferSize());
        ++this.numberOfFetches;
        try {
            this.sendStatementID();
            if (sendRetType) {
                this.sendType(desc, (short)1, stmt instanceof IfxPreparedStatement);
            }
            log.trace(Trace.C_S_MARKER, "SQ_NFETCH");
            this.os.write(IfxMessageTypes.SQ_NFETCH_BYTES);
            log.trace(Trace.C_S_MARKER, "Tuple buffer size: {}", (Object)tupleBufferSize);
            this.os.writeInt(tupleBufferSize);
            this.os.write(IfxMessageTypes.IFX_SHORT_ZERO);
            if (this.rowColumn == null) {
                this.rowColumn = new IfxRowColumn(this.conn, desc, tupleBufferSize);
            } else {
                this.rowColumn.setMetaData(desc);
            }
            this.rowColumn.reset();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private void sendClose() throws SQLException {
        log.debug("Closing SQLI Stmt ID #{}", this.statementID);
        try {
            this.sendStatementID();
            log.trace(Trace.C_S_MARKER, "SQ_CLOSE");
            this.os.write(IfxMessageTypes.SQ_CLOSE_BYTES);
            this.SQ_CLOSESent = true;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private void sendRelease(IfxStatement stmt) throws SQLException {
        log.debug("Releasing SQLI Stmt ID #{}", this.statementID);
        try {
            this.sendStatementID();
            log.trace(Trace.C_S_MARKER, "SQ_RELEASE");
            this.os.write(IfxMessageTypes.SQ_RELEASE_BYTES);
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    @Override
    public void executeCloseDatabase() throws SQLException {
        String dbName = this.conn.getConnectionDbName();
        if (dbName != null && dbName.length() != 0) {
            return;
        }
        try {
            this.conn.lockSession();
            this.os.writeSmallInt((short)37);
            this.receiveMessage();
            this.conn.databaseClosed();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        finally {
            this.conn.unlockSession();
        }
    }

    @Override
    public void executeExecute(Statement stmt, boolean holdable, boolean withReOptimization) throws SQLException {
        this.executeExecute(stmt, holdable, withReOptimization, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeExecute(Statement stmt, boolean holdable, boolean withReOptimization, ResultSetMetaData outputDesc) throws SQLException {
        this.resetTuples();
        this.doneCommit = false;
        this.conn.lockSession();
        try {
            if (!(stmt instanceof IfxPreparedStatement)) {
                this.sendPrepare((IfxStatement)stmt);
                this.receiveMessage();
                if (this.desc != null) {
                    this.desc.parseSetTableName(((IfxStatement)stmt).commandString);
                }
            }
            if (!this.conn.autoCommit) {
                this.initiateTransaction();
            }
            try {
                if (this.statementType == 2 || this.statementType == 56 && this.desc != null && this.desc.getColumnCount() > 0) {
                    this.sendStatementQuery((IfxStatement)stmt, holdable, withReOptimization, (IfxResultSetMetaData)outputDesc);
                } else {
                    this.sendStatementExecute((IfxStatement)stmt);
                }
            }
            catch (SQLException e) {
                if (this.TxStmt == 2 && this.sqlcode != -255) {
                    this.conn.setTxEndState();
                }
                throw e;
            }
        }
        finally {
            this.conn.unlockSession();
        }
        this.callsetDatabaseOpen(IfxSqli.getDbName(stmt));
        if (this.TxStmt == 1) {
            this.conn.setTxBeginState();
        } else if (this.TxStmt == 2) {
            this.conn.setTxEndState();
        } else if (this.conn.isCommitNeeded() && !this.isResultSet()) {
            this.executeCommit();
            this.doneCommit = true;
        }
    }

    public void receiveMessage() throws SQLException {
        short msg = 0;
        this.clearExceptions();
        try {
            this.flip();
            try {
                do {
                    if ((msg = this.is.readSmallInt()) == 56 && this.conn != null) {
                        this.conn.unlockSession();
                    }
                    if (this.dispatchMsg(msg)) continue;
                    break;
                } while (msg != 12 && msg != 56);
            }
            finally {
                if (this.sqliTrace != null) {
                    this.sqliTrace.recordS2C();
                }
            }
        }
        catch (SQLException e) {
            this.addException(e);
        }
        catch (Exception e) {
            this.addException(this.handleSocketException(e, this.conn));
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public boolean dispatchMsg(int msg) throws IOException, SQLException {
        boolean retval = true;
        switch (msg) {
            case 56: {
                log.trace(Trace.S_C_MARKER, "SQ_EXIT");
                this.sendExit();
                break;
            }
            case 8: {
                this.descTrue = true;
                this.receiveDescribe();
                break;
            }
            case 14: {
                this.receiveTuple();
                break;
            }
            case 25: {
                log.trace(Trace.S_C_MARKER, "SQ_TUPID");
                this.receiveTupleId();
                break;
            }
            case 15: {
                this.receiveDone();
                break;
            }
            case 39: {
                log.trace(Trace.S_C_MARKER, "SQ_BLOB");
                if (this.isText && this.convText) {
                    this.receiveText();
                    break;
                }
                this.receiveBlob();
                break;
            }
            case 97: {
                log.trace(Trace.S_C_MARKER, "SQ_LODATA");
                this.receiveLODATA();
                break;
            }
            case 13: {
                log.trace(Trace.S_C_MARKER, "SQ_ERR");
                this.receiveError();
                break;
            }
            case 55: {
                this.receiveCost();
                break;
            }
            case 94: {
                this.receiveInsertDone();
                break;
            }
            case 99: {
                log.trace(Trace.S_C_MARKER, "SQ_XACTSTAT");
                this.receiveXactstat();
                break;
            }
            case 10: {
                log.trace(Trace.S_C_MARKER, "SQ_CLOSE");
                this.SQ_CLOSERecvd = true;
                break;
            }
            case 81: {
                log.trace(Trace.S_C_MARKER, "SQ_INFO");
                this.receiveInfo();
                break;
            }
            case 53: {
                log.trace(Trace.S_C_MARKER, "SQ_VERSION");
                this.receiveVersion();
                break;
            }
            case 12: {
                log.trace(Trace.S_C_MARKER, "SQ_EOT");
                break;
            }
            case 101: {
                log.trace(Trace.S_C_MARKER, "SQ_GETROUTINE");
                this.receiveHandle();
                break;
            }
            case 103: {
                log.trace(Trace.S_C_MARKER, "SQ_FPROUTINE");
                this.receiveFastPath();
                break;
            }
            case 98: {
                log.trace(Trace.S_C_MARKER, "SQ_FILE");
                this.receiveSQFILE();
                break;
            }
            case 26: {
                log.trace(Trace.S_C_MARKER, "SQ_DBLIST");
                this.receiveDBList();
                break;
            }
            case 104: {
                log.trace(Trace.S_C_MARKER, "SQ_FPARAM");
                this.receiveFParam();
                break;
            }
            case 18: {
                log.trace(Trace.S_C_MARKER, "SQ_PUTERR");
                this.receivePutErr();
                break;
            }
            case 86: {
                log.warn(Trace.S_C_MARKER, "SQ_REASSOC");
                break;
            }
            case 125: {
                log.trace(Trace.S_C_MARKER, "SQ_IDESCRIBE");
                this.receiveIDescribe();
                break;
            }
            case 126: {
                log.trace(Trace.S_C_MARKER, "SQ_PROTOCOLS");
                this.receiveProtocols();
                break;
            }
            case 132: {
                log.trace(Trace.S_C_MARKER, "SQ_IFPDESCRIBE");
                this.receiveIFPDescribe();
                break;
            }
            case 135: {
                log.trace(Trace.S_C_MARKER, "SQ_SGKDESCRIBE");
                this.receiveSGKDescribe();
                break;
            }
            case 136: {
                log.trace(Trace.S_C_MARKER, "SQ_SGKTUPLE");
                this.receiveSGKTuple();
                break;
            }
            default: {
                log.error(Trace.S_C_MARKER, "Unknown message: {}", (Object)msg);
                this.setError(-408);
                retval = false;
            }
        }
        return retval;
    }

    protected void flip() throws SQLException {
        try {
            this.sendEOT();
            if (this.sqliTrace != null) {
                this.sqliTrace.recordC2S();
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private void sendEOT() throws IOException {
        log.trace(Trace.C_S_MARKER, "SQ_EOT");
        this.os.write(IfxMessageTypes.SQ_EOT_BYTES);
        this.os.flush();
        this.os.setByteCntAtEOT();
    }

    private void sendACK() throws IOException {
        log.trace(Trace.C_S_MARKER, "SQ_ACK");
        this.os.writeSmallInt((short)128);
    }

    private void receiveEOT() throws IOException {
        short msg = this.is.readSmallInt();
        if (log.isTraceEnabled()) {
            if (msg == 12) {
                log.trace(Trace.S_C_MARKER, "SQ_EOT");
            } else {
                log.error(Trace.S_C_MARKER, "Unexpected protocol message: {}", (Object)msg);
            }
        }
    }

    private void sendStatementID() throws IOException {
        log.trace(Trace.C_S_MARKER, "SQ_ID: {}", (Object)this.statementID);
        if (this.statementType == 0 && this.statementID == -1) {
            return;
        }
        this.os.write(IfxMessageTypes.SQ_ID_BYTES);
        this.os.writeSmallInt(this.statementID);
    }

    public void sendSQBatchStart() throws IOException {
        if (this.conn.isSQBatchSupported()) {
            log.trace(Trace.C_S_MARKER, "SQ_BATCHSTART");
            this.os.writeSmallInt((short)141);
        }
    }

    public void sendSQBatchEnd() throws IOException {
        if (this.conn.isSQBatchSupported()) {
            log.trace(Trace.C_S_MARKER, "SQ_BATCHEND");
            this.os.writeSmallInt((short)142);
        }
    }

    private void sendExit() throws SQLException {
        this.conn.unlockIfOwner();
        this.conn.close();
    }

    private void callsetDatabaseOpen(String dbname) throws SQLException {
        if (this.OpenDBStmt) {
            this.conn.setDbName(dbname);
            this.conn.setDatabaseOpen(this.OpenDBStmt, this.serverWarningsShort);
            this.dbEncoding = this.conn.getdbEncoding();
        }
    }

    private void setError(int errcode) throws SQLException {
        throw Messages.getSQLException(errcode, this.conn);
    }

    private void receiveDescribe() throws SQLException {
        short nfields = 0;
        int intVal = 0;
        String strtab = null;
        int ifxType = 0;
        int ifxExType = 0;
        int encLen = 0;
        int[] fieldIndex = null;
        try {
            this.statementType = this.is.readSmallInt();
            this.statementID = this.is.readSmallInt();
            log.debug("Stored SQLI Statement id #{}", this.statementID);
            intVal = this.is.readInt();
            this.setSQLerrd(3, intVal);
            int tupleSize = this.conn.isLargeTupleSize() ? this.is.readInt() : (int)this.is.readSmallInt();
            nfields = this.is.readSmallInt();
            if (nfields > 0) {
                this.desc = new IfxResultSetMetaData(nfields, this.conn);
                this.desc.setTupleSize(tupleSize);
                this.desc.setDelimIdent(this.conn.isDelimIdentSet());
            }
            int stringTableSize = this.is.readInt();
            this.TxStmt = 0;
            if (this.statementType == 34) {
                this.TxStmt = 1;
            } else if (this.statementType == 35 || this.statementType == 36) {
                this.TxStmt = (short)2;
            }
            log.trace(Trace.S_C_MARKER, "SQ_DESCRIBE Type: {} ID: {} Tuple Size: {} Fields: {}", this.statementType, this.statementID, tupleSize, nfields);
            if (nfields > 0) {
                fieldIndex = new int[nfields];
                for (short i = 1; i <= nfields; i = (short)(i + 1)) {
                    fieldIndex[i - 1] = this.is.readInt();
                    intVal = this.is.readInt();
                    this.desc.setColumnStartPosition(i, intVal);
                    short shortVal = this.is.readSmallInt();
                    this.desc.setIfxColumnType(i, shortVal);
                    ifxType = this.desc.getIfxColumnType(i);
                    intVal = this.is.readInt();
                    this.desc.setColumnExtendedId(i, intVal);
                    ifxExType = intVal;
                    String stringData = this.is.readChar(this.dbEncoding);
                    this.desc.setExtendedOwnerName(i, stringData);
                    stringData = this.is.readChar();
                    this.desc.setExtendedName(i, stringData);
                    shortVal = this.is.readSmallInt();
                    this.desc.setReference(i, shortVal);
                    shortVal = this.is.readSmallInt();
                    this.desc.setAlignment(i, shortVal);
                    intVal = this.is.readInt();
                    this.desc.setSourceType(i, intVal);
                    intVal = this.is.readInt();
                    this.desc.setEncodedLength(i, intVal);
                    encLen = intVal;
                    intVal = IfxTypes.IfxTypeToDecDigits(ifxType, ifxExType, encLen);
                    this.desc.setDecimalDigits(i, intVal);
                    intVal = IfxTypes.IfxTypeToRightDecimal(ifxType, ifxExType, encLen);
                    this.desc.setRightDecimal(i, intVal);
                }
                this.desc.setTextByteColumnCount();
            }
            if (stringTableSize > 0) {
                byte[] b = new byte[stringTableSize];
                this.is.readPadded(b);
                strtab = IfxToJavaType.IfxToJavaChar(b, this.dbEncoding, this.conn.encoption);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (strtab != null) {
            String colName = null;
            StringTokenizer itok = new StringTokenizer(strtab, "\u0000");
            for (short i = 0; i < nfields; i = (short)(i + 1)) {
                if (itok.hasMoreTokens()) {
                    colName = itok.nextToken();
                    this.desc.setColumnName(i + 1, colName);
                    continue;
                }
                this.desc.setColumnName(i + 1, null);
            }
        }
    }

    void setSQLerrd(int i, long val) {
        this.sqlerrd[i] = val;
    }

    private void receiveInsertDone() throws SQLException {
        try {
            this.serial8Inserted = this.is.readLongInt();
            if (this.conn.isBigintSupported()) {
                this.bigSerialInserted = this.is.readLongBigint();
            }
            log.trace(Trace.S_C_MARKER, "SQ_INSERTDONE Serial inserted: {}, Bigserial inserted: {}", this.serial8Inserted, this.bigSerialInserted);
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    @Override
    public long getBigSerialInserted() {
        return this.bigSerialInserted;
    }

    @Override
    public long getSerial8Inserted() {
        return this.serial8Inserted;
    }

    private void receiveDone() throws SQLException {
        this.OpenDBStmt = false;
        try {
            if (this.executeBatchInProgress && this.batchRowStatus == null) {
                this.batchRowStatus = new ArrayList();
            }
            if (this.statementType == 1 || this.statementType == 12 || this.statementType == 38) {
                this.OpenDBStmt = true;
            }
            if (this.statementType == 31) {
                this.conn.databaseClosed();
            }
            short warnings = this.is.readSmallInt();
            this.setWarnings(warnings, this.OpenDBStmt);
            long intVal = this.conn.isLongRowId() ? this.is.readLongBigint() : (long)this.is.readInt();
            if (this.executeBatchInProgress) {
                this.batchRowStatus.add(this.batchCount++, (int)intVal);
            }
            log.trace(Trace.S_C_MARKER, "SQ_DONE Rows: {}", (Object)intVal);
            this.setSQLerrd(2, intVal);
            intVal = this.conn.isLongRowId() ? this.is.readLongBigint() : (long)this.is.readInt();
            if (intVal == 0L && this.statementType == 2 && !this.descTrue) {
                this.SQLState = Messages.getSQLSTATE(100);
                this.message = Messages.getMessage(36007);
                this.addWarning(100, this.message);
            }
            log.trace(Trace.S_C_MARKER, "SQ_DONE RowId: {}", (Object)intVal);
            this.setSQLerrd(5, intVal);
            intVal = this.is.readInt();
            this.setSQLerrd(1, intVal);
            if (!this.OpenDBStmt && this.statementType == 31) {
                this.conn.setDatabaseOpen(this.OpenDBStmt, this.serverWarningsShort);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    @Override
    public long getEstimateNumberofRow() {
        return this.sqlerrd[0];
    }

    @Override
    public int getSerialInsert() {
        return (int)this.sqlerrd[1];
    }

    @Override
    public int getNumberOfRowsProcessed() {
        return (int)this.sqlerrd[2];
    }

    long getEstimatedCode() {
        return this.sqlerrd[3];
    }

    long getSQLStatementOffset() {
        return this.sqlerrd[4];
    }

    long getRowID() {
        return this.sqlerrd[5];
    }

    private void receiveCost() throws SQLException {
        try {
            int intVal = this.is.readInt();
            log.trace(Trace.S_C_MARKER, "SQ_COST Estimated Rows: {}", (Object)intVal);
            this.setSQLerrd(0, intVal);
            intVal = this.is.readInt();
            this.setSQLerrd(3, intVal);
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private void receiveXactstat() throws SQLException {
        try {
            this.xcEvent = this.is.readSmallInt();
            this.xcNewLevel = this.is.readSmallInt();
            this.xcOldLevel = this.is.readSmallInt();
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    int getXCEvent() {
        return this.xcEvent;
    }

    int getNewLevel() {
        return this.xcNewLevel;
    }

    int getOldLevel() {
        return this.xcOldLevel;
    }

    private void receiveTuple() throws SQLException {
        ++this.numberOfTuplesReceived;
        try {
            short warn = this.is.readSmallInt();
            if (warn > 0) {
                log.warn(Trace.S_C_MARKER, "Receive tuple warning: {}", warn);
            }
            if (this.totalTuplesInBuffer == 0) {
                this.offsetList.clear();
                this.offsetList.add(0);
            }
            int size = this.rowColumn.readTuple(this.is);
            this.totalTupleSize += size;
            this.tupleSizeReceived = Math.max(size, this.tupleSizeReceived);
            ++this.totalTuplesInBuffer;
            if (this.totalTuplesInBuffer < this.offsetList.size()) {
                this.offsetList.set(this.totalTuplesInBuffer, this.totalTupleSize);
            } else {
                this.offsetList.add(this.totalTupleSize);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    public void addException(SQLException e) {
        if (this.exception == null) {
            this.exception = e;
        } else {
            this.exception.setNextException(e);
        }
    }

    private void addException(int sqlcode, String sqlerrm, Object ... objects) {
        SQLException e = null;
        String isamMessage = "";
        if (sqlcode == -329) {
            this.addException(new SQLException(Messages.getErrorMessage(-329, this.conn.dbName), Messages.getSQLSTATE(sqlcode), sqlcode));
            return;
        }
        if (this.conn.appendIsam && this.isamcode != 0) {
            isamMessage = "(" + sqlcode + ") " + Messages.getMessage(this.isamcode) + "(" + this.isamcode + ")";
        }
        if (sqlcode == -9752 && this.conn.isNamedParametersSupported()) {
            String detailHandle = Messages.getMessage(sqlcode) + ":" + sqlerrm + isamMessage;
            e = new SQLException(detailHandle, Messages.getSQLSTATE(sqlcode), sqlcode);
        } else {
            e = sqlcode == -201 ? Messages.getSQLException(sqlcode, null, objects) : (Messages.getErrorMessage(sqlcode) == null ? new SQLException(sqlerrm, Messages.getSQLSTATE(sqlcode), sqlcode) : Messages.buildIsamException(sqlcode, isamMessage, sqlerrm, objects));
        }
        this.addException(e);
    }

    private void addException(String reason, String SQLState, int sqlcode) {
        String locale = this.conn.getclLocale();
        SQLException e = null;
        String isamMessage = "";
        if (this.conn.appendIsam && this.isamcode != 0) {
            isamMessage = "(" + sqlcode + ") " + Messages.getMessage(this.isamcode, locale) + "(" + this.isamcode + ")";
        }
        e = reason == null || reason.trim().isEmpty() ? (SQLState == null || SQLState.trim().isEmpty() ? new SQLException(Messages.getMessage(sqlcode, locale) + isamMessage, Messages.getSQLSTATE(sqlcode), sqlcode) : new SQLException(Messages.getMessage(sqlcode, locale) + isamMessage, SQLState, sqlcode)) : (SQLState == null || SQLState.trim().isEmpty() ? new SQLException(reason + isamMessage, "U0001", sqlcode) : new SQLException(reason + isamMessage, SQLState, sqlcode));
        this.addException(e);
    }

    public SQLException getExceptions() {
        return this.exception;
    }

    private void addWarning(int sqlcode, String message) {
        this.chainWarnings(new SQLWarning(message, Messages.getSQLSTATE(sqlcode), sqlcode));
    }

    private void addWarning(String message, String sqlstate) {
        this.chainWarnings(WarningMessages.getSQLWarning(sqlstate, message));
    }

    private void setWarnings(short w, boolean OpenDBStmt) {
        int set = 0;
        this.SQLState = null;
        if (this.conn.Noansiwarn) {
            w = (short)(w & 0xFFFFFFEF);
        }
        this.serverWarningsShort = w;
        if (w == 0) {
            return;
        }
        for (int i = 1; i <= 6; i = (int)((short)(i + 1))) {
            set = w & 1;
            if (set == 1) {
                switch (i) {
                    case 1: {
                        if (OpenDBStmt) {
                            this.addWarning(null, "01I01");
                            break;
                        }
                        this.addWarning(null, "01006");
                        break;
                    }
                    case 2: {
                        if (OpenDBStmt) {
                            this.addWarning(null, "01I03");
                            break;
                        }
                        this.addWarning(null, "01003");
                        break;
                    }
                    case 3: {
                        if (OpenDBStmt) {
                            this.addWarning(null, "01I04");
                            break;
                        }
                        this.addWarning(null, "01003");
                        break;
                    }
                    case 4: {
                        this.addWarning(null, "01I05");
                        break;
                    }
                    case 5: {
                        this.addWarning(null, "01I06");
                        break;
                    }
                    case 6: {
                        if (OpenDBStmt) {
                            this.addWarning(null, "01I10");
                            break;
                        }
                        this.addWarning(null, "01I11");
                    }
                }
            }
            w = (short)(w >> 1);
        }
    }

    @Override
    public void chainWarnings(SQLWarning cwarn) {
        if (this.warn == null) {
            this.warn = cwarn;
        } else if (this.warn.getSQLState() != cwarn.getSQLState()) {
            this.warn.setNextWarning(cwarn);
        }
    }

    @Override
    public void clearExceptions() {
        this.sqlcode = 0;
        this.isamcode = 0;
        this.SQLState = null;
        this.message = null;
        this.exception = null;
    }

    @Override
    public void clearWarnings() {
        this.SQLState = null;
        this.message = null;
        this.sqlcode = 0;
        this.isamcode = 0;
        this.warn = null;
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warn;
    }

    private void receivePutErr() throws SQLException {
        try {
            this.putErrRowCount = this.conn.isLongRowId() ? this.is.readLongBigint() : (long)this.is.readInt();
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        this.receiveError();
    }

    private void receiveError() throws SQLException {
        try {
            this.sqlcode = this.is.readSmallInt();
            if (this.sqlcode == -619) {
                this.gobbleSmallInts(2);
                if (this.conn.isRemove64KLimitSupported()) {
                    this.gobbleSmallInts(1);
                }
                this.is.readChar();
                log.warn(Trace.S_C_MARKER, "Error Code 619, resyncing data");
                this.addException(this.sqlcode, null, new Object[0]);
                return;
            }
            this.isamcode = this.is.readSmallInt();
            this.setSQLerrd(1, this.isamcode);
            int shortVal = this.conn.isRemove64KLimitSupported() ? this.is.readInt() : (int)this.is.readSmallInt();
            this.setSQLerrd(4, shortVal);
            this.conn.setSQLStatementOffset(shortVal);
            String sqlerrm = null;
            if (this.sqlcode != -368) {
                sqlerrm = this.is.readChar(this.dbEncoding).trim();
            }
            log.debug(Trace.S_C_MARKER, "Received SQLCode: {}, ISAM: {}, Statement Offset: {}, Message: {}", this.sqlcode, this.isamcode, shortVal, sqlerrm);
            if (this.sqlcode == 100) {
                this.SQLState = Messages.getSQLSTATE(this.sqlcode);
                this.message = Messages.getMessage(36007, this.conn.getclLocale());
                this.addWarning(this.sqlcode, this.message);
                if (this.conn.AnsiDb) {
                    this.setSQLerrd(2, 0L);
                    if (this.batchRowStatus == null) {
                        this.batchRowStatus = new ArrayList();
                    }
                }
            } else if (this.sqlcode != 0 && this.sqlcode != -937) {
                this.addException(this.sqlcode, sqlerrm, this.conn.getSQLStatementOffset());
                if (this.isamcode != 0) {
                    this.exception.initCause(Messages.getSQLException(this.isamcode));
                }
            } else {
                byte[] b = new byte[5];
                this.is.readPadded(b);
                this.SQLState = IfxToJavaType.IfxToJavaChar(b, this.conn.encoption);
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\tSQLState: ", this.SQLState);
                }
                this.message = this.is.readChar(this.dbEncoding);
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\tMI message:", this.message);
                }
                if (this.sqlcode == 0) {
                    this.isamcode = 0;
                    this.addWarning(this.message, this.SQLState);
                } else {
                    this.addException(this.message, this.SQLState, this.sqlcode);
                    if (this.isamcode != 0) {
                        this.addException(this.isamcode, null, new Object[0]);
                    }
                }
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (IOException ie) {
            this.addException(-80507, null, new Object[0]);
        }
        catch (Exception ee) {
            this.addException(-79716, null, new Object[0]);
        }
    }

    public int getSQLCode() {
        return this.sqlcode;
    }

    String getSQLState() {
        return this.SQLState;
    }

    String getMessage() {
        return this.message;
    }

    private void receiveTupleId() throws SQLException {
        try {
            this.Tupid = this.is.readInt();
            if (this.getTupleCount() > 0) {
                this.firstTuple = this.Tupid;
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\tTuple ID: ", this.firstTuple);
                }
                this.lastTuple = this.firstTuple + this.getTupleCount() - 1;
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    void executeInfo(short regflag) throws SQLException {
        if (!this.conn.lockSession()) {
            throw Messages.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendInfo(regflag);
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
    }

    private void sendInfo(short regflag) throws SQLException {
        try {
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "C->S");
                this.protoTrace.writeTrace(logger, 1, "\tSQ_INFO ", (short)81);
            }
            this.os.writeSmallInt((short)81);
            if (regflag != 0) {
                this.os.writeSmallInt((short)1);
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\tINFO_REQUEST");
                }
                this.os.writeSmallInt((short)0);
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\t\tData: ", (short)0);
                }
            }
            this.os.writeSmallInt((short)0);
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tINFO_DONE");
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private void receiveInfo() throws SQLException {
        try {
            short message;
            block8: while ((message = this.is.readSmallInt()) > 0) {
                int length = this.is.readSmallInt();
                switch (message) {
                    case 2: {
                        if (log.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\tINFO_VERSION");
                            this.protoTrace.writeTrace(logger, 2, "\t\t\tLength: ", length);
                        }
                        if (length < 4) {
                            this.setError(-408);
                            continue block8;
                        }
                        length -= 4;
                        continue block8;
                    }
                    case 3: {
                        int intVal;
                        if (log.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\tINFO_TYPE");
                        }
                        int TypeList = 0;
                        for (int i = 0; i < length / 4; ++i) {
                            intVal = this.is.readInt();
                            if (log.isTraceEnabled()) {
                                this.protoTrace.writeTrace(logger, 2, "\t\t\tData:  ", intVal);
                            }
                            TypeList |= intVal;
                        }
                        this.conn.setTypeList(TypeList);
                        continue block8;
                    }
                    case 4: {
                        int intVal;
                        if (log.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\tINFO_CAPABILITY");
                        }
                        int CapList = 0;
                        for (int i = 0; i < length / 4; ++i) {
                            intVal = this.is.readInt();
                            if (log.isTraceEnabled()) {
                                this.protoTrace.writeTrace(logger, 2, "\t\t\tData:  ", intVal);
                            }
                            CapList |= intVal;
                        }
                        this.conn.setCapList(CapList);
                        continue block8;
                    }
                }
                this.gobbleChars(length);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    @Override
    public void executeEnv(Properties EnvVars) throws SQLException {
        if (!this.conn.lockSession()) {
            throw Messages.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendEnv(EnvVars);
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
    }

    private void sendEnv(Properties EnvVars) throws SQLException {
        short totLen = 0;
        short nameLen = 0;
        short valueLen = 0;
        short LongNameLen = 0;
        short LongValueLen = 0;
        String name = null;
        String value = null;
        int len = 0;
        IfxDataOutputStream os = this.conn.Ifxproto_send();
        totLen = 4;
        Enumeration<?> e = EnvVars.propertyNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value = EnvVars.getProperty(name);
            nameLen = (short)name.length();
            valueLen = (short)value.length();
            len = nameLen & 1;
            if (len == 1) {
                nameLen = (short)(nameLen + 1);
            }
            if ((len = valueLen & 1) == 1) {
                valueLen = (short)(valueLen + 1);
            }
            totLen = (short)(totLen + (nameLen + valueLen + 4));
            if (nameLen > LongNameLen) {
                LongNameLen = nameLen;
            }
            if (valueLen <= LongValueLen) continue;
            LongValueLen = valueLen;
        }
        totLen = (short)(totLen + 2);
        try {
            os.writeSmallInt((short)81);
            os.writeSmallInt((short)6);
            os.writeSmallInt(totLen);
            os.writeSmallInt(LongNameLen);
            os.writeSmallInt(LongValueLen);
            log.trace(Trace.C_S_MARKER, "SQ_INFO: {}", (Object)EnvVars);
            e = EnvVars.propertyNames();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                value = EnvVars.getProperty(name);
                byte[] nameBytes = null;
                byte[] valueBytes = null;
                try {
                    nameBytes = os.getJavaToIfxChar(name, this.dbEncoding);
                    valueBytes = os.getJavaToIfxChar(value, this.dbEncoding);
                }
                catch (Exception ex) {
                    os.writeSmallInt((short)0);
                    os.writeSmallInt((short)0);
                    throw ex;
                }
                os.writeChar(nameBytes);
                os.writeChar(valueBytes);
            }
            os.writeSmallInt((short)0);
            os.writeSmallInt((short)0);
        }
        catch (SQLException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw this.handleSocketException(e3, this.conn);
        }
    }

    private void gobbleChars(int length) throws SQLException {
        try {
            byte[] b = new byte[length];
            this.is.readPadded(b);
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private void gobbleSmallInts(int number) throws SQLException {
        try {
            for (int i = 0; i < number; ++i) {
                this.is.readSmallInt();
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    @Override
    public void executeVersion() throws SQLException {
        try {
            this.conn.lockSession();
            this.sendVersion();
            this.receiveMessage();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        finally {
            this.conn.unlockSession();
        }
    }

    private void sendVersion() throws IOException {
        log.trace(Trace.C_S_MARKER, "SQ_VERSION");
        this.os.writeSmallInt((short)53);
    }

    private void receiveVersion() throws IOException, SQLException {
        this.serverVersion = this.is.readChar();
        log.trace(Trace.S_C_MARKER, "Server Version: {}", (Object)this.serverVersion);
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    int getTupleBufferSize(int fetchBufferSize) {
        if (fetchBufferSize > 0) {
            return Math.min(fetchBufferSize, this.conn.getMaxFetchBufSize());
        }
        if (this.tupleBufferSize != -1) {
            return this.tupleBufferSize;
        }
        this.tupleBufferSize = this.desc.getTupleSize() <= 2048 ? 4096 : (this.desc.getTupleSize() <= 4096 ? 8192 : this.desc.getTupleSize());
        if (this.conn.fetchBufSize > this.tupleBufferSize) {
            this.tupleBufferSize = this.conn.getCorrectedFetchBufSize();
        }
        return this.tupleBufferSize;
    }

    @Override
    public boolean isResultSet() throws SQLException {
        int outputNumber = 0;
        if (this.desc != null) {
            outputNumber = this.desc.getColumnCount();
        }
        return this.statementType == 2 || this.statementType == 56 && outputNumber > 0;
    }

    @Override
    public int getTupleCount() {
        return this.totalTuplesInBuffer;
    }

    @Override
    public boolean getaRow(int direction, int count, int scrolltype, boolean isscrollcurs, Statement stmt) throws SQLException {
        if (direction != 1000 && count != 1) {
            throw Messages.getSQLException(-79751, this.conn);
        }
        if (stmt.getResultSetType() == 1003) {
            this.conn.closeFinalizedBlobsOnServer();
        }
        if (isscrollcurs && (scrolltype == 6 || scrolltype == 1)) {
            if (this.getTupleCount() != 0) {
                this.repositionIfInTupleBuffer(count);
            }
            if (count == 0) {
                this.curRow = -1;
                return false;
            }
        }
        int tcount = this.getTupleCount() - (this.curRow + 1);
        if (isscrollcurs) {
            if (!this.SQ_CLOSERecvd && (this.getNumberOfTuplesReceived() != 0 || this.first) && (tcount == 0 || scrolltype != 1 && scrolltype != 6)) {
                IfxResultSet currentRS = ((IfxStatement)stmt).currentResult;
                int fetchBufferSize = 0;
                if (currentRS.getFetchSize() != 0) {
                    fetchBufferSize = currentRS.calculateFetchBufferSize();
                }
                if (fetchBufferSize != 0) {
                    fetchBufferSize = Math.min(fetchBufferSize, this.conn.getMaxFetchBufSize());
                }
                this.executeScrollFetch(scrolltype, count, stmt, fetchBufferSize);
                tcount = this.getTupleCount() - (this.curRow + 1);
            }
        } else {
            if (!this.SQ_CLOSERecvd && !this.first) {
                return false;
            }
            if (!this.SQ_CLOSERecvd && this.first && tcount == 0 && this.sqlerrd[2] == 0L) {
                this.executeFetch(stmt);
                ((IfxStatement)stmt).cursorOpen = true;
                tcount = this.getTupleCount() - (this.curRow + 1);
            }
        }
        if (tcount == 0) {
            if (!isscrollcurs && this.conn.isCommitNeeded() && !this.doneCommit) {
                this.executeCommit();
                this.doneCommit = true;
            }
            this.first = false;
            return false;
        }
        ++this.curRow;
        if (isscrollcurs && count != this.getTupid() && (scrolltype == 6 || scrolltype == 1)) {
            throw Messages.getSQLException(-79716, this.conn);
        }
        this.rowColumn.setOffsetInTuple(this.offsetList.get(this.curRow));
        return true;
    }

    @Override
    public int getTupleSize() throws SQLException {
        return this.desc.getTupleSize();
    }

    private void repositionIfInTupleBuffer(int rowId) {
        this.curRow = rowId >= this.firstTuple && rowId <= this.lastTuple ? rowId - this.firstTuple - 1 : this.totalTuplesInBuffer - 1;
    }

    @Override
    public IfxObject getColumnInRow(int colIndex) throws SQLException {
        if (this.rowColumn == null) {
            throw Messages.getSQLException(-79739, this.conn);
        }
        return this.rowColumn.getColumn(colIndex, null);
    }

    IfxObject getColumnInRow(int colIndex, Calendar cal) throws SQLException {
        if (this.rowColumn == null) {
            throw Messages.getSQLException(-79739, this.conn);
        }
        return this.rowColumn.getColumn(colIndex, cal);
    }

    @Override
    public void loadColumnData(int colIndex, IfxObject val) throws SQLException {
        if (this.rowColumn == null) {
            throw Messages.getSQLException(-79739, this.conn);
        }
        this.rowColumn.loadColumnData(colIndex, val);
    }

    private void sendBlob(List<IfxObject> vector, int count, int si, int inputvals) throws SQLException {
        try {
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "C->S");
                this.protoTrace.writeTrace(logger, 1, "\tSQ_BBIND");
            }
            this.os.writeSmallInt((short)41);
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\t\t# of blobs: ", count);
            }
            this.os.writeSmallInt((short)count);
            this.os.flush();
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        for (int i = 0; i < inputvals; ++i) {
            this.isText = false;
            IfxObject ival = vector.get(si + i);
            short type = (short)ival.getIfxType();
            if (type == 12) {
                this.isText = true;
            }
            if (!(ival.isNull() || type != 11 && type != 12)) {
                IfxBlob BlobObject = (IfxBlob)ival;
                if (type == 11 || this.isText && !this.convText) {
                    if (BlobObject.isBlobByteType()) {
                        this.sendBytesBlob(this.os, BlobObject.getBlobBuffer());
                    } else {
                        this.sendStreamBlob(this.os, BlobObject.getBlobInputStream(), BlobObject.getBlobLength());
                    }
                } else if (BlobObject.isBlobByteType()) {
                    this.convTextBlobBuffer(BlobObject);
                    this.sendBytesBlob(this.os, BlobObject.getBlobBuffer());
                } else {
                    this.convTextBlobStream(BlobObject);
                    this.sendStreamBlob(this.os, BlobObject.getBlobInputStream(), BlobObject.getBlobLength());
                }
            }
            this.isText = false;
        }
        this.isText = false;
    }

    private void convTextBlobStream(IfxBlob blobObj) throws SQLException {
        InputStream in = null;
        OutputStream out = null;
        IfxTmpFile tempBlobFile = null;
        String from = this.conn.getclEncoding();
        String to = this.conn.getdbEncoding();
        try {
            int len;
            if (blobObj.getBlobLength() <= this.conn.getCodesetLobSize()) {
                in = blobObj.getBlobInputStream();
                out = new ByteArrayOutputStream();
            } else {
                in = blobObj.getBlobInputStream();
                tempBlobFile = new IfxTmpFile(this.conn);
                out = tempBlobFile.getOutputStream();
            }
            BufferedReader r = new BufferedReader(new InputStreamReader(in, from));
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter(out, to));
            char[] buffer = new char[4096];
            while ((len = r.read(buffer)) != -1) {
                ((Writer)w).write(buffer, 0, len);
            }
            ((Reader)r).close();
            ((Writer)w).flush();
            ((Writer)w).close();
            in.close();
            if (tempBlobFile == null) {
                IfxByteArrayInputStream fin = new IfxByteArrayInputStream((ByteArrayOutputStream)out);
                blobObj.fromInputStream((InputStream)fin, ((ByteArrayOutputStream)out).size());
            } else {
                out.close();
                int fileLength = tempBlobFile.length();
                blobObj.fromInputStream(tempBlobFile.getInputStream(), fileLength);
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private void convTextBlobBuffer(IfxBlob blobObj) throws SQLException {
        IfxByteArrayInputStream in = null;
        OutputStream out = null;
        IfxTmpFile tempBlobFile = null;
        String from = this.conn.getclEncoding();
        String to = this.conn.getdbEncoding();
        try {
            int len;
            in = new IfxByteArrayInputStream(blobObj.getBlobBuffer());
            if (blobObj.getBlobLength() <= this.conn.getCodesetLobSize()) {
                out = new ByteArrayOutputStream();
            } else {
                tempBlobFile = new IfxTmpFile(this.conn);
                out = tempBlobFile.getOutputStream();
            }
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)in, from));
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter(out, to));
            char[] buffer = new char[4096];
            while ((len = r.read(buffer)) != -1) {
                ((Writer)w).write(buffer, 0, len);
            }
            ((Reader)r).close();
            ((Writer)w).flush();
            ((Writer)w).close();
            ((InputStream)in).close();
            blobObj.blobBuffer = null;
            if (tempBlobFile == null) {
                blobObj.setBlobBuffer(((ByteArrayOutputStream)out).toByteArray());
            } else {
                out.close();
                InputStream fin = tempBlobFile.getInputStream();
                int fileLength = tempBlobFile.length();
                byte[] buf = new byte[fileLength];
                fin.read(buf, 0, fileLength);
                blobObj.setBlobBuffer(buf);
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private void sendBytesBlob(IfxDataOutputStream os, byte[] buffer) throws SQLException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(buffer);){
            this.sendStreamBlob(os, is, buffer.length);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendStreamBlob(IfxDataOutputStream os, InputStream fd, int length) throws SQLException {
        byte[] buffer = new byte[1024];
        int readBufferSize = length == -1 ? 1024 : (length < 1024 ? length : 1024);
        int readLength = 0;
        if (log.isTraceEnabled()) {
            this.protoTrace.writeTrace(logger, 1, "");
            this.protoTrace.writeTrace(logger, 1, "C->S");
        }
        int readLimit = length == -1 ? Integer.MAX_VALUE : length;
        try {
            while ((readLength = fd.read(buffer, 0, readBufferSize)) > 0) {
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_BLOB");
                    this.protoTrace.writeTrace(logger, 2, "\t\tSize: ", readLength);
                }
                os.writeSmallInt((short)39);
                os.writeSmallInt((short)readLength);
                os.writePadded(buffer, 0, readLength);
                if ((readLimit -= readLength) >= readBufferSize) continue;
                readBufferSize = readLimit;
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        try {
            os.flush();
            fd.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\tSQ_BLOB");
            }
            os.writeSmallInt((short)39);
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tSize: ", 0);
            }
            os.writeSmallInt((short)0);
        }
        catch (Exception e) {
            try {
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_FERR");
                }
                os.writeSmallInt((short)40);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.receiveMessage();
            }
            catch (SQLException ee) {
                if (this.TxStmt == 2 && this.sqlcode != -255) {
                    this.conn.setTxEndState();
                }
                e.addSuppressed(ee);
                throw Messages.getSQLException((Throwable)e, -79752, (IfxConnection)this.conn);
            }
        }
    }

    @Override
    public void executeFetchBlob(IfxObject blobDesc) throws SQLException {
        int bufferSize = this.convText ? this.conn.getCodesetLobSize() : this.conn.getBlobCacheSize();
        this.BlobFd = null;
        this.BlobBuffer = null;
        this.BlobWriteFailure = 0;
        this.BlobWriteOffset = 0;
        this.BufferOrStream = 0;
        IfxBlob blobInfo = (IfxBlob)blobDesc;
        int blobLength = blobInfo.getBlobLength();
        short type = (short)blobDesc.getIfxType();
        this.isText = type == 12;
        if (bufferSize < 0 || bufferSize > 0 && blobLength <= bufferSize) {
            try {
                this.BlobBuffer = new byte[blobLength];
            }
            catch (Exception e) {
                throw Messages.getSQLException((Throwable)e, -79753, (IfxConnection)this.conn);
            }
            blobInfo.setBlobBuffer(this.BlobBuffer);
            blobInfo.setBlobFileName();
            this.BufferOrStream = 0;
        } else {
            blobInfo.tempBlobFile = new IfxTmpFile(this.conn);
            try {
                this.BlobFd = blobInfo.tempBlobFile.getOutputStream();
                this.BlobBuffer = null;
                this.BufferOrStream = 1;
            }
            catch (Exception e) {
                if (bufferSize == 0) {
                    throw Messages.getSQLException(-79774, this.conn);
                }
                this.BlobBuffer = new byte[blobLength];
                blobInfo.setBlobBuffer(this.BlobBuffer);
                blobInfo.setBlobFileName();
                this.BufferOrStream = 0;
            }
        }
        this.conn.lockSession();
        try {
            this.sendFetchBlob((IfxBlob)blobDesc);
            this.receiveMessage();
        }
        catch (SQLException e) {
            try {
                if (this.BlobFd != null) {
                    this.BlobFd.close();
                }
            }
            catch (IOException i) {
                this.isText = false;
            }
            throw e;
        }
        catch (Exception e) {
            try {
                this.BlobFd.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.isText = false;
            throw this.handleSocketException(e, this.conn);
        }
        finally {
            this.conn.unlockSession();
        }
        if (this.BlobFd != null) {
            try {
                this.BlobFd.close();
            }
            catch (IOException e) {
                this.isText = false;
                throw this.handleSocketException(e, this.conn);
            }
        }
        if (this.BlobWriteFailure == 1) {
            this.isText = false;
            throw Messages.getSQLException(-79754, this.conn);
        }
        if (this.isText && this.convText) {
            this.fetchCodesetConvertedTextBlob(blobInfo);
        }
        this.isText = false;
    }

    private void fetchCodesetConvertedTextBlob(IfxBlob blobInfo) throws SQLException {
        InputStream in = null;
        OutputStream out = null;
        String from = this.conn.getdbEncoding();
        String to = this.conn.getclEncoding();
        try {
            int len;
            if (blobInfo.getBlobLength() <= this.conn.getCodesetLobSize()) {
                in = new IfxByteArrayInputStream(blobInfo.blobBuffer);
                out = new ByteArrayOutputStream();
            } else {
                IfxTmpFile infile = blobInfo.tempBlobFile;
                in = infile.getInputStream();
                blobInfo.tempBlobFile = new IfxTmpFile(this.conn);
                out = blobInfo.tempBlobFile.getOutputStream();
            }
            BufferedReader r = new BufferedReader(new InputStreamReader(in, from));
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter(out, to));
            char[] buffer = new char[4096];
            while ((len = r.read(buffer)) != -1) {
                ((Writer)w).write(buffer, 0, len);
            }
            ((Reader)r).close();
            ((Writer)w).flush();
            ((Writer)w).close();
            if (blobInfo.getBlobLength() > this.conn.getCodesetLobSize()) {
                out.close();
            } else {
                this.BlobBuffer = ((ByteArrayOutputStream)out).toByteArray();
                blobInfo.setBlobBuffer(this.BlobBuffer);
            }
            in.close();
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void sendFetchBlob(IfxBlob blobDesc) throws SQLException {
        try {
            this.sendStatementID();
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\tSQ_FETCHBLOB");
            }
            this.os.writeSmallInt((short)38);
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        try {
            this.os.writePadded(blobDesc.toIfx());
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private void receiveText() throws SQLException {
        int strtab;
        short datalen;
        byte[] blobBuffer = null;
        try {
            datalen = this.is.readSmallInt();
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tSize: ", (int)datalen);
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        try {
            blobBuffer = new byte[datalen];
            strtab = this.is.readPadded(blobBuffer);
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (this.BlobWriteFailure == 0) {
            try {
                this.blobDataWrite(blobBuffer, this.BlobWriteOffset, strtab);
                this.BlobWriteOffset += strtab;
            }
            catch (Exception e) {
                this.BlobWriteFailure = 1;
            }
        }
        if (strtab < datalen) {
            int remaining = 0;
            while (strtab < datalen) {
                try {
                    blobBuffer = new byte[datalen - strtab];
                    remaining = this.is.readPadded(blobBuffer);
                }
                catch (Exception e) {
                    throw this.handleSocketException(e, this.conn);
                }
                if (this.BlobWriteFailure == 0) {
                    try {
                        this.blobDataWrite(blobBuffer, this.BlobWriteOffset, remaining);
                        this.BlobWriteOffset += remaining;
                    }
                    catch (Exception e) {
                        this.BlobWriteFailure = 1;
                    }
                }
                strtab += remaining;
            }
        }
    }

    private void receiveBlob() throws SQLException {
        int strtab;
        short datalen;
        byte[] blobBuffer = null;
        try {
            datalen = this.is.readSmallInt();
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tSize: ", (int)datalen);
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        try {
            blobBuffer = new byte[datalen];
            strtab = this.is.readPadded(blobBuffer);
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (this.BlobWriteFailure == 0) {
            try {
                this.blobDataWrite(blobBuffer, this.BlobWriteOffset, strtab);
                this.BlobWriteOffset += strtab;
            }
            catch (Exception e) {
                this.BlobWriteFailure = 1;
            }
        }
        if (strtab < datalen) {
            int remaining = 0;
            while (strtab < datalen) {
                try {
                    blobBuffer = new byte[datalen - strtab];
                    remaining = this.is.readPadded(blobBuffer);
                }
                catch (Exception e) {
                    throw this.handleSocketException(e, this.conn);
                }
                if (this.BlobWriteFailure == 0) {
                    try {
                        this.blobDataWrite(blobBuffer, this.BlobWriteOffset, remaining);
                        this.BlobWriteOffset += remaining;
                    }
                    catch (Exception e) {
                        this.BlobWriteFailure = 1;
                    }
                }
                strtab += remaining;
            }
        }
    }

    private int blobDataWrite(byte[] buffer, int BlobWriteOffset, int length) {
        if (this.BufferOrStream == 1) {
            try {
                this.BlobFd.write(buffer, 0, length);
            }
            catch (Exception e) {
                return 1;
            }
        } else if (length > 0) {
            System.arraycopy(buffer, 0, this.BlobBuffer, BlobWriteOffset, length);
        }
        return 0;
    }

    public void executeScrollFetch(int scrolltype, int index, Statement stmt, int fetchBufferSize) throws SQLException {
        ++this.numberOfFetches;
        this.resetTuples();
        if (!this.conn.lockSession()) {
            throw Messages.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            IfxResultSetMetaData fetchRsmd = null;
            if (stmt != null && stmt instanceof IfxPreparedStatement) {
                IfxPreparedStatement pstmt = (IfxPreparedStatement)stmt;
                fetchRsmd = (IfxResultSetMetaData)pstmt.getOutPutMetaData();
            }
            boolean isPrepStmt = stmt instanceof IfxPreparedStatement;
            if (fetchRsmd != null) {
                this.sendScrollFetch(scrolltype, index, fetchRsmd, fetchBufferSize, isPrepStmt);
            } else {
                this.sendScrollFetch(scrolltype, index, this.desc, fetchBufferSize, isPrepStmt);
            }
            ((IfxStatement)stmt).cursorOpen = true;
            this.receiveMessage();
        }
        catch (SQLException e) {
            ((IfxStatement)stmt).cursorOpen = false;
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        int i = this.tupleSizeReceived;
        this.conn.unlockSession();
        ((IfxStatement)stmt).currentResult.setTupleSizeReceived(i);
    }

    private void sendScrollFetch(int scrolltype, int index, IfxResultSetMetaData desc, int fetchBufferSize, boolean isPreparedStatement) throws SQLException {
        int sendBufferSize = 0;
        sendBufferSize = fetchBufferSize != 0 ? fetchBufferSize : (this.tupleBufferSize = this.getTupleBufferSize(-1));
        try {
            this.sendStatementID();
            if (desc.hasVariableLengthColumns) {
                this.sendType(desc, (short)1, isPreparedStatement);
            }
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\tSQ_SFETCH");
            }
            this.os.writeSmallInt((short)23);
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tDirection: ", scrolltype);
            }
            this.os.writeSmallInt((short)scrolltype);
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tOffset: ", index);
            }
            this.os.writeInt(index);
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tTuple Buffer Size: ", sendBufferSize);
            }
            this.os.writeInt(sendBufferSize);
            if (this.rowColumn == null) {
                this.rowColumn = new IfxRowColumn(this.conn, desc, sendBufferSize);
            } else {
                this.rowColumn.setMetaData(desc);
            }
            this.rowColumn.reset();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    @Override
    public int getTupid() throws SQLException {
        return this.Tupid + this.curRow;
    }

    public InputStream toClobStream(IfxSmBlob obj) throws SQLException {
        InputStream fd = null;
        String from = this.conn.getdbEncoding();
        String to = this.conn.getclEncoding();
        InputStream in = null;
        OutputStream out = null;
        IfxTmpFile tempClobFile = null;
        try {
            int len;
            IfxLobInputStream lobStream = (IfxLobInputStream)obj.toAsciiStream();
            int size = (int)lobStream.getSize();
            int codesetSize = this.conn.getCodesetLobSize();
            if (size <= codesetSize) {
                try {
                    byte[] blobBuffer = new byte[size];
                    lobStream.read(blobBuffer);
                    in = new ByteArrayInputStream(blobBuffer);
                    out = new ByteArrayOutputStream();
                }
                catch (Exception e) {
                    throw Messages.getSQLException((Throwable)e, -79753, (IfxConnection)this.conn);
                }
            }
            try {
                in = lobStream.getStream();
                tempClobFile = new IfxTmpFile(this.conn);
                out = tempClobFile.getOutputStream();
            }
            catch (Exception e) {
                throw this.handleSocketException(e, this.conn);
            }
            BufferedReader r = new BufferedReader(new InputStreamReader(in, from));
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter(out, to));
            char[] buffer = new char[4096];
            while ((len = r.read(buffer)) != -1) {
                ((Writer)w).write(buffer, 0, len);
            }
            ((Reader)r).close();
            ((Writer)w).flush();
            ((Writer)w).close();
            in.close();
            if (size <= codesetSize) {
                fd = new IfxByteArrayInputStream((ByteArrayOutputStream)out);
            } else {
                out.close();
                fd = tempClobFile.getInputStream();
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        return fd;
    }

    @Override
    public Vector<IfxObject> executeFastPath(String signature, Vector<IfxObject> inParams, boolean request_fparam) throws SQLException {
        this.executeFastPath(signature, null, inParams, false, request_fparam);
        return this.fpRet;
    }

    @Override
    public void executeFastPath(String signature, Vector<IfxObject> inParams, boolean hasOutParameter, boolean request_fparam) throws SQLException {
        this.executeFastPath(signature, null, inParams, hasOutParameter, request_fparam);
    }

    public void executeFastPath(String signature, ResultSetMetaData pmd, Vector<IfxObject> inParams, boolean hasOutParameter, boolean request_fparam) throws SQLException {
        log.trace("Fastpath execution for: {}", (Object)signature);
        this.fpRet = null;
        if (this.fpInput != null) {
            this.fpInput.removeAllElements();
            this.fpInput = null;
        }
        if (signature == null) {
            return;
        }
        if (!this.conn.lockSession()) {
            throw Messages.getSQLMinorException(-79748, -80033, this.conn);
        }
        if (!this.conn.autoCommit) {
            try {
                this.initiateTransaction();
            }
            catch (SQLException e) {
                this.conn.unlockSession();
                throw e;
            }
        }
        short xcNewLevelSave = this.xcNewLevel;
        try {
            this.getHandle(signature, request_fparam, hasOutParameter);
            this.checkFastPathExp(inParams, pmd);
            this.sendFastPath(this.fpHandle, pmd, inParams, request_fparam);
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            if (this.conn.isCommitNeeded() && xcNewLevelSave < 1 && this.xcNewLevel == 1) {
                this.executeCommit();
                this.doneCommit = true;
            }
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            if (this.conn.isCommitNeeded() && xcNewLevelSave < 1 && this.xcNewLevel == 1) {
                this.executeCommit();
                this.doneCommit = true;
            }
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
        if (this.conn.isCommitNeeded() && xcNewLevelSave < 1 && this.xcNewLevel == 1) {
            this.executeCommit();
            this.doneCommit = true;
        }
        log.trace("Fastpath execution completed");
    }

    @Override
    public Vector<IfxObject> getFPReturnVector() {
        return this.fpRet;
    }

    private void getHandle(String signature, boolean request_fparam, boolean hasOutParameter) throws SQLException {
        this.fpHandle = this.conn.getFPCacheRoutineId(signature);
        if (this.fpHandle != -1) {
            this.fparam = request_fparam ? this.conn.getFPCacheFParam(signature) : null;
        } else {
            try {
                this.partialFParam = false;
                if (request_fparam) {
                    this.fparam = new IfxFParam();
                    this.fparam.hasOutParameter = hasOutParameter;
                }
                if (this.conn.isNamedParametersSupported()) {
                    byte[] dbBytes = null;
                    int handleIx = signature.indexOf(94);
                    dbBytes = handleIx > 0 ? this.getJavaToIfxCharBytes(signature.substring(0, handleIx)) : this.getJavaToIfxCharBytes(signature);
                    log.trace(Trace.C_S_MARKER, "SQ_GETROUTINE: {}", (Object)signature);
                    this.os.writeSmallInt((short)101);
                    if (handleIx > 0) {
                        this.os.writeByte(1);
                        this.os.writeChar(dbBytes);
                        int handle = Integer.parseInt(signature.substring(handleIx + 1));
                        this.os.writeInt(handle);
                    } else {
                        this.os.writeByte(0);
                        this.os.writeChar(dbBytes);
                    }
                } else {
                    byte[] dbBytes = this.getJavaToIfxCharBytes(signature);
                    log.trace(Trace.C_S_MARKER, "\tSQ_GETROUTINE: {}", (Object)signature);
                    this.os.writeSmallInt((short)101);
                    this.os.writeChar(dbBytes);
                }
                if (request_fparam) {
                    this.os.writeSmallInt((short)1);
                } else {
                    this.os.writeSmallInt((short)0);
                }
                this.receiveMessage();
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw this.handleSocketException(e, this.conn);
            }
            this.conn.setFPCacheInfo(this.fpHandle, signature, this.fparam);
        }
    }

    private void sendFastPath(int handle, ResultSetMetaData pmd, Vector<IfxObject> inParams, boolean request_fparam) throws SQLException {
        int paramCount = this.conn.isNamedParametersSupported() && pmd != null ? pmd.getColumnCount() : (inParams != null ? inParams.size() : 0);
        if (inParams != null) {
            this.fpInput = new Vector<IfxObject>(inParams);
        }
        try {
            log.trace(Trace.C_S_MARKER, "SQ_EXFPROUTINE Database: {}, Handle: {}, Param Count: {}", this.routineDbName, handle, paramCount);
            this.os.writeSmallInt((short)102);
            if (this.conn.isNamedParametersSupported()) {
                if (this.routineDbName != null) {
                    this.os.writeChar(this.os.getJavaToIfxChar(this.routineDbName));
                } else {
                    this.os.writeChar(this.os.getJavaToIfxChar(""));
                }
            }
            this.os.writeInt(handle);
            this.os.writeSmallInt((short)paramCount);
            if (request_fparam) {
                this.os.writeSmallInt((short)1);
            } else {
                this.os.writeSmallInt((short)0);
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (paramCount != 0) {
            this.sendBind(inParams, pmd, paramCount, 0, paramCount);
        }
        if (request_fparam) {
            this.sendFParam();
        }
    }

    private void receiveFastPath() throws SQLException {
        this.fpRet = new Vector();
        try {
            short numParams = this.is.readSmallInt();
            if (this.fparam != null && this.fparam.colInfoArray.length < numParams) {
                throw Messages.getSQLException(-79716, "receiveFastPath colInfoArray too small", (IfxConnection)this.conn);
            }
            for (short count = 0; count < numParams; count = (short)(count + 1)) {
                int type;
                IfxColumnInfo colInfo = new IfxColumnInfo();
                if (this.fparam != null) {
                    this.fparam.colInfoArray[count] = colInfo;
                }
                if (((type = this.is.readSmallInt()) & 0x800) > 0) {
                    colInfo.IsDistinct = true;
                }
                colInfo.SQLtype = type &= 0xFF;
                if (type >= 18 && type != 52 && type != 53 || colInfo.IsDistinct) {
                    colInfo.ExtendedOwner = this.is.readChar();
                    colInfo.ExtendedName = this.is.readChar();
                }
                type = this.cleanUpFPTypeInfo(count, type, colInfo);
                colInfo.Nullable = 1;
                short ind = this.is.readSmallInt();
                short prec = this.is.readSmallInt();
                if (prec != 0 && colInfo.ColLength == 0) {
                    colInfo.ColLength = prec;
                }
                IfxObject obj = IfxValue.makeInstance((IfxConnection)this.conn, colInfo);
                obj.setConnection(this.conn);
                log.trace(Trace.S_C_MARKER, "SQ_FPROUTINE Param #{}, Info: {}", count + 1, colInfo);
                if (ind == -1) {
                    obj.nullify();
                    this.fpRet.addElement(obj);
                    continue;
                }
                switch (type) {
                    case 0: 
                    case 13: 
                    case 15: 
                    case 16: {
                        obj.fromString(this.is.readChar(this.dbEncoding));
                        break;
                    }
                    case 2: 
                    case 6: {
                        obj.fromInt(this.is.readInt());
                        break;
                    }
                    case 7: {
                        obj.fromDate(this.is.readDate());
                        break;
                    }
                    case 1: {
                        obj.fromShort(this.is.readSmallInt());
                        break;
                    }
                    case 17: 
                    case 18: {
                        obj.fromLong(this.is.readLongInt());
                        break;
                    }
                    case 4: {
                        obj.fromFloat(this.is.readReal(prec));
                        break;
                    }
                    case 3: {
                        obj.fromDouble(this.is.readDouble(prec));
                        break;
                    }
                    case 5: 
                    case 8: {
                        obj.fromDecimal(this.is.readDecimal(prec));
                        break;
                    }
                    case 14: {
                        byte startCode = Interval.getStartCode(prec);
                        if (startCode == 0 || startCode == 2) {
                            obj.fromIntervalYM((IntervalYM)this.is.readInterval(prec));
                            break;
                        }
                        obj.fromIntervalDF((IntervalDF)this.is.readInterval(prec));
                        break;
                    }
                    case 10: {
                        if (IfxDateTime.getStartCode(prec) >= 6 && IfxDateTime.getEndCode(prec) <= 10) {
                            obj.fromTimestamp(this.is.readDateTime(prec));
                            Time tm = obj.toTime();
                            obj.fromTime(tm);
                            break;
                        }
                        ((IfxDateTime)obj).fromIfx(this.is.readRawDateTime(prec), prec);
                        break;
                    }
                    case 40: 
                    case 41: 
                    case 44: {
                        int datalen = this.is.readInt();
                        if (datalen <= 0) break;
                        int udtOffSet = 5;
                        byte[] b = new byte[datalen + udtOffSet];
                        b[0] = 0;
                        byte[] bInt = JavaToIfxType.JavaToIfxInt(datalen);
                        System.arraycopy(bInt, 0, b, 1, 4);
                        this.is.readPadded(b, udtOffSet, datalen);
                        if (colInfo.ExtendedId == 11 || colInfo.ExtendedId == 10) {
                            ((IfxSmBlob)obj).fromIfxFP(b);
                            break;
                        }
                        obj.fromIfx(b);
                        break;
                    }
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: {
                        int datalen = this.is.readShort();
                        datalen = this.is.readInt();
                        if (datalen <= 0) break;
                        byte[] b = new byte[datalen + 4];
                        byte[] bInt = JavaToIfxType.JavaToIfxInt(datalen);
                        System.arraycopy(bInt, 0, b, 0, 4);
                        this.is.read(b, 4, datalen);
                        obj.fromIfx(b);
                        break;
                    }
                    case 11: 
                    case 12: {
                        byte[] descriptor = new byte[56];
                        for (int i = 0; i < 56; ++i) {
                            descriptor[i] = this.is.readByte();
                        }
                        obj.fromIfx(descriptor);
                        break;
                    }
                    case 52: 
                    case 53: {
                        obj.fromLong(this.is.readLongBigint());
                        break;
                    }
                    default: {
                        if (!log.isTraceEnabled()) break;
                        this.protoTrace.writeTrace(logger, 2, " *** Unsupported data found: " + type);
                    }
                }
                this.fpRet.addElement(obj);
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private int cleanUpFPTypeInfo(int count, int type, IfxColumnInfo colInfo) {
        boolean thisIsOutParam = false;
        int argIndex = -1;
        int retIndex = -1;
        if (this.fparam != null) {
            if (count < this.fparam.numberOfOutParams) {
                thisIsOutParam = true;
                argIndex = this.fparam.outParamSequence[count];
            } else {
                retIndex = count - this.fparam.numberOfOutParams;
            }
        }
        if (type == 45) {
            type = 44;
            colInfo.SQLtype = 44;
            colInfo.ExtendedId = 5;
        } else if (type == 43) {
            type = 44;
            colInfo.SQLtype = 44;
            colInfo.ExtendedId = 1;
        } else if (type == 102) {
            type = 44;
            colInfo.SQLtype = 44;
            colInfo.ExtendedId = 10;
        } else if (type == 101) {
            type = 44;
            colInfo.SQLtype = 44;
            colInfo.ExtendedId = 11;
        } else if (this.fparam != null) {
            colInfo.ExtendedId = thisIsOutParam ? this.fparam.argType[argIndex].xid : this.fparam.retType[retIndex].xid;
        }
        if (thisIsOutParam) {
            IfxObject obj = this.fpInput.get(argIndex);
            String name = obj.getExtendedTypeName();
            if (name != null && name.trim().length() != 0) {
                colInfo.ExtendedName = name;
            }
            if (type == 40 || type == 41) {
                if (obj instanceof IfxRow) {
                    type = 22;
                    colInfo.SQLtype = 22;
                } else if (obj instanceof IfxCollection) {
                    type = 20;
                    colInfo.SQLtype = 20;
                }
            }
        }
        return type;
    }

    private void receiveHandle() throws SQLException {
        try {
            if (this.conn.isNamedParametersSupported()) {
                this.routineDbName = this.is.readChar();
            }
            this.fpHandle = this.is.readInt();
            if (this.idesc != null) {
                this.idesc.routineDbName = this.routineDbName;
                this.idesc.fpHandle = this.fpHandle;
            }
            log.trace(Trace.S_C_MARKER, "SQ_GETROUTINE Database: {}, Handle: {}", this.routineDbName, this.fpHandle);
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private void receiveFParam() throws SQLException {
        this.totalOutValues = 0;
        this.totalOutParams = 0;
        if (this.fparam == null) {
            throw Messages.getSQLException(-79716, "IfxSqli.receiveFParam() fparam is null", (IfxConnection)this.conn);
        }
        try {
            byte b;
            this.fparam.funcState = this.is.readLong();
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tFuncState: ", Long.toHexString(this.fparam.funcState));
            }
            this.fparam.request = this.is.readInt();
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tRequest: ", this.fparam.request);
            }
            this.fparam.isDone = (b = this.is.readByte()) != 0;
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tisDone: ", this.fparam.isDone);
            }
            if (this.partialFParam) {
                return;
            }
            this.fparam.id = this.is.readInt();
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tid: ", this.fparam.id);
            }
            this.fparam.row = this.is.readLong();
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\trow: ", this.fparam.row);
            }
            this.fparam.colid = this.is.readInt();
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tcolid: ", this.fparam.colid);
            }
            this.fparam.nrets = this.is.readShort();
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tNumber of return values: ", this.fparam.nrets);
            }
            if (this.fparam.nrets > 0) {
                this.fparam.retNull = new boolean[this.fparam.nrets];
                this.fparam.retType = new IfxFParam.FPTypeInfo[this.fparam.nrets];
                this.readFPTypeInfo(false, this.fparam.nrets, this.fparam.retNull, this.fparam.retType, "Return", this.fparam.outParamSequence);
                this.totalOutValues = this.fparam.nrets;
            }
            this.fparam.nargs = this.is.readShort();
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\n\t\tNumber of parameters: ", this.fparam.nargs);
            }
            boolean hasParameterNames = false;
            boolean isUDRUnique = false;
            if (this.conn.isNamedParametersSupported()) {
                short namedFlags = this.is.readSmallInt();
                hasParameterNames = (namedFlags & 1) != 0;
                boolean bl = isUDRUnique = (namedFlags & 2) != 0;
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\tnamed Flags: ", (int)namedFlags);
                }
            }
            if (this.fparam.nargs > 0) {
                this.fparam.argNull = new boolean[this.fparam.nargs];
                this.fparam.argType = new IfxFParam.FPTypeInfo[this.fparam.nargs];
                this.fparam.outParamSequence = new int[this.fparam.nargs];
                this.readFPTypeInfo(hasParameterNames, this.fparam.nargs, this.fparam.argNull, this.fparam.argType, "Parameter", this.fparam.outParamSequence);
            }
            this.fparam.numberOfOutParams = this.totalOutParams;
            this.fparam.colInfoArray = new IfxColumnInfo[this.totalOutValues];
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        this.partialFParam = true;
    }

    private void readFPTypeInfo(boolean hasParameterNames, int count, boolean[] argNull, IfxFParam.FPTypeInfo[] typeInfo, String header, int[] outParamSequence) throws SQLException {
        try {
            for (int i = 0; i < count; ++i) {
                byte b;
                typeInfo[i] = new IfxFParam.FPTypeInfo();
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\t    " + header + " Type #: " + (i + 1));
                }
                if (hasParameterNames) {
                    byte argFlags = this.is.readByte();
                    String argName = this.is.readChar();
                    if (log.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\targument flags: ", argFlags);
                        this.protoTrace.writeTrace(logger, 2, "\t\t\targument Name: ", argName);
                    }
                }
                argNull[i] = (b = this.is.readByte()) != 0;
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\t\targNull: ", argNull[i]);
                }
                typeInfo[i].type = this.is.readShort();
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\t\ttype: ", typeInfo[i].type);
                }
                typeInfo[i].xid = this.is.readInt();
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\t\txid: ", typeInfo[i].xid);
                }
                typeInfo[i].len = this.is.readInt();
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\t\tlength: ", typeInfo[i].len);
                }
                typeInfo[i].precision = this.is.readShort();
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\t\tprecision: ", typeInfo[i].precision);
                }
                typeInfo[i].scale = this.is.readShort();
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\t\tscale: ", typeInfo[i].scale);
                }
                if (!header.equals("Parameter")) continue;
                typeInfo[i].mode = this.is.readShort();
                if (typeInfo[i].mode == 1) {
                    ++this.totalOutValues;
                    ++this.totalOutParams;
                    outParamSequence[this.totalOutParams - 1] = i;
                }
                if (!log.isTraceEnabled()) continue;
                this.protoTrace.writeTrace(logger, 2, "\t\t\tmode: ", typeInfo[i].mode);
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private void sendFParam() throws SQLException {
        if (this.fparam == null) {
            throw Messages.getSQLException(-79716, "IfxSqli.sendFParam() fparam is null", (IfxConnection)this.conn);
        }
        try {
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "C->S");
                this.protoTrace.writeTrace(logger, 1, "\tSQ_FPARAM");
            }
            this.os.writeSmallInt((short)104);
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\t\tfuncState: " + Long.toHexString(this.fparam.funcState));
            }
            this.os.writeLongInt(this.fparam.funcState);
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\t\trequest: " + this.fparam.request);
            }
            this.os.writeInt(this.fparam.request);
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tisDone: ", this.fparam.isDone);
            }
            if (this.fparam.isDone) {
                this.os.writeByte(0);
            } else {
                this.os.writeByte(1);
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    @Override
    public IfxFParam getFParam() {
        return this.fparam;
    }

    @Override
    public int executeReadSmBlob(int lofd, byte[] buffer, int nbytes) throws SQLException {
        this.BlobBuffer = buffer;
        this.BlobRequestSize = nbytes;
        this.BlobFd = null;
        this.BlobWriteOffset = 0;
        this.BufferOrStream = 0;
        this.BlobWriteFailure = 0;
        this.amountRW = 0;
        return this.doLoData((short)0, lofd, nbytes, 0);
    }

    @Override
    public int executeReadSmBlob(int lofd, byte[] buffer, int nbytes, int offset) throws SQLException {
        this.BlobBuffer = buffer;
        this.BlobRequestSize = nbytes;
        this.BlobFd = null;
        this.BlobWriteOffset = 0;
        this.BufferOrStream = 0;
        this.BlobWriteFailure = 0;
        this.amountRW = 0;
        return this.doLoData((short)1, lofd, nbytes, offset);
    }

    @Override
    public int executeReadSmBlob(int lofd, OutputStream fileFd, int nbytes) throws SQLException {
        this.BlobBuffer = null;
        this.BlobRequestSize = nbytes;
        this.BlobFd = fileFd;
        this.BlobWriteOffset = 0;
        this.BufferOrStream = 1;
        this.amountRW = 0;
        return this.doLoData((short)0, lofd, nbytes, 0);
    }

    private int doLoData(short subCom, int loFd, int dataLength, int off) throws SQLException {
        this.conn.lockSession();
        try {
            this.sendLoData(subCom, loFd, dataLength, off);
            this.receiveMessage();
        }
        catch (Exception e) {
            SQLException sqlException = Messages.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
            throw Messages.setSQLExceptionCause(sqlException, e);
        }
        finally {
            this.conn.unlockSession();
        }
        return this.amountRW;
    }

    @Override
    public int executeWriteSmBlob(int loFd, byte[] buffer) throws SQLException {
        return this.executeWriteSmBlob(loFd, buffer, 0, buffer == null ? 0 : buffer.length);
    }

    @Override
    public int executeWriteSmBlob(int loFd, byte[] buffer, int offset, int length) throws SQLException {
        int dataLength = length;
        int dataOffset = offset;
        int size = 0;
        this.amountRW = 0;
        if (!this.conn.lockSession()) {
            throw Messages.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendLoData((short)2, loFd, dataLength, 0);
            while (dataLength > 0) {
                size = dataLength < 32000 ? dataLength : 32000;
                this.os.writeSmallInt((short)size);
                this.os.writePadded(buffer, dataOffset, size);
                dataLength -= size;
                dataOffset += size;
            }
            this.os.flush();
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
        return this.amountRW;
    }

    @Override
    public int executeWriteSmBlob(int loFd, InputStream fin, int length) throws SQLException {
        InputStream fd = fin instanceof IfxLobInputStream ? ((IfxLobInputStream)fin).getStream() : fin;
        int dataLength = length;
        int size = 0;
        this.amountRW = 0;
        int readLength = 0;
        byte[] buffer = new byte[32000];
        boolean readFault = false;
        if (!this.conn.lockSession()) {
            throw Messages.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendLoData((short)2, loFd, dataLength, 0);
            while (dataLength > 0) {
                try {
                    size = dataLength < 32000 ? dataLength : 32000;
                    readLength = fd.read(buffer, 0, size);
                    if (readLength <= 0) {
                        readFault = true;
                        readLength = size;
                    }
                    this.os.writeSmallInt((short)readLength);
                    this.os.writePadded(buffer, 0, readLength);
                    dataLength -= readLength;
                }
                catch (Exception e) {
                    readFault = true;
                }
            }
            this.receiveMessage();
            if (readFault) {
                throw Messages.getSQLException(-79752, this.conn);
            }
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
        return this.amountRW;
    }

    private void sendLoData(short subCom, int loFd, int length, int off) throws SQLException {
        try {
            this.os.writeSmallInt((short)97);
            if (log.isTraceEnabled()) {
                String type = null;
                switch (subCom) {
                    case 2: {
                        type = "LO_WRITE";
                        break;
                    }
                    case 1: {
                        type = "LO_READWITHSEEK";
                        break;
                    }
                    case 0: {
                        type = "LO_READ";
                    }
                }
                log.trace(Trace.C_S_MARKER, "SQ_LODATA Operation: {}, File descriptor: {}, Length: {}, Buffer size: {}", type, loFd, length, (short)32000);
            }
            this.os.writeSmallInt(subCom);
            this.os.writeSmallInt((short)loFd);
            this.os.writeInt(length);
            this.os.writeSmallInt((short)32000);
            if (subCom == 1) {
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\toffset: ", off);
                }
                this.os.writeLongInt(off);
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\twhence:  IfxSmartBlob.LO_SEEK_CUR");
                }
                this.os.writeSmallInt((short)1);
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private void receiveLODATA() throws SQLException {
        short optype = 0;
        int fileSize = 0;
        try {
            optype = this.is.readSmallInt();
            fileSize = this.is.readInt();
            log.trace(Trace.S_C_MARKER, "SQ_LODATA Operation: {}, Size: {}", optype, fileSize);
        }
        catch (Exception e) {
            log.error("Exception reading LODATA", e);
        }
        if (optype == 2) {
            if (fileSize < 0) {
                this.isamcode = fileSize;
                this.amountRW = -1;
                this.setSQLerrd(1, this.isamcode);
                this.addException(Messages.getSQLException(-9810, this.conn));
                this.addException(this.isamcode, null, new Object[0]);
            } else {
                this.amountRW = fileSize;
            }
            return;
        }
        if (fileSize < 1) {
            try {
                this.is.readSmallInt();
            }
            catch (Exception e) {
                throw this.handleSocketException(e, this.conn);
            }
            this.amountRW = 0;
            return;
        }
        byte[] readBuffer = null;
        if (this.BlobRequestSize > fileSize) {
            this.BlobRequestSize = fileSize;
        }
        short size = 0;
        while (this.BlobRequestSize > 0) {
            try {
                size = this.is.readSmallInt();
                if (size < 0) {
                    this.amountRW = -1;
                    return;
                }
                readBuffer = new byte[size];
                int n = this.is.readPadded(readBuffer);
            }
            catch (Exception e) {
                throw this.handleSocketException(e, this.conn);
            }
            if (this.BlobWriteFailure != 0) continue;
            try {
                this.blobDataWrite(readBuffer, this.BlobWriteOffset, size);
                this.BlobWriteOffset += size;
            }
            catch (Exception e) {
                this.BlobWriteFailure = 1;
            }
            this.amountRW += size;
            this.BlobRequestSize -= size;
        }
        if (log.isTraceEnabled()) {
            this.protoTrace.writeTrace(logger, 1, "\tNo. of Bytes Read : ", this.amountRW);
        }
    }

    private void receiveSQFILE() throws SQLException {
        short optype = -1;
        byte[] buf = null;
        int bufSize = -1;
        long readAmount = 0L;
        int message = -1;
        int err = 0;
        try {
            optype = this.is.readSmallInt();
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\t\tOpType : ", optype);
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        switch (optype) {
            case 0: {
                try {
                    short length = this.is.readSmallInt();
                    byte[] b = new byte[length];
                    this.is.readPadded(b);
                    this.copyToFileName = stringUtil.getString(b, this.dbEncoding);
                    this.copyToFileMode = this.is.readInt();
                    this.copyToFileFlags = this.is.readInt();
                    this.copyToFileOffset = this.is.readInt();
                    message = this.is.readSmallInt();
                }
                catch (Exception e) {
                    throw this.handleSocketException(e, this.conn);
                }
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\t\tFile Name : ", this.copyToFileName);
                    this.protoTrace.writeTrace(logger, 1, "\t\tMode ", this.copyToFileMode);
                    this.protoTrace.writeTrace(logger, 1, "\t\tFlags ", this.copyToFileFlags);
                    this.protoTrace.writeTrace(logger, 1, "\t\tOffset ", this.copyToFileOffset);
                }
                if (message != 12) {
                    this.sendSQFILEError(-408);
                    break;
                }
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_EOT");
                }
                try {
                    this.copyToFileFd = new File(this.copyToFileName);
                }
                catch (NullPointerException e) {
                    this.copyToFileFd = null;
                    this.sendSQFILEError(2);
                    break;
                }
                try {
                    if ((this.copyToFileFlags & 0x10) != 0) {
                        if (!this.copyToFileFd.exists()) {
                            this.copyToFileFd = null;
                            this.sendSQFILEError(2);
                            break;
                        }
                        this.copyToFileFd.setReadOnly();
                    }
                    if ((this.copyToFileFlags & 1) == 0 || !this.copyToFileFd.exists()) break;
                    this.copyToFileFd = null;
                    this.sendSQFILEError(17);
                    break;
                }
                catch (SecurityException e) {
                    throw this.handleSocketException(e, this.conn);
                }
            }
            case 2: {
                long totalSize;
                message = 0;
                long nbytes = 0L;
                try {
                    bufSize = this.is.readSmallInt();
                    readAmount = this.is.readInt();
                    message = this.is.readSmallInt();
                }
                catch (Exception e) {
                    this.sendSQFILEError(-408);
                    break;
                }
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\t\tChunk Size ", bufSize);
                    this.protoTrace.writeTrace(logger, 1, "\t\tAmount to Read ", readAmount);
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_EOT");
                }
                if (message != 12) {
                    this.sendSQFILEError(-408);
                    break;
                }
                if (this.copyToFileFd == null) {
                    this.sendSQFILEError(9);
                    break;
                }
                try {
                    this.loFile = new RandomAccessFile(this.copyToFileFd, "r");
                    totalSize = this.loFile.length();
                }
                catch (IOException e) {
                    this.sendSQFILEError(9);
                    break;
                }
                if ((long)this.copyToFileOffset > totalSize) {
                    this.sendSQFILEError(9);
                    break;
                }
                try {
                    buf = new byte[bufSize];
                }
                catch (Exception e) {
                    this.sendSQFILEError(-406);
                    break;
                }
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "");
                    this.protoTrace.writeTrace(logger, 1, "C->S");
                }
                try {
                    this.os.writeSmallInt((short)106);
                }
                catch (Exception e) {
                    throw this.handleSocketException(e, this.conn);
                }
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_FILE_READ");
                }
                readAmount = readAmount == -1L ? totalSize - (long)this.copyToFileOffset : (totalSize - (long)this.copyToFileOffset < readAmount ? totalSize - (long)this.copyToFileOffset : readAmount);
                try {
                    this.os.writeInt((int)readAmount);
                }
                catch (Exception e) {
                    throw this.handleSocketException(e, this.conn);
                }
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tAmount", readAmount);
                }
                try {
                    this.loFile.seek(this.copyToFileOffset);
                }
                catch (IOException e) {
                    this.sendSQFILEError(29);
                    break;
                }
                int size = 0;
                try {
                    while (readAmount > 0L) {
                        nbytes = (long)bufSize < readAmount ? (long)bufSize : readAmount;
                        try {
                            size = this.loFile.read(buf, 0, (int)nbytes);
                        }
                        catch (Exception io) {
                            break;
                        }
                        this.os.writeSmallInt((short)106);
                        this.os.writeSmallInt((short)size);
                        this.os.writePadded(buf, 0, size);
                        readAmount -= (long)size;
                    }
                }
                catch (Exception e) {
                    throw this.handleSocketException(e, this.conn);
                }
                if (readAmount <= 0L) break;
                this.sendSQFILEError(5);
                break;
            }
            case 3: {
                if (this.copyToFileFd == null) {
                    this.sendSQFILEError(9);
                    break;
                }
                err = 0;
                try {
                    this.loFile = new RandomAccessFile(this.copyToFileFd, "rw");
                    if ((this.copyToFileFlags & 2) != 0) {
                        if (this.copyToFileOffset != 0) {
                            this.loFile.seek(this.copyToFileOffset);
                        } else {
                            this.loFile.seek(this.loFile.length());
                        }
                    }
                }
                catch (Exception e) {
                    this.sendSQFILEError(13);
                    break;
                }
                try {
                    while (true) {
                        short s = this.is.readSmallInt();
                        message = s;
                        if (s == 107) {
                            bufSize = this.is.readSmallInt();
                            byte[] buffer = new byte[bufSize];
                            this.is.readPadded(buffer);
                            if ((this.copyToFileFlags & 0x80) != 0) {
                                this.loFile.writeChars(new String(buffer));
                                continue;
                            }
                            this.loFile.write(buffer, 0, bufSize);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    err = 2;
                    break;
                }
                try {
                    if (message == 13) {
                        err = this.is.readSmallInt();
                    }
                    if (err != 0) {
                        this.sendSQFILEError(err);
                        break;
                    }
                    long TotalSize = this.loFile.length();
                    if (log.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 1, "\tSQ_FILE_WRITE");
                        this.protoTrace.writeTrace(logger, 1, "\t\tTotal Size:" + TotalSize);
                    }
                    this.os.writeSmallInt((short)107);
                    this.os.writeInt((int)TotalSize);
                    break;
                }
                catch (IOException e) {
                    throw this.handleSocketException(e, this.conn);
                }
            }
            case 1: {
                try {
                    message = this.is.readSmallInt();
                }
                catch (IOException e) {
                    message = 0;
                }
                if (message != 12) {
                    this.sendSQFILEError(-408);
                    break;
                }
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_EOT");
                }
                try {
                    if (this.copyToFileFd == null || this.loFile == null) break;
                    this.loFile.close();
                }
                catch (IOException iOException) {}
                break;
            }
        }
        if (log.isTraceEnabled()) {
            this.protoTrace.writeTrace(logger, 1, "");
            this.protoTrace.writeTrace(logger, 1, "C->S");
        }
        this.flip();
    }

    @Override
    public void executeProtocols(byte[] protocols) throws SQLException {
        if (!this.conn.lockSession()) {
            throw Messages.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendProtocols(protocols);
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
    }

    private void sendProtocols(byte[] protocols) throws SQLException {
        if (protocols == null || protocols.length == 0) {
            throw Messages.getSQLException(-79716);
        }
        try {
            log.trace(Trace.C_S_MARKER, "SQ_PROTOCOLS");
            this.os.writeSmallInt((short)126);
            this.os.writeSmallInt((short)protocols.length);
            this.os.writePadded(protocols);
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private void receiveProtocols() throws SQLException {
        try {
            short datalen = this.is.readSmallInt();
            this.serverProtocol = new byte[datalen];
            this.is.readPadded(this.serverProtocol);
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    @Override
    public byte[] getProtocols() {
        return this.serverProtocol;
    }

    private void sendSQFILEError(int error) throws SQLException {
        if (log.isTraceEnabled()) {
            this.protoTrace.writeTrace(logger, 1, "");
            this.protoTrace.writeTrace(logger, 1, "C->S");
            this.protoTrace.writeTrace(logger, 1, "\tSQ_ERR");
            this.protoTrace.writeTrace(logger, 1, "\tSQL error : " + error);
            this.protoTrace.writeTrace(logger, 1, "\tISAM/RSAM error : 0");
            this.protoTrace.writeTrace(logger, 1, "\tOffset  : 0");
            this.protoTrace.writeTrace(logger, 1, "\tError message  : 0");
        }
        try {
            this.os.writeSmallInt((short)13);
            this.os.writeSmallInt((short)error);
            this.os.writeSmallInt((short)0);
            this.os.writeSmallInt((short)0);
            if (this.conn.isRemove64KLimitSupported()) {
                this.os.writeSmallInt((short)0);
            }
            this.os.writeSmallInt((short)0);
        }
        catch (IOException e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private void sendPut(IfxPreparedStatement pstmt) throws SQLException {
        IfxResultSetMetaData putRsmd = (IfxResultSetMetaData)pstmt.getOutPutMetaData();
        if (log.isTraceEnabled()) {
            if (putRsmd.textByteColumnCount > 0) {
                log.trace("SQ_PUT with text/byte columns");
            }
            if (putRsmd.hasVariableLengthColumns) {
                log.trace("SQ_PUT with variable length columns");
            }
        }
        if (pstmt.executeBatchInProgress) {
            this.executeBatchInProgress = true;
        }
        try {
            if (!pstmt.cursorOpen) {
                this.sendQuery(pstmt, false, false, null);
            } else {
                this.sendStatementID();
            }
            if (!putRsmd.hasVariableLengthColumns && putRsmd.textByteColumnCount <= 0) {
                int tSize = this.getTupleSize();
                byte[] rowArray = null;
                byte[] bData = pstmt.getAllRows();
                while ((rowArray = pstmt.getNextRowBatch(bData)) != null) {
                    log.trace(Trace.C_S_MARKER, "SQ_PUT");
                    this.os.writeSmallInt((short)17);
                    log.trace(Trace.C_S_MARKER, "Tuple size: {}", (Object)tSize);
                    this.os.writeInt(tSize);
                    log.trace(Trace.C_S_MARKER, "Rows: {}", (Object)pstmt.getNumRowsCurrBatch());
                    this.os.writeSmallInt((short)pstmt.getNumRowsCurrBatch());
                    this.os.write(rowArray);
                    if (!this.executeBatchInProgress) continue;
                    this.receiveMessage();
                    this.sendStatementID();
                }
            } else {
                if (putRsmd.hasVariableLengthColumns) {
                    this.sendType((IfxResultSetMetaData)pstmt.getOutPutMetaData(), (short)0, true);
                }
                for (int i = 0; i < pstmt.getBatchCount(); ++i) {
                    log.trace(Trace.C_S_MARKER, "SQ_PUT");
                    this.os.writeSmallInt((short)17);
                    byte[] bData = pstmt.getNextRow();
                    log.trace(Trace.C_S_MARKER, "Tuple size: {}", (Object)bData.length);
                    this.os.writeInt(bData.length);
                    log.trace(Trace.C_S_MARKER, "Rows: 1");
                    this.os.writeSmallInt((short)1);
                    this.os.writePadded(bData);
                    for (int j = i * putRsmd.textByteColumnCount; j < i * putRsmd.textByteColumnCount + putRsmd.textByteColumnCount; ++j) {
                        IfxBlob BlobObject = pstmt.getIfxBlobAt(j);
                        if (BlobObject == null) continue;
                        if (BlobObject.isBlobByteType()) {
                            this.sendBytesBlob(this.os, BlobObject.getBlobBuffer());
                            continue;
                        }
                        this.sendStreamBlob(this.os, BlobObject.getBlobInputStream(), BlobObject.getBlobLength());
                    }
                    if (((IfxResultSetMetaData)pstmt.getOutPutMetaData()).usingIMPEXP()) {
                        this.receiveMessage();
                    }
                    if (!this.executeBatchInProgress || this.os.getBytesSentSinceLastEOT() < this.conn.getMaxFetchBufSize()) continue;
                    this.receiveMessage();
                    this.sendStatementID();
                    if (!putRsmd.hasVariableLengthColumns) continue;
                    if (log.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 1, "\tvar-size rows");
                    }
                    this.sendType((IfxResultSetMetaData)pstmt.getOutPutMetaData(), (short)0, true);
                }
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    static String getDbName(Statement stmt) {
        if (stmt.getClass() == IfxPreparedStatement.class) {
            return ((IfxPreparedStatement)stmt).getDBName();
        }
        return IfxSqli.parseDbName(((IfxStatement)stmt).commandString);
    }

    static String parseDbName(String sql) {
        String token = null;
        String dbName = null;
        try {
            StringTokenizer tok = new StringTokenizer(sql, " ");
            token = tok.nextToken();
            if (token.equalsIgnoreCase("DATABASE")) {
                dbName = tok.nextToken();
            } else if (token.equalsIgnoreCase("CREATE") && (token = tok.nextToken()).equalsIgnoreCase("DATABASE")) {
                String tok1 = tok.nextToken();
                if (tok1.equalsIgnoreCase("IF")) {
                    for (int i = 0; i < 3; ++i) {
                        tok1 = tok.nextToken();
                    }
                }
                dbName = tok1;
            }
        }
        catch (Exception e) {
            dbName = null;
        }
        if (dbName != null && dbName.endsWith(";")) {
            dbName = dbName.substring(0, dbName.length() - 1);
        }
        return dbName;
    }

    @Override
    public int incRefCount(byte[] locator) throws SQLException {
        return 0;
    }

    @Override
    public int decRefCount(byte[] locator) throws SQLException {
        return 0;
    }

    protected void setIsReleased(boolean val) {
        this.isReleased = val;
    }

    @Override
    public int getStatementID() {
        return this.statementID;
    }

    void initiateTransaction() throws SQLException {
        if (!this.conn.inXATransaction() && this.conn.db_use_log && !this.conn.AnsiDb && this.TxStmt != 1 && this.conn.TxState == 1) {
            this.sendBegin();
            this.receiveMessage();
            this.conn.setTxBeginState();
        }
        if (this.conn.AnsiDb && !this.conn.autoCommit && !this.conn.inXATransaction()) {
            this.conn.TxState = (short)2;
        }
    }

    @Override
    public IfxResultSetMetaData executeDescribeInput() throws SQLException {
        this.conn.lockSession();
        try {
            this.sendCIDescribe();
            this.receiveMessage();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        finally {
            this.conn.unlockSession();
        }
        return this.idesc;
    }

    private void sendCIDescribe() throws SQLException {
        try {
            this.sendStatementID();
            log.trace(Trace.C_S_MARKER, "SQ_CIDESCRIBE");
            this.os.writeSmallInt((short)124);
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private void receiveIDescribe() throws SQLException {
        this.recvIDescribe(false);
    }

    private void recvIDescribe(boolean isFastPath) throws SQLException {
        short nparameters = 0;
        int intVal = 0;
        try {
            nparameters = this.is.readSmallInt();
            this.idesc = new IfxResultSetMetaData(nparameters, this.conn);
            boolean hasParameterNames = false;
            boolean isUDRUnique = false;
            int numberArguments = -1;
            if (this.conn.isNamedParametersSupported() && nparameters != 0) {
                short namedFlags = this.is.readSmallInt();
                hasParameterNames = (namedFlags & 1) != 0;
                boolean bl = isUDRUnique = (namedFlags & 2) != 0;
                if (!isFastPath && hasParameterNames) {
                    numberArguments = this.is.readSmallInt();
                }
                this.idesc.namedFlags = namedFlags;
                this.idesc.numArgsRoutine = numberArguments;
            }
            if (nparameters > 0) {
                for (short i = 1; i <= nparameters; i = (short)(i + 1)) {
                    if (hasParameterNames) {
                        byte argFlags = this.is.readByte();
                        String argName = this.is.readChar();
                        this.idesc.setArgumentFlags(i, argFlags);
                        this.idesc.setArgumentName(i, argName);
                    }
                    short shortVal = this.is.readSmallInt();
                    this.idesc.setIfxColumnType(i, shortVal);
                    intVal = this.is.readInt();
                    this.idesc.setColumnExtendedId(i, intVal);
                    String stringData = this.is.readChar();
                    this.idesc.setExtendedOwnerName(i, stringData);
                    stringData = this.is.readChar();
                    this.idesc.setExtendedName(i, stringData);
                    shortVal = this.is.readSmallInt();
                    this.idesc.setReference(i, shortVal);
                    shortVal = this.is.readSmallInt();
                    this.idesc.setAlignment(i, shortVal);
                    intVal = this.is.readInt();
                    this.idesc.setSourceType(i, intVal);
                    intVal = this.is.readInt();
                    this.idesc.setEncodedLength(i, intVal);
                    int type = this.idesc.getIfxColumnType(i);
                    if (type == 5 || type == 8) {
                        intVal = IfxTypes.IfxTypeToDecDigits(this.idesc.getIfxColumnType(i), this.idesc.getColumnExtendedId(i), this.idesc.getEncodedLength(i));
                        this.idesc.setDecimalDigits(i, intVal);
                        intVal = IfxTypes.IfxTypeToRightDecimal(this.idesc.getIfxColumnType(i), this.idesc.getColumnExtendedId(i), this.idesc.getEncodedLength(i));
                        this.idesc.setRightDecimal(i, intVal);
                    }
                    if (!isFastPath) continue;
                    shortVal = this.is.readSmallInt();
                    this.idesc.setMode(i, shortVal);
                }
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private void receiveSGKDescribe() throws SQLException {
        short nfields = 0;
        int intVal = 0;
        String strtab = null;
        int[] fieldIndex = null;
        try {
            this.is.readSmallInt();
            this.is.readSmallInt();
            intVal = this.is.readInt();
            this.setSQLerrd(3, intVal);
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tStatement Type: ", this.statementType);
                this.protoTrace.writeTrace(logger, 2, "\t\tStatement ID: ", this.statementID);
                this.protoTrace.writeTrace(logger, 2, "\t\tEstimated Cost: ", intVal);
            }
            int tupleSize = this.conn.isLargeTupleSize() ? this.is.readInt() : (int)this.is.readSmallInt();
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tTuplesize: ", tupleSize);
            }
            nfields = this.is.readSmallInt();
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\t# of fields: ", (int)nfields);
            }
            this.SGK_desc = new IfxResultSetMetaData(nfields, this.conn);
            this.SGK_desc.setTupleSize(tupleSize);
            int stringTableSize = this.is.readInt();
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tString table: ", stringTableSize);
            }
            if (nfields > 0) {
                fieldIndex = new int[nfields];
                for (short i = 1; i <= nfields; i = (short)(i + 1)) {
                    fieldIndex[i - 1] = this.is.readInt();
                    if (log.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t    Field Index: ", fieldIndex[i - 1]);
                    }
                    intVal = this.is.readInt();
                    if (log.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tColumn Start Pos: ", intVal);
                    }
                    this.SGK_desc.setColumnStartPosition(i, intVal);
                    short shortVal = this.is.readSmallInt();
                    if (log.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tColumn type: ", shortVal);
                    }
                    this.SGK_desc.setIfxColumnType(i, shortVal);
                    intVal = this.is.readInt();
                    if (log.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tColumn Extended Id: ", intVal);
                    }
                    this.SGK_desc.setColumnExtendedId(i, intVal);
                    String stringData = this.is.readChar(this.dbEncoding);
                    if (log.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tOwner name: " + stringData);
                    }
                    this.SGK_desc.setExtendedOwnerName(i, stringData);
                    stringData = this.is.readChar();
                    if (log.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tExtended name: " + stringData);
                    }
                    this.SGK_desc.setExtendedName(i, stringData);
                    shortVal = this.is.readSmallInt();
                    if (log.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tReference: ", shortVal);
                    }
                    this.SGK_desc.setReference(i, shortVal);
                    shortVal = this.is.readSmallInt();
                    if (log.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tAlignment: ", shortVal);
                    }
                    this.SGK_desc.setAlignment(i, shortVal);
                    intVal = this.is.readInt();
                    if (log.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tSource type: ", intVal);
                    }
                    this.SGK_desc.setSourceType(i, intVal);
                    intVal = this.is.readInt();
                    if (log.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tLength: ", intVal);
                    }
                    this.SGK_desc.setEncodedLength(i, intVal);
                }
                this.SGK_desc.setTextByteColumnCount();
            }
            if (stringTableSize > 0) {
                byte[] b = new byte[stringTableSize];
                this.is.readPadded(b);
                strtab = IfxToJavaType.IfxToJavaChar(b, this.dbEncoding, this.conn.encoption);
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\tData in String table: ", strtab);
                }
            }
            this.SGK_rowColumn = new IfxRowColumn(this.conn, this.SGK_desc, 100);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (strtab != null) {
            String colName = null;
            StringTokenizer itok = new StringTokenizer(strtab, "\u0000");
            for (short i = 0; i < nfields; i = (short)(i + 1)) {
                if (itok.hasMoreTokens()) {
                    colName = itok.nextToken();
                    this.SGK_desc.setColumnName(i + 1, colName);
                    continue;
                }
                this.SGK_desc.setColumnName(i + 1, null);
            }
        }
        if (this.conn != null) {
            this.SGK_desc.setDelimIdent(this.conn.isDelimIdentSet());
        }
    }

    private void receiveSGKTuple() throws SQLException {
        try {
            this.is.readSmallInt();
            if (this.SGK_rowColumn == null) {
                throw Messages.getSQLException(-79716, "No SGK_DESCRIBE", (IfxConnection)this.conn);
            }
            int size = this.SGK_rowColumn.readTuple(this.is);
            this.SGK_totalTupleSize += size;
            if (++this.SGK_totalTuples >= this.SGK_offsetVector.size()) {
                this.SGK_offsetVector.setSize(this.SGK_totalTuples + 100);
                this.SGK_offsetVector.setElementAt(0, 0);
            }
            this.SGK_offsetVector.setElementAt(this.SGK_totalTupleSize, this.SGK_totalTuples);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private String acceptPrivateServerChallenge() {
        try {
            short msg;
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "S->C");
            }
            if ((msg = this.is.readSmallInt()) == 129) {
                short fileXNameLength = this.is.readSmallInt();
                byte[] fileNameMessage = new byte[fileXNameLength];
                this.is.readPadded(fileNameMessage, 0, fileXNameLength);
                String fileXName = IfxToJavaType.IfxToJavaChar(fileNameMessage, this.conn.encoption);
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_CHALLENGE");
                    this.protoTrace.writeTrace(logger, 1, "\tfileXNameLength=" + fileXNameLength);
                    if (fileXNameLength > 0) {
                        this.protoTrace.writeTrace(logger, 1, "\tfileXName=" + fileXName);
                    }
                }
                FileInputStream fInStream = new FileInputStream(fileXName);
                DataInputStream fileXInput = new DataInputStream(fInStream);
                String fileYName = fileXInput.readLine();
                byte[] intZbuf = new byte[256];
                fileXInput.read(intZbuf, 0, 256);
                fileXInput.close();
                fInStream.close();
                FileOutputStream fOutStream = new FileOutputStream(fileYName);
                fOutStream.write(intZbuf);
                fOutStream.close();
                this.receiveEOT();
                if (this.sqliTrace != null) {
                    this.sqliTrace.recordS2C();
                }
                return fileYName;
            }
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\t*** Unknown error message: " + msg + " ***\n");
            }
            this.setError(-408);
            return null;
        }
        catch (SQLException e) {
            this.addException(e);
            return null;
        }
        catch (IOException ie) {
            this.addException(Messages.getSQLException(-80507, this.conn));
            return null;
        }
        catch (Exception e) {
            this.addException(Messages.getSQLException(-79716, this.conn));
            return null;
        }
    }

    private boolean sendPrivateServerResponse(String fileYName) {
        try {
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "C->S");
                this.protoTrace.writeTrace(logger, 1, "\tSQ_RESPONSE");
                this.protoTrace.writeTrace(logger, 1, "\tfileYNameLength=" + fileYName.length());
                if (fileYName.length() > 0) {
                    this.protoTrace.writeTrace(logger, 1, "\tfileYName=" + fileYName);
                }
            }
            this.os.writeSmallInt((short)130);
            this.os.writeSmallInt((short)fileYName.length());
            byte[] b = JavaToIfxType.JavaToIfxChar(fileYName, this.conn.encoption);
            this.os.writePadded(b, 2, b.length - 2);
            this.flip();
            this.clearExceptions();
            short msg = this.is.readSmallInt();
            if (msg == 127) {
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "");
                    this.protoTrace.writeTrace(logger, 1, "S->C");
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_ACCEPT");
                }
                if ((msg = this.is.readSmallInt()) == 12) {
                    if (log.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 1, "\tSQ_EOT");
                    }
                    return true;
                }
            } else if (msg == 56) {
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "");
                    this.protoTrace.writeTrace(logger, 1, "S->C");
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_EXIT");
                }
            } else if (msg == 12) {
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "");
                    this.protoTrace.writeTrace(logger, 1, "S->C");
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_EOT");
                }
            } else if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "S->C");
                this.protoTrace.writeTrace(logger, 1, "\t*** Unknown error message: " + msg + " ***\n");
            }
            return false;
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                this.addException((SQLException)e);
            } else if (e instanceof IOException) {
                this.addException(Messages.getSQLException((Throwable)e, -80507, (IfxConnection)this.conn));
            } else {
                this.addException(Messages.getSQLException((Throwable)e, -79716, (IfxConnection)this.conn));
            }
            return false;
        }
    }

    @Override
    public boolean handlePrivateServerExchange() throws SQLException {
        try {
            this.sendACK();
            this.flip();
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        this.clearExceptions();
        String fileYName = this.acceptPrivateServerChallenge();
        if (fileYName == null) {
            return false;
        }
        boolean flag = this.sendPrivateServerResponse(fileYName);
        if (this.sqliTrace != null) {
            this.sqliTrace.recordS2C();
        }
        return flag;
    }

    @Override
    public void handlePAMAuthentication(String pamClientClassName) throws SQLException {
        PAM userPAMInterface = null;
        try {
            if (pamClientClassName != null) {
                Class<?> c = Class.forName(pamClientClassName);
                boolean interfaceFound = false;
                for (Class<PAM> clazz : c.getInterfaces()) {
                    if (!clazz.isAssignableFrom(PAM.class)) continue;
                    interfaceFound = true;
                    break;
                }
                if (!interfaceFound) {
                    throw Messages.getSQLException(-79884);
                }
                userPAMInterface = (PAM)c.newInstance();
            }
        }
        catch (ClassNotFoundException e) {
            throw Messages.getSQLException(-79883);
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        boolean done = false;
        IfxPAMChallenge challengeMessage = null;
        IfxPAMResponse responseMessage = null;
        try {
            this.sendACK();
            this.flip();
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        while (!this.userPAMAuthorized && !done) {
            boolean responseRequired;
            challengeMessage = this.readPAMChallengeMessage();
            if (this.userPAMAuthorized) {
                done = true;
                continue;
            }
            if (challengeMessage == null) {
                done = true;
                continue;
            }
            switch (challengeMessage.getChallengeType()) {
                case 3: 
                case 4: {
                    responseRequired = false;
                    break;
                }
                default: {
                    responseRequired = true;
                }
            }
            if (userPAMInterface == null) {
                throw Messages.getSQLException(-79898, this.conn, "IFX_PAM_CLASS");
            }
            responseMessage = userPAMInterface.pamChallenge(challengeMessage);
            if (responseMessage.getTerminateConnection()) {
                this.sendExit();
                done = true;
                continue;
            }
            if (!responseRequired) continue;
            this.sendPAMResponseMessage(responseMessage);
        }
        if (!this.userPAMAuthorized) {
            throw Messages.getSQLException(-79885);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private IfxPAMChallenge readPAMChallengeMessage() throws SQLException {
        message = new byte[513];
        returnValue = null;
        this.clearExceptions();
        try {
            this.conn.lockSession();
            if (IfxSqli.log.isTraceEnabled()) {
                this.protoTrace.writeTrace(IfxSqli.logger, 1, "");
                this.protoTrace.writeTrace(IfxSqli.logger, 1, "S->C");
            }
            msg = this.is.readSmallInt();
            switch (msg) {
                case 56: {
                    if (IfxSqli.log.isTraceEnabled()) {
                        this.protoTrace.writeTrace(IfxSqli.logger, 1, "\tSQ_EXIT");
                    }
                    this.sendExit();
                    ** break;
lbl17:
                    // 1 sources

                    break;
                }
                case 127: {
                    if (IfxSqli.log.isTraceEnabled()) {
                        this.protoTrace.writeTrace(IfxSqli.logger, 1, "\tSQ_ACCEPT");
                    }
                    this.userPAMAuthorized = true;
                    this.receiveEOT();
                    ** break;
lbl24:
                    // 1 sources

                    break;
                }
                case 129: {
                    if (IfxSqli.log.isTraceEnabled()) {
                        this.protoTrace.writeTrace(IfxSqli.logger, 1, "\tSQ_CHALLENGE");
                    }
                    messageStyle = this.is.readSmallInt();
                    messageLength = this.is.readSmallInt();
                    this.is.readPadded(message, 0, messageLength);
                    returnValue = new PAMChallengeImpl(IfxToJavaType.IfxToJavaChar(message, this.conn.encoption), messageStyle);
                    if (IfxSqli.log.isTraceEnabled()) {
                        this.protoTrace.writeTrace(IfxSqli.logger, 1, "\tMessageType=" + messageStyle);
                        this.protoTrace.writeTrace(IfxSqli.logger, 1, "\tMessageLength=" + messageLength);
                        this.protoTrace.writeTrace(IfxSqli.logger, 1, "\tMessage=" + returnValue.getChallenge());
                    }
                    this.receiveEOT();
                    ** break;
lbl39:
                    // 1 sources

                    break;
                }
                default: {
                    if (IfxSqli.log.isTraceEnabled()) {
                        this.protoTrace.writeTrace(IfxSqli.logger, 1, "\t*** Unknown error message: " + msg + " ***\n");
                    }
                    this.setError(-408);
                    break;
                }
            }
        }
        catch (SQLException e) {
            this.addException(e);
        }
        catch (IOException e) {
            this.addException(Messages.getSQLException(e, -80507));
        }
        catch (Exception e) {
            this.addException(Messages.getSQLException(e, -79716));
        }
        finally {
            this.conn.unlockIfOwner();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return returnValue;
    }

    private void sendPAMResponseMessage(IfxPAMResponse r) throws SQLException {
        String responseString = r.getResponse();
        short msgLen = 0;
        if (responseString != null) {
            if (responseString.length() > 512) {
                throw Messages.getSQLException(-79886, this.conn);
            }
            msgLen = (short)responseString.length();
        }
        if (log.isTraceEnabled()) {
            this.protoTrace.writeTrace(logger, 1, "");
            this.protoTrace.writeTrace(logger, 1, "C->S");
            this.protoTrace.writeTrace(logger, 1, "\tSQ_RESPONSE");
            this.protoTrace.writeTrace(logger, 2, "\t\tMESSAGE LENGTH: " + msgLen);
            this.protoTrace.writeTrace(logger, 2, "\t\tData:");
            if (r.getResponse() == null || r.getResponse().isEmpty()) {
                this.protoTrace.writeTrace(logger, 2, "<null>");
            } else {
                this.protoTrace.writeTrace(logger, 2, r.getResponse());
            }
        }
        try {
            this.os.writeSmallInt((short)130);
            this.os.writeSmallInt(msgLen);
            if (msgLen != 0) {
                byte[] b = JavaToIfxType.JavaToIfxChar(r.getResponse(), this.conn.encoption);
                this.os.writePadded(b, 2, b.length - 2);
            }
            this.sendEOT();
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    @Override
    public IfxResultSetMetaData executeFPDescribe(String signature, boolean isProc, String procName, int numargs) throws SQLException {
        if (!this.conn.lockSession()) {
            throw Messages.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendCFPDescribe(signature, isProc, procName, numargs);
            this.receiveMessage();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        finally {
            this.conn.unlockSession();
        }
        return this.idesc;
    }

    private void sendCFPDescribe(String signature, boolean isProc, String procName, int numargs) throws SQLException {
        try {
            if (this.conn.isNamedParametersSupported()) {
                byte[] dbBytes = null;
                int handleIx = signature.indexOf(94);
                dbBytes = handleIx > 0 ? this.os.getJavaToIfxChar(signature.substring(0, handleIx)) : this.os.getJavaToIfxChar(procName);
                this.os.writeSmallInt((short)131);
                if (handleIx > 0) {
                    this.os.writeByte(1);
                    this.os.writeChar(dbBytes);
                    int handle = Integer.parseInt(signature.substring(handleIx + 1));
                    this.os.writeInt(handle);
                    if (log.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\tisRoutineById:  1");
                        this.protoTrace.writeTrace(logger, 2, "\tDbName: " + signature.substring(0, handleIx));
                        this.routineDbName = signature.substring(0, handleIx);
                        this.protoTrace.writeTrace(logger, 2, "\thandle id: " + handle);
                    }
                } else {
                    this.os.writeByte(0);
                    if (isProc) {
                        this.os.writeSmallInt((short)0);
                    } else {
                        this.os.writeSmallInt((short)1);
                    }
                    this.os.writeChar(dbBytes);
                    this.os.writeInt(numargs);
                    if (log.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t Procedure: " + (isProc ? "true" : "false"));
                        this.protoTrace.writeTrace(logger, 2, "\t\t Name     : " + procName);
                        this.protoTrace.writeTrace(logger, 2, "\t\t NumArgs  : " + numargs);
                    }
                }
            } else {
                byte[] dbBytes = this.os.getJavaToIfxChar(procName);
                this.os.writeSmallInt((short)131);
                if (isProc) {
                    this.os.writeSmallInt((short)0);
                } else {
                    this.os.writeSmallInt((short)1);
                }
                this.os.writeChar(dbBytes);
                this.os.writeInt(numargs);
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\t Procedure: " + (isProc ? "true" : "false"));
                    this.protoTrace.writeTrace(logger, 2, "\t\t Name     : " + procName);
                    this.protoTrace.writeTrace(logger, 2, "\t\t NumArgs  : " + numargs);
                }
            }
            this.sendEOT();
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw this.handleSocketException(e, this.conn);
        }
    }

    private void receiveIFPDescribe() throws SQLException {
        try {
            this.recvIDescribe(true);
        }
        catch (SQLException e) {
            this.addException(e);
        }
        catch (Exception e) {
            this.addException(Messages.getSQLException(-79716, this.conn));
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public boolean getNextSGKRow() throws SQLException {
        int tcount = this.SGK_totalTuples - (this.SGK_curRow + 1);
        if (tcount == 0) {
            return false;
        }
        ++this.SGK_curRow;
        this.SGK_curOffset = this.SGK_offsetVector.get(this.SGK_curRow);
        this.SGK_rowColumn.setOffsetInTuple(this.SGK_curOffset);
        return true;
    }

    private void sendSGKPrepare(IfxStatement stmt) throws SQLException {
        try {
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\tSQ_SGKPREPARE");
            }
            this.os.writeSmallInt((short)134);
            if (log.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\t\treturnGeneratedKey: " + stmt.SGK_returnGeneratedKeys);
            }
            this.os.writeSmallInt(stmt.SGK_returnGeneratedKeys);
            if (stmt.SGK_returnGeneratedKeys == 2) {
                int nkeys = 0;
                if (stmt.SGK_indexes != null) {
                    nkeys = stmt.SGK_indexes.length;
                }
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\t\t# keys: " + nkeys);
                }
                this.os.writeSmallInt((short)nkeys);
                for (int i = 0; i < nkeys; ++i) {
                    if (log.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 1, "\t\t\tindex: " + stmt.SGK_indexes[i]);
                    }
                    this.os.writeSmallInt((short)stmt.SGK_indexes[i]);
                }
            } else if (stmt.SGK_returnGeneratedKeys == 3) {
                int nkeys = 0;
                if (stmt.SGK_names != null) {
                    nkeys = stmt.SGK_names.length;
                }
                if (log.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\t\t# keys: " + nkeys);
                }
                this.os.writeSmallInt((short)nkeys);
                for (int i = 0; i < nkeys; ++i) {
                    if (log.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 1, "\t\t\tname: " + stmt.SGK_names[i]);
                    }
                    this.os.writeChar(this.os.getJavaToIfxChar(stmt.SGK_names[i]));
                }
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    public int getNumberOfFetches() {
        return this.numberOfFetches;
    }

    protected int getNumberOfTuplesReceived() {
        return this.numberOfTuplesReceived;
    }

    private SQLException handleSocketException(Exception e, IfxSqliConnect conn) {
        if (conn != null) {
            conn.setOpen(false);
        }
        if (e instanceof SQLException) {
            return (SQLException)e;
        }
        if (e instanceof IOException) {
            return Messages.getSQLException((Throwable)e, -80507, (IfxConnection)conn);
        }
        return Messages.getSQLException(e, -79716);
    }

    private void checkFastPathExp(List<IfxObject> exVector, ResultSetMetaData pmd) throws SQLException {
        int paramCount = this.conn.isNamedParametersSupported() && pmd != null ? pmd.getColumnCount() : (exVector != null ? exVector.size() : 0);
        for (int i = 0; i < paramCount; ++i) {
            IfxObject ival = null;
            if (i < exVector.size()) {
                ival = exVector.get(i);
            }
            if (ival != null) continue;
            int ord = i % paramCount + 1;
            if (pmd != null && ((IfxResultSetMetaData)pmd).hasDefaultValue(ord)) {
                return;
            }
            throw Messages.getSQLException(-79823, ((IfxResultSetMetaData)pmd).getArgumentName(ord), (IfxConnection)this.conn);
        }
    }

    private byte[] getJavaToIfxCharBytes(String s) throws IOException, SQLException {
        if (this.conn.isRemove64KLimitSupported()) {
            return this.os.getJavaToIfx4BytesChar(s, this.dbEncoding);
        }
        return this.os.getJavaToIfxChar(s, this.dbEncoding);
    }

    public int getPutErrRowCount() {
        return (int)this.putErrRowCount;
    }

    public void clearPutErrRowCount() {
    }
}

