/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.asf.ASFException;
import com.informix.jdbc.IfmxStatement;
import com.informix.jdbc.IfxBSONObject;
import com.informix.jdbc.IfxCancelQueryImpl;
import com.informix.jdbc.IfxClientResultSet;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSet;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxSavepoint;
import com.informix.jdbc.IfxSmBlob;
import com.informix.jdbc.IfxSqli;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.NativeSQL;
import com.informix.jdbc.PreparedStatementCache;
import com.informix.jdbc.STREAMS_FETCHING;
import com.informix.lang.JavaToIfxType;
import com.informix.lang.Messages;
import com.informix.lang.WarningMessages;
import com.informix.util.BsonUtils;
import com.informix.util.JdbcLogger;
import java.lang.ref.WeakReference;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class IfxStatement
implements IfmxStatement {
    private static final JdbcLogger log = JdbcLogger.getLogger(IfxStatement.class);
    private static final AtomicLong STATEMENT_COUNTER = new AtomicLong();
    private String cursorName = null;
    protected boolean cursorOpen = false;
    private int maxRows = 0;
    private SQLWarning statementWarnings = null;
    private boolean calledgetResultSet = false;
    private boolean autoFree = false;
    protected boolean poolable = false;
    protected boolean isRsHoldable = false;
    protected final IfxConnection jconn;
    protected final IfxProtocol prot;
    public String commandString = null;
    protected IfxResultSet currentResult = null;
    boolean escapeProcessing = true;
    protected int numqmarks = 0;
    private int ResultSetType = 1003;
    private int ResultSetConcurrency = 1007;
    private int FetchSize = 0;
    private int FetchDirection = 1000;
    private int fetchBufferSize = 0;
    protected Vector<String> BatchVector = new Vector();
    protected final Vector<IfxObject> BatchParamVector = new Vector();
    protected boolean executeBatchInProgress = false;
    protected IfxResultSetMetaData outputMetaData = null;
    protected int statementType = 0;
    private int maxFieldSize;
    protected boolean Closed = false;
    protected int timeoutSeconds = 0;
    protected static final short SGK_NO_KEYS = 0;
    protected static final short SGK_ALL_KEYS = 1;
    protected static final short SGK_KEYS_BY_INDEX = 2;
    protected static final short SGK_KEYS_BY_NAME = 3;
    short SGK_returnGeneratedKeys = 0;
    protected int[] SGK_indexes = null;
    protected String[] SGK_names = null;
    protected IfxResultSetMetaData SGK_metaData = null;
    protected IfxClientResultSet SGK_resultSet = null;
    protected final PreparedStatementCache pool;
    protected Timer statementTimer = null;
    private boolean closeOnCompletion;
    protected final long statementId = STATEMENT_COUNTER.incrementAndGet();
    protected int rowsUpdated = -1;
    private byte[] ifxCursorBytes;

    IfxStatement(IfxConnection conn) throws SQLException {
        if (conn == null || conn.isClosed()) {
            throw Messages.getSQLException(-79730);
        }
        this.jconn = conn;
        this.autoFree = ((IfxSqliConnect)this.jconn).getAutoFree();
        this.pool = ((IfxSqliConnect)this.jconn).implicitCache;
        this.setResultSetHoldability(((IfxSqliConnect)this.jconn).isHoldable());
        this.prot = this.jconn.createProto();
        log.debug("Statement #{} created on Connection #{}", this.statementId, (Object)conn.getId());
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.executeQuery(sql, this.isRsHoldable());
    }

    @Override
    public ResultSet executeQuery(String sql, boolean withHold) throws SQLException {
        this.validate(sql);
        if (this.currentResult != null) {
            this.currentResult.closePrev();
            this.currentResult = null;
        }
        this.currentResult = new IfxResultSet(this, this.jconn, this.prot);
        log.debug("Executing statement #{} SQL: {}", this.statementId, (Object)sql);
        return this.executeQuery(withHold, false);
    }

    void validate(String sql) throws SQLException {
        if (sql == null) {
            throw Messages.getSQLException(-79726, this.jconn);
        }
        if (this.jconn.isClosed()) {
            throw Messages.getSQLException(-79730, this.jconn);
        }
        this.commandString = this.escapeProcessing ? NativeSQL.parseSQLString(this.jconn, sql) : sql;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.SGK_returnGeneratedKeys = 0;
        return this.executeUpdateBody(sql);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        log.trace("AutoGenKeys={}. SQL: {}", autoGeneratedKeys, (Object)sql);
        if (!(this.jconn instanceof IfxSqliConnect)) {
            throw Messages.getSQLException(-79882, ": Statement.executeUpdate(String, int)", this.jconn);
        }
        if (autoGeneratedKeys == 1) {
            this.SGK_returnGeneratedKeys = 1;
        } else if (autoGeneratedKeys == 2) {
            this.SGK_returnGeneratedKeys = 0;
        } else {
            throw Messages.getSQLException(-19841, ": Statement.executeUpdate(String, int)", this.jconn);
        }
        return this.executeUpdateBody(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        log.trace("Auto-gen key indexes: {}", columnIndexes);
        if (!(this.jconn instanceof IfxSqliConnect)) {
            throw Messages.getSQLException(-79882, ": Statement.executeUpdate(String, int[])", this.jconn);
        }
        if (columnIndexes == null || columnIndexes.length <= 0) {
            throw Messages.getSQLException(-19841, ": Statement.executeUpdate(String, int[])", this.jconn);
        }
        this.SGK_indexes = (int[])columnIndexes.clone();
        this.SGK_returnGeneratedKeys = (short)2;
        return this.executeUpdateBody(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        log.trace("Auto-gen key columns: {}", columnNames);
        if (!(this.jconn instanceof IfxSqliConnect)) {
            throw Messages.getSQLException(-79882, ": Statement.executeUpdate(String, String[])", this.jconn);
        }
        if (columnNames == null || columnNames.length <= 0) {
            throw Messages.getSQLException(-19841, ": Statement.executeUpdate(String, String[])", this.jconn);
        }
        this.SGK_names = (String[])columnNames.clone();
        this.SGK_returnGeneratedKeys = (short)3;
        return this.executeUpdateBody(sql);
    }

    private int executeUpdateBody(String sql) throws SQLException {
        log.debug("Executing statement #{} SQL: {}", this.statementId, (Object)sql);
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        this.validate(sql);
        if (this.currentResult != null) {
            this.currentResult.closePrev();
            this.currentResult = null;
        }
        return this.executeUpdateImpl();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (!(this.jconn instanceof IfxSqliConnect)) {
            throw Messages.getSQLException(-79882, ": Statement.getGeneratedKeys()", this.jconn);
        }
        IfxSqli sqliProto = (IfxSqli)this.prot;
        if (sqliProto.SGK_rowColumn == null) {
            IfxResultSetMetaData rsmd = new IfxResultSetMetaData(0, this.jconn);
            this.SGK_resultSet = new IfxClientResultSet(this.jconn, rsmd);
        } else {
            this.SGK_metaData = (IfxResultSetMetaData)sqliProto.getSGK_metaData();
            this.SGK_resultSet = new IfxClientResultSet(this.jconn, this.SGK_metaData);
            while (sqliProto.getNextSGKRow()) {
                this.SGK_resultSet.newRow(1);
                for (int i = 1; i <= this.SGK_metaData.getColumnCount(); ++i) {
                    IfxObject colObject = sqliProto.SGK_rowColumn.getColumn(i);
                    this.SGK_resultSet.updateIfxObject(i, (Object)colObject);
                }
            }
        }
        this.SGK_resultSet.beforeFirst();
        this.SGK_resultSet.setType(1003);
        this.SGK_resultSet.setFetchDirection(1000);
        this.SGK_resultSet.setConcurrency(1007);
        return this.SGK_resultSet;
    }

    @Override
    public void close() throws SQLException {
        if (this.Closed) {
            return;
        }
        log.debug("Closing Statement #{}", this.statementId);
        this.Closed = true;
        if (this.currentResult != null) {
            this.currentResult.close();
            this.currentResult = null;
        }
        if (this.cursorOpen) {
            log.trace("Closing open cursor");
            this.prot.executeClose(this);
        }
        this.prot.executeRelease(this);
        ((IfxSqliConnect)this.jconn).removeFromStmtList(this);
        this.cursorName = null;
        this.statementWarnings = null;
        this.commandString = null;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        if (max < 0) {
            throw Messages.getSQLException(-79877, this.jconn);
        }
        this.maxFieldSize = max;
    }

    @Override
    public int getMaxRows() throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        if (max < 0) {
            throw Messages.getSQLMinorException(-79731, -80007, this.jconn);
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        this.escapeProcessing = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        return this.timeoutSeconds;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        if (seconds >= 0) {
            this.timeoutSeconds = seconds;
            if (this.statementTimer == null) {
                this.statementTimer = this.jconn.getStatementTimer();
            }
        } else {
            throw Messages.getSQLException(-79773, this.jconn);
        }
    }

    @Override
    public void cancel() throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        try {
            ((IfxSqliConnect)this.jconn).asfconn.sOOBSocket();
        }
        catch (ASFException asf) {
            throw Messages.getSQLException(-908, this.jconn);
        }
    }

    private void addWarning(String message, String sqlstate) {
        this.chainWarnings(WarningMessages.getSQLWarning(sqlstate, message));
    }

    void chainWarnings(SQLWarning warn) {
        if (warn != null) {
            if (this.statementWarnings != null) {
                this.statementWarnings.setNextWarning(warn);
            } else {
                this.statementWarnings = warn;
            }
        }
    }

    protected void transferWarnings() throws SQLException {
        SQLWarning warn = this.prot.getWarnings();
        if (warn != null) {
            if (this.statementWarnings != null) {
                this.statementWarnings.setNextWarning(warn);
            } else {
                this.statementWarnings = warn;
            }
        }
        this.prot.clearWarnings();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        if (this.currentResult != null) {
            this.chainWarnings(this.currentResult.getWarnings());
        }
        return this.statementWarnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        this.prot.clearWarnings();
        this.statementWarnings = null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        if (name.length() <= 0) {
            throw Messages.getSQLException(-79732, this.jconn);
        }
        this.cursorName = name;
        this.ifxCursorBytes = JavaToIfxType.JavaToIfxChar(name, false);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.SGK_returnGeneratedKeys = 0;
        return this.executeBody(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (!(this.jconn instanceof IfxSqliConnect)) {
            throw Messages.getSQLException(-79882, ": Statement.execute(String, int)", this.jconn);
        }
        if (autoGeneratedKeys == 1) {
            this.SGK_returnGeneratedKeys = 1;
        } else if (autoGeneratedKeys == 2) {
            this.SGK_returnGeneratedKeys = 0;
        } else {
            throw Messages.getSQLException(-19841, ": Statement.executeUpdate(String, int)", this.jconn);
        }
        return this.executeBody(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (!(this.jconn instanceof IfxSqliConnect)) {
            throw Messages.getSQLException(-79882, ": Statement.execute(String, int[])", this.jconn);
        }
        if (columnIndexes == null || columnIndexes.length <= 0) {
            throw Messages.getSQLException(-19841, ": Statement.executeUpdate(String, int[])", this.jconn);
        }
        this.SGK_indexes = (int[])columnIndexes.clone();
        this.SGK_returnGeneratedKeys = (short)2;
        return this.executeBody(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        if (!(this.jconn instanceof IfxSqliConnect)) {
            throw Messages.getSQLException(-79882, ": Statement.execute(String, String[])", this.jconn);
        }
        if (columnNames == null || columnNames.length <= 0) {
            throw Messages.getSQLException(-19841, ": Statement.executeUpdate(String, String[])", this.jconn);
        }
        this.SGK_names = (String[])columnNames.clone();
        this.SGK_returnGeneratedKeys = (short)3;
        return this.executeBody(sql);
    }

    private boolean executeBody(String sql) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        log.debug("Executing statment #{}: {}", this.statementId, (Object)sql);
        this.validate(sql);
        if (this.currentResult != null) {
            this.currentResult.closePrev();
            this.currentResult = null;
        }
        this.currentResult = new IfxResultSet(this, this.jconn, this.prot);
        return this.executeImpl(this.isRsHoldable, false);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        if (this.getResultSetAlreadyCalled() || this.currentResult == null || this.currentResult.isClosed() || this.currentResult.getUpdateCount() != -1) {
            return null;
        }
        this.currentResult.getMetaData().setUppercaseMetaData(this.jconn.isUpperCaseMetaDataLabels());
        return this.currentResult;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        if (this.isClosed() || this.prot.isResultSet()) {
            return -1;
        }
        if (this.currentResult != null) {
            int toReturn = this.currentResult.getUpdateCount();
            this.currentResult.closePrev();
            this.currentResult = null;
            this.rowsUpdated = -1;
            return toReturn;
        }
        int toReturn = this.rowsUpdated;
        this.rowsUpdated = -1;
        return toReturn;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        if (this.currentResult != null) {
            this.currentResult.clearWarnings();
            this.currentResult.close();
        }
        this.resetMethodCalledFlags();
        this.rowsUpdated = -1;
        return false;
    }

    public String getCursorName() throws SQLException {
        if (this.cursorName == null) {
            this.cursorName = this.getConnection().getGeneratedCursor();
            this.ifxCursorBytes = JavaToIfxType.JavaToIfxChar(this.cursorName, false);
        }
        return this.cursorName;
    }

    public byte[] getIfxEncodedCursorName() throws SQLException {
        return this.ifxCursorBytes;
    }

    int getqmarks() {
        return this.numqmarks;
    }

    void setqmarks(int count) {
        this.numqmarks = count;
    }

    @Override
    public IfxConnection getConnection() throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        return this.jconn;
    }

    protected ResultSet executeQuery(boolean withHold, boolean withReOptimization) throws SQLException {
        if (this.jconn.isClosed()) {
            throw Messages.getSQLException(-79730);
        }
        if (!this.jconn.isDirect()) {
            ((IfxSqliConnect)this.jconn).closeFinalizedBlobsOnServer();
        }
        this.resetMethodCalledFlags();
        IfxCancelQueryImpl cancelTask = null;
        if (this.timeoutSeconds > 0) {
            cancelTask = new IfxCancelQueryImpl(this);
            this.statementTimer.schedule((TimerTask)cancelTask, (long)this.timeoutSeconds * 1000L);
        }
        try {
            this.currentResult.executeQuery(this.outputMetaData, withHold, withReOptimization);
        }
        catch (SQLException e) {
            try {
                if (e.getErrorCode() == -710) {
                    this.poolable = false;
                }
                throw e;
            }
            catch (Throwable throwable) {
                if (this.timeoutSeconds > 0 && cancelTask != null && !cancelTask.cancel()) {
                    throw new SQLTimeoutException(Messages.getErrorMessage(-80505, this.timeoutSeconds), Messages.getSQLSTATE(-80505), -80505);
                }
                if (this.statementTimer != null) {
                    this.statementTimer.purge();
                }
                throw throwable;
            }
        }
        if (this.timeoutSeconds > 0 && cancelTask != null && !cancelTask.cancel()) {
            throw new SQLTimeoutException(Messages.getErrorMessage(-80505, this.timeoutSeconds), Messages.getSQLSTATE(-80505), -80505);
        }
        if (this.statementTimer != null) {
            this.statementTimer.purge();
        }
        if (!this.jconn.isDirect()) {
            IfxSqli pr = (IfxSqli)this.prot;
            ((IfxSqliConnect)this.jconn).changeStmtId(this, pr.getStatementID());
        }
        this.transferWarnings();
        if (!withHold) {
            this.addResultSetToSvpt(this.currentResult);
        }
        this.currentResult.getMetaData().setUppercaseMetaData(this.jconn.isUpperCaseMetaDataLabels());
        return this.currentResult;
    }

    int executeUpdateImpl() throws SQLException {
        if (this.jconn.isClosed()) {
            throw Messages.getSQLException(-79730);
        }
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        this.resetMethodCalledFlags();
        int returnValue = 0;
        if (!this.jconn.isDirect()) {
            ((IfxSqliConnect)this.jconn).closeFinalizedBlobsOnServer();
        }
        IfxCancelQueryImpl cancelTask = null;
        if (this.timeoutSeconds > 0) {
            cancelTask = new IfxCancelQueryImpl(this);
            this.statementTimer.schedule((TimerTask)cancelTask, (long)this.timeoutSeconds * 1000L);
        }
        try {
            returnValue = this.executeUpdate2();
        }
        catch (SQLException e) {
            try {
                if (e.getErrorCode() == -710) {
                    this.poolable = false;
                }
                throw e;
            }
            catch (Throwable throwable) {
                if (this.timeoutSeconds > 0 && cancelTask != null && !cancelTask.cancel()) {
                    throw new SQLTimeoutException(Messages.getErrorMessage(-80505, this.timeoutSeconds), Messages.getSQLSTATE(-80505), -80505);
                }
                if (this.statementTimer != null) {
                    this.statementTimer.purge();
                }
                throw throwable;
            }
        }
        if (this.timeoutSeconds > 0 && cancelTask != null && !cancelTask.cancel()) {
            throw new SQLTimeoutException(Messages.getErrorMessage(-80505, this.timeoutSeconds), Messages.getSQLSTATE(-80505), -80505);
        }
        if (this.statementTimer != null) {
            this.statementTimer.purge();
        }
        if (returnValue == 0 && this.commandString.toLowerCase().indexOf("isolation") != -1) {
            ((IfxSqliConnect)this.jconn).setTxnIsolationLvl(this.commandString);
        }
        this.transferWarnings();
        return returnValue;
    }

    protected int executeUpdate2() throws SQLException {
        log.debug("Executing Statement #{}", this.statementId);
        this.clearWarnings();
        this.prot.clearSerialValues();
        if (this instanceof IfxPreparedStatement && !((IfxSqliConnect)this.jconn).usePut) {
            List<IfxObject> vec = this.executeBatchInProgress ? ((IfxPreparedStatement)this).getBatchParamVector() : ((IfxPreparedStatement)this).getVector();
            for (IfxObject ival : vec) {
                if (!(ival instanceof IfxSmBlob)) continue;
                IfxSmBlob sval = (IfxSmBlob)ival;
                short type = sval.blobType;
                if (type == 2 || type == 1) {
                    sval.createBlobOnServer(sval.BlobInputStream, sval.sm_size);
                    continue;
                }
                if (type != 3) continue;
                sval.createBlobOnServer(sval.BlobCharInputStream, sval.sm_size);
            }
        }
        this.prot.executeCommand(this);
        this.rowsUpdated = this.prot.getNumberOfRowsProcessed();
        return this.rowsUpdated;
    }

    boolean executeImpl(boolean holdable, boolean reOptimized) throws SQLException {
        boolean returnValue;
        this.resetMethodCalledFlags();
        if (!this.jconn.isDirect()) {
            ((IfxSqliConnect)this.jconn).closeFinalizedBlobsOnServer();
        }
        IfxCancelQueryImpl cancelTask = null;
        if (this.timeoutSeconds > 0) {
            cancelTask = new IfxCancelQueryImpl(this);
            this.statementTimer.schedule((TimerTask)cancelTask, (long)this.timeoutSeconds * 1000L);
        }
        try {
            returnValue = this.currentResult.executeExecute(holdable, reOptimized, this.outputMetaData);
        }
        catch (SQLException e) {
            try {
                if (e.getErrorCode() == -710) {
                    this.poolable = false;
                }
                throw e;
            }
            catch (Throwable throwable) {
                if (this.timeoutSeconds > 0 && cancelTask != null && !cancelTask.cancel()) {
                    throw new SQLTimeoutException(Messages.getErrorMessage(-80505, this.timeoutSeconds), Messages.getSQLSTATE(-80505), -80505);
                }
                if (this.statementTimer != null) {
                    this.statementTimer.purge();
                }
                throw throwable;
            }
        }
        if (this.timeoutSeconds > 0 && cancelTask != null && !cancelTask.cancel()) {
            throw new SQLTimeoutException(Messages.getErrorMessage(-80505, this.timeoutSeconds), Messages.getSQLSTATE(-80505), -80505);
        }
        if (this.statementTimer != null) {
            this.statementTimer.purge();
        }
        this.transferWarnings();
        if (this.jconn.getCatalog() == null) {
            this.jconn.getPreparedStatementCache().clear();
        }
        if (log.isDebugEnabled() && !returnValue) {
            log.debug("Statement #{} completed", this.statementId);
        }
        if (!returnValue) {
            this.rowsUpdated = this.prot.getNumberOfRowsProcessed();
        }
        return returnValue;
    }

    void resultSetClosed(IfxResultSet rs) throws SQLException {
        if (rs.equals(this.currentResult) && rs.isClosed() && this.closeOnCompletion) {
            this.currentResult = null;
            this.close();
        }
        if (this.autoFree) {
            this.Closed = true;
            ((IfxSqliConnect)this.jconn).removeFromStmtList(this);
        }
    }

    @Override
    public int getSerial() {
        return this.prot.getSerialInsert();
    }

    @Override
    public long getSerial8() throws SQLException {
        return this.prot.getSerial8Inserted();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865);
        }
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw Messages.getSQLException(-79764);
        }
        if (this.getResultSetType() == 1003 && direction != 1000) {
            throw Messages.getSQLException(-79765);
        }
        this.FetchDirection = direction;
    }

    @Override
    public int getFetchDirection() {
        return this.FetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        if (rows < 0 || this.maxRows != 0 && rows > this.maxRows) {
            throw Messages.getSQLException(-79766, this.jconn);
        }
        this.FetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.FetchSize;
    }

    @Override
    public int getResultSetConcurrency() {
        return this.ResultSetConcurrency;
    }

    @Override
    public int getResultSetType() {
        return this.ResultSetType;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        this.validate(sql);
        this.commandString = this.commandString.trim();
        if (!this.commandString.endsWith(";")) {
            this.commandString = this.commandString + ";";
        }
        this.BatchVector.addElement(this.commandString);
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        this.BatchVector.clear();
        this.scrubBatch();
    }

    protected void scrubBatch() {
        this.executeBatchInProgress = false;
        this.prot.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] statusArray = null;
        if (this.Closed) {
            throw Messages.getSQLException(-79865, this.jconn);
        }
        this.executeBatchInProgress = true;
        this.commandString = "";
        if (this.BatchVector.isEmpty()) {
            return new int[0];
        }
        for (int i = 0; i < this.BatchVector.size(); ++i) {
            this.commandString = this.commandString + this.BatchVector.elementAt(i);
        }
        if (!this.jconn.isDirect()) {
            try {
                int retval = this.executeUpdateImpl();
                ArrayList<Integer> BatchRowStatus = ((IfxSqli)this.prot).batchRowStatus;
                statusArray = new int[BatchRowStatus.size()];
                for (int k = 0; k < BatchRowStatus.size(); ++k) {
                    statusArray[k] = BatchRowStatus.get(k);
                }
                ((IfxSqli)this.prot).batchRowStatus.clear();
            }
            catch (SQLException e) {
                IfxSqli prot = (IfxSqli)this.prot;
                ArrayList<Integer> BatchRowStatus = prot.batchRowStatus;
                this.executeBatchInProgress = false;
                if (BatchRowStatus != null) {
                    statusArray = new int[BatchRowStatus.size()];
                    for (int k = 0; k < BatchRowStatus.size(); ++k) {
                        statusArray[k] = BatchRowStatus.get(k);
                    }
                    prot.batchRowStatus.clear();
                    this.clearBatch();
                    throw new BatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), statusArray);
                }
                this.clearBatch();
                throw new BatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), new int[0]);
            }
        }
        try {
            statusArray = new int[this.BatchVector.size()];
            statusArray[0] = this.executeUpdateImpl();
            for (int k = 1; k < this.BatchVector.size(); ++k) {
                statusArray[k] = -2;
            }
        }
        catch (SQLException e) {
            this.clearBatch();
            throw new BatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), new int[0]);
        }
        this.clearBatch();
        this.executeBatchInProgress = false;
        return statusArray;
    }

    protected void setResultSetType(int resultSetType) {
        if (resultSetType != 1004 && resultSetType != 1003) {
            this.addWarning(Messages.getSQLException(-79775, this.jconn).toString(), "01000");
        }
        this.ResultSetType = resultSetType == 1005 ? 1004 : resultSetType;
    }

    protected void setResultSetConcurrency(int resultSetConcurrencyType) throws SQLException {
        if (resultSetConcurrencyType != 1008 && resultSetConcurrencyType != 1007) {
            throw Messages.getSQLException(-79773, this.jconn);
        }
        this.ResultSetConcurrency = resultSetConcurrencyType;
    }

    @Override
    public void setAutoFree(boolean flag) {
        this.autoFree = flag;
    }

    void setResultSetHoldability(boolean rsHoldability) {
        this.isRsHoldable = rsHoldability;
    }

    @Override
    public boolean getAutoFree() {
        return this.autoFree;
    }

    protected void setStatementType(int stype) {
        this.statementType = stype;
    }

    public int getStatementType() {
        return this.statementType;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw Messages.getSQLException(-79700, ": Statement.getMoreResults(int)", this.jconn);
    }

    @Override
    public int getResultSetHoldability() {
        return this.isRsHoldable() ? 1 : 2;
    }

    boolean isRsHoldable() {
        return this.isRsHoldable;
    }

    protected boolean getResultSetAlreadyCalled() {
        if (!this.calledgetResultSet) {
            this.calledgetResultSet = true;
            return false;
        }
        return true;
    }

    protected void resetMethodCalledFlags() {
        this.calledgetResultSet = false;
    }

    void setIsReleased(boolean val) {
        IfxSqli sqliProto = (IfxSqli)this.prot;
        sqliProto.setIsReleased(val);
    }

    @Override
    public long getBigSerial() throws SQLException {
        return this.prot.getBigSerialInserted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResultSetToSvpt(ResultSet rs) {
        if (((IfxSqliConnect)this.jconn).svptList != null) {
            ArrayList<WeakReference<Savepoint>> arrayList = ((IfxSqliConnect)this.jconn).svptList;
            synchronized (arrayList) {
                WeakReference<Savepoint> weakSvpt = null;
                IfxSavepoint svpt = null;
                Iterator<WeakReference<Savepoint>> it = ((IfxSqliConnect)this.jconn).svptList.iterator();
                while (it.hasNext()) {
                    weakSvpt = it.next();
                    svpt = (IfxSavepoint)weakSvpt.get();
                    if (svpt == null) {
                        it.remove();
                        continue;
                    }
                    svpt.addResultSet(rs);
                }
            }
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.Closed || this.jconn.isClosed();
    }

    @Override
    public boolean isPoolable() {
        return this.poolable;
    }

    @Override
    public void setPoolable(boolean poolable) {
        this.poolable = poolable;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw Messages.getSQLException(-80053, this.jconn, this.getClass().getCanonicalName(), iface.getClass().getCanonicalName());
    }

    @Override
    public void setFetchBufferSize(int bufferSize) {
        this.fetchBufferSize = bufferSize;
    }

    @Override
    public int getFetchBufferSize() {
        return this.fetchBufferSize;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.closeOnCompletion;
    }

    @Override
    public Stream<IfxBSONObject> stream(String sql) throws SQLException {
        return this.stream(sql, STREAMS_FETCHING.USE_SPLITERATOR);
    }

    @Override
    public Stream<IfxBSONObject> stream(String sql, STREAMS_FETCHING fetchOption) throws SQLException {
        Objects.requireNonNull(sql);
        if (fetchOption == STREAMS_FETCHING.USE_SPLITERATOR) {
            return StreamSupport.stream(new ResultSetSpliterator(this.executeQuery(sql)), false);
        }
        ArrayList<IfxBSONObject> results = new ArrayList<IfxBSONObject>();
        try (ResultSet rs = this.executeQuery(sql);){
            while (rs.next()) {
                results.add(BsonUtils.convertCurrentResultSetRowToDocument(rs, rs.getMetaData(), -1));
            }
        }
        return results.stream();
    }

    public long getId() {
        return this.statementId;
    }

    public String toString() {
        return "Statement #" + this.statementId + " from Connection #" + this.jconn.getId();
    }

    public static class ResultSetSpliterator
    implements Spliterator<IfxBSONObject> {
        private final ResultSet rs;

        public ResultSetSpliterator(ResultSet rs) {
            Objects.requireNonNull(rs);
            this.rs = rs;
        }

        @Override
        public boolean tryAdvance(Consumer<? super IfxBSONObject> action) {
            try {
                if (this.rs.next()) {
                    action.accept(BsonUtils.convertCurrentResultSetRowToDocument(this.rs, this.rs.getMetaData(), -1));
                    return true;
                }
                this.rs.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            return false;
        }

        @Override
        public Spliterator<IfxBSONObject> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            try {
                return this.rs.isClosed() ? 0L : -1L;
            }
            catch (SQLException e) {
                return 0L;
            }
        }

        @Override
        public int characteristics() {
            return 0;
        }
    }
}

