/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.Version;
import com.informix.jdbcx.InformixDataSource;
import com.informix.lang.Messages;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class InformixDriver
implements Driver {
    private static final String PROTOCOL1 = "jdbc:informix://";
    private static final String PROTOCOL2 = "jdbc:onedb://";

    public static void addPropertiesFromURL(String url, Properties prop) throws SQLException {
        String[] strings = url.split(";");
        InformixDriver.processHostFromUrl(strings[0], prop);
        for (int i = 1; i < strings.length; ++i) {
            strings[i] = strings[i].trim();
            if (strings[i].isEmpty()) continue;
            if (!strings[i].contains("=")) {
                throw Messages.getSQLException(new IllegalArgumentException(strings[i]), -79705);
            }
            String[] param = strings[i].split("=");
            param[0] = param[0].trim();
            if (param.length == 2) {
                InformixDriver.setPropertyIfNotExists(prop, param[0], param[1]);
                continue;
            }
            if (param.length > 2) {
                if (param[0].toUpperCase().startsWith("sessionVariables".toUpperCase())) {
                    InformixDriver.setPropertyIfNotExists(prop, "sessionVariables", strings[i].substring(strings[i].indexOf(61) + 1));
                    continue;
                }
                throw Messages.getSQLException(new IllegalArgumentException(strings[i]), -79705);
            }
            throw Messages.getSQLException(new IllegalArgumentException(strings[i]), -79705);
        }
    }

    private static void setPropertyIfNotExists(Properties prop, String key, String value) {
        if (!prop.containsKey(key)) {
            prop.setProperty(key, value);
        }
    }

    private static void processHostFromUrl(String url, Properties prop) throws SQLException {
        if ((url = url.startsWith(PROTOCOL1) ? url.substring(PROTOCOL1.length()) : url.substring(PROTOCOL2.length())).indexOf(59) > -1) {
            url = url.substring(0, url.indexOf(59));
        }
        if (url.length() == 0) {
            return;
        }
        if (url.indexOf(47) > -1) {
            InformixDriver.setPropertyIfNotExists(prop, "DATABASE", url.substring(url.indexOf(47) + 1));
            url = url.substring(0, url.indexOf(47));
        }
        if (url.lastIndexOf(58) < 0) {
            throw Messages.getSQLException(new IllegalArgumentException("Missing ':' in network address"), -79705);
        }
        InformixDriver.setPropertyIfNotExists(prop, "PORT", url.substring(url.lastIndexOf(58) + 1));
        url = url.substring(0, url.lastIndexOf(58));
        InformixDriver.setPropertyIfNotExists(prop, "HOST", url);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        if (info == null) {
            info = new Properties();
        }
        InformixDataSource ds = new InformixDataSource();
        ds.putAll(info);
        InformixDriver.addPropertiesFromURL(url, ds);
        return ds.getConnection();
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url != null && (url.startsWith(PROTOCOL1) || url.startsWith(PROTOCOL2));
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        try {
            InformixDriver.class.getClassLoader().getResourceAsStream("");
            DriverManager.registerDriver(new InformixDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException("Unknown exception instantiating JDBC Driver", e);
        }
    }
}

