/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class Version {
    private static final String BUILD_INFORMATION_FILE = "com/informix/jdbc/jdbc-version.properties";
    private static final int majorVersion;
    private static final int minorVersion;
    private static final int serviceVersion;
    private static final int serviceSubVersion;
    private static final Date buildDate;
    private static final int buildNumber;
    private static final String vendor;
    private static final String betaVersion;
    private static final String commit;
    private static final String supportVersion;

    public static void main(String[] args) {
        System.out.println(Version.getVersionAsString());
    }

    public static String getVersionAsString() {
        StringBuilder sb = new StringBuilder("Product-Name: " + vendor + " JDBC Driver\n");
        sb.append("Build-Version: " + majorVersion + '.' + minorVersion + '.' + serviceVersion + '.' + serviceSubVersion + '\n');
        sb.append("Build-Number: " + buildNumber + '\n');
        sb.append("Build-Date: " + (buildDate == null ? "" : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(buildDate)) + '\n');
        if (!betaVersion.trim().isEmpty()) {
            sb.append("Beta-Version: " + betaVersion + '\n');
        }
        if (!supportVersion.isEmpty()) {
            sb.append("Support-Version: " + supportVersion + '\n');
        }
        if (!commit.isEmpty()) {
            sb.append("Commit: " + commit);
        }
        return sb.toString().trim();
    }

    public static int getMajorVersion() {
        return majorVersion;
    }

    public static int getMinorVersion() {
        return minorVersion;
    }

    public static int getServiceVersion() {
        return serviceVersion;
    }

    public static int getServiceSubVersion() {
        return serviceSubVersion;
    }

    public static int getBuildNumber() {
        return buildNumber;
    }

    public static Date getBuildDate() {
        return buildDate;
    }

    public static String getVendor() {
        return vendor;
    }

    public static String getLegacyVersionString() {
        String toReturn = "" + majorVersion + '.' + minorVersion + "." + serviceVersion;
        if (serviceSubVersion > 0) {
            toReturn = toReturn + "." + serviceSubVersion;
        }
        if (!betaVersion.isEmpty()) {
            toReturn = toReturn + betaVersion;
        }
        toReturn = toReturn + supportVersion;
        return toReturn;
    }

    static {
        String v;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        int major = 8;
        int minor = 0;
        int service = 0;
        int subservice = 0;
        int build = 0;
        Date date = null;
        String commitLine = "";
        String supportVersionId = "";
        String versionForBeta = "";
        Properties p = new Properties();
        URL url = Version.class.getClassLoader().getResource(BUILD_INFORMATION_FILE);
        if (url != null) {
            try (InputStream is = Version.class.getClassLoader().getResource(BUILD_INFORMATION_FILE).openStream();){
                String[] versionSplit;
                p.load(is);
                String version = p.getProperty("version", "-1.-1.-1");
                if (version.indexOf(45) > 0) {
                    versionForBeta = version.substring(version.indexOf(45) + 1, version.length());
                    version = version.substring(0, version.indexOf(45));
                }
                if ((versionSplit = version.split("\\.")).length != 3 && versionSplit.length != 4) {
                    throw new RuntimeException("Incorrect number of properties for build file:  com/informix/jdbc/jdbc-version.properties");
                }
                major = Integer.parseInt(versionSplit[0]);
                minor = Integer.parseInt(versionSplit[1]);
                service = Integer.parseInt(versionSplit[2]);
                if (versionSplit.length == 4) {
                    subservice = Integer.parseInt(versionSplit[3]);
                }
                date = dateFormat.parse(p.getProperty("build-date"));
                build = Integer.parseInt(p.getProperty("build-number", "0"));
                commitLine = p.getProperty("commit", "");
                supportVersionId = p.getProperty("support-version", "");
            }
            catch (Exception e) {
                System.err.println("Exception reading properties file: " + e.getMessage());
            }
        }
        vendor = (v = p.getProperty("vendor", "IBM")) == null || v.isEmpty() ? v : v.toUpperCase();
        majorVersion = major;
        minorVersion = minor;
        serviceVersion = service;
        buildDate = date;
        buildNumber = build;
        serviceSubVersion = subservice;
        betaVersion = versionForBeta;
        commit = commitLine;
        supportVersion = supportVersionId;
    }
}

