/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.stream.cdc;

import com.informix.jdbc.IfmxTableDescriptor;
import com.informix.jdbc.IfxSmartBlob;
import com.informix.jdbc.stream.api.StreamEngine;
import com.informix.jdbc.stream.api.StreamRecord;
import com.informix.jdbc.stream.cdc.CDCRecordBuilder;
import com.informix.jdbc.stream.impl.StreamException;
import com.informix.lang.Messages;
import com.informix.util.JdbcLogger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;

public class CDCEngine
implements StreamEngine {
    private final JdbcLogger logger = JdbcLogger.getLogger(CDCEngine.class);
    private final Builder builder;
    private IfxSmartBlob smartBlob;
    private final Connection con;
    private int sessionID;
    private final int bufferSize;
    private final byte[] buffer;
    private final CDCRecordBuilder recordBuilder;
    private final int timeout;
    private final List<IfmxWatchedTable> capturedTables = new ArrayList<IfmxWatchedTable>();
    private final boolean stopLoggingOnClose;
    private boolean inlineLOB = false;
    private boolean isClosed = false;
    private final long startingSequencePosition;

    public static Builder builder(DataSource ds) {
        return new Builder(ds);
    }

    private static String buildExceptionMessage(String message, int errorCode) {
        return message + ": " + Messages.getMessage(errorCode);
    }

    private CDCEngine(Builder builder) throws SQLException {
        this.builder = builder;
        this.con = builder.ds.getConnection();
        this.recordBuilder = new CDCRecordBuilder(builder.ds.getConnection());
        this.timeout = builder.getTimeout();
        this.bufferSize = builder.getBufferSize();
        this.buffer = new byte[this.bufferSize];
        this.startingSequencePosition = builder.getSequenceId();
        this.capturedTables.addAll(builder.getWatchedTables());
        this.stopLoggingOnClose = builder.stopLoggingOnClose;
    }

    @Override
    public void init() throws SQLException, StreamException {
        String serverName;
        Throwable throwable;
        ResultSet rs;
        String serverType = this.con.getMetaData().getDatabaseProductName().equalsIgnoreCase("OneDB") ? "ONEDB_SERVER" : "INFORMIXSERVER";
        try (PreparedStatement ps = this.con.prepareStatement("SELECT env_value FROM sysmaster:sysenv where env_name = ?");){
            ps.setString(1, serverType);
            rs = ps.executeQuery();
            throwable = null;
            try {
                rs.next();
                serverName = rs.getString(1).trim();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        this.logger.debug("Server name detected: {}", (Object)serverName);
        var4_3 = null;
        try (CallableStatement cstmt = this.con.prepareCall("execute function informix.cdc_opensess(?,?,?,?,?,?)");){
            cstmt.setString(1, serverName);
            cstmt.setInt(2, 0);
            cstmt.setInt(3, this.timeout);
            cstmt.setInt(4, 1);
            cstmt.setInt(5, 1);
            cstmt.setInt(6, 1);
            rs = cstmt.executeQuery();
            throwable = null;
            try {
                rs.next();
                this.sessionID = rs.getInt(1);
                if (this.sessionID < 0) {
                    throw new StreamException(CDCEngine.buildExceptionMessage("Unable to create CDC session", this.sessionID), this.sessionID);
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var4_3 = throwable6;
            throw throwable6;
        }
        this.smartBlob = new IfxSmartBlob(this.con);
        for (IfmxWatchedTable table : this.capturedTables) {
            this.watchTable(table);
        }
        this.activateSession();
    }

    @Override
    public StreamRecord getRecord() throws SQLException, StreamException {
        int length = this.smartBlob.IfxLoRead(this.sessionID, this.buffer, this.buffer.length);
        if (length > -1) {
            StreamRecord r = this.recordBuilder.buildRecord(this.buffer);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("{}", r);
            }
            return r;
        }
        throw new StreamException("IfxLoRead returned -1, no more data?");
    }

    private void watchTable(IfmxWatchedTable table) throws SQLException, StreamException {
        this.logger.debug("Starting watch on table [{}]", table);
        this.setFullRowLogging(table.getDesciptorString(), true);
        this.startCapture(table);
    }

    private void setFullRowLogging(String tableName, boolean enable) throws StreamException {
        this.logger.debug("Setting full row logging on [{}] to '{}'", (Object)tableName, (Object)enable);
        try (CallableStatement cstmt = this.con.prepareCall("execute function informix.cdc_set_fullrowlogging(?,?)");){
            cstmt.setString(1, tableName);
            if (enable) {
                cstmt.setInt(2, 1);
            } else {
                cstmt.setInt(2, 0);
            }
            try (ResultSet rs = cstmt.executeQuery();){
                rs.next();
                int resultCode = rs.getInt(1);
                if (resultCode != 0) {
                    throw new StreamException(CDCEngine.buildExceptionMessage("Unable to set full row logging", resultCode), resultCode);
                }
            }
        }
        catch (SQLException ex) {
            throw new StreamException("Unable to set full row logging ", ex);
        }
    }

    private void startCapture(IfmxWatchedTable table) throws StreamException, SQLException {
        Throwable throwable;
        ResultSet rs2;
        Throwable throwable2;
        if (table.getColumnDescriptorString().equals("*")) {
            this.logger.debug("Starting column lookup for [{}]", (Object)table.getDesciptorString());
            throwable2 = null;
            try (Statement s = this.con.createStatement(1003, 1007);){
                rs2 = s.executeQuery("SELECT FIRST 1 * FROM " + table.getDesciptorString());
                throwable = null;
                try {
                    ResultSetMetaData md = rs2.getMetaData();
                    String[] columns = new String[md.getColumnCount()];
                    for (int i = 1; i <= md.getColumnCount(); ++i) {
                        columns[i - 1] = md.getColumnName(i).trim();
                    }
                    this.logger.debug("Dynamically adding to table [{}] columns: {}", (Object)table.getDesciptorString(), (Object)columns);
                    table.columns(columns);
                }
                catch (Throwable md) {
                    throwable = md;
                    throw md;
                }
                finally {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable md) {
                                throwable.addSuppressed(md);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                }
            }
            catch (Throwable rs2) {
                throwable2 = rs2;
                throw rs2;
            }
        }
        this.logger.debug("Starting capture on [{}]", table);
        try {
            throwable2 = null;
            try (CallableStatement cstmt = this.con.prepareCall("execute function informix.cdc_startcapture(?,?,?,?,?)");){
                cstmt.setInt(1, this.sessionID);
                cstmt.setLong(2, 0L);
                cstmt.setString(3, table.getDesciptorString());
                cstmt.setString(4, table.getColumnDescriptorString());
                cstmt.setInt(5, table.getLabel());
                rs2 = cstmt.executeQuery();
                throwable = null;
                try {
                    rs2.next();
                    int resultCode = rs2.getInt(1);
                    if (resultCode != 0) {
                        throw new StreamException(CDCEngine.buildExceptionMessage("Unable to start cdc capture", 83723), resultCode);
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
        }
        catch (SQLException ex) {
            throw new SQLException("CDCConnection: Unable to start cdc capture ", ex);
        }
    }

    private void unwatchTable(IfmxWatchedTable table) throws StreamException {
        this.endCapture(table);
        if (this.stopLoggingOnClose) {
            this.setFullRowLogging(table.getDesciptorString(), false);
        }
    }

    private void endCapture(IfmxWatchedTable table) throws StreamException {
        try (CallableStatement cstmt = this.con.prepareCall("execute function informix.cdc_endcapture(?,0,?)");){
            cstmt.setInt(1, this.sessionID);
            cstmt.setString(2, table.getDesciptorString());
            try (ResultSet rs = cstmt.executeQuery();){
                rs.next();
                int resultCode = rs.getInt(1);
                if (resultCode != 0) {
                    throw new StreamException(CDCEngine.buildExceptionMessage("Unable to end cdc capture", resultCode), resultCode);
                }
            }
        }
        catch (SQLException ex) {
            throw new StreamException("Unable to end cdc capture ", ex);
        }
    }

    private void activateSession() throws StreamException {
        this.logger.debug("Activating CDC session");
        try (CallableStatement cstmt = this.con.prepareCall("execute function informix.cdc_activatesess(?,?)");){
            cstmt.setInt(1, this.sessionID);
            cstmt.setLong(2, this.startingSequencePosition);
            try (ResultSet rs = cstmt.executeQuery();){
                rs.next();
                int resultCode = rs.getInt(1);
                if (resultCode != 0) {
                    throw new StreamException(CDCEngine.buildExceptionMessage("Unable to activate session", resultCode), resultCode);
                }
            }
        }
        catch (SQLException ex) {
            throw new StreamException("Unable to activate session", ex);
        }
    }

    private void closeSession() throws StreamException {
        this.logger.debug("Closing CDC session");
        try (CallableStatement cstmt = this.con.prepareCall("execute function informix.cdc_closesess(?)");){
            cstmt.setInt(1, this.sessionID);
            try (ResultSet rs = cstmt.executeQuery();){
                rs.next();
                int resultCode = rs.getInt(1);
                if (resultCode != 0) {
                    throw new StreamException(CDCEngine.buildExceptionMessage("Unable to close session", resultCode), resultCode);
                }
            }
        }
        catch (SQLException ex) {
            throw new StreamException("Unable to close session", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws StreamException {
        if (this.isClosed) {
            return;
        }
        this.logger.debug("Closing down CDC engine");
        StreamException e = null;
        try {
            for (IfmxWatchedTable capturedTable : this.capturedTables) {
                this.unwatchTable(capturedTable);
            }
            this.closeSession();
        }
        catch (StreamException ee) {
            e = ee;
        }
        finally {
            StreamException se;
            this.isClosed = true;
            try {
                this.con.close();
            }
            catch (SQLException ee) {
                se = new StreamException("Could not close main connection", ee);
                if (e == null) {
                    e = se;
                }
                e.addSuppressed(se);
            }
            try {
                this.recordBuilder.close();
            }
            catch (SQLException ee) {
                se = new StreamException("Could not close record builder", ee);
                if (e == null) {
                    e = se;
                }
                e.addSuppressed(se);
            }
        }
        if (e != null) {
            throw e;
        }
    }

    public boolean isInlineLOB() {
        return this.inlineLOB;
    }

    public Builder getBuilder() {
        return this.builder;
    }

    public static class Builder {
        private final DataSource ds;
        private final List<IfmxWatchedTable> tables = new ArrayList<IfmxWatchedTable>();
        private int timeout = 5;
        private int buffer = 10240;
        private long sequencePosition = 0L;
        private boolean stopLoggingOnClose = true;

        public Builder(DataSource ds) {
            this.ds = ds;
        }

        public Builder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder buffer(int bufferSize) {
            this.buffer = bufferSize;
            return this;
        }

        public int getBufferSize() {
            return this.buffer;
        }

        public Builder watchTable(String canonicalTableName, String ... columns) {
            return this.watchTable(IfmxTableDescriptor.parse(canonicalTableName), columns);
        }

        public Builder watchTable(IfmxTableDescriptor desc, String ... columns) {
            this.tables.add(new IfmxWatchedTable(desc).columns(columns));
            return this;
        }

        public Builder watchTable(IfmxWatchedTable table) {
            this.tables.add(table);
            return this;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public List<IfmxWatchedTable> getWatchedTables() {
            return this.tables;
        }

        public DataSource getDataSource() {
            return this.ds;
        }

        public Builder sequenceId(long position) {
            this.sequencePosition = position;
            return this;
        }

        public long getSequenceId() {
            return this.sequencePosition;
        }

        public Builder stopLoggingOnClose(boolean stopOnClose) {
            this.stopLoggingOnClose = stopOnClose;
            return this;
        }

        public CDCEngine build() throws SQLException {
            return new CDCEngine(this);
        }
    }

    public static class IfmxWatchedTable
    extends IfmxTableDescriptor {
        private static final AtomicInteger counter = new AtomicInteger(1);
        private int label = counter.getAndIncrement();
        private String[] columns;

        public IfmxWatchedTable(String databaseName, String namespace, String tableName) {
            super(databaseName, namespace, tableName);
        }

        public IfmxWatchedTable(IfmxTableDescriptor desc) {
            super(desc.getDatabaseName(), desc.getNamespace(), desc.getTableName());
        }

        public String getColumnDescriptorString() {
            return String.join((CharSequence)",", this.columns);
        }

        public String[] getColumns() {
            return this.columns;
        }

        public IfmxWatchedTable columns(String[] columns) {
            this.columns = columns;
            return this;
        }

        public IfmxWatchedTable label(int label) {
            if (label < 0) {
                throw new IllegalArgumentException("Label must be a positive number");
            }
            this.label = label;
            return this;
        }

        public int getLabel() {
            return this.label;
        }

        @Override
        public String toString() {
            return super.toString() + "::" + this.getColumnDescriptorString();
        }
    }
}

