/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.udt.timeseries;

import java.util.concurrent.CopyOnWriteArrayList;

public abstract class MemoizingCache<T> {
    private final CopyOnWriteArrayList<T> cache = new CopyOnWriteArrayList();

    public T getValue(int index) {
        if (index + 1 > this.cache.size()) {
            this.expandCacheSize(index);
        }
        return this.cache.get(index);
    }

    private synchronized void expandCacheSize(int size) {
        int desiredSize = size + 1;
        if (desiredSize <= this.cache.size()) {
            return;
        }
        for (int i = this.cache.size(); i < desiredSize; ++i) {
            this.cache.add(this.build(i));
        }
    }

    public abstract T build(int var1);
}

