/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.udt.timeseries.field.definition;

import com.informix.jdbc.IfmxUDTSQLInput;
import com.informix.jdbc.IfmxUDTSQLOutput;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.udt.timeseries.field.definition.AbstractInformixFieldDefinition;
import com.informix.jdbc.udt.timeseries.field.definition.ObjectConversionUtilities;
import com.informix.jdbc.udt.timeseries.field.definition.TimeSeriesFieldDefinition;
import com.informix.jdbc.udt.timeseries.field.definition.TimeSeriesFieldDefinitionFactory;
import com.informix.jdbc.udt.timeseries.field.definition.TimeSeriesFieldType;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;

public class DateTimeSeriesFieldDefinition
extends AbstractInformixFieldDefinition<Date>
implements TimeSeriesFieldDefinition<Date> {
    public DateTimeSeriesFieldDefinition() {
        super(TimeSeriesFieldType.DATE);
    }

    public static DateTimeSeriesFieldDefinition parseFieldDefinition(String s) {
        String trimmed = s.trim();
        if (trimmed.equalsIgnoreCase(TimeSeriesFieldType.DATE.getInformixTypeName())) {
            return new DateTimeSeriesFieldDefinition();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Date read(IfmxUDTSQLInput stream, IfxResultSetMetaData metaData, Integer index) throws SQLException {
        return stream.readDate();
    }

    @Override
    public void write(IfmxUDTSQLOutput stream, Date value) throws SQLException {
        if (value instanceof java.sql.Date) {
            stream.writeDate((java.sql.Date)value);
        } else {
            java.sql.Date sqlDate = new java.sql.Date(value.getTime());
            stream.writeDate(sqlDate);
        }
    }

    @Override
    public String convertValueToString(Object value) {
        if (value == null) {
            return "null::date";
        }
        if (value instanceof Calendar) {
            Calendar c = (Calendar)value;
            StringBuilder sb = new StringBuilder();
            sb.append('\'');
            sb.append(c.get(1));
            sb.append('-');
            sb.append(c.get(2));
            sb.append('-');
            sb.append(c.get(5));
            sb.append('\'');
            sb.append("::");
            sb.append(this.toSqlString());
            return sb.toString();
        }
        if (value instanceof Date) {
            Date d = (Date)value;
            StringBuilder sb = new StringBuilder();
            sb.append('\'');
            sb.append(d.getYear());
            sb.append('-');
            sb.append(d.getMonth());
            sb.append('-');
            sb.append(d.getDate());
            sb.append("::");
            sb.append(this.toSqlString());
            return sb.toString();
        }
        throw new IllegalArgumentException(MessageFormat.format("the value must be of type {0} (was {1})", Date.class, value.getClass()));
    }

    @Override
    public java.sql.Date convertValueTo(Object value) throws IllegalArgumentException {
        if (value == null || value instanceof java.sql.Date) {
            return (java.sql.Date)value;
        }
        Long l = ObjectConversionUtilities.convertObjectToLong(value, java.sql.Date.class.getName());
        return new java.sql.Date(l);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DateTimeSeriesFieldDefinition []");
        return builder.toString();
    }

    public static class Factory
    implements TimeSeriesFieldDefinitionFactory<Date> {
        @Override
        public TimeSeriesFieldDefinition<Date> parse(String s) {
            return DateTimeSeriesFieldDefinition.parseFieldDefinition(s);
        }
    }
}

