/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.udt.timeseries.loader;

import com.informix.jdbc.udt.timeseries.loader.ICalendarParser;
import java.text.ParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class Iso8601CalendarParser
implements ICalendarParser {
    @Override
    public Calendar parse(String input) throws ParseException {
        if (input == null) {
            throw new NullPointerException("input must not be null");
        }
        if (input.trim().length() == 0) {
            throw new ParseException("input must not be empty", 0);
        }
        if (input.matches("^(\\+|-)?\\d+L$")) {
            int end = input.length();
            long millis = Long.parseLong(input.substring(0, end - 1));
            GregorianCalendar gc = new GregorianCalendar(1979, 0, 1);
            gc.setTimeInMillis(millis);
            return gc;
        }
        if (input.matches("^\\d{4}$")) {
            int year = Integer.parseInt(input);
            return new GregorianCalendar(year, 0, 1);
        }
        if (input.matches("^\\d{4}-\\d{1,2}$")) {
            String[] ym = input.split("-");
            int year = Integer.parseInt(ym[0]);
            int month = Integer.parseInt(ym[1]);
            return new GregorianCalendar(year, month - 1, 1);
        }
        if (input.matches("\\d{4}-\\d{1,2}-\\d{1,2}")) {
            String[] ymd = input.split("-");
            int year = Integer.parseInt(ymd[0]);
            int month = Integer.parseInt(ymd[1]);
            int day = Integer.parseInt(ymd[2]);
            return new GregorianCalendar(year, month - 1, day);
        }
        if (input.matches("\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}")) {
            String[] ymd = input.split(" ")[0].split("-");
            int year = Integer.parseInt(ymd[0]);
            int month = Integer.parseInt(ymd[1]);
            int day = Integer.parseInt(ymd[2]);
            String[] hm = input.split(" ")[1].split(":");
            int hour = Integer.parseInt(hm[0]);
            int minute = Integer.parseInt(hm[1]);
            return new GregorianCalendar(year, month - 1, day, hour, minute);
        }
        if (input.matches("\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}")) {
            String[] ymd = input.split(" ")[0].split("-");
            int year = Integer.parseInt(ymd[0]);
            int month = Integer.parseInt(ymd[1]);
            int day = Integer.parseInt(ymd[2]);
            String[] hms = input.split(" ")[1].split(":");
            int hour = Integer.parseInt(hms[0]);
            int minute = Integer.parseInt(hms[1]);
            int second = Integer.parseInt(hms[2]);
            return new GregorianCalendar(year, month - 1, day, hour, minute, second);
        }
        if (input.matches("\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}.\\d{1,3}")) {
            String[] ymd = input.split(" ")[0].split("-");
            int year = Integer.parseInt(ymd[0]);
            int month = Integer.parseInt(ymd[1]);
            int day = Integer.parseInt(ymd[2]);
            String[] hms = input.split(" ")[1].split(":");
            int hour = Integer.parseInt(hms[0]);
            int minute = Integer.parseInt(hms[1]);
            String[] SSsss = hms[2].split("\\.");
            int second = Integer.parseInt(SSsss[0]);
            int milliseconds = Integer.parseInt(SSsss[1]);
            if (SSsss[1].length() == 1) {
                milliseconds *= 100;
            } else if (SSsss[1].length() == 2) {
                milliseconds *= 10;
            }
            GregorianCalendar gc = new GregorianCalendar(year, month - 1, day, hour, minute, second);
            gc.set(14, milliseconds);
            return gc;
        }
        if (input.matches("\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{1,2}:\\d{1,2}.\\d{1,3}")) {
            String[] ymd = input.split("T")[0].split("-");
            int year = Integer.parseInt(ymd[0]);
            int month = Integer.parseInt(ymd[1]);
            int day = Integer.parseInt(ymd[2]);
            String[] hms = input.split("T")[1].split(":");
            int hour = Integer.parseInt(hms[0]);
            int minute = Integer.parseInt(hms[1]);
            String[] SSsss = hms[2].split("\\.");
            int second = Integer.parseInt(SSsss[0]);
            if (SSsss[1].indexOf(43) != -1) {
                SSsss[1] = SSsss[1].substring(0, SSsss[1].indexOf(43));
            }
            int milliseconds = Integer.parseInt(SSsss[1]);
            if (SSsss[1].length() == 1) {
                milliseconds *= 100;
            } else if (SSsss[1].length() == 2) {
                milliseconds *= 10;
            }
            GregorianCalendar gc = new GregorianCalendar(year, month - 1, day, hour, minute, second);
            gc.set(14, milliseconds);
            return gc;
        }
        throw new ParseException(input, 0);
    }
}

