/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbcx;

import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbcx.IfxConnectionPoolDataSource;
import com.informix.jdbcx.IfxReUsableConnection;
import com.informix.jdbcx.IfxSqliConnReUsableConnection;
import com.informix.lang.Messages;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class IfxPooledConnection
implements PooledConnection {
    private final Vector<ConnectionEventListener> listeners = new Vector();
    private Properties DSProp = null;
    private IfxReUsableConnection conn = null;
    private IfxConnectionPoolDataSource cpds = null;
    protected long timeInPool = 0L;

    public IfxPooledConnection() throws SQLException {
        this.DSProp = null;
        this.conn = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IfxPooledConnection(String luser, String lpasswd, IfxConnectionPoolDataSource tcpds) throws SQLException {
        int limit;
        this.cpds = tcpds;
        this.conn = null;
        this.DSProp = this.cpds.getDsProperties();
        String value = this.DSProp.getProperty("IFMX_CPM_MAX_CONNECTIONS");
        if (value == null || value.length() == 0) {
            value = "-1";
        }
        if ((limit = Integer.parseInt(value)) != -1 && this.cpds.getConnectionCount() >= limit) {
            throw Messages.getLocSQLException(-79831, this.cpds.getIfxCLIENT_LOCALE());
        }
        this.establishConnection(luser, lpasswd);
        Properties properties = this.DSProp;
        synchronized (properties) {
            this.cpds.addToReferenceList(this);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.conn != null) {
            ((IfxSqliConnect)((Object)this.conn)).setOpen(true);
        }
        return (Connection)((Object)this.conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.conn == null) {
            return;
        }
        IfxConnectionPoolDataSource ifxConnectionPoolDataSource = this.cpds;
        synchronized (ifxConnectionPoolDataSource) {
            try {
                this.conn.hardClose();
            }
            finally {
                this.cpds.removeFromReferenceList(this);
            }
        }
        this.conn = null;
    }

    @Override
    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.addElement(listener);
    }

    @Override
    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.removeElement(listener);
    }

    void notifyListeners() {
        this.notifyListenersOfErrors(null);
    }

    void notifyListenersOfErrors(SQLException e) {
        ConnectionEventListener eventListener = null;
        Vector clonedListener = null;
        clonedListener = (Vector)this.listeners.clone();
        for (int i = 0; i < clonedListener.size(); ++i) {
            eventListener = (ConnectionEventListener)clonedListener.get(i);
            if (e == null) {
                eventListener.connectionClosed(new ConnectionEvent(this));
                continue;
            }
            eventListener.connectionErrorOccurred(new ConnectionEvent(this, e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void establishConnection(String luser, String lpasswd) throws SQLException {
        String urlString = null;
        String dbName = null;
        String host = null;
        String port = null;
        host = this.DSProp.getProperty("IFXHOST");
        port = this.DSProp.getProperty("PORTNO");
        if (host != null && port != null) {
            urlString = host + ":" + port;
        }
        if ((dbName = this.DSProp.getProperty("DATABASE")) != null) {
            try {
                this.conn = this.getClientServerReUsable(luser, lpasswd, urlString, dbName);
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw Messages.getLocSQLException(-79716, e.toString(), this.cpds.getIfxCLIENT_LOCALE());
            }
            finally {
                Properties properties = this.DSProp;
                synchronized (properties) {
                    this.DSProp.setProperty("DATABASE", dbName);
                }
            }
        }
        throw Messages.getLocSQLException(-79716, "Missing DATABASE Property", this.cpds.getIfxCLIENT_LOCALE());
    }

    public void setTimeInPool() {
        this.timeInPool = System.currentTimeMillis();
    }

    private IfxReUsableConnection getClientServerReUsable(String luser, String lpasswd, String urlString, String dbName) throws SQLException {
        if (!this.cpds.checkIsDirect()) {
            IfxSqliConnReUsableConnection scrc = null;
            scrc = new IfxSqliConnReUsableConnection(luser, lpasswd, this, urlString, this.DSProp, dbName);
            return scrc;
        }
        Constructor<?> directReUsableCons = this.cpds.getReUsableCons();
        Object[] objs = new Object[]{this, urlString, this.DSProp, dbName};
        if (directReUsableCons != null) {
            try {
                this.conn = (IfxReUsableConnection)directReUsableCons.newInstance(objs);
                return this.conn;
            }
            catch (Exception e) {
                throw Messages.getSQLException(e, -79716);
            }
        }
        try {
            String className = "com.informix.jdbcx.IfxDirConnReUsableConnection";
            Class<?> clsRef = Class.forName(className);
            if (urlString == null) {
                urlString = "";
            }
            if (dbName == null) {
                dbName = "";
            }
            Class[] classArgs = new Class[]{this.getClass(), urlString.getClass(), this.DSProp.getClass(), dbName.getClass()};
            Constructor<?> cons = clsRef.getConstructor(classArgs);
            this.cpds.setReUsableCons(cons);
            this.conn = (IfxReUsableConnection)cons.newInstance(objs);
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
        return this.conn;
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
    }
}

