/*
 * Decompiled with CFR 0.152.
 */
package com.informix.lang;

import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class IfxTypes {
    public static final short IFX_TYPE_CHAR = 0;
    public static final short IFX_TYPE_SMALLINT = 1;
    public static final short IFX_TYPE_INT = 2;
    public static final short IFX_TYPE_FLOAT = 3;
    public static final short IFX_TYPE_SMFLOAT = 4;
    public static final short IFX_TYPE_DECIMAL = 5;
    public static final short IFX_TYPE_SERIAL = 6;
    public static final short IFX_TYPE_DATE = 7;
    public static final short IFX_TYPE_MONEY = 8;
    public static final short IFX_TYPE_NULL = 9;
    public static final short IFX_TYPE_DATETIME = 10;
    public static final short IFX_TYPE_BYTE = 11;
    public static final short IFX_TYPE_TEXT = 12;
    public static final short IFX_TYPE_VARCHAR = 13;
    public static final short IFX_TYPE_INTERVAL = 14;
    public static final short IFX_TYPE_NCHAR = 15;
    public static final short IFX_TYPE_NVCHAR = 16;
    public static final short IFX_TYPE_INT8 = 17;
    public static final short IFX_TYPE_SERIAL8 = 18;
    public static final short IFX_TYPE_SET = 19;
    public static final short IFX_TYPE_MULTISET = 20;
    public static final short IFX_TYPE_LIST = 21;
    public static final short IFX_TYPE_ROW = 22;
    public static final short IFX_TYPE_COLLECTION = 23;
    public static final short IFX_TYPE_ROWREF = 24;
    public static final short IFX_TYPE_UDTVAR = 40;
    public static final short IFX_TYPE_UDTFIXED = 41;
    public static final short IFX_TYPE_REFSER8 = 42;
    public static final short IFX_TYPE_LVARCHAR = 43;
    public static final short IFX_TYPE_SENDRECV = 44;
    public static final short IFX_TYPE_BOOL = 45;
    public static final short IFX_TYPE_IMPEXP = 46;
    public static final short IFX_TYPE_IMPEXPBIN = 47;
    public static final short IFX_TYPE_SQLUDRDEFAULT = 48;
    public static final short IFX_TYPE_UNKNOWN = 49;
    public static final short IFX_TYPE_MAX = 54;
    public static final short IFX_TYPE_CLOB = 101;
    public static final short IFX_TYPE_BLOB = 102;
    public static final short IFX_BIT_NOTNULLABLE = 256;
    public static final short IFX_BIT_DISTINCT = 2048;
    public static final short IFX_BIT_NAMEDROW = 4096;
    public static final short IFX_BIT_COLLCLIENT = Short.MIN_VALUE;
    public static final short IFX_BIT_DBOOLEAN = 16384;
    public static final short IFX_XID_LVARCHAR = 1;
    public static final short IFX_XID_SENDRECV = 2;
    public static final short IFX_XID_IMPEXP = 3;
    public static final short IFX_XID_IMPEXPBIN = 4;
    public static final short IFX_XID_BOOLEAN = 5;
    public static final short IFX_XID_POINTER = 6;
    public static final short IFX_XID_INDEXKEYARRAY = 7;
    public static final short IFX_XID_RTNPARAMTYPES = 8;
    public static final short IFX_XID_SELFUNCARGS = 9;
    public static final short IFX_XID_BLOB = 10;
    public static final short IFX_XID_CLOB = 11;
    public static final short IFX_XID_LOLIST = 12;
    public static final short IFX_XID_IFX_LO_SPEC = 13;
    public static final short IFX_XID_IFX_LO_STAT = 14;
    public static final short IFX_XID_STAT = 15;
    public static final short IFX_XID_CLIENTBINVAL = 16;
    public static final short IFX_XID_STREAM = 17;
    public static final short IFX_XID_IDSSECURITYLABEL = 18;
    public static final short IFX_XID_IDSELEMENTENC = 19;
    public static final short IFX_XID_IDSCOVERINGINFO = 20;
    public static final short IFX_XID_LLVC = 24;
    public static final short IFX_XID_JSON = 25;
    public static final short IFX_XID_BSON = 26;
    public static final short LAST_BUILTIN_XID_TYPE = 26;
    public static final short IFX_TYPE_BIGINT = 52;
    public static final short IFX_TYPE_BIGSERIAL = 53;
    public static final String IFX_XNAME_BLOB = "blob";
    public static final String IFX_XNAME_CLOB = "clob";
    public static final String IFX_XNAME_BOOL = "boolean";
    public static final String IFX_XNAME_LVARCHAR = "lvarchar";
    public static final String IFX_XNAME_BSON = "bson";
    public static final String IFX_XNAME_JSON = "json";
    public static final String IFX_XNAME_UDT = "udt";
    private static final Map<Integer, Integer> IfxToJDBCTypeTable = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> JDBCToIfxTypeTable = new HashMap<Integer, Integer>();
    private static final Map<String, Integer> JavaToIfxTypeTable = new HashMap<String, Integer>();
    private static final Map<Integer, String> IfxTypeToJavaTable = new HashMap<Integer, String>();
    private static final Map<Integer, String> IfxTypeToNameTable = new HashMap<Integer, String>();
    private static final Map<Integer, String> JDBCTypeToNameTable = new HashMap<Integer, String>();
    private static final Map<String, Integer> IfxNameToIfxTypeTable = new HashMap<String, Integer>();
    private static final Map<Integer, Integer> IfxToJDBC2TypeTable = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> IfxTypeToDecDigitsTable = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> IfxExTypeToDecDigitsTable = new HashMap<Integer, Integer>();
    private static final Map<Integer, String> IfxExTypeToNameTable = new HashMap<Integer, String>();
    private static final Map<Class<?>, String> JAVA_TO_IFX_TYPENAME = new HashMap();

    private IfxTypes() {
    }

    public static int FromIfxToJDBC2Type(int ifxType) {
        Integer type = IfxToJDBC2TypeTable.get(ifxType);
        if (type == null) {
            type = 1111;
        }
        return type;
    }

    public static int FromIfxToJDBCType(int ifxType) {
        Integer type = IfxToJDBCTypeTable.get(ifxType);
        if (type == null) {
            type = 1111;
        }
        return type;
    }

    public static String fromJavaToIfxTypeName(Class<?> clazz) {
        return JAVA_TO_IFX_TYPENAME.get(clazz);
    }

    public static int FromJDBCToIfxType(int jdbcType) {
        return JDBCToIfxTypeTable.getOrDefault(jdbcType, 49);
    }

    public static int FromJavaToIfxType(String javaClassName) {
        Integer type = JavaToIfxTypeTable.get(javaClassName);
        if (type == null) {
            type = 49;
        }
        return type;
    }

    public static String FromIfxTypeToJava(int ifxType) {
        String name = IfxTypeToJavaTable.get(ifxType);
        if (name == null) {
            name = "unknown";
        }
        return name;
    }

    public static String IfxTypeToName(int ifxType) {
        String name = IfxTypeToNameTable.get(ifxType);
        if (name == null) {
            name = "unknown";
        }
        return name;
    }

    public static String IfxExTypeToName(int ifxExtType) {
        String name = IfxExTypeToNameTable.get(ifxExtType);
        if (name == null) {
            name = "unknown";
        }
        return name;
    }

    public static String JDBCTypeToName(int jdbcType) {
        String name = JDBCTypeToNameTable.get(jdbcType);
        if (name == null) {
            name = "unknown";
        }
        return name;
    }

    public static int FromIfxNameToIfxType(String name) {
        String s = name.trim().toLowerCase();
        Integer type = IfxNameToIfxTypeTable.get(s);
        if (type == null) {
            type = 1111;
        }
        return type;
    }

    public static int IfxTypeToDecDigits(int ifxType, int ifxExType, int colLen) {
        Integer decDigits;
        if (ifxType == 40 || ifxType == 41) {
            decDigits = IfxExTypeToDecDigitsTable.get(ifxExType);
        } else if (ifxType == 5 || ifxType == 8) {
            decDigits = colLen >> 8 & 0xFF;
        } else if (ifxType == 10 || ifxType == 14) {
            int tu_start = colLen >> 4 & 0xF;
            int tu_end = colLen & 0xF;
            int tu_len = colLen >> 8 & 0xFF;
            decDigits = tu_len + ((tu_end > 10 ? 12 : tu_end) - tu_start) / 2;
        } else {
            decDigits = IfxTypeToDecDigitsTable.get(ifxType);
        }
        if (decDigits == null) {
            decDigits = 0;
        }
        if (decDigits.equals(-1)) {
            decDigits = colLen;
        }
        return decDigits;
    }

    public static int IfxTypeToRightDecimal(int ifxType, int ifxExType, int colLen) {
        int tu_end;
        int decDigits = ifxType == 10 || ifxType == 14 ? ((tu_end = colLen & 0xF) > 10 ? tu_end - 10 : 0) : (ifxType == 5 || ifxType == 8 ? colLen & 0xFF : 0);
        return decDigits;
    }

    public static boolean IsFloatTypes(int ifxType) {
        return (ifxType &= 0xFF) == 3 || ifxType == 4;
    }

    public static boolean isString(int ifxType) {
        return (ifxType &= 0xFF) == 0 || ifxType == 13 || ifxType == 15 || ifxType == 16 || ifxType == 43;
    }

    public static boolean isUDT(int ifxType) {
        return (ifxType &= 0xFF) == 40 || ifxType == 41 || ifxType == 45 || ifxType == 43;
    }

    public static boolean isCollection(int ifxType) {
        return (ifxType &= 0xFF) == 21 || ifxType == 19 || ifxType == 20;
    }

    public static boolean isComplexType(int ifxType) {
        if (IfxTypes.isCollection(ifxType)) {
            return true;
        }
        return (ifxType &= 0xFF) == 22;
    }

    public static int getIfxTypeForExtendedTypes(int extendedId) {
        int ifxType = 49;
        switch (extendedId) {
            case 5: {
                ifxType = 45;
                break;
            }
            case 1: {
                ifxType = 43;
                break;
            }
            case 10: 
            case 11: 
            case 25: 
            case 26: 
            case 40: 
            case 41: {
                ifxType = 44;
            }
        }
        return ifxType;
    }

    static {
        JAVA_TO_IFX_TYPENAME.put(Character.TYPE, "CHAR(1)");
        JAVA_TO_IFX_TYPENAME.put(Character.class, "CHAR(1)");
        JAVA_TO_IFX_TYPENAME.put(Boolean.TYPE, "BOOLEAN");
        JAVA_TO_IFX_TYPENAME.put(Boolean.class, "BOOLEAN");
        JAVA_TO_IFX_TYPENAME.put(Integer.TYPE, "INTEGER");
        JAVA_TO_IFX_TYPENAME.put(Integer.class, "INTEGER");
        JAVA_TO_IFX_TYPENAME.put(Long.TYPE, "BIGINT");
        JAVA_TO_IFX_TYPENAME.put(Long.class, "BIGINT");
        JAVA_TO_IFX_TYPENAME.put(Double.TYPE, "FLOAT");
        JAVA_TO_IFX_TYPENAME.put(Double.class, "FLOAT");
        JAVA_TO_IFX_TYPENAME.put(Float.TYPE, "SMALLFLOAT");
        JAVA_TO_IFX_TYPENAME.put(Float.class, "SMALLFLOAT");
        JAVA_TO_IFX_TYPENAME.put(Short.TYPE, "SMALLINT");
        JAVA_TO_IFX_TYPENAME.put(Short.class, "SMALLINT");
        JAVA_TO_IFX_TYPENAME.put(BigDecimal.class, "DECIMAL");
        JAVA_TO_IFX_TYPENAME.put(String.class, "LVARCHAR");
        JAVA_TO_IFX_TYPENAME.put(java.sql.Date.class, "DATETIME YEAR TO FRACTION(5)");
        JAVA_TO_IFX_TYPENAME.put(Date.class, "DATETIME YEAR TO FRACTION(5)");
        JAVA_TO_IFX_TYPENAME.put(Time.class, "DATETIME HOUR TO SECOND");
        JAVA_TO_IFX_TYPENAME.put(Timestamp.class, "DATETIME YEAR TO FRACTION(5)");
        JAVA_TO_IFX_TYPENAME.put(IntervalYM.class, "INTERVAL YEAR TO MONTH");
        JAVA_TO_IFX_TYPENAME.put(IntervalDF.class, "INTERVAL DAY TO FRACTION(5)");
        JAVA_TO_IFX_TYPENAME.put(Blob.class, "BLOB");
        JAVA_TO_IFX_TYPENAME.put(Clob.class, "CLOB");
        IfxToJDBCTypeTable.put(0, 1);
        IfxToJDBCTypeTable.put(1, 5);
        IfxToJDBCTypeTable.put(2, 4);
        IfxToJDBCTypeTable.put(3, 8);
        IfxToJDBCTypeTable.put(4, 7);
        IfxToJDBCTypeTable.put(5, 3);
        IfxToJDBCTypeTable.put(6, 4);
        IfxToJDBCTypeTable.put(7, 91);
        IfxToJDBCTypeTable.put(8, 3);
        IfxToJDBCTypeTable.put(9, 0);
        IfxToJDBCTypeTable.put(10, 93);
        IfxToJDBCTypeTable.put(11, -4);
        IfxToJDBCTypeTable.put(12, -1);
        IfxToJDBCTypeTable.put(13, 12);
        IfxToJDBCTypeTable.put(15, 1);
        IfxToJDBCTypeTable.put(16, 12);
        IfxToJDBCTypeTable.put(14, 1);
        IfxToJDBCTypeTable.put(17, -5);
        IfxToJDBCTypeTable.put(18, -5);
        IfxToJDBCTypeTable.put(19, 1111);
        IfxToJDBCTypeTable.put(21, 1111);
        IfxToJDBCTypeTable.put(20, 1111);
        IfxToJDBCTypeTable.put(22, 2002);
        IfxToJDBCTypeTable.put(40, 2000);
        IfxToJDBCTypeTable.put(41, 2000);
        IfxToJDBCTypeTable.put(43, -1);
        IfxToJDBCTypeTable.put(44, 2000);
        IfxToJDBCTypeTable.put(45, 16);
        IfxToJDBCTypeTable.put(46, 2000);
        IfxToJDBCTypeTable.put(47, 2000);
        IfxToJDBCTypeTable.put(102, 2004);
        IfxToJDBCTypeTable.put(101, 2005);
        IfxToJDBCTypeTable.put(52, -5);
        IfxToJDBCTypeTable.put(53, -5);
        JDBCToIfxTypeTable.put(-5, 17);
        JDBCToIfxTypeTable.put(-2, 11);
        JDBCToIfxTypeTable.put(-7, 45);
        JDBCToIfxTypeTable.put(1, 0);
        JDBCToIfxTypeTable.put(91, 7);
        JDBCToIfxTypeTable.put(3, 5);
        JDBCToIfxTypeTable.put(8, 3);
        JDBCToIfxTypeTable.put(6, 3);
        JDBCToIfxTypeTable.put(4, 2);
        JDBCToIfxTypeTable.put(-4, 11);
        JDBCToIfxTypeTable.put(-1, 43);
        JDBCToIfxTypeTable.put(0, 9);
        JDBCToIfxTypeTable.put(2, 5);
        JDBCToIfxTypeTable.put(7, 4);
        JDBCToIfxTypeTable.put(5, 1);
        JDBCToIfxTypeTable.put(92, 10);
        JDBCToIfxTypeTable.put(93, 10);
        JDBCToIfxTypeTable.put(-6, 1);
        JDBCToIfxTypeTable.put(16, 45);
        JDBCToIfxTypeTable.put(-3, 11);
        JDBCToIfxTypeTable.put(12, 13);
        JDBCToIfxTypeTable.put(2000, 44);
        JDBCToIfxTypeTable.put(2002, 22);
        JDBCToIfxTypeTable.put(2003, 19);
        JDBCToIfxTypeTable.put(2004, 102);
        JDBCToIfxTypeTable.put(2005, 101);
        JDBCToIfxTypeTable.put(-5, 52);
        JDBCToIfxTypeTable.put(-5, 53);
        JavaToIfxTypeTable.put("java.lang.String", 0);
        JavaToIfxTypeTable.put("java.math.BigDecimal", 5);
        JavaToIfxTypeTable.put("java.lang.Integer", 2);
        JavaToIfxTypeTable.put("java.lang.Short", 1);
        JavaToIfxTypeTable.put("java.lang.Long", 17);
        JavaToIfxTypeTable.put("java.lang.Float", 4);
        JavaToIfxTypeTable.put("java.lang.Double", 3);
        JavaToIfxTypeTable.put("[B", 11);
        JavaToIfxTypeTable.put("java.sql.Date", 7);
        JavaToIfxTypeTable.put("java.util.Date", 10);
        JavaToIfxTypeTable.put("java.sql.Time", 10);
        JavaToIfxTypeTable.put("java.sql.Timestamp", 10);
        JavaToIfxTypeTable.put("com.informix.lang.IntervalYM", 14);
        JavaToIfxTypeTable.put("com.informix.lang.IntervalDF", 14);
        JavaToIfxTypeTable.put("java.util.ArrayList", 21);
        JavaToIfxTypeTable.put("java.util.LinkedList", 21);
        JavaToIfxTypeTable.put("java.util.Vector", 21);
        JavaToIfxTypeTable.put("java.util.HashSet", 19);
        JavaToIfxTypeTable.put("java.util.TreeSet", 19);
        JavaToIfxTypeTable.put("java.lang.Boolean", 45);
        JavaToIfxTypeTable.put("java.sql.Blob", 102);
        JavaToIfxTypeTable.put("java.sql.Clob", 101);
        IfxTypeToJavaTable.put(0, "java.lang.String");
        IfxTypeToJavaTable.put(1, "java.lang.Short");
        IfxTypeToJavaTable.put(2, "java.lang.Integer");
        IfxTypeToJavaTable.put(3, "java.lang.Double");
        IfxTypeToJavaTable.put(4, "java.lang.Float");
        IfxTypeToJavaTable.put(5, "java.math.BigDecimal");
        IfxTypeToJavaTable.put(6, "java.lang.Integer");
        IfxTypeToJavaTable.put(7, "java.sql.Date");
        IfxTypeToJavaTable.put(8, "java.math.BigDecimal");
        IfxTypeToJavaTable.put(10, "java.sql.Timestamp");
        IfxTypeToJavaTable.put(11, "[B");
        IfxTypeToJavaTable.put(12, "java.lang.String");
        IfxTypeToJavaTable.put(13, "java.lang.String");
        IfxTypeToJavaTable.put(14, "com.informix.lang.Interval");
        IfxTypeToJavaTable.put(15, "java.lang.String");
        IfxTypeToJavaTable.put(16, "java.lang.String");
        IfxTypeToJavaTable.put(17, "java.lang.Long");
        IfxTypeToJavaTable.put(18, "java.lang.Long");
        IfxTypeToJavaTable.put(19, "java.sql.Array");
        IfxTypeToJavaTable.put(20, "java.sql.Array");
        IfxTypeToJavaTable.put(21, "java.sql.Array");
        IfxTypeToJavaTable.put(22, "java.sql.Struct");
        IfxTypeToJavaTable.put(40, "java.sql.SQLData");
        IfxTypeToJavaTable.put(41, "java.sql.SQLData");
        IfxTypeToJavaTable.put(43, "java.lang.String");
        IfxTypeToJavaTable.put(44, "java.sql.SQLData");
        IfxTypeToJavaTable.put(45, "java.lang.Boolean");
        IfxTypeToJavaTable.put(46, "java.sql.SQLData");
        IfxTypeToJavaTable.put(47, "java.sql.SQLData");
        IfxTypeToJavaTable.put(52, "java.lang.Long");
        IfxTypeToJavaTable.put(53, "java.lang.Long");
        IfxTypeToNameTable.put(0, "char");
        IfxTypeToNameTable.put(1, "smallint");
        IfxTypeToNameTable.put(2, "int");
        IfxTypeToNameTable.put(3, "float");
        IfxTypeToNameTable.put(4, "smallfloat");
        IfxTypeToNameTable.put(5, "decimal");
        IfxTypeToNameTable.put(6, "serial");
        IfxTypeToNameTable.put(7, "date");
        IfxTypeToNameTable.put(8, "money");
        IfxTypeToNameTable.put(10, "datetime");
        IfxTypeToNameTable.put(11, "byte");
        IfxTypeToNameTable.put(12, "text");
        IfxTypeToNameTable.put(13, "varchar");
        IfxTypeToNameTable.put(14, "interval");
        IfxTypeToNameTable.put(15, "nchar");
        IfxTypeToNameTable.put(16, "nvarchar");
        IfxTypeToNameTable.put(17, "int8");
        IfxTypeToNameTable.put(18, "serial8");
        IfxTypeToNameTable.put(43, IFX_XNAME_LVARCHAR);
        IfxTypeToNameTable.put(45, IFX_XNAME_BOOL);
        IfxTypeToNameTable.put(22, "row");
        IfxTypeToNameTable.put(19, "set");
        IfxTypeToNameTable.put(21, "list");
        IfxTypeToNameTable.put(20, "multiset");
        IfxTypeToNameTable.put(43, IFX_XNAME_LVARCHAR);
        IfxTypeToNameTable.put(45, IFX_XNAME_BOOL);
        IfxTypeToNameTable.put(102, IFX_XNAME_BLOB);
        IfxTypeToNameTable.put(101, IFX_XNAME_CLOB);
        IfxTypeToNameTable.put(44, "sendrecv");
        IfxTypeToNameTable.put(46, "impexp");
        IfxTypeToNameTable.put(47, "impexpbin");
        IfxTypeToNameTable.put(52, "bigint");
        IfxTypeToNameTable.put(53, "bigserial");
        IfxTypeToNameTable.put(40, "sqludtvar");
        IfxNameToIfxTypeTable.put("char", 0);
        IfxNameToIfxTypeTable.put("smallint", 1);
        IfxNameToIfxTypeTable.put("int", 2);
        IfxNameToIfxTypeTable.put("integer", 2);
        IfxNameToIfxTypeTable.put("float", 3);
        IfxNameToIfxTypeTable.put("double precision", 3);
        IfxNameToIfxTypeTable.put("smallfloat", 4);
        IfxNameToIfxTypeTable.put("decimal", 5);
        IfxNameToIfxTypeTable.put("serial", 6);
        IfxNameToIfxTypeTable.put("date", 7);
        IfxNameToIfxTypeTable.put("money", 8);
        IfxNameToIfxTypeTable.put("datetime", 10);
        IfxNameToIfxTypeTable.put("byte", 11);
        IfxNameToIfxTypeTable.put("text", 12);
        IfxNameToIfxTypeTable.put("varchar", 13);
        IfxNameToIfxTypeTable.put("interval", 14);
        IfxNameToIfxTypeTable.put("nchar", 15);
        IfxNameToIfxTypeTable.put("nvarchar", 16);
        IfxNameToIfxTypeTable.put("int8", 17);
        IfxNameToIfxTypeTable.put("serial8", 18);
        IfxNameToIfxTypeTable.put("row", 22);
        IfxNameToIfxTypeTable.put("set", 19);
        IfxNameToIfxTypeTable.put("list", 21);
        IfxNameToIfxTypeTable.put("multiset", 20);
        IfxNameToIfxTypeTable.put(IFX_XNAME_LVARCHAR, 43);
        IfxNameToIfxTypeTable.put(IFX_XNAME_BOOL, 45);
        IfxNameToIfxTypeTable.put(IFX_XNAME_BLOB, 102);
        IfxNameToIfxTypeTable.put(IFX_XNAME_CLOB, 101);
        IfxNameToIfxTypeTable.put("bigserial", 53);
        IfxNameToIfxTypeTable.put("bigint", 52);
        JDBCTypeToNameTable.put(-5, "java.sql.Types.BIGINT");
        JDBCTypeToNameTable.put(-2, "java.sql.Types.BINARY");
        JDBCTypeToNameTable.put(-7, "java.sql.Types.BIT");
        JDBCTypeToNameTable.put(1, "java.sql.Types.CHAR");
        JDBCTypeToNameTable.put(91, "java.sql.Types.DATE");
        JDBCTypeToNameTable.put(3, "java.sql.Types.DECIMAL");
        JDBCTypeToNameTable.put(8, "java.sql.Types.DOUBLE");
        JDBCTypeToNameTable.put(6, "java.sql.Types.FLOAT");
        JDBCTypeToNameTable.put(4, "java.sql.Types.INTEGER");
        JDBCTypeToNameTable.put(-4, "java.sql.Types.LONGVARBINARY");
        JDBCTypeToNameTable.put(-1, "java.sql.Types.LONGVARCHAR");
        JDBCTypeToNameTable.put(0, "java.sql.Types.NULL");
        JDBCTypeToNameTable.put(2, "java.sql.Types.NUMERIC");
        JDBCTypeToNameTable.put(7, "java.sql.Types.REAL");
        JDBCTypeToNameTable.put(5, "java.sql.Types.SMALLINT");
        JDBCTypeToNameTable.put(92, "java.sql.Types.TIME");
        JDBCTypeToNameTable.put(93, "java.sql.Types.TIMESTAMP");
        JDBCTypeToNameTable.put(-6, "java.sql.Types.TINYINT");
        JDBCTypeToNameTable.put(1111, "java.sql.Types.OTHER");
        JDBCTypeToNameTable.put(-3, "java.sql.Types.VARBINARY");
        JDBCTypeToNameTable.put(12, "java.sql.Types.VARCHAR");
        JDBCTypeToNameTable.put(2003, "java.sql.Types.ARRAY");
        JDBCTypeToNameTable.put(2004, "java.sql.Types.BLOB");
        JDBCTypeToNameTable.put(2005, "java.sql.Types.CLOB");
        JDBCTypeToNameTable.put(2001, "java.sql.Types.DISTINCT");
        JDBCTypeToNameTable.put(2000, "java.sql.Types.JAVA_OBJECT");
        JDBCTypeToNameTable.put(2002, "java.sql.Types.STRUCT");
        JDBCTypeToNameTable.put(16, "java.sql.Types.BOOLEAN");
        IfxToJDBC2TypeTable.put(0, 1);
        IfxToJDBC2TypeTable.put(1, 5);
        IfxToJDBC2TypeTable.put(2, 4);
        IfxToJDBC2TypeTable.put(3, 8);
        IfxToJDBC2TypeTable.put(4, 7);
        IfxToJDBC2TypeTable.put(5, 3);
        IfxToJDBC2TypeTable.put(6, 4);
        IfxToJDBC2TypeTable.put(7, 91);
        IfxToJDBC2TypeTable.put(8, 3);
        IfxToJDBC2TypeTable.put(9, 0);
        IfxToJDBC2TypeTable.put(10, 93);
        IfxToJDBC2TypeTable.put(11, -4);
        IfxToJDBC2TypeTable.put(12, -1);
        IfxToJDBC2TypeTable.put(13, 12);
        IfxToJDBC2TypeTable.put(15, 1);
        IfxToJDBC2TypeTable.put(16, 12);
        IfxToJDBC2TypeTable.put(14, 1);
        IfxToJDBC2TypeTable.put(17, -5);
        IfxToJDBC2TypeTable.put(18, -5);
        IfxToJDBC2TypeTable.put(19, 2003);
        IfxToJDBC2TypeTable.put(21, 2003);
        IfxToJDBC2TypeTable.put(20, 2003);
        IfxToJDBC2TypeTable.put(22, 2002);
        IfxToJDBC2TypeTable.put(40, 2000);
        IfxToJDBC2TypeTable.put(41, 2000);
        IfxToJDBC2TypeTable.put(43, -1);
        IfxToJDBC2TypeTable.put(44, 2000);
        IfxToJDBC2TypeTable.put(45, 16);
        IfxToJDBC2TypeTable.put(46, 2000);
        IfxToJDBC2TypeTable.put(47, 2000);
        IfxToJDBC2TypeTable.put(101, 2005);
        IfxToJDBC2TypeTable.put(102, 2004);
        IfxToJDBC2TypeTable.put(53, -5);
        IfxToJDBC2TypeTable.put(52, -5);
        IfxTypeToDecDigitsTable.put(0, -1);
        IfxTypeToDecDigitsTable.put(1, 5);
        IfxTypeToDecDigitsTable.put(2, 10);
        IfxTypeToDecDigitsTable.put(3, 15);
        IfxTypeToDecDigitsTable.put(4, 7);
        IfxTypeToDecDigitsTable.put(5, -1);
        IfxTypeToDecDigitsTable.put(6, 10);
        IfxTypeToDecDigitsTable.put(7, 10);
        IfxTypeToDecDigitsTable.put(8, -1);
        IfxTypeToDecDigitsTable.put(9, 0);
        IfxTypeToDecDigitsTable.put(10, -1);
        IfxTypeToDecDigitsTable.put(11, -1);
        IfxTypeToDecDigitsTable.put(12, -1);
        IfxTypeToDecDigitsTable.put(13, -1);
        IfxTypeToDecDigitsTable.put(15, -1);
        IfxTypeToDecDigitsTable.put(16, -1);
        IfxTypeToDecDigitsTable.put(14, -1);
        IfxTypeToDecDigitsTable.put(17, 19);
        IfxTypeToDecDigitsTable.put(18, 19);
        IfxTypeToDecDigitsTable.put(19, 0);
        IfxTypeToDecDigitsTable.put(21, 0);
        IfxTypeToDecDigitsTable.put(22, 0);
        IfxTypeToDecDigitsTable.put(40, 0);
        IfxTypeToDecDigitsTable.put(41, 0);
        IfxTypeToDecDigitsTable.put(43, -1);
        IfxTypeToDecDigitsTable.put(44, 0);
        IfxTypeToDecDigitsTable.put(45, 0);
        IfxTypeToDecDigitsTable.put(46, 0);
        IfxTypeToDecDigitsTable.put(47, 0);
        IfxTypeToDecDigitsTable.put(102, -1);
        IfxTypeToDecDigitsTable.put(101, -1);
        IfxTypeToDecDigitsTable.put(52, 19);
        IfxTypeToDecDigitsTable.put(53, 19);
        IfxExTypeToDecDigitsTable.put(1, -1);
        IfxExTypeToDecDigitsTable.put(2, 0);
        IfxExTypeToDecDigitsTable.put(3, 0);
        IfxExTypeToDecDigitsTable.put(4, 0);
        IfxExTypeToDecDigitsTable.put(5, 0);
        IfxExTypeToDecDigitsTable.put(6, 0);
        IfxExTypeToDecDigitsTable.put(7, 0);
        IfxExTypeToDecDigitsTable.put(8, 0);
        IfxExTypeToDecDigitsTable.put(9, 0);
        IfxExTypeToDecDigitsTable.put(10, -1);
        IfxExTypeToDecDigitsTable.put(11, -1);
        IfxExTypeToDecDigitsTable.put(12, 0);
        IfxExTypeToDecDigitsTable.put(15, 0);
        IfxExTypeToNameTable.put(1, "IFX_XID_LVARCHAR");
        IfxExTypeToNameTable.put(2, "IFX_XID_SENDRECV");
        IfxExTypeToNameTable.put(3, "IFX_XID_IMPEXP");
        IfxExTypeToNameTable.put(4, "IFX_XID_IMPEXPBIN");
        IfxExTypeToNameTable.put(5, "IFX_XID_BOOLEAN");
        IfxExTypeToNameTable.put(6, "IFX_XID_POINTER");
        IfxExTypeToNameTable.put(7, "IFX_XID_INDEXKEYARRAY");
        IfxExTypeToNameTable.put(8, "IFX_XID_RTNPARAMTYPES");
        IfxExTypeToNameTable.put(9, "IFX_XID_SELFUNCARGS");
        IfxExTypeToNameTable.put(10, "IFX_XID_BLOB");
        IfxExTypeToNameTable.put(11, "IFX_XID_CLOB");
        IfxExTypeToNameTable.put(12, "IFX_XID_LOLIST");
        IfxExTypeToNameTable.put(13, "IFX_XID_IFX_LO_SPEC");
        IfxExTypeToNameTable.put(14, "IFX_XID_IFX_LO_STAT");
        IfxExTypeToNameTable.put(16, "IFX_XID_CLIENTBINVAL");
        IfxExTypeToNameTable.put(17, "IFX_XID_STREAM");
        IfxExTypeToNameTable.put(18, "IFX_XID_IDSSECURITYLABEL");
        IfxExTypeToNameTable.put(19, "IFX_XID_IDSELEMENTENC");
        IfxExTypeToNameTable.put(20, "IFX_XID_IDSCOVERINGINFO");
        IfxExTypeToNameTable.put(24, "IFX_XID_LLVC");
        IfxExTypeToNameTable.put(25, "IFX_XID_JSON");
        IfxExTypeToNameTable.put(26, "IFX_XID_BSON");
    }
}

