/*
 * Decompiled with CFR 0.152.
 */
package com.informix.util;

import com.informix.jdbc.IfmxResultSetMetaData;
import com.informix.jdbc.IfxBSONObject;
import com.informix.jdbc.IfxBblob;
import com.informix.jdbc.IfxCblob;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxStruct;
import com.informix.jdbc.types.TypeInfo;
import com.informix.jdbc.udt.timeseries.IfmxTimeSeries;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class BsonUtils {
    private BsonUtils() {
    }

    public static IfxBSONObject convertCurrentResultSetRowToDocument(ResultSet resultSet, ResultSetMetaData rsmd, int limit) throws SQLException {
        IfxBSONObject document = new IfxBSONObject();
        int columnCount = rsmd.getColumnCount();
        for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
            Object columnObject = resultSet.getObject(columnIndex);
            columnObject = BsonUtils.ensureResultSetObjectForEncoder(columnObject, rsmd, columnIndex, limit);
            String columnLabel = rsmd.getColumnLabel(columnIndex);
            document.put(columnLabel, columnObject);
        }
        return document;
    }

    public static Object ensureObjectForEncoder(Object o) throws SQLException {
        if (o instanceof java.sql.Date) {
            return new Date(((java.sql.Date)o).getTime());
        }
        if (o instanceof Short) {
            return ((Short)o).intValue();
        }
        if (o instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)o;
            if (bigDecimal.scale() <= 0) {
                if (bigDecimal.precision() - bigDecimal.scale() <= 9) {
                    return bigDecimal.intValue();
                }
                return bigDecimal.longValue();
            }
            return bigDecimal.doubleValue();
        }
        if (o instanceof IfxBblob) {
            IfxBblob blob = (IfxBblob)o;
            String locatorId = blob.getLocator().toString();
            blob.close();
            return new IfxBSONObject("$lob", new IfxBSONObject("type", "blob").append("id", locatorId));
        }
        if (o instanceof IfxCblob) {
            IfxCblob clob = (IfxCblob)o;
            String locatorId = clob.getLocator().toString();
            clob.close();
            return new IfxBSONObject("$lob", new IfxBSONObject("type", "clob").append("id", locatorId));
        }
        return o;
    }

    private static Object ensureResultSetObjectForEncoder(Object o, ResultSetMetaData rsmd, int columnIndex, int limit) throws SQLException {
        if ((o = BsonUtils.ensureObjectForEncoder(o)) instanceof String && rsmd.getColumnType(columnIndex) == 1) {
            return ((String)o).trim();
        }
        if (o instanceof IfxStruct) {
            IfxResultSetMetaData ifxRsmd = (IfxResultSetMetaData)rsmd;
            int extendedTypeId = ifxRsmd.getColumnExtendedId(columnIndex);
            return BsonUtils.convertIfxStructToDocument((IfxStruct)o, ifxRsmd, extendedTypeId);
        }
        if (o instanceof IfmxTimeSeries) {
            return ((IfmxTimeSeries)o).toBson(limit);
        }
        if (o instanceof List) {
            List list = (List)o;
            if (!list.isEmpty()) {
                LinkedList<Object> newList = new LinkedList<Object>();
                for (int j = 0; j < list.size(); ++j) {
                    Object listElement = list.get(j);
                    newList.add(BsonUtils.ensureResultSetObjectForEncoder(listElement, rsmd, columnIndex, limit));
                }
                return newList;
            }
            return o;
        }
        return o;
    }

    private static IfxBSONObject convertIfxStructToDocument(IfxStruct ifxStruct, IfxResultSetMetaData ifxRsmd, int extendedTypeId) throws SQLException {
        TypeInfo udtInfo = ifxRsmd.getConnection().getUDTInfo(extendedTypeId);
        IfxResultSetMetaData udtMetaData = udtInfo.getMetaData();
        IfmxResultSetMetaData structRsmd = udtMetaData.getChild(1);
        int udtIfxType = udtInfo.getDatabaseType();
        if ((udtIfxType == 19 || udtIfxType == 20 || udtIfxType == 21) && structRsmd.getChild(1) != null) {
            structRsmd = structRsmd.getChild(1);
        }
        IfxBSONObject document = new IfxBSONObject();
        Object[] attrs = ifxStruct.getAttributes();
        for (int i = 0; i < structRsmd.getColumnCount(); ++i) {
            Object attr = attrs[i];
            if (attr instanceof List) {
                List list = (List)attr;
                LinkedList<Object> subList = new LinkedList<Object>();
                for (int j = 0; j < list.size(); ++j) {
                    Object subListElem = list.get(j);
                    BsonUtils.appendObjectToList(subList, ifxRsmd, structRsmd, i, subListElem);
                }
                String label = structRsmd.getColumnLabel(i + 1);
                document.put(label, (Object)subList);
                continue;
            }
            BsonUtils.appendObjectToDocument(document, ifxRsmd, structRsmd, i, attr);
        }
        return document;
    }

    private static void appendObjectToList(List<Object> list, IfxResultSetMetaData ifxRsmd, IfmxResultSetMetaData structRsmd, int structIndex, Object object) throws SQLException {
        if (object instanceof IfxStruct) {
            int attrExtendedTypeId = structRsmd.getColumnExtendedId(structIndex + 1);
            object = BsonUtils.convertIfxStructToDocument((IfxStruct)object, ifxRsmd, attrExtendedTypeId);
        } else {
            object = BsonUtils.ensureObjectForEncoder(object);
        }
        list.add(object);
    }

    private static void appendObjectToDocument(IfxBSONObject document, IfxResultSetMetaData ifxRsmd, IfmxResultSetMetaData structRsmd, int structIndex, Object object) throws SQLException {
        if (object instanceof IfxStruct) {
            int attrExtendedTypeId = structRsmd.getColumnExtendedId(structIndex + 1);
            object = BsonUtils.convertIfxStructToDocument((IfxStruct)object, ifxRsmd, attrExtendedTypeId);
        } else {
            object = BsonUtils.ensureObjectForEncoder(object);
        }
        String label = structRsmd.getColumnLabel(structIndex + 1);
        document.put(label, object);
    }
}

