/*
 * Decompiled with CFR 0.152.
 */
package com.informix.util;

import java.util.HashMap;
import java.util.Map;

public class CaseMap<V>
extends HashMap<String, V> {
    private static final long serialVersionUID = 1L;
    protected final boolean preserveCase;

    public CaseMap(boolean preserveCase) {
        this.preserveCase = preserveCase;
    }

    public boolean isCaseSensitive() {
        return this.preserveCase;
    }

    @Override
    public Object clone() {
        CaseMap copy = new CaseMap(this.preserveCase);
        for (Map.Entry entry : this.entrySet()) {
            copy.put((String)entry.getKey(), entry.getValue());
        }
        return copy;
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.preserveCase) {
            return super.containsKey(key);
        }
        return super.containsKey(key.toString().toLowerCase());
    }

    @Override
    public V get(Object key) {
        if (this.preserveCase) {
            return super.get(key);
        }
        return super.get(key.toString().toLowerCase());
    }

    @Override
    public V put(String key, V value) {
        if (this.preserveCase) {
            return super.put(key, value);
        }
        return super.put(key.toLowerCase(), value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        for (Map.Entry<String, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
        super.putAll(m);
    }

    @Override
    public V remove(Object key) {
        if (this.preserveCase) {
            return super.remove(key);
        }
        return super.remove(key.toString().toLowerCase());
    }
}

