/*
 * Decompiled with CFR 0.152.
 */
package com.informix.util;

import com.informix.asf.JnsObject;
import com.informix.jdbc.InformixDriver;
import com.informix.lang.Messages;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class InformixUrl {
    private String errorMessage;
    private final String url;
    private final Properties properties = new Properties();
    private String host = null;
    private String port = null;
    private String databaseName = null;
    private String subProtocol = null;
    private String hostPortUrl = null;
    private String proxy = null;

    public String getUrl() {
        return this.url;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getSubProtocol() {
        return this.subProtocol;
    }

    public String getDatabase() {
        return this.databaseName;
    }

    public void setDatabase(String databaseName) {
        this.databaseName = databaseName;
    }

    public InformixUrl(String url, Properties props) throws SQLException {
        this.url = url;
        if (props != null) {
            InformixUrl.copyAndCapitalizeKeys(props, this.properties);
        }
        if (url.startsWith("jdbc:onedb")) {
            InformixDriver.addPropertiesFromURL(url, this.properties);
            this.databaseName = this.properties.getProperty("DATABASE");
            this.host = this.properties.getProperty("HOST");
            this.port = this.properties.getProperty("PORT");
            this.subProtocol = "informix-sqli";
        } else {
            if (!this.checkURL(url)) {
                throw new IllegalArgumentException("Invalid URL format");
            }
            this.getPropertiesFromUrl(url);
            this.putInformixVarsIntoProperties();
        }
    }

    private synchronized boolean checkURL(String url) throws SQLException {
        boolean checkSubprotocol = true;
        boolean gotIpV6Literal = false;
        if (url.indexOf(58) == -1) {
            this.errorMessage = Messages.getMinorMsg(-80035) + " '" + url + "'" + Messages.getMinorMsg(-80004) + " ':'";
            return false;
        }
        StringTokenizer urlStartTok = new StringTokenizer(url, ";=", true);
        String urlStart = urlStartTok.nextToken();
        boolean endsColon = false;
        boolean notLDAP = true;
        if (urlStart.charAt(urlStart.length() - 1) == ':') {
            endsColon = true;
        }
        StringTokenizer tokenizer = new StringTokenizer(urlStart, ":", true);
        String jdbc = tokenizer.nextToken();
        if (urlStartTok.hasMoreTokens() && urlStartTok.nextToken().equals("=")) {
            notLDAP = false;
        }
        if (!jdbc.equalsIgnoreCase("jdbc")) {
            this.errorMessage = Messages.getMinorMsg(-80035) + " '" + url + "' " + Messages.getMessage(-79756);
            return false;
        }
        tokenizer.nextToken();
        String address = tokenizer.nextToken();
        if (tokenizer.hasMoreTokens()) {
            tokenizer.nextToken();
        }
        if (address != null && address.charAt(0) == '/' && address.charAt(1) == '/') {
            address = address.substring(2, address.length());
        }
        if (address.equals("informix-sqli")) {
            this.subProtocol = address;
            this.properties.put("CONNECTIONCLASS", "com.informix.jdbc.IfxSqliConnect");
            if (tokenizer.hasMoreTokens()) {
                address = tokenizer.nextToken();
            }
            if (tokenizer.hasMoreTokens()) {
                tokenizer.nextToken();
            }
        } else if (address.equals("informix-direct")) {
            this.properties.put("CONNECTIONCLASS", "com.informix.jdbc.IfxDirectConnection");
            checkSubprotocol = false;
            if (tokenizer.hasMoreTokens()) {
                address = tokenizer.nextToken();
                if (!address.equals(":") && tokenizer.hasMoreTokens()) {
                    tokenizer.nextToken();
                }
            } else {
                address = null;
            }
        } else {
            this.errorMessage = Messages.getMessage(-79757) + ": '" + address + "'";
            return false;
        }
        if (address != null && address.charAt(0) == '/' && address.charAt(1) == '/') {
            address = address.substring(2, address.length());
            if (checkSubprotocol) {
                gotIpV6Literal = true;
            }
        }
        if (!checkSubprotocol) {
            if (address != null && address.length() > 0 && address.charAt(0) == '/') {
                String dbAndOptionals = address;
                StringTokenizer portT = new StringTokenizer(dbAndOptionals, "/");
                String dbName = portT.nextToken();
                if (!InformixUrl.isValidDatabaseIdentifier(dbName)) {
                    this.errorMessage = Messages.getMessage(-79760) + ": '" + dbName + "'";
                    return false;
                }
                this.databaseName = dbName;
                this.hostPortUrl = null;
            }
        } else {
            int requiredTokens;
            int tokensLeft = tokenizer.countTokens();
            int n = requiredTokens = endsColon ? 3 : 4;
            if (gotIpV6Literal && tokensLeft <= requiredTokens) {
                gotIpV6Literal = false;
            }
            if (gotIpV6Literal) {
                address = address + ":";
                while (tokensLeft > requiredTokens) {
                    address = address + tokenizer.nextToken();
                    --tokensLeft;
                }
                tokenizer.nextToken();
            }
            StringTokenizer addrT = new StringTokenizer(address, ".");
            String token1 = addrT.nextToken();
            if (notLDAP || tokenizer.hasMoreTokens()) {
                if (token1.indexOf(47) == -1) {
                    if (!tokenizer.hasMoreTokens()) {
                        throw Messages.getSQLException(-79705);
                    }
                    String portAsString = tokenizer.nextToken();
                    if (tokenizer.hasMoreTokens()) {
                        tokenizer.nextToken();
                    }
                    if (portAsString != null && portAsString.indexOf(47) == -1) {
                        if (!this.isInteger(portAsString)) {
                            int portNumber = JnsObject.getServiceByName(portAsString);
                            if (portNumber == -1) {
                                throw Messages.getSQLException(-79759, ": '" + portAsString + "'");
                            }
                            this.hostPortUrl = address + ":" + portNumber;
                        } else {
                            this.hostPortUrl = address + ":" + portAsString;
                        }
                    } else if (portAsString != null) {
                        StringTokenizer portT = new StringTokenizer(portAsString, "/");
                        if (!this.isInteger(portAsString = portT.nextToken())) {
                            int portNumber = JnsObject.getServiceByName(portAsString);
                            if (portNumber == -1) {
                                throw Messages.getSQLException(-79759, ": '" + portAsString + "'");
                            }
                            this.hostPortUrl = address + ":" + portNumber;
                        } else {
                            this.hostPortUrl = address + ":" + portAsString;
                        }
                        String dbName = portT.nextToken(":").substring(1);
                        if (dbName == null || dbName.length() == 0) {
                            this.errorMessage = Messages.getMessage(-79760) + ": '" + dbName + "'";
                            return false;
                        }
                        if (!InformixUrl.isValidDatabaseIdentifier(dbName)) {
                            throw Messages.getSQLException(-79760, dbName);
                        }
                        this.databaseName = dbName;
                    }
                    this.host = address;
                    this.port = portAsString;
                } else {
                    this.databaseName = token1.substring(1, token1.length());
                    this.hostPortUrl = null;
                }
            } else {
                this.hostPortUrl = null;
            }
        }
        return true;
    }

    private static void copyAndCapitalizeKeys(Properties source, Properties target) {
        String key = null;
        Enumeration<Object> e = source.keys();
        while (e.hasMoreElements()) {
            String value;
            Object element = e.nextElement();
            if (element == null || (value = source.getProperty(key = element.toString())) == null) continue;
            target.put(key.toUpperCase(), value);
        }
    }

    private void putInformixVarsIntoProperties() {
        if (this.host != null) {
            this.properties.put("IFXHOST", this.host);
        }
        if (this.port != null) {
            this.properties.put("PORTNO", this.port);
        }
        if (this.databaseName != null) {
            this.properties.put("DATABASE", this.databaseName);
        }
    }

    private void getPropertiesFromUrl(String url) throws SQLException {
        int a;
        int lastColon = -1;
        String propertiesStr = null;
        String propStr = null;
        StringTokenizer tok = null;
        StringTokenizer propT = null;
        if (this.properties.get("DATABASE") == null && this.databaseName != null) {
            this.properties.put("DATABASE", this.databaseName);
        }
        if ((a = url.indexOf(61)) != -1) {
            int b = -1;
            while ((b = url.indexOf(58, (lastColon = b) + 1)) != -1 && b < a) {
            }
            if (lastColon == -1) {
                return;
            }
        }
        if ((propertiesStr = url.substring(lastColon + 1)) != null) {
            tok = new StringTokenizer(propertiesStr, ";");
        }
        if (propertiesStr != null && propertiesStr.indexOf(61) != -1 && tok.hasMoreTokens()) {
            while (tok.hasMoreTokens()) {
                propStr = tok.nextToken(";");
                propT = new StringTokenizer(propStr, "=");
                String key = propT.nextToken();
                String value = propT.nextToken(";").substring(1);
                if (key.equalsIgnoreCase("CSM")) {
                    if (value == null || !value.startsWith("(") || !value.endsWith(")")) {
                        throw Messages.getSQLException(-79705);
                    }
                    String csm_value = value.substring(1, value.length() - 1);
                    this.properties.put("CSM", csm_value);
                    continue;
                }
                this.properties.put(key.toUpperCase(), value);
            }
        }
        if ((this.proxy = this.properties.getProperty("PROXY")) != null) {
            this.formatProxy(this.proxy);
            this.properties.put("PROXY", this.proxy);
        }
        this.properties.put("USERURL", this.url);
    }

    private boolean isInteger(String s) {
        try {
            return Integer.parseInt(s) >= 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isValidDatabaseIdentifier(String identifier) {
        String databaseName = null;
        int index = identifier.lastIndexOf(47);
        databaseName = index != -1 ? identifier.substring(index + 1) : identifier;
        char c = databaseName.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            return false;
        }
        for (int i = 1; i < databaseName.length(); ++i) {
            c = databaseName.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '#') continue;
            return false;
        }
        return true;
    }

    private boolean formatProxy(String url) {
        String beforeQMark = null;
        String afterQMark = null;
        String address = null;
        StringBuilder sb = new StringBuilder("http://");
        int i = url.indexOf(63);
        if (i != -1) {
            beforeQMark = url.substring(0, i);
            afterQMark = url.substring(i, url.length());
        } else {
            beforeQMark = url;
        }
        try {
            address = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return false;
        }
        String token = null;
        StringTokenizer st = new StringTokenizer(beforeQMark, "/");
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if (token.toUpperCase().indexOf("HTTP") != -1 || token.toUpperCase().indexOf("SERVLET") != -1 || token.toUpperCase().indexOf("JDBCPROXY") != -1) continue;
            address = token;
        }
        sb.append(address);
        sb.append("/servlet/IfxJDBCProxy");
        if (afterQMark != null) {
            sb.append(afterQMark);
        }
        this.proxy = sb.toString();
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("InformixUrl [");
        if (this.errorMessage != null) {
            builder.append("errorMessage=");
            builder.append(this.errorMessage);
            builder.append(", ");
        }
        if (this.url != null) {
            builder.append("url=");
            builder.append(this.url);
            builder.append(", ");
        }
        if (this.properties != null) {
            builder.append("properties=");
            builder.append(this.properties);
            builder.append(", ");
        }
        if (this.host != null) {
            builder.append("host=");
            builder.append(this.host);
            builder.append(", ");
        }
        if (this.port != null) {
            builder.append("port=");
            builder.append(this.port);
            builder.append(", ");
        }
        if (this.databaseName != null) {
            builder.append("databaseName=");
            builder.append(this.databaseName);
            builder.append(", ");
        }
        if (this.subProtocol != null) {
            builder.append("subProtocol=");
            builder.append(this.subProtocol);
            builder.append(", ");
        }
        if (this.hostPortUrl != null) {
            builder.append("hostPortUrl=");
            builder.append(this.hostPortUrl);
            builder.append(", ");
        }
        if (this.proxy != null) {
            builder.append("proxy=");
            builder.append(this.proxy);
            builder.append(", ");
        }
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.databaseName == null ? 0 : this.databaseName.hashCode());
        result = 31 * result + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.hostPortUrl == null ? 0 : this.hostPortUrl.hashCode());
        result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.proxy == null ? 0 : this.proxy.hashCode());
        result = 31 * result + (this.subProtocol == null ? 0 : this.subProtocol.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InformixUrl other = (InformixUrl)obj;
        if (this.databaseName == null ? other.databaseName != null : !this.databaseName.equals(other.databaseName)) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.hostPortUrl == null ? other.hostPortUrl != null : !this.hostPortUrl.equals(other.hostPortUrl)) {
            return false;
        }
        if (this.port == null ? other.port != null : !this.port.equals(other.port)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        if (this.proxy == null ? other.proxy != null : !this.proxy.equals(other.proxy)) {
            return false;
        }
        if (this.subProtocol == null ? other.subProtocol != null : !this.subProtocol.equals(other.subProtocol)) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }
}

