/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxResultSet;
import com.informix.jdbc.IfxBSONObject;
import com.informix.jdbc.IfxBlob;
import com.informix.jdbc.IfxCallableStatement;
import com.informix.jdbc.IfxCollection;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDateTime;
import com.informix.jdbc.IfxFParam;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxSmBlob;
import com.informix.jdbc.IfxSqli;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.IfxUpdateResultSet;
import com.informix.jdbc.udt.StringUDT;
import com.informix.jdbcx.IfxXAReusableConnection;
import com.informix.jdbcx.IfxXid;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.lang.Messages;
import com.informix.util.JdbcLogger;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.xa.Xid;

public class IfxResultSet
extends IfxUpdateResultSet
implements IfmxResultSet {
    private static final JdbcLogger log = JdbcLogger.getLogger(IfxResultSet.class);
    private static final AtomicLong RESULTSET_COUNTER = new AtomicLong();
    static final int DIR_FIRST = 3;
    static final int DIR_LAST = 4;
    static final int DIR_ABSL = 6;
    static final int DIR_NEXT = 1;
    static final int DIR_PREV = 2;
    static final int DIR_RELT = 7;
    static final int DIR_CURR = 5;
    protected final IfxProtocol prot;
    protected HashMap<String, Integer> nameToIdxTable;
    protected int curRowID;
    protected int lastRowID = -1;
    protected boolean scrollableEmptyResultSet = false;
    protected boolean lastColWasNull;
    protected Vector<IfxObject> colVector;
    protected Vector<String> keyNameVector;
    protected boolean noMoreRows;
    static final int IS_XA_TX = 1;
    protected boolean isClosed;
    private Xid connectXid = null;
    private boolean pending = false;
    private int fetchSize = 0;
    private int tupleSizeReceived = 0;
    protected boolean withHold = false;
    private final long id = RESULTSET_COUNTER.incrementAndGet();

    IfxResultSet(IfxStatement thisStatement, IfxConnection conn, IfxProtocol prot) throws SQLException {
        super(conn, thisStatement);
        if (prot == null) {
            throw Messages.getSQLException(-79736, conn);
        }
        this.prot = prot;
        this.fetchSize = thisStatement.getFetchSize();
        boolean bl = this.pending = !conn.getAutoCommit();
        if (conn.isXAConnection()) {
            this.connectXid = ((IfxXAReusableConnection)conn).getCurrentXid();
        }
        this.lastRowID = 0;
        log.debug("ResultSet #{} created from Statement #{}", this.id, (Object)thisStatement.getId());
    }

    void executeQuery(boolean withHold, boolean withReOptimization) throws SQLException {
        this.executeQuery(null, withHold, withReOptimization);
    }

    void executeQuery(IfxResultSetMetaData outputMetaData, boolean withHold, boolean withReOptimization) throws SQLException {
        this.clearWarnings();
        this.withHold = withHold;
        this.prot.executeStatementQuery(this.stmt, withHold, withReOptimization, outputMetaData);
        this.curRowID = 0;
        this.lastRowID = 0;
        this.rsmd = this.getMetaData();
    }

    int executeUpdate() throws SQLException {
        this.clearWarnings();
        if (this.stmt instanceof IfxPreparedStatement && !((IfxSqliConnect)this.conn).usePut) {
            List<IfxObject> vec = this.stmt.executeBatchInProgress ? ((IfxPreparedStatement)this.stmt).getBatchParamVector() : ((IfxPreparedStatement)this.stmt).getVector();
            for (IfxObject ival : vec) {
                if (!(ival instanceof IfxSmBlob)) continue;
                IfxSmBlob sval = (IfxSmBlob)ival;
                short type = sval.blobType;
                if (type == 2 || type == 1) {
                    sval.createBlobOnServer(sval.BlobInputStream, sval.sm_size);
                    continue;
                }
                if (type != 3) continue;
                sval.createBlobOnServer(sval.BlobCharInputStream, sval.sm_size);
            }
        }
        this.prot.executeCommand(this.stmt);
        this.curRowID = 0;
        this.lastRowID = 0;
        return this.prot.getNumberOfRowsProcessed();
    }

    Vector<IfxObject> executeFastPath(String signature, ResultSetMetaData pmd, Vector<IfxObject> inParams, boolean outParam2, boolean request_fparam) throws SQLException {
        this.clearWarnings();
        ((IfxSqli)this.prot).executeFastPath(signature, pmd, inParams, outParam2, request_fparam);
        this.curRowID = 0;
        this.lastRowID = 0;
        return this.prot.getFPReturnVector();
    }

    IfxFParam getFParam() {
        return this.prot.getFParam();
    }

    boolean executeExecute(boolean holdable, boolean withReOptimized, IfxResultSetMetaData outputMetaData) throws SQLException {
        this.clearWarnings();
        if (this.stmt instanceof IfxPreparedStatement && !((IfxSqliConnect)this.conn).usePut) {
            for (IfxObject ival : ((IfxPreparedStatement)this.stmt).getVector()) {
                if (!(ival instanceof IfxSmBlob)) continue;
                IfxSmBlob sval = (IfxSmBlob)ival;
                short type = sval.blobType;
                if (sval.sm_size < -1L) continue;
                switch (type) {
                    case 1: {
                        sval.createBlobOnServer(sval.blobBuffer, sval.sm_size);
                        break;
                    }
                    case 2: {
                        sval.createBlobOnServer(sval.BlobInputStream, sval.sm_size);
                        break;
                    }
                    case 3: {
                        sval.createBlobOnServer(sval.BlobCharInputStream, sval.sm_size);
                    }
                }
            }
        }
        this.prot.executeExecute(this.stmt, holdable, withReOptimized, outputMetaData);
        return this.prot.isResultSet();
    }

    @Override
    public boolean next() throws SQLException {
        boolean isMore;
        boolean scrollable;
        if (this.isClosed) {
            log.error("Trying to call next() on ResultSet #{} from Statement #{} which is already closed", (Object)this.id, (Object)this.stmt.getId());
            throw Messages.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw Messages.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.lastRowID == -1) {
            return false;
        }
        if (this.lastRowID != 0 && this.curRowID >= this.lastRowID) {
            if (this.curRowID == this.lastRowID) {
                ++this.curRowID;
            }
            return false;
        }
        int maxRows = this.stmt.getMaxRows();
        if (maxRows != 0 && this.curRowID >= maxRows) {
            this.lastRowID = maxRows;
            this.curRowID = this.lastRowID + 1;
            return false;
        }
        boolean bl = scrollable = this.stmt.getResultSetType() == 1004;
        if (scrollable) {
            this.scrollableEmptyResultSet = false;
            isMore = this.prot.getaRow(this.stmt.getFetchDirection(), ++this.curRowID, 1, scrollable, this.stmt);
            if (!isMore) {
                if (this.curRowID - 1 == 0 && this.lastRowID == 0) {
                    this.scrollableEmptyResultSet = true;
                }
                this.lastRowID = this.curRowID - 1;
            }
        } else {
            isMore = this.prot.getaRow(this.stmt.getFetchDirection(), 1, 1, scrollable, this.stmt);
        }
        if (!isMore) {
            return false;
        }
        if (this.colVector == null) {
            this.colVector = new Vector(this.getMetaData().getColumnCount());
            this.colVector.setSize(this.getMetaData().getColumnCount());
            if (this.stmt.getResultSetConcurrency() == 1008) {
                this.MoveToInsert = false;
                if (this.UpdateColVector == null) {
                    this.UpdateColVector = new Vector<IfxObject>(this.colVector);
                }
            }
        } else {
            this.clearColumnVector();
            if (this.stmt.getResultSetConcurrency() == 1008) {
                this.clearUpdateColVector();
            }
        }
        if (!scrollable) {
            ++this.curRowID;
        }
        return true;
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        Integer idx;
        if (this.nameToIdxTable == null) {
            if (this.rsmd == null) {
                this.getMetaData();
            }
            if (this.rsmd == null) {
                throw Messages.getSQLException(-79737, this.conn);
            }
            int numCols = this.rsmd.getColumnCount();
            this.nameToIdxTable = new HashMap(numCols);
            for (int i = 1; i <= numCols; ++i) {
                this.nameToIdxTable.put(this.rsmd.getColumnInfo((int)i).ColName, i);
            }
        }
        if (!this.conn.isDelimIdentSet()) {
            if (this.conn.isDirect()) {
                columnName = columnName.trim();
            }
            idx = this.nameToIdxTable.get(columnName.toLowerCase());
        } else {
            idx = this.nameToIdxTable.get(columnName);
        }
        if (idx == null) {
            throw Messages.getSQLException(-79738, columnName, this.conn);
        }
        return idx;
    }

    IfxObject getValue(int columnIndex) throws SQLException {
        return this.getValue(columnIndex, null);
    }

    IfxObject getValue(int columnIndex, Calendar cal) throws SQLException {
        if (this.isClosed) {
            throw Messages.getSQLException(-79868, this.conn);
        }
        if (this.colVector == null) {
            throw Messages.getSQLException(-79739, this.conn);
        }
        if (columnIndex < 1 || columnIndex > this.colVector.size()) {
            throw Messages.getSQLException(-79703, this.conn);
        }
        IfxObject value = this.colVector.get(columnIndex - 1);
        if (value == null) {
            value = this.prot instanceof IfxSqli ? ((IfxSqli)this.prot).getColumnInRow(columnIndex, cal) : this.prot.getColumnInRow(columnIndex);
            this.colVector.setElementAt(value, columnIndex - 1);
        } else {
            if (cal != null && value instanceof IfxDateTime) {
                ((IfxDateTime)value).dbCalendar = cal;
            }
            this.prot.loadColumnData(columnIndex, value);
        }
        if (value.isNull()) {
            this.lastColWasNull = true;
            return null;
        }
        if (value.getWarning() != null) {
            this.prot.chainWarnings(new DataTruncation(columnIndex, false, true, value.getWarning().getDataSize(), value.getWarning().getTransferSize()));
        }
        this.lastColWasNull = false;
        this.blobCheck(value);
        return value;
    }

    IfxObject getValueFastPath(int columnIndex) throws SQLException {
        return this.prot.getColumnInRow(columnIndex);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        int length;
        IfxObject value = this.getValue(columnIndex);
        if (value == null) {
            return null;
        }
        String S = value.getClass().getName().endsWith("IfxSmBlob") ? ((IfxSmBlob)value).toClobString() : value.toString();
        if (this.stmt != null && (length = this.stmt.getMaxFieldSize()) > 0) {
            int columnType = this.rsmd.getColumnType(columnIndex);
            if (S.length() > length && (columnType == 1 || columnType == 12 || columnType == -1 || columnType == -2 || columnType == -3 || columnType == -4)) {
                S = S.substring(0, length);
            }
        }
        return S;
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getObject(columnIndex, this.conn.getTypeMap());
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (value == null || value.isNull()) {
            return null;
        }
        InputStream is = value.extendedID == 11 && ((IfxSqliConnect)this.conn).isConvText() ? ((IfxSqli)this.prot).toClobStream((IfxSmBlob)value) : value.toAsciiStream();
        return is;
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (value == null || value.isNull()) {
            return null;
        }
        return value.toCharacterStream();
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (value == null || value.isNull()) {
            return null;
        }
        return value.toDecimal().setScale(scale, 4);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (value == null || value.isNull()) {
            return null;
        }
        return value.toDecimal();
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (value == null || value.isNull()) {
            return false;
        }
        return value.toBoolean();
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (value == null || value.isNull()) {
            return 0;
        }
        return value.toShort();
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (value == null || value.isNull()) {
            return 0;
        }
        return value.toInt();
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (value == null || value.isNull()) {
            return 0L;
        }
        return value.toLong();
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (value == null || value.isNull()) {
            return 0.0f;
        }
        return value.toFloat();
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (value == null || value.isNull()) {
            return 0;
        }
        return value.toByte();
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (value == null || value.isNull()) {
            return null;
        }
        return value.toBytes();
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (value == null || value.isNull()) {
            return null;
        }
        return value.toDate();
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (value == null || value.isNull()) {
            return 0.0;
        }
        return value.toDouble();
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (value == null || value.isNull()) {
            return null;
        }
        return value.toTime();
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, (Calendar)null);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        IfxObject value = this.getValue(columnIndex, cal);
        if (value == null || value.isNull()) {
            return null;
        }
        value.setConnection(this.conn);
        return value.toTimestamp();
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw Messages.getSQLException(-79700, ": ResultSet.getUnicodeStream(int).", this.conn);
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        throw Messages.getSQLException(-79700, ": ResultSet.getUnicodeStream(String).", this.conn);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (value == null || value.isNull()) {
            return null;
        }
        return value.toBinaryStream();
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public SQLWarning getWarnings() {
        return this.prot.getWarnings();
    }

    @Override
    public void clearWarnings() {
        this.prot.clearWarnings();
    }

    @Override
    public String getCursorName() throws SQLException {
        if (this.stmt == null) {
            throw Messages.getSQLException(-79740, this.conn);
        }
        return this.stmt.getCursorName();
    }

    @Override
    public IfxResultSetMetaData getMetaData() throws SQLException {
        if (this.isClosed) {
            throw Messages.getSQLException(-79878, this.conn);
        }
        this.rsmd = (IfxResultSetMetaData)this.prot.getMetaData();
        return this.rsmd;
    }

    @Override
    public Object getObject(int colIdx, Map<String, Class<?>> map) throws SQLException {
        if (this.isClosed) {
            throw Messages.getSQLException(-79878, this.conn);
        }
        IfxObject value = this.getValue(colIdx);
        if (value != null && !value.isNull()) {
            value.setTypeMap(map);
            Object o = value.toObject();
            if (o instanceof StringUDT) {
                return ((StringUDT)o).toString();
            }
            return o;
        }
        return null;
    }

    @Override
    public Object getObject(String columnName, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(columnName), map);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastColWasNull;
    }

    int getUpdateCount() throws SQLException {
        if (this.isClosed() || this.prot.isResultSet()) {
            return -1;
        }
        return this.prot.getNumberOfRowsProcessed();
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        log.debug("Closing ResultSet #{}", this.id);
        this.isClosed = true;
        if (this.prot != null && this.stmt.cursorOpen) {
            this.prot.executeClose(this.stmt);
        }
        if (!(this.stmt instanceof IfxPreparedStatement) && !(this.stmt instanceof IfxCallableStatement)) {
            this.closePrev();
        } else {
            this.clear();
        }
        this.stmt.resultSetClosed(this);
    }

    void clear() throws SQLException {
        if (this.nameToIdxTable != null) {
            this.nameToIdxTable.clear();
            this.nameToIdxTable = null;
        }
        this.lastColWasNull = false;
        this.curRowID = 0;
        this.lastRowID = 0;
        this.clearColumnVector();
        if (this.colVector != null) {
            this.colVector.clear();
            this.colVector = null;
        }
        if (this.keyNameVector != null) {
            this.keyNameVector.clear();
            this.keyNameVector = null;
        }
        if (this.WhereVal != null) {
            this.WhereVal.clear();
            this.WhereVal = null;
        }
        if (((IfxSqliConnect)this.conn).freeclobwithrs) {
            try {
                ((IfxSqliConnect)this.conn).deleteAllFiles();
            }
            catch (Exception e) {
                throw Messages.getSQLException(-79716, e.toString(), (IfxConnection)((IfxSqliConnect)this.conn));
            }
        }
    }

    void closePrev() throws SQLException {
        log.debug("Releasing ResultSet #{}", this.id);
        this.prot.executeRelease(this.stmt);
        this.clear();
        if (this.UpdateColVector != null) {
            this.UpdateColVector.removeAllElements();
            this.UpdateColVector = null;
        }
    }

    private void clearColumnVector() {
        if (this.colVector != null) {
            int colSize = this.colVector.size();
            for (int i = 0; i < colSize; ++i) {
                IfxObject obj = this.colVector.get(i);
                if (obj == null) continue;
                obj.clear();
            }
        }
    }

    protected void blobCheck(IfxObject obj) throws SQLException {
        IfxBlob BlobObject;
        if (obj instanceof IfxBlob && !(BlobObject = (IfxBlob)obj).isBlobLoaded()) {
            try {
                this.prot.executeFetchBlob(BlobObject);
            }
            catch (Exception e) {
                SQLException sqlException = Messages.getSQLException(-79701, this.conn);
                if (e instanceof SQLException) {
                    sqlException.setNextException((SQLException)e);
                }
                sqlException = Messages.setSQLExceptionCause(sqlException, e);
                throw sqlException;
            }
            BlobObject.setLoaded();
        }
    }

    int getSerial() {
        return this.prot.getSerialInsert();
    }

    long getSerial8() {
        return this.prot.getSerial8Inserted();
    }

    @Override
    public Interval getInterval(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (value == null || value.isNull()) {
            return null;
        }
        return value.toInterval();
    }

    @Override
    public Interval getInterval(String columnName) throws SQLException {
        return this.getInterval(this.findColumn(columnName));
    }

    @Override
    public IntervalYM getIntervalYM(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (value == null || value.isNull()) {
            return null;
        }
        return value.toIntervalYM();
    }

    @Override
    public IntervalYM getIntervalYM(String columnName) throws SQLException {
        return this.getIntervalYM(this.findColumn(columnName));
    }

    @Override
    public IntervalDF getIntervalDF(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (value == null || value.isNull()) {
            return null;
        }
        return value.toIntervalDF();
    }

    @Override
    public IntervalDF getIntervalDF(String columnName) throws SQLException {
        return this.getIntervalDF(this.findColumn(columnName));
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    boolean isAccessible() {
        Xid currentXid;
        if (!this.conn.inXATransaction() && this.connectXid == null) {
            return true;
        }
        return this.conn.inXATransaction() && this.connectXid != null && IfxXid.equals(this.connectXid, currentXid = ((IfxXAReusableConnection)this.conn).getCurrentXid());
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.isClosed) {
            throw Messages.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw Messages.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.curRowID > 0 || this.lastRowID == -1) {
            return false;
        }
        int numberTuples = ((IfxSqli)this.prot).getNumberOfTuplesReceived();
        int numberFetches = ((IfxSqli)this.prot).getNumberOfFetches();
        if (numberTuples == 0 && numberFetches == 0 && this.first()) {
            this.previous();
        }
        if (((IfxSqli)this.prot).getNumberOfTuplesReceived() == 0) {
            this.lastRowID = -1;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.isClosed) {
            throw Messages.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw Messages.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.curRowID < 1 || this.lastRowID < 1) {
            return false;
        }
        return this.curRowID == this.lastRowID + 1;
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.isClosed) {
            throw Messages.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw Messages.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        return this.lastRowID > -1 && this.curRowID == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.isClosed) {
            throw Messages.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw Messages.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.lastRowID == -1) {
            return false;
        }
        if (this.lastRowID == 0) {
            int svcurRowID = this.curRowID;
            boolean b = this.last();
            this.lastRowID = this.curRowID;
            if (svcurRowID == 0) {
                this.curRowID = 0;
            } else {
                boolean bl = this.absolute(svcurRowID);
            }
        }
        return this.curRowID > 0 && this.curRowID == this.lastRowID;
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.isClosed) {
            throw Messages.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw Messages.getSQLException(-259, this.conn);
        }
        if (this.curRowID == 0) {
            return;
        }
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw Messages.getSQLException(-79767, this.conn);
        }
        this.curRowID = 0;
        if (this.absolute(1)) {
            this.previous();
        }
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.isClosed) {
            throw Messages.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw Messages.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw Messages.getSQLException(-79767, this.conn);
        }
        if (this.lastRowID != 0) {
            this.curRowID = this.lastRowID + 1;
        } else {
            if (((IfxSqli)this.prot).getNumberOfFetches() != 0 && ((IfxSqli)this.prot).getNumberOfTuplesReceived() == 0) {
                this.lastRowID = -1;
                return;
            }
            boolean b = this.last();
            if (b) {
                this.curRowID = this.lastRowID + 1;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean first() throws SQLException {
        if (this.isClosed) {
            throw Messages.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw Messages.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw Messages.getSQLException(-79767, this.conn);
        }
        if (this.lastRowID < 0) {
            return false;
        }
        boolean isMore = this.prot.getaRow(this.stmt.getFetchDirection(), 1, 6, true, this.stmt);
        if (!isMore) {
            this.lastRowID = -1;
            return false;
        }
        this.curRowID = this.prot.getTupid();
        if (this.colVector == null) {
            try {
                this.colVector = new Vector();
                this.colVector.setSize(this.getMetaData().getColumnCount());
                if (this.stmt.getResultSetConcurrency() != 1008) return true;
                this.MoveToInsert = false;
                if (this.UpdateColVector != null) return true;
                this.UpdateColVector = new Vector<IfxObject>(this.colVector);
                return true;
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw Messages.getSQLException(-79716, e.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
            if (this.stmt.getResultSetConcurrency() != 1008) return true;
            this.clearUpdateColVector();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean last() throws SQLException {
        if (this.isClosed) {
            throw Messages.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw Messages.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw Messages.getSQLException(-79767, this.conn);
        }
        boolean isMore = false;
        if (this.lastRowID == -1) {
            return false;
        }
        isMore = this.lastRowID == 0 ? this.prot.getaRow(this.stmt.getFetchDirection(), 0, 4, true, this.stmt) : this.prot.getaRow(this.stmt.getFetchDirection(), this.lastRowID, 6, true, this.stmt);
        if (!isMore) {
            this.lastRowID = -1;
            return false;
        }
        this.lastRowID = this.curRowID = this.prot.getTupid();
        if (this.colVector == null) {
            try {
                this.colVector = new Vector();
                this.colVector.setSize(this.getMetaData().getColumnCount());
                if (this.stmt.getResultSetConcurrency() != 1008) return true;
                this.MoveToInsert = false;
                if (this.UpdateColVector != null) return true;
                this.UpdateColVector = new Vector<IfxObject>(this.colVector);
                return true;
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw Messages.getSQLException(-79716, e.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
            if (this.stmt.getResultSetConcurrency() != 1008) return true;
            this.clearUpdateColVector();
        }
        return true;
    }

    @Override
    public int getRow() throws SQLException {
        if (this.scrollableEmptyResultSet) {
            return 0;
        }
        if (this.lastRowID > 0 && this.curRowID > this.lastRowID) {
            return 0;
        }
        return this.curRowID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean absolute(int row) throws SQLException {
        boolean isMore = false;
        if (this.isClosed) {
            throw Messages.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw Messages.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw Messages.getSQLException(-79767, this.conn);
        }
        if (row == 0) {
            this.beforeFirst();
            return false;
        }
        if (this.lastRowID == -1) {
            return false;
        }
        if (row > 0) {
            if (this.lastRowID > 0 && row > this.lastRowID) {
                this.afterLast();
                return false;
            }
            isMore = this.prot.getaRow(this.stmt.getFetchDirection(), row, 6, true, this.stmt);
        } else if (row < 0) {
            if (this.lastRowID == 0 && !this.last()) {
                return false;
            }
            this.curRowID = this.lastRowID + row + 1;
            if (this.curRowID < 1) {
                this.curRowID = 0;
                return false;
            }
            isMore = this.prot.getaRow(this.stmt.getFetchDirection(), this.curRowID, 6, true, this.stmt);
        }
        if (!isMore) {
            this.afterLast();
            return false;
        }
        this.curRowID = this.prot.getTupid();
        if (this.colVector == null) {
            try {
                this.colVector = new Vector();
                this.colVector.setSize(this.getMetaData().getColumnCount());
                if (this.stmt.getResultSetConcurrency() != 1008) return true;
                this.MoveToInsert = false;
                if (this.UpdateColVector != null) return true;
                this.UpdateColVector = new Vector<IfxObject>(this.colVector);
                return true;
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw Messages.getSQLException(-79716, e.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
            if (this.stmt.getResultSetConcurrency() != 1008) return true;
            this.clearUpdateColVector();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean relative(int rows) throws SQLException {
        if (this.isClosed) {
            throw Messages.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw Messages.getSQLException(-259, this.conn);
        }
        if (rows == 0) {
            return true;
        }
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw Messages.getSQLException(-79767, this.conn);
        }
        if (this.curRowID == 0) {
            throw Messages.getSQLException(-79739, this.conn);
        }
        if (this.lastRowID > 0 && this.curRowID > this.lastRowID) {
            throw Messages.getSQLException(-79739, this.conn);
        }
        int requestedRow = this.curRowID + rows;
        if (requestedRow < 1) {
            this.beforeFirst();
            return false;
        }
        if (this.lastRowID > 0 && requestedRow > this.lastRowID) {
            this.afterLast();
            return false;
        }
        boolean isMore = this.prot.getaRow(this.stmt.getFetchDirection(), requestedRow, 6, true, this.stmt);
        if (!isMore) {
            this.afterLast();
            return false;
        }
        this.curRowID = this.prot.getTupid();
        if (this.colVector == null) {
            try {
                this.colVector = new Vector();
                this.colVector.setSize(this.getMetaData().getColumnCount());
                if (this.stmt.getResultSetConcurrency() != 1008) return true;
                this.MoveToInsert = false;
                if (this.UpdateColVector != null) return true;
                this.UpdateColVector = new Vector<IfxObject>(this.colVector);
                return true;
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw Messages.getSQLException(-79716, e.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
            if (this.stmt.getResultSetConcurrency() != 1008) return true;
            this.clearUpdateColVector();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean previous() throws SQLException {
        if (this.isClosed) {
            throw Messages.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw Messages.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw Messages.getSQLException(-79767, this.conn);
        }
        if (this.lastRowID < 0 || this.curRowID <= 0) {
            return false;
        }
        this.curRowID += -1;
        boolean isMore = this.prot.getaRow(this.stmt.getFetchDirection(), this.curRowID, 6, true, this.stmt);
        if (!isMore) {
            return false;
        }
        this.curRowID = this.prot.getTupid();
        if (this.colVector == null) {
            try {
                this.colVector = new Vector();
                this.colVector.setSize(this.getMetaData().getColumnCount());
                if (this.stmt.getResultSetConcurrency() != 1008) return true;
                this.MoveToInsert = false;
                if (this.UpdateColVector != null) return true;
                this.UpdateColVector = new Vector<IfxObject>(this.colVector);
                return true;
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw Messages.getSQLException(-79716, e.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
            if (this.stmt.getResultSetConcurrency() != 1008) return true;
            this.clearUpdateColVector();
        }
        return true;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.stmt.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.stmt.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (this.isClosed) {
            throw Messages.getSQLException(-79868, this.conn);
        }
        if (rows < 0) {
            throw Messages.getSQLException(-79700, ": ResultSet.setFetchSize(int).", this.conn);
        }
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.isClosed) {
            throw Messages.getSQLException(-79868);
        }
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        return this.stmt.getResultSetType();
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.stmt.getResultSetConcurrency();
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x, scale);
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.stmt;
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw Messages.getSQLException(-79700, ": ResultSet.getRef(int).", this.conn);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (value == null || value.isNull()) {
            return null;
        }
        return value.toBlob();
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (value == null || value.isNull()) {
            return null;
        }
        return value.toClob();
    }

    @Override
    public Array getArray(int colIdx) throws SQLException {
        IfxCollection value = (IfxCollection)this.getValue(colIdx);
        Array array = null;
        if (value != null && !value.isNull()) {
            array = value.toArray();
        }
        return array;
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        throw Messages.getSQLException(-79700, ": ResultSet.getRef(String).", this.conn);
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        int idx = this.findColumn(colName);
        return this.getBlob(idx);
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        return this.getArray(this.findColumn(colName));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date tmpdate = this.getDate(columnIndex);
        if (tmpdate == null) {
            return null;
        }
        Calendar defCal = Calendar.getInstance();
        if (cal == null) {
            cal = defCal;
        }
        defCal.setTime(tmpdate);
        long tm = tmpdate.getTime();
        long utc = tm + (long)(defCal.get(15) + defCal.get(16));
        long usr = utc - (long)(cal.get(15) + cal.get(16));
        return new Date(usr);
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Time tmptime = this.getTime(columnIndex);
        if (tmptime == null) {
            return null;
        }
        long tm = tmptime.getTime() + (long)cal.get(15) + (long)cal.get(16);
        return new Time(tm);
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    private void getRSPKeys(String TableName, boolean getkeyflag, boolean isForUpdateClause) throws SQLException {
        int i;
        int primarykeyidx;
        String keyName = null;
        ResultSet primaryKeyRS = null;
        DatabaseMetaData dbmd = this.conn.getMetaData();
        String dbmdCatalog = "";
        String dbmdSchema = "";
        String dbmdTabname = "";
        int ix_colon = TableName.indexOf(58);
        int ix_period = TableName.indexOf(46);
        if (ix_colon < 0 && ix_period < 0 || ix_colon == 0 || ix_period == 0 || ix_period + 1 == TableName.length() || ix_colon + 1 == TableName.length() || ix_period > 0 && ix_colon + 1 >= ix_period) {
            dbmdTabname = TableName;
        } else {
            int ix_cur = 0;
            if (ix_colon > 0) {
                dbmdCatalog = TableName.substring(0, ix_colon);
                ix_cur = ix_colon + 1;
            }
            if (ix_period > 0) {
                dbmdSchema = TableName.substring(ix_cur, ix_period);
                ix_cur = ix_period + 1;
            }
            dbmdTabname = TableName.substring(ix_cur);
        }
        if (!getkeyflag) {
            int i2;
            StringBuilder instr = new StringBuilder(200);
            instr.append("insert into ").append(TableName).append("(");
            boolean first = false;
            int count = 0;
            for (i2 = 0; i2 < this.UpdateColVector.size(); ++i2) {
                IfxObject val = (IfxObject)this.UpdateColVector.get(i2);
                if (val == null || !val.get_used_in_update()) continue;
                if (first) {
                    instr.append(",");
                }
                instr.append(this.rsmd.getColumnInfo((int)(i2 + 1)).ColName);
                first = true;
                ++count;
            }
            instr.append(") values (");
            first = false;
            for (i2 = 0; i2 < count; ++i2) {
                if (first) {
                    instr.append(",");
                }
                instr.append("?");
                first = true;
            }
            instr.append(");");
            this.insertCmd = instr.toString();
            return;
        }
        if (this.keyNameVector == null) {
            this.keyNameVector = new Vector();
            this.WhereVal = new Vector();
            if (this.rsmd.findrowid() != -1) {
                this.keyNameVector.add("rowid");
                this.WhereVal.add(this.getValue(this.rsmd.rowidx));
            } else {
                keyName = this.rsmd.findserial();
                if (keyName != null) {
                    this.keyNameVector.add(keyName);
                    this.WhereVal.add(this.getValue(this.rsmd.serialidx));
                } else {
                    primaryKeyRS = dbmd.getPrimaryKeys(dbmdCatalog, dbmdSchema, dbmdTabname);
                    if (primaryKeyRS != null) {
                        while (primaryKeyRS.next()) {
                            String name = primaryKeyRS.getString(4);
                            this.keyNameVector.add(name);
                            primarykeyidx = this.findColumn(name);
                            this.WhereVal.add(this.getValue(primarykeyidx));
                        }
                        primaryKeyRS.close();
                    }
                }
            }
            if (this.keyNameVector.isEmpty()) {
                throw Messages.getSQLException(-79817, this.conn);
            }
        } else {
            this.WhereVal.clear();
            if (this.rsmd.rowidx != -1) {
                this.WhereVal.add(this.getValue(this.rsmd.rowidx));
            } else if (this.rsmd.serialidx != -1) {
                this.WhereVal.add(this.getValue(this.rsmd.serialidx));
            } else {
                for (i = 0; i < this.keyNameVector.size(); ++i) {
                    String name = this.keyNameVector.get(i);
                    primarykeyidx = this.findColumn(name);
                    this.WhereVal.add(this.getValue(primarykeyidx));
                }
            }
        }
        StringBuilder upstr = new StringBuilder(200);
        boolean first = false;
        upstr.append("update ").append(TableName).append(" set ");
        for (i = 0; i < this.UpdateColVector.size(); ++i) {
            IfxObject val = (IfxObject)this.UpdateColVector.get(i);
            if (val == null || !val.get_used_in_update()) continue;
            if (first) {
                upstr.append(", ");
            }
            upstr.append(this.rsmd.getColumnInfo((int)(i + 1)).ColName).append(" = ? ");
            first = true;
        }
        StringBuilder delstr = new StringBuilder(200);
        delstr.append("delete from ").append(TableName).append(" ");
        StringBuilder whereClause = new StringBuilder(200);
        whereClause.append("where ");
        if (isForUpdateClause) {
            whereClause.append("current of " + this.stmt.getCursorName() + " ;");
        } else {
            for (i = 0; i < this.keyNameVector.size(); ++i) {
                whereClause.append(this.keyNameVector.get(i)).append(" = ?");
                if (i < this.keyNameVector.size() - 1) {
                    whereClause.append(" and ");
                    continue;
                }
                whereClause.append(" ");
            }
            whereClause.append(";");
        }
        delstr.append(whereClause.toString());
        upstr.append(whereClause.toString());
        this.updateCmd = upstr.toString();
        this.deleteCmd = delstr.toString();
    }

    private void validateUpdateCall(boolean getkeyflag) throws SQLException {
        if (this.stmt.getResultSetConcurrency() != 1008) {
            throw Messages.getSQLException(-79818, this.conn);
        }
        if (this.UpdateColVector == null || this.updatecanceled) {
            throw Messages.getSQLException(-79739, this.conn);
        }
        String TableName = IfxResultSetMetaData.parseTableName(this.stmt.commandString);
        if (TableName == null) {
            throw Messages.getSQLException(-79816, this.conn);
        }
        this.isForUpdateClause = false;
        String tmpStmt = this.stmt.commandString.toUpperCase().trim();
        if (tmpStmt != null && tmpStmt.startsWith("SELECT")) {
            if (tmpStmt.endsWith(";")) {
                tmpStmt = tmpStmt.substring(0, tmpStmt.indexOf(";"));
            }
            this.isForUpdateClause = tmpStmt.endsWith("FOR UPDATE");
        }
        this.getRSPKeys(TableName, getkeyflag, this.isForUpdateClause);
        this.updatecanceled = false;
    }

    private void validate(int columnIndex) throws SQLException {
        if (this.isClosed) {
            throw Messages.getSQLException(-79868, this.conn);
        }
        if (columnIndex < 1 || columnIndex > this.colVector.size()) {
            throw Messages.getSQLException(-79703, this.conn);
        }
        if (this.stmt.getResultSetConcurrency() == 1007) {
            throw Messages.getSQLException(-80054, this.conn);
        }
    }

    @Override
    public void insertRow() throws SQLException {
        if (!this.MoveToInsert) {
            throw Messages.getSQLException(-79815, this.conn);
        }
        this.validateUpdateCall(false);
        super.insertRow();
    }

    @Override
    public void updateRow() throws SQLException {
        if (this.MoveToInsert) {
            throw Messages.getSQLException(-79819, this.conn);
        }
        this.validateUpdateCall(true);
        super.updateRow();
    }

    @Override
    public void deleteRow() throws SQLException {
        if (this.MoveToInsert) {
            throw Messages.getSQLException(-79819, this.conn);
        }
        this.validateUpdateCall(true);
        super.deleteRow();
    }

    int getTupleBufferSize() {
        return ((IfxSqli)this.prot).getTupleBufferSize(0);
    }

    int getTupleSize() throws SQLException {
        return ((IfxSqli)this.prot).getTupleSize();
    }

    public IfxProtocol getProtocol() {
        return this.prot;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw Messages.getSQLException(-79700, ": IfxResultSet.getURL(int)", this.conn);
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return this.getURL(this.findColumn(columnName));
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw Messages.getSQLException(-79700, ": IfxResultSet.updateRef(int)", this.conn);
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw Messages.getSQLException(-79700, ": IfxResultSet.updateRef(String)", this.conn);
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.updateBlob(this.findColumn(columnName), x);
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        this.updateClob(this.findColumn(columnName), x);
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        this.updateArray(this.findColumn(columnName), x);
    }

    public void releaseBlob() {
        if (((IfxSqliConnect)this.conn).autoCommit) {
            ((IfxSqliConnect)this.conn).releaseBlob();
        }
    }

    void setPending(boolean b) {
        this.pending = b;
    }

    boolean isPending() {
        return this.pending;
    }

    @Override
    public String getUnloadString(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (value == null || value.isNull()) {
            return null;
        }
        value.setConnection(this.conn);
        return value.toUnloadString();
    }

    int calculateFetchBufferSize() throws SQLException {
        if (this.rsmd == null) {
            return this.tupleSizeReceived;
        }
        IfxStatement stmtRS = (IfxStatement)this.getStatement();
        int rsFetchSize = this.getFetchSize();
        int maxRows = stmtRS.getMaxRows();
        if (rsFetchSize == 0 && maxRows == 0) {
            return 0;
        }
        int fetchSize = rsFetchSize;
        if (maxRows != 0) {
            fetchSize = rsFetchSize != 0 ? Math.min(rsFetchSize, maxRows) : maxRows;
        }
        int colIx = this.rsmd.getColumnCount();
        int sizeViaLast = this.rsmd.getColumnStartPosition(colIx) + this.rsmd.getColumnLength(colIx);
        if (this.rsmd.isVariableLengthType(colIx)) {
            sizeViaLast += 5;
        }
        int maxTupleSize = Math.max(sizeViaLast, this.rsmd.getTupleSize());
        maxTupleSize = Math.max(maxTupleSize, this.tupleSizeReceived);
        return fetchSize * maxTupleSize;
    }

    protected void setTupleSizeReceived(int sizeReceived) {
        this.tupleSizeReceived = sizeReceived;
    }

    long getBigSerial() {
        return this.prot.getBigSerialInserted();
    }

    @Override
    public int getHoldability() {
        return this.withHold ? 1 : 2;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(columnLabel);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return (NClob)this.getClob(columnIndex);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return (NClob)this.getClob(columnLabel);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw Messages.getSQLException(-79700, ": IfxResultSet.getRowId(int)", this.conn);
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw Messages.getSQLException(-79700, ": IfxResultSet.getRowId(String)", this.conn);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw Messages.getSQLException(-79700, ": IfxResultSet.getSQLXML(int)", this.conn);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw Messages.getSQLException(-79700, ": IfxResultSet.getSQLXML(String)", this.conn);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.validate(columnIndex);
        super.updateAsciiStream(columnIndex, x, -1L);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(columnIndex, x, (long)length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        super.updateBinaryStream(columnIndex, x, -1L);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        super.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        super.updateBinaryStream(columnIndex, inputStream, -1L);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), inputStream);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        super.updateBinaryStream(columnIndex, inputStream, length);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), inputStream, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        super.updateCharacterStream(columnIndex, x, -1L);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        super.updateCharacterStream(this.findColumn(columnLabel), reader, -1L);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        super.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        super.updateCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        super.updateCharacterStream(columnIndex, reader, -1L);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        super.updateCharacterStream(this.findColumn(columnLabel), reader, -1L);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        super.updateCharacterStream(columnIndex, reader, length);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        super.updateCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        super.updateCharacterStream(columnIndex, x, -1L);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        super.updateCharacterStream(this.findColumn(columnLabel), reader, -1L);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        super.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        super.updateCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.updateClob(columnIndex, (Clob)nClob);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.updateClob(this.findColumn(columnLabel), (Clob)nClob);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        super.updateCharacterStream(columnIndex, reader, -1L);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        super.updateCharacterStream(this.findColumn(columnLabel), reader, -1L);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        super.updateCharacterStream(columnIndex, reader, length);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        super.updateCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.updateString(columnIndex, nString);
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.updateString(columnLabel, nString);
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw Messages.getSQLException(-79700, ": IfxResultSet.updateRowId(int, RowId)", this.conn);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw Messages.getSQLException(-79700, ": IfxResultSet.updateRowId(String, RowId)", this.conn);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw Messages.getSQLException(-79700, ": IfxResultSet.updateSQLXML(int, SQLXML)", this.conn);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw Messages.getSQLException(-79700, ": IfxResultSet.updateSQLXML(String, SQLXML)", this.conn);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw Messages.getSQLException(-80053, this.conn, this.getClass().getCanonicalName(), iface.getClass().getCanonicalName());
    }

    @Override
    public IfxBSONObject getIfxBSONObject(int columnIndex) throws SQLException {
        return (IfxBSONObject)this.getObject(columnIndex, this.conn.getTypeMap());
    }

    @Override
    public IfxBSONObject getIfxBSONObject(String columnName) throws SQLException {
        return this.getIfxBSONObject(this.findColumn(columnName));
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        HashMap typeMap = new HashMap();
        typeMap.put("*", type);
        return (T)this.getObject(columnIndex, typeMap);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    void reset() {
        this.isClosed = false;
    }

    long getId() {
        return this.id;
    }
}

