/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.asf.IfxDataInputStream;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxFloat;
import com.informix.jdbc.IfxSmallFloat;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.Messages;
import com.informix.util.Trace;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.Time;
import java.sql.Timestamp;

abstract class IfxSQLInput
implements SQLInput {
    protected final IfxConnection conn;
    protected final ByteArrayInputStream bStream;
    protected final IfxDataInputStream is;
    protected final Trace trace;
    protected final byte[] buf;
    protected boolean isNull = false;
    protected int totalLength;
    protected int unreadLength;
    protected int currentPos = 0;
    private int startPos = 0;

    IfxSQLInput(IfxConnection conn, byte[] b, int index, int length) {
        this.conn = conn;
        this.bStream = new ByteArrayInputStream(b, index, length);
        this.is = new IfxDataInputStream(this.bStream);
        this.trace = conn != null ? conn.getTrace() : null;
        this.unreadLength = this.totalLength = length;
        this.buf = b;
        this.startPos = index;
    }

    byte[] toByteArray() {
        byte[] b = new byte[this.totalLength];
        System.arraycopy(this.buf, this.startPos, b, 0, this.totalLength);
        return b;
    }

    protected void skipBytes(int len) throws SQLException {
        try {
            this.is.skipBytes(len);
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    protected int currentPosition() {
        return this.totalLength - this.bStream.available();
    }

    public int length() {
        return this.totalLength;
    }

    protected int available() {
        return this.bStream.available();
    }

    protected void reset() {
        this.bStream.reset();
        this.currentPos = 0;
    }

    protected void checkLength(int len) throws SQLException {
        if (this.unreadLength < len) {
            throw Messages.getSQLException(-79772);
        }
        this.unreadLength -= len;
    }

    @Override
    public String readString() throws SQLException {
        throw Messages.getSQLException(-79700, ": SQLInput.readString().");
    }

    @Override
    public boolean readBoolean() throws SQLException {
        throw Messages.getSQLException(-79700, ": SQLInput.readBoolean().");
    }

    @Override
    public byte readByte() throws SQLException {
        return (byte)this.readShort();
    }

    @Override
    public short readShort() throws SQLException {
        this.checkLength(2);
        this.isNull = false;
        try {
            short s = this.is.readShort();
            if (s == Short.MIN_VALUE) {
                this.isNull = true;
                s = 0;
            }
            this.currentPos += 2;
            return s;
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    @Override
    public int readInt() throws SQLException {
        this.checkLength(4);
        this.isNull = false;
        try {
            int i = this.is.readInt();
            if (i == Integer.MIN_VALUE) {
                this.isNull = true;
                i = 0;
            }
            this.currentPos += 4;
            return i;
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    @Override
    public long readLong() throws SQLException {
        this.checkLength(10);
        this.isNull = false;
        try {
            long l = this.is.readLongInt();
            if (l == Long.MIN_VALUE) {
                this.isNull = true;
                l = 0L;
            }
            this.currentPos += 10;
            return l;
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    public long readLongBigint() throws SQLException {
        this.checkLength(8);
        this.isNull = false;
        try {
            long l = this.is.readLongBigint();
            if (l == Long.MIN_VALUE) {
                this.isNull = true;
                l = 0L;
            }
            this.currentPos += 8;
            return l;
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    @Override
    public float readFloat() throws SQLException {
        this.checkLength(4);
        byte[] b = new byte[4];
        this.isNull = true;
        try {
            this.bStream.read(b, 0, 4);
            this.currentPos += 4;
            this.isNull = IfxSmallFloat.isIfxNull(b);
            if (this.isNull) {
                return 0.0f;
            }
            return IfxToJavaType.IfxToJavaReal(b);
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    @Override
    public double readDouble() throws SQLException {
        this.checkLength(8);
        byte[] b = new byte[8];
        this.isNull = true;
        try {
            this.bStream.read(b, 0, 8);
            this.isNull = IfxFloat.isIfxNull(b);
            if (this.isNull) {
                return 0.0;
            }
            return IfxToJavaType.IfxToJavaDouble(b);
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        throw Messages.getSQLException(-79700, ": SQLInput.readBigDecimal().");
    }

    @Override
    public byte[] readBytes() throws SQLException {
        throw Messages.getSQLException(-79700, ": SQLInput.readBytes().");
    }

    public byte[] readBytes(int len) throws SQLException {
        byte[] b;
        if (this.unreadLength < len) {
            len = this.unreadLength;
        }
        this.checkLength(len);
        try {
            b = new byte[len];
            this.is.readFully(b, 0, len);
            this.currentPos += len;
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
        return b;
    }

    @Override
    public Date readDate() throws SQLException {
        this.checkLength(4);
        try {
            Date d = this.is.readDate();
            this.currentPos += 4;
            if (d == null) {
                this.isNull = true;
                return null;
            }
            return d;
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    @Override
    public Time readTime() throws SQLException {
        try {
            Timestamp ts = this.readTimestamp();
            if (ts == null) {
                this.isNull = true;
                return null;
            }
            return new Time(ts.getTime());
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        throw Messages.getSQLException(-79700, ": SQLInput.readTimestamp().");
    }

    @Override
    public Reader readCharacterStream() throws SQLException {
        throw Messages.getSQLException(-79700, ": SQLInput.readCharacterStream().");
    }

    @Override
    public InputStream readAsciiStream() throws SQLException {
        throw Messages.getSQLException(-79700, ": SQLInput.readAsciiStream().");
    }

    @Override
    public InputStream readBinaryStream() throws SQLException {
        throw Messages.getSQLException(-79700, ": SQLInput.readBinaryStream().");
    }

    @Override
    public Object readObject() throws SQLException {
        throw Messages.getSQLException(-79700, ": SQLInput.readObject().");
    }

    @Override
    public Ref readRef() throws SQLException {
        throw Messages.getSQLException(-79700, ": SQLInput.readRef().");
    }

    @Override
    public Blob readBlob() throws SQLException {
        throw Messages.getSQLException(-79700, ": SQLInput.readBlob().");
    }

    @Override
    public Clob readClob() throws SQLException {
        throw Messages.getSQLException(-79700, ": SQLInput.readClob().");
    }

    @Override
    public Array readArray() throws SQLException {
        throw Messages.getSQLException(-79700, ": SQLInput.readArray().");
    }

    @Override
    public boolean wasNull() {
        return this.isNull;
    }
}

