/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxUDTSQLOutput;
import com.informix.jdbc.IfxBblob;
import com.informix.jdbc.IfxCblob;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxSQLOutput;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.SQLUDTOutput;
import com.informix.jdbc.types.TypeInfo;
import com.informix.lang.Decimal;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.lang.JavaToIfxType;
import com.informix.lang.Messages;
import com.informix.util.stringUtil;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Timestamp;

public class IfxUDTOutput
extends IfxSQLOutput
implements SQLUDTOutput,
IfmxUDTSQLOutput {
    private static final int NO_ALIGNMENT = -1;
    private boolean autoAlignmentEnabled = true;

    IfxUDTOutput() {
    }

    IfxUDTOutput(IfxConnection conn) throws SQLException {
        super(conn);
    }

    private void checkAlignment(int dataSize, int alignment) throws SQLException {
        if (this.autoAlignmentEnabled && alignment != -1) {
            int currentPos = this.getCurrentPosition();
            int nPadded = (currentPos + dataSize + (alignment - 1) & ~(alignment - 1)) - (currentPos + dataSize);
            try {
                while (nPadded-- > 0) {
                    this.os.write(0);
                    super.adjustTotalDataSize();
                }
            }
            catch (Exception e) {
                throw Messages.getSQLException(e, -79716);
            }
        }
    }

    @Override
    public void writeString(String x, int len) throws SQLException {
        this.checkAlignment(len, -1);
        try {
            int numPadded = len - x.length();
            byte[] b = stringUtil.getBytes(x, this.conn);
            this.os.write(b, 0, x.length() > len ? len : x.length());
            while (numPadded-- > 0) {
                this.os.write(0);
            }
            super.adjustTotalDataSize();
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    public void writeString(String x, String dbEnc) throws SQLException {
        try {
            this.os.write(JavaToIfxType.JavaToIfxLvarchar(x, dbEnc, ((IfxSqliConnect)this.conn).encoption));
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw Messages.getSQLException(e, -79783);
        }
    }

    @Override
    public void writeByte(byte x) throws SQLException {
        this.checkAlignment(1, -1);
        try {
            this.os.writeByte(x);
            super.adjustTotalDataSize();
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    @Override
    public void writeBoolean(boolean x) throws SQLException {
        byte b = 0;
        if (x) {
            b = 1;
        }
        this.writeByte(b);
    }

    @Override
    public void writeShort(short x) throws SQLException {
        this.checkAlignment(2, 2);
        super.writeShort(x);
    }

    @Override
    public void writeInt(int x) throws SQLException {
        this.checkAlignment(4, 4);
        super.writeInt(x);
    }

    @Override
    public void writeLong(long x) throws SQLException {
        short sign = 1;
        if (x < 0L) {
            sign = -1;
            x = -x;
        }
        long i1 = x & 0xFFFFFFFFL;
        this.writeInt((int)i1);
        int i2 = (int)(x >> 32);
        this.writeInt(i2);
        this.writeShort(sign);
        if (this.autoAlignmentEnabled) {
            this.writeByte((byte)0);
            this.writeByte((byte)0);
        }
    }

    public void writeLongBigint(long x) throws SQLException {
        long i1 = x & 0xFFFFFFFFL;
        this.writeInt((int)i1);
        int i2 = (int)(x >> 32);
        this.writeInt(i2);
    }

    @Override
    public void writeFloat(float x) throws SQLException {
        this.checkAlignment(4, 4);
        super.writeFloat(x);
    }

    @Override
    public void writeDouble(double x) throws SQLException {
        this.checkAlignment(8, 8);
        super.writeDouble(x);
    }

    @Override
    public void writeBigDecimal(BigDecimal x) throws SQLException {
        try {
            this.checkAlignment(2, 2);
            this.os.write(new Decimal(x).javaToDec_t());
            super.adjustTotalDataSize();
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    public void write(byte[] b, int offset, int length) throws SQLException {
        try {
            this.os.write(b, offset, length);
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    public void write(byte[] b, int length) throws SQLException {
        try {
            this.os.write(b, 0, length);
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    @Override
    public void writeBytes(byte[] x, int len) throws SQLException {
        try {
            this.checkAlignment(len, -1);
            int numPadded = len - x.length;
            this.os.write(x);
            while (numPadded-- > 0) {
                this.os.write(0);
            }
            super.adjustTotalDataSize();
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    @Override
    public void writeTimestamp(Timestamp x) throws SQLException {
        try {
            Decimal dec = JavaToIfxType.convertTimestampToDecimal(x);
            short qual = 4365;
            this.checkAlignment(2, 2);
            this.os.writeShort(qual);
            this.os.write(dec.javaToDec_t());
            super.adjustTotalDataSize();
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    @Override
    public void writeCharacterStream(Reader x) throws SQLException {
        throw Messages.getSQLException(-79700, ": IfxUDTOutput.writeCharacterStream(Reader).");
    }

    @Override
    public void writeAsciiStream(InputStream x) throws SQLException {
        throw Messages.getSQLException(-79700, ": IfxUDTOutput.writeAsciiStream(InputStream).");
    }

    @Override
    public void writeBinaryStream(InputStream x) throws SQLException {
        throw Messages.getSQLException(-79700, ": IfxUDTOutput.writeBinaryStream(InputStream).");
    }

    @Override
    public void writeObject(SQLData x) throws SQLException {
        throw Messages.getSQLException(-79700, ": IfxUDTOutput.writeObject(SQLData).");
    }

    @Override
    public void writeRef(Ref x) throws SQLException {
        throw Messages.getSQLException(-79700, ": IfxUDTOutput.writeRef(Ref).");
    }

    void writeIfxLocator(IfxLocator loc) throws SQLException {
        this.writeBytes(loc.toBytes());
    }

    @Override
    public void writeBlob(Blob x) throws SQLException {
        if (!(x instanceof IfxBblob)) {
            throw Messages.getSQLException(-79700, ": IfxUDTOutput.writeBlob(Blob).");
        }
        this.writeIfxLocator(((IfxBblob)x).getLocator());
    }

    @Override
    public void writeClob(Clob x) throws SQLException {
        if (!(x instanceof IfxCblob)) {
            throw Messages.getSQLException(-79700, ": IfxUDTOutput.writeClob(Clob).");
        }
        this.writeIfxLocator(((IfxCblob)x).getLocator());
    }

    @Override
    public void writeStruct(Struct x) throws SQLException {
        throw Messages.getSQLException(-79700, ": IfxUDTOutput.writeStruct(Struct).");
    }

    @Override
    public void writeArray(Array x) throws SQLException {
        throw Messages.getSQLException(-79700, ": IfxUDTOutput.writeArray(Array).");
    }

    @Override
    public void writeInterval(Interval x) throws SQLException {
        try {
            short qual = 0;
            qual = x.getQualifier();
            Decimal dec = x instanceof IntervalYM ? JavaToIfxType.convertIntervalToDecimal((IntervalYM)x) : JavaToIfxType.convertIntervalToDecimal((IntervalDF)x);
            this.checkAlignment(2, 2);
            this.os.writeShort(qual);
            this.os.write(dec.javaToDec_t());
            super.adjustTotalDataSize();
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
    }

    @Override
    public int length() {
        return super.length();
    }

    @Override
    public void setAutoAlignment(boolean value) {
        this.autoAlignmentEnabled = value;
    }

    @Override
    public boolean getAutoAlignment() {
        return this.autoAlignmentEnabled;
    }

    @Override
    public void skipBytes(int len) throws SQLException {
        this.setCurrentPosition(this.bStream.getCount() + len);
    }

    @Override
    public int getCurrentPosition() {
        return this.bStream.getCount();
    }

    @Override
    public void setCurrentPosition(int position) throws SQLException {
        if (position < 0 || position > this.bStream.getTotalDataSize()) {
            throw Messages.getSQLException(-79772);
        }
        this.bStream.setCount(position);
    }

    @Override
    public int available() {
        return this.bStream.getTotalDataSize() - this.bStream.getCount();
    }

    @Override
    public TypeInfo getUDTInfo(int xid) throws SQLException {
        return this.conn.getUDTInfo(xid);
    }

    @Override
    public TypeInfo getUDTInfo(String name, String owner) throws SQLException {
        return this.conn.getUDTInfo(name, owner);
    }

    @Override
    public void writeURL(URL x) throws SQLException {
        throw Messages.getSQLException(-79700, ": IfxUDTOutput.writeURL()");
    }

    @Override
    public void writeNClob(NClob x) throws SQLException {
        throw Messages.getSQLException(-79700, ": IfxUDTOutput.writeNClob(NClob)");
    }

    @Override
    public void writeNString(String x) throws SQLException {
        throw Messages.getSQLException(-79700, ": IfxUDTOutput.writeNString(String)");
    }

    @Override
    public void writeRowId(RowId x) throws SQLException {
        throw Messages.getSQLException(-79700, ": IfxUDTOutput.writeRowId(RowId)");
    }

    @Override
    public void writeSQLXML(SQLXML x) throws SQLException {
        throw Messages.getSQLException(-79700, ": IfxUDTOutput.writeSQLXML(SQLXML)");
    }
}

