/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxPreparedStatement;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.IfxValue;
import com.informix.lang.IfxTypes;
import com.informix.lang.Messages;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;

public class IfxUpdateResultSet {
    protected Vector<IfxObject> UpdateColVector = null;
    protected final IfxConnection conn;
    protected IfxResultSetMetaData rsmd = null;
    protected final IfxStatement stmt;
    protected Vector<IfxObject> WhereVal = null;
    protected String updateCmd;
    protected String deleteCmd;
    protected String insertCmd;
    protected boolean MoveToInsert = true;
    protected boolean updatecanceled = false;
    protected boolean isForUpdateClause = false;

    public IfxUpdateResultSet(IfxConnection con, IfxStatement stmt) {
        if (con == null || stmt == null) {
            throw new NullPointerException("Connection and statement objects must not be null!");
        }
        this.conn = con;
        this.stmt = stmt;
    }

    public boolean rowUpdated() throws SQLException {
        throw Messages.getSQLException(-79700, ": ResultSet.rowUpdated().", this.conn);
    }

    public boolean rowInserted() throws SQLException {
        throw Messages.getSQLException(-79700, ": ResultSet.rowInserted().", this.conn);
    }

    public boolean rowDeleted() throws SQLException {
        throw Messages.getSQLException(-79700, ": ResultSet.rowDeleted().", this.conn);
    }

    private void validate_updateXXX(int columnIndex) throws SQLException {
        if (this.stmt.getResultSetConcurrency() != 1008) {
            throw Messages.getSQLException(-79818, this.conn);
        }
        if (this.UpdateColVector == null) {
            throw Messages.getSQLException(-79739, this.conn);
        }
        if (columnIndex < 1 || columnIndex > this.UpdateColVector.size()) {
            throw Messages.getSQLException(-79703, this.conn);
        }
    }

    public void updateNull(int columnIndex) throws SQLException {
        IfxObject value = null;
        this.validate_updateXXX(columnIndex);
        value = this.UpdateColVector.elementAt(columnIndex - 1);
        if (value == null) {
            value = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(columnIndex));
        }
        value.nullify();
        value.set_used_in_update(true);
        this.UpdateColVector.setElementAt(value, columnIndex - 1);
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        IfxObject value = null;
        this.validate_updateXXX(columnIndex);
        value = this.UpdateColVector.elementAt(columnIndex - 1);
        if (value == null) {
            value = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(columnIndex));
        }
        value.fromBoolean(x);
        value.set_used_in_update(true);
        this.UpdateColVector.setElementAt(value, columnIndex - 1);
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        IfxObject value = null;
        this.validate_updateXXX(columnIndex);
        value = this.UpdateColVector.elementAt(columnIndex - 1);
        if (value == null) {
            value = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(columnIndex));
        }
        value.fromByte(x);
        value.set_used_in_update(true);
        this.UpdateColVector.setElementAt(value, columnIndex - 1);
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        IfxObject value = null;
        this.validate_updateXXX(columnIndex);
        value = this.UpdateColVector.elementAt(columnIndex - 1);
        if (value == null) {
            value = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(columnIndex));
        }
        value.fromShort(x);
        value.set_used_in_update(true);
        this.UpdateColVector.setElementAt(value, columnIndex - 1);
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        IfxObject value = null;
        this.validate_updateXXX(columnIndex);
        value = this.UpdateColVector.elementAt(columnIndex - 1);
        if (value == null) {
            value = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(columnIndex));
        }
        value.fromObject(x);
        value.set_used_in_update(true);
        this.UpdateColVector.setElementAt(value, columnIndex - 1);
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        IfxObject value = null;
        this.validate_updateXXX(columnIndex);
        value = this.UpdateColVector.elementAt(columnIndex - 1);
        if (value == null) {
            value = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(columnIndex));
        }
        if (x != null) {
            value.fromClob(x);
        } else {
            value.nullify();
        }
        value.set_used_in_update(true);
        this.UpdateColVector.setElementAt(value, columnIndex - 1);
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        IfxObject value = null;
        this.validate_updateXXX(columnIndex);
        value = this.UpdateColVector.elementAt(columnIndex - 1);
        if (value == null) {
            value = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(columnIndex));
        }
        if (x != null) {
            value.fromBlob(x);
        } else {
            value.nullify();
        }
        value.set_used_in_update(true);
        this.UpdateColVector.setElementAt(value, columnIndex - 1);
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        IfxObject value = null;
        this.validate_updateXXX(columnIndex);
        value = this.UpdateColVector.elementAt(columnIndex - 1);
        if (value == null) {
            value = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(columnIndex));
        }
        value.fromInt(x);
        value.set_used_in_update(true);
        this.UpdateColVector.setElementAt(value, columnIndex - 1);
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        IfxObject value = null;
        this.validate_updateXXX(columnIndex);
        value = this.UpdateColVector.elementAt(columnIndex - 1);
        if (value == null) {
            value = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(columnIndex));
        }
        value.fromLong(x);
        value.set_used_in_update(true);
        this.UpdateColVector.setElementAt(value, columnIndex - 1);
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        IfxObject value = null;
        this.validate_updateXXX(columnIndex);
        value = this.UpdateColVector.elementAt(columnIndex - 1);
        if (value == null) {
            value = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(columnIndex));
        }
        value.fromFloat(x);
        value.set_used_in_update(true);
        this.UpdateColVector.setElementAt(value, columnIndex - 1);
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        IfxObject value = null;
        this.validate_updateXXX(columnIndex);
        value = this.UpdateColVector.elementAt(columnIndex - 1);
        if (value == null) {
            value = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(columnIndex));
        }
        value.fromDouble(x);
        value.set_used_in_update(true);
        this.UpdateColVector.setElementAt(value, columnIndex - 1);
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        IfxObject value = null;
        this.validate_updateXXX(columnIndex);
        value = this.UpdateColVector.elementAt(columnIndex - 1);
        if (value == null) {
            value = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(columnIndex));
        }
        value.fromDecimal(x);
        value.set_used_in_update(true);
        this.UpdateColVector.setElementAt(value, columnIndex - 1);
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        IfxObject value = null;
        this.validate_updateXXX(columnIndex);
        value = this.UpdateColVector.elementAt(columnIndex - 1);
        if (value == null) {
            value = this.rsmd.isVariableLengthType(columnIndex) ? IfxValue.makeInstanceFromIfxType(this.conn, 43) : IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(columnIndex));
        }
        value.fromString(x);
        value.set_used_in_update(true);
        this.UpdateColVector.setElementAt(value, columnIndex - 1);
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        IfxObject value = null;
        this.validate_updateXXX(columnIndex);
        value = this.UpdateColVector.elementAt(columnIndex - 1);
        if (value == null) {
            value = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(columnIndex));
        }
        value.fromBytes(x);
        value.set_used_in_update(true);
        this.UpdateColVector.setElementAt(value, columnIndex - 1);
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        IfxObject value = null;
        this.validate_updateXXX(columnIndex);
        value = this.UpdateColVector.elementAt(columnIndex - 1);
        if (value == null) {
            value = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(columnIndex));
        }
        value.fromDate(x);
        value.set_used_in_update(true);
        this.UpdateColVector.setElementAt(value, columnIndex - 1);
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        IfxObject value = null;
        this.validate_updateXXX(columnIndex);
        value = this.UpdateColVector.elementAt(columnIndex - 1);
        if (value == null) {
            value = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(columnIndex));
        }
        value.fromTime(x);
        value.set_used_in_update(true);
        this.UpdateColVector.setElementAt(value, columnIndex - 1);
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        IfxObject value = null;
        this.validate_updateXXX(columnIndex);
        value = this.UpdateColVector.elementAt(columnIndex - 1);
        if (value == null) {
            value = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(columnIndex));
        }
        value.fromTimestamp(x);
        value.set_used_in_update(true);
        this.UpdateColVector.setElementAt(value, columnIndex - 1);
    }

    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        IfxObject value = null;
        this.validate_updateXXX(columnIndex);
        value = this.UpdateColVector.elementAt(columnIndex - 1);
        if (value == null) {
            value = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(columnIndex));
        }
        value.fromAsciiStream(x, length);
        value.set_used_in_update(true);
        this.UpdateColVector.setElementAt(value, columnIndex - 1);
    }

    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        IfxObject value = null;
        this.validate_updateXXX(columnIndex);
        value = this.UpdateColVector.elementAt(columnIndex - 1);
        if (value == null) {
            value = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(columnIndex));
        }
        value.fromBinaryStream(x, length);
        value.set_used_in_update(true);
        this.UpdateColVector.setElementAt(value, columnIndex - 1);
    }

    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        IfxObject value = null;
        this.validate_updateXXX(columnIndex);
        value = this.UpdateColVector.elementAt(columnIndex - 1);
        if (value == null) {
            value = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(columnIndex));
        }
        value.fromCharacterStream(x, length);
        value.set_used_in_update(true);
        this.UpdateColVector.setElementAt(value, columnIndex - 1);
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        IfxObject value = null;
        this.validate_updateXXX(columnIndex);
        value = this.UpdateColVector.elementAt(columnIndex - 1);
        if (value == null) {
            value = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(columnIndex));
        }
        value.fromObject(x, scale);
        value.set_used_in_update(true);
        this.UpdateColVector.setElementAt(value, columnIndex - 1);
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        IfxObject value = null;
        this.validate_updateXXX(columnIndex);
        value = this.UpdateColVector.elementAt(columnIndex - 1);
        if (value == null) {
            value = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(columnIndex));
        }
        value.fromObject(x);
        value.set_used_in_update(true);
        this.UpdateColVector.setElementAt(value, columnIndex - 1);
    }

    public void insertRow() throws SQLException {
        try (PreparedStatement pstmt = null;){
            pstmt = this.conn.prepareStatement(this.insertCmd);
            pstmt.setPoolable(false);
            int j = 1;
            for (int i = 0; i < this.UpdateColVector.size(); ++i) {
                IfxObject val;
                if (this.UpdateColVector.elementAt(i) == null || !(val = this.UpdateColVector.elementAt(i)).get_used_in_update()) continue;
                int ifxType = val.getIfxType();
                if (IfxTypes.isString(ifxType)) {
                    pstmt.setString(j++, val.toString());
                    continue;
                }
                if (ifxType == 44 || ifxType == 11 || ifxType == 12) {
                    ((IfxPreparedStatement)pstmt).set(j++, val);
                    continue;
                }
                pstmt.setObject(j++, val.toObject());
            }
            pstmt.execute();
        }
    }

    public void updateRow() throws SQLException {
        IfxObject val = null;
        int idx = 0;
        try (PreparedStatement pstmt = null;){
            int i;
            pstmt = this.conn.prepareStatement(this.updateCmd);
            pstmt.setPoolable(false);
            for (i = 0; i < this.UpdateColVector.size(); ++i) {
                val = this.UpdateColVector.elementAt(i);
                if (val == null || !val.get_used_in_update()) continue;
                int ifxType = val.getIfxType();
                if (IfxTypes.isString(ifxType)) {
                    pstmt.setString(++idx, val.toString());
                    continue;
                }
                if (ifxType == 44 || ifxType == 11 || ifxType == 12) {
                    ((IfxPreparedStatement)pstmt).set(++idx, val);
                    continue;
                }
                ((IfmxPreparedStatement)pstmt).IfxSetObject(++idx, val.toObject(), ifxType);
            }
            if (!this.isForUpdateClause) {
                ++idx;
                for (i = 0; i < this.WhereVal.size(); ++i) {
                    val = this.WhereVal.elementAt(i);
                    if (IfxTypes.isString(val.getIfxType())) {
                        pstmt.setString(idx++, val.toString());
                        continue;
                    }
                    pstmt.setObject(idx++, val.toObject());
                }
            }
            pstmt.execute();
        }
    }

    public void deleteRow() throws SQLException {
        try (PreparedStatement pstmt = null;){
            pstmt = this.conn.prepareStatement(this.deleteCmd);
            pstmt.setPoolable(false);
            if (!this.isForUpdateClause) {
                int j = 1;
                for (int i = 0; i < this.WhereVal.size(); ++i) {
                    IfxObject val = this.WhereVal.elementAt(i);
                    if (IfxTypes.isString(val.getIfxType())) {
                        pstmt.setString(j++, val.toString());
                        continue;
                    }
                    pstmt.setObject(j++, val.toObject());
                }
            }
            pstmt.execute();
        }
    }

    public void refreshRow() throws SQLException {
        throw Messages.getSQLException(-79700, ": ResultSet.refreshRow().", this.conn);
    }

    public void cancelRowUpdates() throws SQLException {
        if (this.MoveToInsert) {
            throw Messages.getSQLException(-79819, this.conn);
        }
        this.clearUpdateColVector();
        this.updatecanceled = true;
    }

    public void moveToInsertRow() throws SQLException {
        if (this.stmt.getResultSetConcurrency() != 1008) {
            throw Messages.getSQLException(-79763, this.conn);
        }
        this.MoveToInsert = true;
        int NumOfCols = 0;
        if (this.rsmd != null) {
            NumOfCols = this.rsmd.getColumnCount();
        }
        this.UpdateColVector = new Vector(NumOfCols);
        this.UpdateColVector.setSize(NumOfCols);
    }

    public void moveToCurrentRow() throws SQLException {
        if (this.stmt.getResultSetConcurrency() != 1008) {
            throw Messages.getSQLException(-79818, this.conn);
        }
        this.clearUpdateColVector();
    }

    protected void clearUpdateColVector() {
        if (this.UpdateColVector != null) {
            for (int i = this.UpdateColVector.size() - 1; i >= 0; --i) {
                IfxObject obj = this.UpdateColVector.elementAt(i);
                if (obj == null) continue;
                obj.set_used_in_update(false);
            }
        }
        this.MoveToInsert = false;
    }
}

