/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.stream.cdc.records;

import com.informix.jdbc.IfxBigInt;
import com.informix.jdbc.IfxBoolean;
import com.informix.jdbc.IfxChar;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDate;
import com.informix.jdbc.IfxDateTime;
import com.informix.jdbc.IfxDecimal;
import com.informix.jdbc.IfxFloat;
import com.informix.jdbc.IfxInt8;
import com.informix.jdbc.IfxInteger;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxLvarchar;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxShort;
import com.informix.jdbc.IfxSmBlob;
import com.informix.jdbc.IfxSmallFloat;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxValue;
import com.informix.jdbc.IfxVarChar;
import com.informix.jdbc.stream.api.StreamOperationRecord;
import com.informix.jdbc.stream.api.StreamRecordType;
import com.informix.jdbc.stream.cdc.records.CDCRecord;
import com.informix.jdbc.stream.impl.StreamException;
import com.informix.jdbc.types.ReadableType;
import com.informix.lang.IfxToJavaType;
import com.informix.util.JdbcLogger;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CDCOperationRecord
extends CDCRecord
implements StreamOperationRecord {
    private final JdbcLogger logger = JdbcLogger.getLogger(CDCOperationRecord.class);
    private final byte[] buffer;
    private final List<IfxColumnInfo> columns;
    private final Connection con;
    private final Map<String, ReadableType> objects = new LinkedHashMap<String, ReadableType>();

    public CDCOperationRecord(StreamRecordType type, byte[] header, byte[] buffer, Map<String, List<IfxColumnInfo>> columns, Connection con) {
        super(type);
        this.buffer = buffer;
        this.con = con;
        ByteBuffer headerBuffer = ByteBuffer.wrap(header);
        this.sequence = headerBuffer.getLong();
        this.transaction = headerBuffer.getInt();
        this.label = Integer.toString(headerBuffer.getInt());
        this.columns = columns.get(this.label);
        this.logger.debug("New IfxCDCOperationRecord created. Label: {}", (Object)this.label);
    }

    @Override
    public synchronized Map<String, ReadableType> getData() throws StreamException {
        if (!this.objects.isEmpty()) {
            return this.objects;
        }
        try {
            int offset = 0;
            for (IfxColumnInfo column : this.columns) {
                IfxObject o = IfxValue.makeInstance((IfxConnection)((IfxSqliConnect)this.con), column);
                this.logger.debug("Column type: {}", (Object)o.getClass().getSimpleName());
                if (o instanceof IfxInteger || o instanceof IfxDate) {
                    o.fromIfx(this.buffer, offset, 4);
                    offset += 4;
                } else if (o instanceof IfxChar) {
                    int colLength = column.getColumnLength();
                    o.fromIfx(this.buffer, offset, colLength);
                    offset += colLength;
                } else if (o instanceof IfxLvarchar) {
                    short lvarcharLength = IfxToJavaType.IfxToJavaSmallInt(this.buffer, offset);
                    o.fromCDC(this.buffer, offset, lvarcharLength - 1);
                    offset += lvarcharLength + 2;
                } else if (o instanceof IfxVarChar) {
                    int varcharLength = this.buffer[offset] & 0xFF;
                    o.fromIfx(this.buffer, offset, varcharLength);
                    offset += varcharLength + 1;
                } else if (o instanceof IfxBigInt || o instanceof IfxFloat) {
                    o.fromIfx(this.buffer, offset, 8);
                    offset += 8;
                } else if (o instanceof IfxInt8) {
                    o.fromIfx(this.buffer, offset, 10);
                    offset += 10;
                } else if (o instanceof IfxDecimal) {
                    short encodedLength = (short)column.getColumnLength();
                    int length = ((encodedLength >> 8 & 0xFF) + (encodedLength & 0xFF & 1) + 3) / 2 - 1 + 1;
                    o.fromIfx(this.buffer, offset, length, encodedLength);
                    offset += length;
                } else if (o instanceof IfxDateTime) {
                    o.fromIfx(this.buffer, offset, column.getNumberOfBytes(), (short)column.getColumnLength());
                    offset += column.getNumberOfBytes();
                } else if (o instanceof IfxShort) {
                    o.fromIfx(this.buffer, offset, this.buffer.length);
                    offset += 2;
                } else if (o instanceof IfxBoolean) {
                    ((IfxBoolean)o).fromIfx(this.buffer, offset);
                    offset += 2;
                } else if (o instanceof IfxSmBlob) {
                    byte[] locBytes = new byte[72];
                    System.arraycopy(this.buffer, offset + 4, locBytes, 0, 72);
                    o = new IfxSmBlob((IfxConnection)this.con, new IfxLocator(locBytes, this.con));
                    offset += 76;
                } else if (o instanceof IfxSmallFloat) {
                    o.fromIfx(this.buffer, offset, 4);
                    offset += 4;
                } else {
                    throw new StreamException("Unsupported column type: " + column);
                }
                this.objects.put(column.getColumnName(), o);
            }
        }
        catch (Exception e) {
            throw new StreamException("Error processing CDC data stream", e);
        }
        return this.objects;
    }

    @Override
    public boolean hasOperationData() {
        return true;
    }
}

