/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.stream.transactions;

import com.informix.jdbc.stream.api.StreamOperationRecord;
import com.informix.jdbc.stream.api.StreamRecord;
import com.informix.jdbc.stream.api.StreamRecordType;
import com.informix.jdbc.stream.cdc.records.CDCBeginTransactionRecord;
import java.util.List;

public class StreamTransactionRecord
implements StreamRecord {
    private final CDCBeginTransactionRecord beginRecord;
    private final StreamRecord closingRecord;
    private final List<StreamOperationRecord> records;

    public StreamTransactionRecord(CDCBeginTransactionRecord beginRecord, StreamRecord closingRecord, List<StreamOperationRecord> records) {
        this.beginRecord = beginRecord;
        this.closingRecord = closingRecord;
        this.records = records;
    }

    @Override
    public StreamRecordType getType() {
        return StreamRecordType.TRANSACTION_GROUP;
    }

    @Override
    public boolean hasOperationData() {
        return false;
    }

    @Override
    public String getLabel() {
        return this.beginRecord.getLabel();
    }

    @Override
    public int getTransactionId() {
        return this.beginRecord.getTransactionId();
    }

    @Override
    public long getSequenceId() {
        return this.beginRecord.getSequenceId();
    }

    public CDCBeginTransactionRecord getBeginRecord() {
        return this.beginRecord;
    }

    public StreamRecord getEndRecord() {
        return this.closingRecord;
    }

    public List<StreamOperationRecord> getOperationRecords() {
        return this.records;
    }

    public String toString() {
        return this.beginRecord.toString() + "\n" + this.getOperationRecords() + "\n" + this.closingRecord.toString();
    }
}

