/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.udt;

import com.informix.jdbc.IfmxUDTSQLInput;
import com.informix.jdbc.IfmxUDTSQLOutput;
import com.informix.jdbc.IfxDistinctInput;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxUDT;
import com.informix.lang.IfxToJavaType;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;

public class BasicUdt
extends IfxUDT
implements SQLData {
    protected byte[] bytes;
    protected final String name;

    public BasicUdt() {
        this.name = "udt";
    }

    public BasicUdt(byte[] bytes) {
        this.bytes = bytes;
        this.name = "udt";
    }

    public BasicUdt(byte[] bytes, String name) {
        this.bytes = bytes;
        this.name = name;
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return this.name;
    }

    @Override
    public void readSQL(SQLInput stream, String typeName) throws SQLException {
        this.bytes = stream instanceof IfxDistinctInput ? ((IfxDistinctInput)stream).readAllBytes() : ((IfmxUDTSQLInput)stream).readAllBytes();
    }

    @Override
    public void writeSQL(SQLOutput stream) throws SQLException {
        IfmxUDTSQLOutput output = (IfmxUDTSQLOutput)stream;
        output.writeBytes(this.bytes, this.bytes.length);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public String toString() {
        return new String(this.getBytes());
    }

    public String getString() throws IOException {
        if (this.conn == null) {
            return new String(this.getBytes());
        }
        return IfxToJavaType.IfxToJavaChar(this.bytes, this.conn.getdbEncoding(), ((IfxSqliConnect)this.conn).getEncoption());
    }

    public String getString(Charset charset) {
        return new String(this.getBytes(), charset);
    }
}

