/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.udt.timeseries;

import com.informix.jdbc.IfmxUDTSQLInput;
import com.informix.jdbc.IfmxUDTSQLOutput;
import com.informix.jdbc.IfxBSONObject;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxUDTInfo;
import com.informix.jdbc.types.TypeInfo;
import com.informix.jdbc.udt.timeseries.IfmxCalendar;
import com.informix.jdbc.udt.timeseries.IfxCalendar;
import com.informix.jdbc.udt.timeseries.IfxTSGenericRow;
import com.informix.jdbc.udt.timeseries.MemoizingCache;
import com.informix.jdbc.udt.timeseries.TimeSeriesRowType;
import com.informix.jdbc.udt.timeseries.TimeseriesContants;
import com.informix.jdbc.udt.timeseries.field.TimeSeriesField;
import com.informix.lang.Interval;
import com.informix.util.JdbcLogger;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class IfmxTimeSeries
extends TimeseriesContants
implements SQLData,
ResultSet {
    private static final int TS_NULL_FIRSTOFF = Integer.MAX_VALUE;
    private static TimeZone defaultTimezone = TimeZone.getDefault();
    private static final JdbcLogger logger = JdbcLogger.getLogger(IfmxTimeSeries.class);
    private volatile boolean closed = false;
    private volatile boolean sqlDataWriteSqlEnable = false;
    private int cursor = -1;
    private int oldCursor = -1;
    private int start = -1;
    private int elemOffset = -1;
    private int elemLength = -1;
    private boolean readHidden = false;
    private String sql_type = null;
    private String sqlRowType = null;
    private int length = 0;
    private byte version = 0;
    private byte spare1 = 0;
    private short flags = 0;
    private int offset = -1;
    private int originDelta = 0;
    private int calId = 0;
    private short expandLimit = 0;
    private short spare2 = 0;
    private TSTypeID typeID = null;
    private int tsVarLen = 4;
    private int calVarLen = 4;
    private int bigintflag = 0;
    private int amLength = 0;
    private byte amVer = 0;
    private byte amSpare = 0;
    private short amFlags = 0;
    private long amInstID = -1L;
    private int amPartitionID = -1;
    private TSTypeID amTypeID = null;
    private short amSpare2 = 0;
    private short amElemSize = 0;
    private String amTSCont = null;
    private IfmxCalendar calendar = null;
    private int tsImFirstOff = Integer.MAX_VALUE;
    private int tsImSize = 0;
    private int tsImFreeOff = 0;
    private int tsNext = 0;
    private int tsDirSize = 0;
    private int tsImNext64 = 0;
    private IfxResultSetMetaData metaData = null;
    private List<List<Object>> tsData = null;
    private List<Object> tsElementData = null;
    private HashMap<String, Integer> tsColumnNameToNumberMap = null;
    private boolean createHeader = false;
    private TimeSeriesRowType timeseriesRowType = null;
    private Connection connection = null;
    private String tableName = null;
    private String timeseriesColumnName = null;
    private String whereClause = null;
    private Object[] whereClauseHostVariables = null;
    private InsertPhase insertPhase = InsertPhase.IDLE;
    boolean caseSensitiveIdentifiers = false;
    private int tsFlagsRef = -1;
    private int tsAmFlagsRef = -1;
    private int tsImFlagsRef = -1;
    private int amStart = -1;
    private int amInMemRef = -1;
    private int amInMemStart = -1;
    private static final MemoizingCache<Integer> powersOfTwoCache = new MemoizingCache<Integer>(){

        @Override
        public Integer build(int index) {
            return (int)Math.pow(2.0, index);
        }
    };

    public static final TimeZone getDefaultTimeZone() {
        return defaultTimezone;
    }

    public static final void setDefaultTimeZone(TimeZone timeZone) {
        defaultTimezone = timeZone;
    }

    public IfmxTimeSeries() {
        IfmxTimeSeries.setTimeZone();
    }

    private static void setTimeZone() {
        String timezoneId = System.getProperty("IFX_TS_TIMEZONE_ID");
        if (timezoneId != null) {
            TimeZone tz = TimeZone.getTimeZone(timezoneId);
            IfmxTimeSeries.setDefaultTimeZone(tz);
        }
    }

    IfmxTimeSeries(Timestamp start, String calendarName, String containerName, String rowTypeName, int threshold, boolean regular, Connection connection) throws SQLException {
        this.connection = connection;
        this.sqlRowType = rowTypeName;
        if (connection == null) {
            throw new SQLException("the JDBC connection must not be null");
        }
        if (calendarName == null) {
            throw new SQLException("the calendar name must not be null");
        }
        if (rowTypeName == null) {
            throw new SQLException("the row type name must not be null");
        }
        if (threshold < 0) {
            throw new SQLException("The timeseries threshold must be >= 0!");
        }
        if (containerName != null) {
            this.amTSCont = containerName;
            this.amPartitionID = this.getContainerPartitionID(connection, containerName);
            this.bigintflag = this.getContainerBigIntFlag(connection, containerName);
        }
        this.expandLimit = (short)threshold;
        try {
            this.timeseriesRowType = TimeSeriesRowType.get(connection, rowTypeName);
            IfxUDTInfo udtInfo = ((IfxConnection)connection).getUDTInfo(rowTypeName, null);
            if (udtInfo == null) {
                throw new SQLException(MessageFormat.format("unable to retrieve the row type information for ''{0}''", rowTypeName));
            }
            IfxResultSetMetaData typeInfo = udtInfo.getMetaData();
            this.metaData = (IfxResultSetMetaData)typeInfo.getChild(1);
            this.amTypeID = new TSTypeID();
            this.amTypeID.setXid(udtInfo.getXid());
        }
        catch (SQLException e) {
            throw new SQLException(MessageFormat.format("unable to retrieve the row type information for ''{0}''", rowTypeName), e);
        }
        this.typeID = new TSTypeID();
        this.typeID.setXid(-1);
        this.typeID.setTiType((short)-1);
        this.typeID.setTiSpare((short)0);
        this.sql_type = "timeseries(" + rowTypeName + ")";
        this.sqlRowType = rowTypeName;
        try {
            this.calendar = IfmxCalendar.getCalendar(connection, calendarName);
            if (this.calendar == null) {
                throw new SQLException(MessageFormat.format("no calendar with name ''{0}'' could be found", calendarName));
            }
            this.calId = this.calendar.getId();
        }
        catch (SQLException e) {
            throw new SQLException(MessageFormat.format("unable to retrieve calendar ''{0}''", calendarName), e.getMessage());
        }
        this.amLength = 0;
        this.amVer = (byte)2;
        this.amSpare = 0;
        if (containerName == null) {
            this.flags = (short)2;
            this.amFlags = (short)(this.amFlags | 1 | 2);
        } else {
            this.amFlags = (short)(this.amFlags | 1 | 2 | 8);
        }
        if (!regular) {
            this.flags = (short)(this.flags | 1);
            this.amFlags = (short)(this.amFlags | 4);
        }
        this.amInstID = -1L;
        this.amElemSize = (short)this.getElementSize();
        this.tsImFirstOff = 0;
        this.tsImSize = 0;
        this.tsImFreeOff = 0;
        this.tsNext = 0;
        this.tsDirSize = 0;
        this.tsData = new ArrayList<List<Object>>();
        this.offset = 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        if (this.sql_type == null) {
            throw new SQLException("the SQL type name is not initialized");
        }
        return this.sql_type;
    }

    public IfmxCalendar getCalendar() throws SQLException {
        if (this.calendar == null) {
            throw new SQLException("the calendar is not initialized");
        }
        return this.calendar;
    }

    public int getOffset() throws SQLException {
        if (this.offset == -1) {
            throw new SQLException("the TimeSeries is not initialised");
        }
        return this.offset;
    }

    public ResultSetMetaData getTSMetaData() throws SQLException {
        if (this.metaData == null) {
            throw new SQLException("the TimeSeries result set meta-data is not assigned");
        }
        return this.metaData;
    }

    @Override
    public void readSQL(SQLInput stream, String typeName) throws SQLException {
        this.sqlDataWriteSqlEnable = true;
        IfmxUDTSQLInput wrkStream = (IfmxUDTSQLInput)stream;
        this.tsTraceMessage("IfmxTimeSeries: Entered readSQL");
        this.setSQLType(typeName);
        this.readRowTypeName(this.sql_type);
        this.readHeader(wrkStream);
        this.readCalendar(wrkStream);
        this.readTypeInfo(wrkStream);
        this.readDirInfo(wrkStream);
        this.readRowTypeInfo(wrkStream);
        this.initTimeSeries(wrkStream);
        this.tsTraceMessage("IfmxTimeSeries: Exited readSQL");
    }

    private void setSQLType(String newSQLType) {
        if (newSQLType == null) {
            throw new NullPointerException("The SQL type parameter is null");
        }
        this.sql_type = newSQLType;
    }

    private void readHeader(IfmxUDTSQLInput wrkStream) throws SQLException {
        this.length = wrkStream.readInt();
        this.version = wrkStream.readByte();
        this.spare1 = wrkStream.readByte();
        this.flags = wrkStream.readShort();
        this.offset = wrkStream.readInt();
        this.originDelta = wrkStream.readInt();
        this.calId = wrkStream.readInt();
        this.expandLimit = wrkStream.readShort();
        this.spare2 = wrkStream.readShort();
        this.typeID = new TSTypeID();
        this.typeID.readFromStream(wrkStream);
        this.tsVarLen = wrkStream.readInt();
        wrkStream.skipBytes(this.tsVarLen - 4);
    }

    private void readCalendar(IfmxUDTSQLInput wrkStream) throws SQLException {
        this.calVarLen = wrkStream.readInt();
        this.calendar = new IfmxCalendar(wrkStream, this.calVarLen);
    }

    private void readTypeInfo(IfmxUDTSQLInput wrkStream) throws SQLException {
        this.amLength = wrkStream.readInt();
        this.amVer = wrkStream.readByte();
        this.amSpare = wrkStream.readByte();
        this.amFlags = wrkStream.readShort();
        this.readTimeseriesID(wrkStream);
        this.amPartitionID = wrkStream.readInt();
        this.amTypeID = new TSTypeID();
        this.amTypeID.readFromStream(wrkStream);
        this.amSpare2 = wrkStream.readShort();
        this.amElemSize = wrkStream.readShort();
        this.readContainerName(wrkStream);
        this.tsNext = wrkStream.readInt();
        if (this.tsNext != 0) {
            throw new SQLException("TimeSeries not in memory!");
        }
    }

    private void readDirInfo(IfmxUDTSQLInput wrkStream) throws SQLException {
        this.start = wrkStream.getCurrentPosition() - 4;
        this.tsImFirstOff = wrkStream.readInt();
        this.tsImSize = wrkStream.readInt();
        this.tsImFreeOff = wrkStream.readInt();
        this.tsDirSize = wrkStream.readInt();
        this.tsTraceMessage("IfmxTimeSeries: The number of elements is: " + this.tsDirSize);
        this.tsTraceMessage("IfmxTimeSeries: The first offset is: " + this.tsImFirstOff);
        if (this.tsImFirstOff != 0 && this.tsDirSize != 0) {
            this.tsDirSize += this.tsImFirstOff;
        }
        this.tsImNext64 = wrkStream.readInt();
        this.tsTraceMessage("IfmxTimeSeries: tsImNext64 = " + this.tsImNext64);
    }

    private void readRowTypeInfo(IfmxUDTSQLInput wrkStream) throws SQLException {
        TypeInfo tsRowType = wrkStream.getUDTInfo(this.amTypeID.xid);
        if (tsRowType == null) {
            throw new SQLException("Cannot read the row type information");
        }
        IfxResultSetMetaData typeInfo = tsRowType.getMetaData();
        this.metaData = (IfxResultSetMetaData)typeInfo.getChild(1);
    }

    void setSQLDataWriteSQLEnable(boolean value) {
        this.sqlDataWriteSqlEnable = value;
    }

    @Override
    public void writeSQL(SQLOutput stream) throws SQLException {
        short tsAmFlags;
        short tsFlags;
        if (!this.sqlDataWriteSqlEnable) {
            throw new SQLException("Direct write access to TimeSeries is no longer supported");
        }
        IfmxUDTSQLOutput wrkStream = (IfmxUDTSQLOutput)stream;
        int start = wrkStream.getCurrentPosition();
        int oldCursor = this.cursor;
        this.tsTraceMessage("IfmxTimeSeries: Enterered writeSQL");
        this.writeTSHeader(wrkStream);
        this.tsTraceMessage("IfmxTimeSeries: After write header");
        if (this.createHeader) {
            return;
        }
        if (this.amStart == -1 || this.amInMemStart == -1 || this.amInMemRef == -1 || this.tsFlagsRef == -1 || this.tsAmFlagsRef == -1 || this.tsImFlagsRef == -1) {
            throw new SQLException("Internal error occured writing to stream!");
        }
        this.tsTraceMessage("IfmxTimeSeries: Before writing directory");
        this.writeTSData(wrkStream);
        this.tsTraceMessage("IfmxTimeSeries: After writing directory");
        if (this.isRegular()) {
            tsFlags = 2;
            tsAmFlags = 11;
        } else {
            tsFlags = 3;
            tsAmFlags = 15;
        }
        int amFinish = wrkStream.getCurrentPosition();
        wrkStream.setCurrentPosition(this.tsFlagsRef);
        wrkStream.writeShort(tsFlags);
        wrkStream.setCurrentPosition(this.tsAmFlagsRef);
        wrkStream.writeShort(tsAmFlags);
        wrkStream.setCurrentPosition(this.amStart);
        wrkStream.writeInt(amFinish - this.amStart);
        wrkStream.setCurrentPosition(this.amInMemRef);
        wrkStream.writeInt(amFinish - this.amInMemStart);
        wrkStream.setCurrentPosition(start);
        wrkStream.writeInt(amFinish - start);
        wrkStream.setCurrentPosition(amFinish);
        wrkStream = null;
        this.cursor = oldCursor;
        this.amInMemRef = -1;
        this.amInMemStart = -1;
        this.amStart = -1;
        this.tsFlagsRef = -1;
        this.tsImFlagsRef = -1;
        this.tsAmFlagsRef = -1;
        this.tsTraceMessage("IfmxTimeSeries: Exited writeSQL");
    }

    public void setHiddenReadMode(boolean mode) {
        this.readHidden = mode;
    }

    public boolean getHiddenReadMode() {
        return this.readHidden;
    }

    public boolean isHidden() throws SQLException {
        TSElementFooter footer = null;
        if (this.cursor == -1 || this.cursor >= this.tsDirSize) {
            throw new SQLException("No current element!");
        }
        footer = (TSElementFooter)this.tsElementData.get(this.tsElementData.size() - 1);
        if (footer == null) {
            throw new SQLException("Internal error, footer not initialised!");
        }
        return footer.isHidden();
    }

    public boolean isDeleted() throws SQLException {
        TSElementFooter footer = null;
        if (this.cursor == -1 || this.cursor >= this.tsDirSize) {
            throw new SQLException("No current element!");
        }
        footer = (TSElementFooter)this.tsElementData.get(this.tsElementData.size() - 1);
        if (footer == null) {
            throw new SQLException("Internal error, footer not initialised!");
        }
        return footer.isDeleted();
    }

    public boolean isRegular() {
        return (this.flags & 1) == 0;
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
        this.tsData = null;
        this.tsElementData = null;
        this.cursor = -1;
        this.tsDirSize = 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    private void checkClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("The TimeSeries result set is closed");
        }
    }

    private boolean checkBeforeRead(int fieldIndex) throws SQLException {
        this.checkClosed();
        if (!this.isValidFieldIndex(fieldIndex, false)) {
            throw new SQLException(MessageFormat.format("The specified column index, {0}, is outside the range 0 <= column index < {1}", fieldIndex, this.tsElementData.size()));
        }
        if (this.cursor >= this.tsDirSize) {
            throw new SQLException("No more elements!");
        }
        return this.isHidden() && !this.readHidden;
    }

    private void checkBeforeUpdate(int fieldIndex) throws SQLException {
        this.checkClosed();
        if (!this.isValidFieldIndex(fieldIndex, true)) {
            throw new SQLException("Column index out of range!");
        }
    }

    private boolean isValidFieldIndex(int fieldIndex, boolean update) {
        boolean returnVal = false;
        if (!(fieldIndex <= 0 || fieldIndex > this.metaData.getColumnCount() || update && fieldIndex == 1)) {
            returnVal = true;
        }
        return returnVal;
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.cursor < 0 || this.cursor > this.tsDirSize) {
            throw new SQLException("No current element!");
        }
        return ((TSElementFooter)this.tsElementData.get(this.tsElementData.size() - 1)).isNull();
    }

    @Override
    public String getString(int fieldIndex) throws SQLException {
        if (this.checkBeforeRead(fieldIndex)) {
            return null;
        }
        Object value = this.tsElementData.get(fieldIndex);
        if (value == null && this.isRegular() && fieldIndex == 1) {
            value = this.getTimestamp(fieldIndex);
        }
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public String getString(String fieldLabel) throws SQLException {
        return this.getString(this.findColumn(fieldLabel));
    }

    @Override
    public boolean getBoolean(int fieldIndex) throws SQLException {
        if (this.checkBeforeRead(fieldIndex)) {
            return false;
        }
        Object c = this.tsElementData.get(fieldIndex);
        if (c == null) {
            return false;
        }
        if (c instanceof Boolean) {
            return (Boolean)c;
        }
        throw new SQLException("Column does not contain a Boolean!");
    }

    @Override
    public boolean getBoolean(String fieldLabel) throws SQLException {
        return this.getBoolean(this.findColumn(fieldLabel));
    }

    @Override
    public byte getByte(int fieldIndex) throws SQLException {
        if (this.checkBeforeRead(fieldIndex)) {
            return 0;
        }
        Object c = this.tsElementData.get(fieldIndex);
        if (c == null) {
            return 0;
        }
        if (c instanceof Byte) {
            return (Byte)c;
        }
        throw new SQLException("Column does not contain a Byte!");
    }

    @Override
    public byte getByte(String fieldLabel) throws SQLException {
        return this.getByte(this.findColumn(fieldLabel));
    }

    @Override
    public short getShort(int fieldIndex) throws SQLException {
        if (this.checkBeforeRead(fieldIndex)) {
            return 0;
        }
        Object value = this.tsElementData.get(fieldIndex);
        if (value == null) {
            return 0;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            try {
                Short shrt = Short.valueOf((String)value);
                return shrt;
            }
            catch (NumberFormatException e) {
                throw new SQLException(MessageFormat.format("the String in field {0} cannot be parsed as a java.lang.Short", fieldIndex), e);
            }
        }
        throw new SQLException(MessageFormat.format("field {0} does not contain a java.lang.Number", fieldIndex));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    public boolean isNull(int fieldIndex) throws SQLException {
        if (this.checkBeforeRead(fieldIndex)) {
            return true;
        }
        Object c = this.tsElementData.get(fieldIndex);
        return c == null;
    }

    public boolean isNull(String fieldLabel) throws SQLException {
        return this.isNull(this.findColumn(fieldLabel));
    }

    @Override
    public int getInt(int fieldIndex) throws SQLException {
        if (this.checkBeforeRead(fieldIndex)) {
            return 0;
        }
        Object value = this.tsElementData.get(fieldIndex);
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                Integer intgr = Integer.valueOf((String)value);
                return intgr;
            }
            catch (NumberFormatException e) {
                throw new SQLException(MessageFormat.format("the String in field {0} cannot be parsed as a java.lang.Integer", fieldIndex), e);
            }
        }
        throw new SQLException(MessageFormat.format("field {0} does not contain a java.lang.Number", fieldIndex));
    }

    @Override
    public int getInt(String fieldLabel) throws SQLException {
        return this.getInt(this.findColumn(fieldLabel));
    }

    @Override
    public long getLong(int fieldIndex) throws SQLException {
        if (this.checkBeforeRead(fieldIndex)) {
            return 0L;
        }
        Object value = this.tsElementData.get(fieldIndex);
        if (value == null) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            try {
                Long lng = Long.valueOf((String)value);
                return lng;
            }
            catch (NumberFormatException e) {
                throw new SQLException(MessageFormat.format("the String in field {0} cannot be parsed as a java.lang.Long", fieldIndex), e);
            }
        }
        throw new SQLException(MessageFormat.format("field {0} does not contain a java.lang.Number", fieldIndex));
    }

    @Override
    public long getLong(String fieldLabel) throws SQLException {
        return this.getLong(this.findColumn(fieldLabel));
    }

    @Override
    public float getFloat(int fieldIndex) throws SQLException {
        if (this.checkBeforeRead(fieldIndex)) {
            return 0.0f;
        }
        Object value = this.tsElementData.get(fieldIndex);
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.floatValue();
        }
        if (value instanceof String) {
            try {
                Float flt = Float.valueOf((String)value);
                return flt.floatValue();
            }
            catch (NumberFormatException e) {
                throw new SQLException(MessageFormat.format("the String in field {0} cannot be parsed as a java.lang.Float", fieldIndex), e);
            }
        }
        throw new SQLException(MessageFormat.format("field {0} does not contain a java.lang.Number", fieldIndex));
    }

    @Override
    public float getFloat(String fieldLabel) throws SQLException {
        return this.getFloat(this.findColumn(fieldLabel));
    }

    @Override
    public double getDouble(int fieldIndex) throws SQLException {
        if (this.checkBeforeRead(fieldIndex)) {
            return 0.0;
        }
        Object value = this.tsElementData.get(fieldIndex);
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        if (value instanceof String) {
            try {
                Double dbl = Double.valueOf((String)value);
                return dbl;
            }
            catch (NumberFormatException e) {
                throw new SQLException(MessageFormat.format("the String in field {0} cannot be parsed as a java.lang.Double", fieldIndex), e);
            }
        }
        throw new SQLException(MessageFormat.format("field {0} does not contain a java.lang.Number", fieldIndex));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int fieldIndex) throws SQLException {
        if (this.checkBeforeRead(fieldIndex)) {
            return null;
        }
        Object value = this.tsElementData.get(fieldIndex);
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return new BigDecimal(number.toString());
        }
        if (value instanceof String) {
            try {
                BigDecimal bigDecimal = new BigDecimal((String)value);
                return bigDecimal;
            }
            catch (NumberFormatException e) {
                throw new SQLException(MessageFormat.format("the String in field {0} cannot be parsed as a java.math.BigDecimal", fieldIndex), e);
            }
        }
        throw new SQLException(MessageFormat.format("field {0} does not contain a java.lang.Number", fieldIndex));
    }

    @Override
    public BigDecimal getBigDecimal(String fieldLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(fieldLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int fieldIndex, int scale) throws SQLException {
        if (this.checkBeforeRead(fieldIndex)) {
            return null;
        }
        Object value = this.tsElementData.get(fieldIndex);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            BigDecimal bigDecimal;
            if (value instanceof BigDecimal) {
                bigDecimal = (BigDecimal)value;
            } else {
                Number number = (Number)value;
                bigDecimal = new BigDecimal(number.toString());
            }
            return bigDecimal.setScale(scale, 4);
        }
        if (value instanceof String) {
            try {
                BigDecimal bigDecimal = new BigDecimal((String)value);
                return bigDecimal.setScale(scale, 4);
            }
            catch (NumberFormatException e) {
                throw new SQLException(MessageFormat.format("the String in field {0} cannot be parsed as a java.math.BigDecimal", fieldIndex), e);
            }
        }
        throw new SQLException(MessageFormat.format("field {0} does not contain a java.lang.Number", fieldIndex));
    }

    @Override
    public BigDecimal getBigDecimal(String fieldLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(fieldLabel), scale);
    }

    @Override
    public byte[] getBytes(int fieldIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public byte[] getBytes(String fieldLabel) throws SQLException {
        return this.getBytes(this.findColumn(fieldLabel));
    }

    @Override
    public Date getDate(int fieldIndex) throws SQLException {
        if (this.checkBeforeRead(fieldIndex)) {
            return null;
        }
        Object c = this.tsElementData.get(fieldIndex);
        if (c == null) {
            return null;
        }
        if (c instanceof Date) {
            return (Date)c;
        }
        throw new SQLException("Column does not contain a Date!");
    }

    @Override
    public Date getDate(String fieldLabel) throws SQLException {
        return this.getDate(this.findColumn(fieldLabel));
    }

    @Override
    public Date getDate(int fieldIndex, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public Date getDate(String fieldLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(fieldLabel), cal);
    }

    @Override
    public Time getTime(int fieldIndex) throws SQLException {
        return this.getTime(fieldIndex, (Calendar)null);
    }

    @Override
    public Time getTime(String fieldLabel) throws SQLException {
        return this.getTime(this.findColumn(fieldLabel));
    }

    @Override
    public Time getTime(int fieldIndex, Calendar cal) throws SQLException {
        if (this.checkBeforeRead(fieldIndex)) {
            return null;
        }
        Object value = this.tsElementData.get(fieldIndex);
        if (value == null && this.isRegular() && fieldIndex == 1) {
            value = this.calendar.getTimestampFromOffset(this.cursor, this.offset);
        }
        if (value == null) {
            return null;
        }
        if (value instanceof Time) {
            if (cal == null) {
                return (Time)value;
            }
            return this.shiftTimeToTimezone((Time)value, cal);
        }
        if (value instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)value;
            if (cal == null) {
                return IfmxTimeSeries.convertToJavaSqlTime(timestamp);
            }
            return IfmxTimeSeries.convertToJavaSqlTime(this.offsetFromUtcModuloDay(timestamp, cal));
        }
        throw new SQLException(MessageFormat.format("Column index {0} does not contain an instance of java.sql.Time or java.sql.Timestamp", fieldIndex));
    }

    private Time shiftTimeToTimezone(Time time, Calendar targetCalendar) {
        long timeOffsetFromUtc = TimeUnit.MINUTES.toMillis(time.getTimezoneOffset());
        long timeMillis = time.getTime();
        long calendarOffsetFromUtc = targetCalendar.getTimeZone().getOffset(timeMillis);
        if (timeOffsetFromUtc == calendarOffsetFromUtc) {
            return time;
        }
        long offsetMillis = timeMillis - timeOffsetFromUtc + calendarOffsetFromUtc;
        if (offsetMillis < 0L) {
            offsetMillis += TimeUnit.DAYS.toMillis(1L);
        }
        Time offsetTime = new Time(offsetMillis);
        return offsetTime;
    }

    private static Timestamp shiftTimestampToTimezone(Timestamp timestamp, Calendar targetCalendar) {
        long timestampOffsetFromUtc = TimeUnit.MINUTES.toMillis(timestamp.getTimezoneOffset());
        long timestampMillis = timestamp.getTime();
        long calendarOffsetFromUtc = targetCalendar.getTimeZone().getOffset(timestampMillis);
        if (timestampOffsetFromUtc == calendarOffsetFromUtc) {
            return timestamp;
        }
        long shiftedMillis = timestampMillis - timestampOffsetFromUtc + calendarOffsetFromUtc;
        Timestamp shiftedTimestamp = new Timestamp(shiftedMillis);
        shiftedTimestamp.setNanos(timestamp.getNanos());
        return shiftedTimestamp;
    }

    private Timestamp offsetFromUtcModuloDay(Timestamp utcTimestamp, Calendar targetCalendar) {
        targetCalendar.setTimeInMillis(utcTimestamp.getTime());
        return new Timestamp(utcTimestamp.getTime() + (long)targetCalendar.getTimeZone().getOffset(utcTimestamp.getTime()));
    }

    private static Time convertToJavaSqlTime(Timestamp timestamp) {
        return new Time(timestamp.getTime());
    }

    public Calendar getCalendar(int fieldIndex, Calendar cal) throws SQLException {
        if (this.checkBeforeRead(fieldIndex)) {
            return null;
        }
        Object value = this.tsElementData.get(fieldIndex);
        if (value == null && this.isRegular() && fieldIndex == 1) {
            value = this.calendar.getTimestampFromOffset(this.cursor, this.offset);
        }
        if (value == null) {
            return null;
        }
        if (value instanceof Time) {
            if (cal == null) {
                cal = Calendar.getInstance(IfmxTimeSeries.getDefaultTimeZone());
            }
            cal.setTimeInMillis(((Time)value).getTime());
            return cal;
        }
        throw new SQLException(MessageFormat.format("Column index {0} does not contain an instance of java.sql.Time or java.sql.Timestamp", fieldIndex));
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    @Override
    public Timestamp getTimestamp(int fieldIndex) throws SQLException {
        this.checkClosed();
        if (!this.isValidFieldIndex(fieldIndex, false)) {
            throw new SQLException(MessageFormat.format("The specified column index, {0}, is outside the range 0 <= column index < {1}", fieldIndex, this.tsElementData.size()));
        }
        if (this.cursor >= this.tsDirSize && this.insertPhase == InsertPhase.IDLE) {
            throw new SQLException("No more elements!");
        }
        if (this.insertPhase == InsertPhase.IDLE && this.isHidden() && !this.readHidden) {
            return null;
        }
        Object c = this.tsElementData.get(fieldIndex);
        if (c == null) {
            if (this.isRegular() && fieldIndex == 1) {
                Timestamp returnVal = this.calendar.getTimestampFromOffset(this.cursor, this.offset);
                return returnVal;
            }
            return null;
        }
        if (c instanceof Timestamp) {
            return (Timestamp)c;
        }
        throw new SQLException(MessageFormat.format("Column {0} does not contain a Timestamp (contains {1})", fieldIndex, c.getClass().getName()));
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(int fieldIndex, Calendar cal) throws SQLException {
        if (cal == null) {
            return this.getTimestamp(fieldIndex);
        }
        Timestamp timestamp = this.getTimestamp(fieldIndex);
        return IfmxTimeSeries.shiftTimestampToTimezone(timestamp, cal);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    @Override
    public Array getArray(int fieldIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public Array getArray(String fieldLabel) throws SQLException {
        return this.getArray(this.findColumn(fieldLabel));
    }

    @Override
    public InputStream getAsciiStream(int fieldIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public InputStream getAsciiStream(String fieldLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(fieldLabel));
    }

    @Override
    public InputStream getUnicodeStream(int fieldIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getBinaryStream(int fieldIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public Reader getCharacterStream(int fieldIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    @Override
    public Object getObject(int fieldIndex) throws SQLException {
        if (this.checkBeforeRead(fieldIndex)) {
            return null;
        }
        Object c = this.tsElementData.get(fieldIndex);
        if (c == null && this.isRegular() && fieldIndex == 1) {
            c = this.getTimestamp(fieldIndex);
        }
        return c;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Object getObject(int fieldIndex, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public Object getObject(String columnName, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(columnName), map);
    }

    @Override
    public Blob getBlob(int fieldIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public Blob getBlob(String columnName) throws SQLException {
        return this.getBlob(this.findColumn(columnName));
    }

    @Override
    public Clob getClob(int fieldIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public Clob getClob(String columnName) throws SQLException {
        return this.getClob(this.findColumn(columnName));
    }

    @Override
    public Ref getRef(int fieldIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public Ref getRef(String columnName) throws SQLException {
        return this.getRef(this.findColumn(columnName));
    }

    public Interval getInterval(int fieldIndex) throws SQLException {
        if (this.checkBeforeRead(fieldIndex)) {
            return null;
        }
        Object c = this.tsElementData.get(fieldIndex);
        if (c == null) {
            return null;
        }
        if (c instanceof Interval) {
            return (Interval)c;
        }
        throw new SQLException(MessageFormat.format("field {0} does not contain a com.informix.lang.Interval", fieldIndex));
    }

    public Interval getInterval(String columnName) throws SQLException {
        return this.getInterval(this.findColumn(columnName));
    }

    @Override
    public boolean next() throws SQLException {
        if (this.tsDirSize > 0 && this.tsDirSize > this.cursor + 1) {
            ++this.cursor;
            this.getElement();
            return true;
        }
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.cursor > 0) {
            --this.cursor;
            this.getElement();
            return true;
        }
        return false;
    }

    @Override
    public boolean first() throws SQLException {
        if (this.tsDirSize == 0) {
            return false;
        }
        this.cursor = 0;
        this.getElement();
        return true;
    }

    @Override
    public boolean last() throws SQLException {
        if (this.tsDirSize == 0) {
            return false;
        }
        this.cursor = this.tsDirSize - 1;
        this.getElement();
        return true;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkClosed();
        if (this.tsDirSize == 0) {
            return false;
        }
        if (row == 0) {
            throw new SQLException("the row number must be a positive or negative integer, not zero");
        }
        if (row < 0) {
            this.cursor = this.tsDirSize + row;
            if (this.cursor < 0) {
                this.cursor = -1;
                return false;
            }
        } else {
            this.cursor = row - 1;
            if (this.cursor >= this.tsDirSize) {
                this.cursor = this.tsDirSize;
                return false;
            }
        }
        this.getElement();
        return true;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkClosed();
        if (rows == 0) {
            return this.tsDirSize > 0;
        }
        if (this.cursor == -1) {
            throw new SQLException("No current TimeSeries row!");
        }
        int newCursor = this.cursor + rows;
        if (newCursor < 0) {
            this.cursor = -1;
            return false;
        }
        if (newCursor >= this.tsDirSize) {
            this.cursor = this.tsDirSize;
            return false;
        }
        this.cursor = newCursor;
        this.getElement();
        return true;
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkClosed();
        if (this.tsDirSize > 0) {
            this.cursor = this.tsDirSize;
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkClosed();
        this.cursor = -1;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.checkClosed();
        if (this.oldCursor == -1) {
            return;
        }
        this.cursor = this.oldCursor;
        this.getElement();
        this.oldCursor = -1;
        this.insertPhase = InsertPhase.IDLE;
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.checkClosed();
        if (!this.isRegular()) {
            throw new SQLException("Not supported for irregular TimeSeries - use moveToInsertRow(Timestamp)");
        }
        this.oldCursor = this.cursor;
        this.insertPhase = InsertPhase.ADD_ELEMENT_DATA_TO_TS;
        this.tsElementData = new ArrayList<Object>(this.metaData.getColumnCount() + 2);
        this.tsElementData.add(new TSElementHeader(this.metaData.getColumnCount()));
        for (int i = 1; i <= this.metaData.getColumnCount(); ++i) {
            this.tsElementData.add(null);
        }
        this.tsElementData.add(new TSElementFooter());
        this.cursor = this.tsDirSize;
    }

    public void moveToInsertRow(Timestamp timestamp) throws SQLException {
        this.checkClosed();
        if (timestamp == null) {
            throw new SQLException("the timestamp must not be null");
        }
        this.oldCursor = this.cursor;
        this.insertPhase = InsertPhase.ADD_ELEMENT_DATA_TO_TS;
        this.tsElementData = new ArrayList<Object>(this.metaData.getColumnCount() + 2);
        this.tsElementData.add(null);
        this.tsElementData.add(timestamp);
        for (int i = 2; i < this.metaData.getColumnCount() + 2; ++i) {
            this.tsElementData.add(null);
        }
        this.cursor = this.tsDirSize;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClosed();
        return this.cursor == 0;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        return this.cursor == -1;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClosed();
        return this.cursor == this.tsDirSize - 1;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClosed();
        return this.cursor >= this.tsDirSize;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClosed();
        if (this.cursor == -1 || this.cursor >= this.tsData.size()) {
            return 0;
        }
        return this.cursor + 1;
    }

    @Override
    public void updateString(int fieldIndex, String value) throws SQLException {
        this.checkBeforeUpdate(fieldIndex);
        try {
            TimeSeriesField<?> field = this.timeseriesRowType.getField(fieldIndex);
            Object object = field.getFieldDefinition().convertValueTo(value);
            this.tsElementData.set(fieldIndex, object);
            this.updateLocalElement();
        }
        catch (Exception e) {
            throw new SQLException(MessageFormat.format("Unable to update field {0}", fieldIndex), e);
        }
    }

    @Override
    public void updateString(String fieldLabel, String value) throws SQLException {
        this.updateString(this.findColumn(fieldLabel), value);
    }

    @Override
    public void updateBoolean(int fieldIndex, boolean value) throws SQLException {
        this.checkBeforeUpdate(fieldIndex);
        try {
            TimeSeriesField<?> field = this.timeseriesRowType.getField(fieldIndex);
            Object object = field.getFieldDefinition().convertValueTo(value);
            this.tsElementData.set(fieldIndex, object);
            this.updateLocalElement();
        }
        catch (Exception e) {
            throw new SQLException(MessageFormat.format("Unable to update field {0}", fieldIndex), e);
        }
    }

    @Override
    public void updateBoolean(String columnName, boolean value) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), value);
    }

    @Override
    public void updateByte(int fieldIndex, byte value) throws SQLException {
        this.checkBeforeUpdate(fieldIndex);
        try {
            TimeSeriesField<?> field = this.timeseriesRowType.getField(fieldIndex);
            Object object = field.getFieldDefinition().convertValueTo(value);
            this.tsElementData.set(fieldIndex, object);
            this.updateLocalElement();
        }
        catch (Exception e) {
            throw new SQLException(MessageFormat.format("Unable to update field {0}", fieldIndex), e);
        }
    }

    @Override
    public void updateByte(String fieldLabel, byte value) throws SQLException {
        this.updateByte(this.findColumn(fieldLabel), value);
    }

    @Override
    public void updateShort(int fieldIndex, short value) throws SQLException {
        this.checkBeforeUpdate(fieldIndex);
        try {
            TimeSeriesField<?> field = this.timeseriesRowType.getField(fieldIndex);
            Object object = field.getFieldDefinition().convertValueTo(value);
            this.tsElementData.set(fieldIndex, object);
            this.updateLocalElement();
        }
        catch (Exception e) {
            throw new SQLException(MessageFormat.format("Unable to update field {0}", fieldIndex), e);
        }
    }

    @Override
    public void updateShort(String columnName, short value) throws SQLException {
        this.updateShort(this.findColumn(columnName), value);
    }

    @Override
    public void updateInt(int fieldIndex, int value) throws SQLException {
        this.checkBeforeUpdate(fieldIndex);
        try {
            TimeSeriesField<?> field = this.timeseriesRowType.getField(fieldIndex);
            Object object = field.getFieldDefinition().convertValueTo(value);
            this.tsElementData.set(fieldIndex, object);
            this.updateLocalElement();
        }
        catch (Exception e) {
            throw new SQLException(MessageFormat.format("Unable to update field {0}", fieldIndex), e);
        }
    }

    @Override
    public void updateInt(String columnName, int value) throws SQLException {
        this.updateInt(this.findColumn(columnName), value);
    }

    @Override
    public void updateLong(int fieldIndex, long value) throws SQLException {
        this.checkBeforeUpdate(fieldIndex);
        try {
            TimeSeriesField<?> field = this.timeseriesRowType.getField(fieldIndex);
            Object object = field.getFieldDefinition().convertValueTo(value);
            this.tsElementData.set(fieldIndex, object);
            this.updateLocalElement();
        }
        catch (Exception e) {
            throw new SQLException(MessageFormat.format("Unable to update field {0}", fieldIndex), e);
        }
    }

    @Override
    public void updateLong(String columnName, long value) throws SQLException {
        this.updateLong(this.findColumn(columnName), value);
    }

    @Override
    public void updateFloat(int fieldIndex, float value) throws SQLException {
        this.checkBeforeUpdate(fieldIndex);
        try {
            TimeSeriesField<?> field = this.timeseriesRowType.getField(fieldIndex);
            Object object = field.getFieldDefinition().convertValueTo(Float.valueOf(value));
            this.tsElementData.set(fieldIndex, object);
            this.updateLocalElement();
        }
        catch (Exception e) {
            throw new SQLException(MessageFormat.format("Unable to update field {0}", fieldIndex), e);
        }
    }

    @Override
    public void updateFloat(String columnName, float value) throws SQLException {
        this.updateFloat(this.findColumn(columnName), value);
    }

    @Override
    public void updateDouble(int fieldIndex, double value) throws SQLException {
        this.checkBeforeUpdate(fieldIndex);
        try {
            TimeSeriesField<?> field = this.timeseriesRowType.getField(fieldIndex);
            Object object = field.getFieldDefinition().convertValueTo(value);
            this.tsElementData.set(fieldIndex, object);
            this.updateLocalElement();
        }
        catch (Exception e) {
            throw new SQLException(MessageFormat.format("Unable to update field {0}", fieldIndex), e);
        }
    }

    @Override
    public void updateDouble(String columnName, double value) throws SQLException {
        this.updateDouble(this.findColumn(columnName), value);
    }

    @Override
    public void updateBytes(int fieldIndex, byte[] value) throws SQLException {
        this.checkBeforeUpdate(fieldIndex);
        try {
            TimeSeriesField<?> field = this.timeseriesRowType.getField(fieldIndex);
            Object object = field.getFieldDefinition().convertValueTo(value);
            this.tsElementData.set(fieldIndex, object);
            this.updateLocalElement();
        }
        catch (Exception e) {
            throw new SQLException(MessageFormat.format("Unable to update field {0}", fieldIndex), e);
        }
    }

    @Override
    public void updateBytes(String columnName, byte[] value) throws SQLException {
        this.updateBytes(this.findColumn(columnName), value);
    }

    @Override
    public void updateDate(int fieldIndex, Date value) throws SQLException {
        this.checkBeforeUpdate(fieldIndex);
        try {
            TimeSeriesField<?> field = this.timeseriesRowType.getField(fieldIndex);
            Object object = field.getFieldDefinition().convertValueTo(value);
            this.tsElementData.set(fieldIndex, object);
            this.updateLocalElement();
        }
        catch (Exception e) {
            throw new SQLException(MessageFormat.format("Unable to update field {0}", fieldIndex), e);
        }
    }

    @Override
    public void updateDate(String columnName, Date value) throws SQLException {
        this.updateDate(this.findColumn(columnName), value);
    }

    @Override
    public void updateTime(int fieldIndex, Time value) throws SQLException {
        this.checkBeforeUpdate(fieldIndex);
        try {
            TimeSeriesField<?> field = this.timeseriesRowType.getField(fieldIndex);
            Object object = field.getFieldDefinition().convertValueTo(value);
            this.tsElementData.set(fieldIndex, object);
            this.updateLocalElement();
        }
        catch (Exception e) {
            throw new SQLException(MessageFormat.format("Unable to update field {0}", fieldIndex), e);
        }
    }

    @Override
    public void updateTime(String columnName, Time value) throws SQLException {
        this.updateTime(this.findColumn(columnName), value);
    }

    @Override
    public void updateTimestamp(int fieldIndex, Timestamp value) throws SQLException {
        this.checkBeforeUpdate(fieldIndex);
        try {
            TimeSeriesField<?> field = this.timeseriesRowType.getField(fieldIndex);
            Object object = field.getFieldDefinition().convertValueTo(value);
            this.tsElementData.set(fieldIndex, object);
            this.updateLocalElement();
        }
        catch (Exception e) {
            throw new SQLException(MessageFormat.format("Unable to update field {0}", fieldIndex), e);
        }
    }

    @Override
    public void updateTimestamp(String fieldLabel, Timestamp value) throws SQLException {
        this.updateTimestamp(this.findColumn(fieldLabel), value);
    }

    @Override
    public void updateCharacterStream(int fieldIndex, Reader x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateCharacterStream(String columnName, Reader x, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateNull(int fieldIndex) throws SQLException {
        this.checkBeforeUpdate(fieldIndex);
        this.tsElementData.set(fieldIndex, null);
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    @Override
    public void updateObject(int fieldIndex, Object value, int scale) throws SQLException {
        this.checkBeforeUpdate(fieldIndex);
        try {
            TimeSeriesField<?> field = this.timeseriesRowType.getField(fieldIndex);
            Object object = field.getFieldDefinition().convertValueTo(value);
            this.tsElementData.set(fieldIndex, object);
            this.updateLocalElement();
        }
        catch (Exception e) {
            throw new SQLException(MessageFormat.format("Unable to update field {0}", fieldIndex), e);
        }
    }

    @Override
    public void updateObject(String fieldLabel, Object value, int scale) throws SQLException {
        this.updateObject(this.findColumn(fieldLabel), value, scale);
    }

    @Override
    public void updateObject(int fieldIndex, Object value) throws SQLException {
        this.checkBeforeUpdate(fieldIndex);
        try {
            TimeSeriesField<?> field = this.timeseriesRowType.getField(fieldIndex);
            Object object = field.getFieldDefinition().convertValueTo(value);
            this.tsElementData.set(fieldIndex, object);
            this.updateLocalElement();
        }
        catch (Exception e) {
            throw new SQLException(MessageFormat.format("Unable to update field {0}", fieldIndex), e);
        }
    }

    @Override
    public void updateObject(String fieldLabel, Object value) throws SQLException {
        this.updateObject(this.findColumn(fieldLabel), value);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public int getType() throws SQLException {
        this.checkClosed();
        return 1005;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1008;
    }

    public void bindForUpdatableResultSet(Connection connection, String tableName, String timeseriesColumnName, String whereClause) {
        this.connection = connection;
        this.tableName = tableName;
        this.timeseriesColumnName = timeseriesColumnName;
        this.whereClause = whereClause;
    }

    public void bindForUpdatableResultSet(Connection connection, String tableName, String timeseriesColumnName, Map<String, Object> whereClauseMap) {
        this.connection = connection;
        this.tableName = tableName;
        this.timeseriesColumnName = timeseriesColumnName;
        this.whereClause = IfmxTimeSeries.createWhereClauseForPreparedStatement(whereClauseMap);
        this.whereClauseHostVariables = whereClauseMap.values().toArray();
    }

    private static String createWhereClauseForPreparedStatement(Map<String, Object> whereClauseMap) {
        if (whereClauseMap == null || whereClauseMap.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean afterFirst = false;
        for (String key : whereClauseMap.keySet()) {
            if (afterFirst) {
                sb.append(" AND ");
            }
            sb.append(key);
            sb.append("=?");
            afterFirst = true;
        }
        return sb.toString();
    }

    /*
     * Exception decompiling
     */
    public static IfmxTimeSeries getUpdatableTimeSeries(Connection connection, String tableName, String timeseriesColumnName, String whereClause) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String buildTimeSeriesQuery(String tableName, String timeseriesColumnName, String whereClause) {
        return MessageFormat.format("SELECT {0} FROM {1} WHERE {2}", timeseriesColumnName, tableName, whereClause);
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return 2;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.metaData == null) {
            throw new SQLException("TimeSeries result set meta-data is not initialised");
        }
        return this.metaData;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        this.checkClosed();
        this.ensureTsColumnNameToNumberMap();
        Integer index = this.tsColumnNameToNumberMap.get(columnName);
        if (index == null && !this.caseSensitiveIdentifiers) {
            for (Map.Entry<String, Integer> entry : this.tsColumnNameToNumberMap.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(columnName)) continue;
                index = entry.getValue();
                break;
            }
        }
        if (index == null) {
            throw new SQLException(MessageFormat.format("No field (column) with the name {0} could be found", columnName));
        }
        return index;
    }

    private void ensureTsColumnNameToNumberMap() throws SQLException {
        if (this.tsColumnNameToNumberMap == null) {
            if (this.metaData == null) {
                throw new SQLException("Result set meta-data is not initialized");
            }
            int numCols = this.metaData.getColumnCount();
            this.tsColumnNameToNumberMap = new HashMap(numCols, 0.75f);
            for (int i = 1; i <= numCols; ++i) {
                String columnName = this.metaData.getColumnName(i);
                this.tsColumnNameToNumberMap.put(columnName, i);
            }
        }
    }

    public int getNumberOfElements() throws SQLException {
        this.checkClosed();
        return this.tsDirSize;
    }

    public String getContainerName() throws SQLException {
        this.checkClosed();
        return this.amTSCont;
    }

    public boolean inContainer() throws SQLException {
        this.checkClosed();
        return (this.flags & 2) != 0;
    }

    public Timestamp getOrigin() throws SQLException {
        this.checkClosed();
        if (this.calendar == null) {
            throw new SQLException("Calendar has not been initialised!");
        }
        return this.calendar.getTimestampFromOffset(0, this.offset);
    }

    public IfmxTimeSeries clip(int start, int end) throws SQLException {
        this.checkClosed();
        if (start < 0 || start >= this.tsDirSize) {
            throw new SQLException("Start offset is out of range!");
        }
        if (end < 0 || end >= this.tsDirSize || end < start) {
            throw new SQLException("End offset is out of range!");
        }
        if (!this.isRegular()) {
            throw new SQLException("Not supported for irregular timeseries!");
        }
        Timestamp s = this.calendar.getTimestampFromOffset(start, this.offset);
        Timestamp e = this.calendar.getTimestampFromOffset(end, this.offset);
        return this.clip(s, e);
    }

    public IfmxTimeSeries clip(Timestamp start, Timestamp end) throws SQLException {
        this.checkClosed();
        if (start.after(end)) {
            throw new SQLException("Invalid date range");
        }
        IfmxTimeSeries newClip = new IfmxTimeSeries();
        newClip.sqlDataWriteSqlEnable = this.sqlDataWriteSqlEnable;
        newClip.length = this.length;
        newClip.version = this.version;
        newClip.amTSCont = this.amTSCont;
        newClip.amPartitionID = this.amPartitionID;
        newClip.expandLimit = this.expandLimit;
        newClip.metaData = this.metaData;
        newClip.amTypeID = new TSTypeID();
        newClip.amTypeID.setXid(this.amTypeID.xid);
        newClip.typeID = new TSTypeID();
        newClip.typeID.setXid(-1);
        newClip.typeID.setTiType((short)-1);
        newClip.typeID.setTiSpare((short)0);
        newClip.sql_type = this.sql_type;
        newClip.sqlRowType = this.sqlRowType;
        newClip.calId = this.calId;
        newClip.calendar = new IfmxCalendar(this.calendar.getName(), this.calendar.getStartDate(), this.calendar.getPatStartDate(), this.calendar.getPattern().toCalendarPatternString());
        newClip.amLength = 0;
        newClip.amVer = (byte)2;
        newClip.amSpare = 0;
        newClip.flags = this.flags;
        newClip.amFlags = this.amFlags;
        newClip.amInstID = -1L;
        newClip.amElemSize = this.amElemSize;
        newClip.tsImFirstOff = 0;
        newClip.tsImSize = 0;
        newClip.tsImFreeOff = 0;
        newClip.tsNext = 0;
        newClip.tsDirSize = 0;
        newClip.tsData = new ArrayList<List<Object>>();
        newClip.offset = 0;
        int size = this.tsData.size();
        boolean offsetIsSet = false;
        if (size == 0) {
            return newClip;
        }
        for (int i = 0; i < size; ++i) {
            Timestamp t = this.calendar.getTimestampFromOffset(i, this.offset);
            if (t == null || t.before(start)) continue;
            if (t.after(end)) break;
            if (!offsetIsSet) {
                offsetIsSet = true;
                IfxCalendar offsetCal = new IfxCalendar(t);
                IfxCalendar origCal = new IfxCalendar(this.calendar.getStartDate());
                newClip.offset = offsetCal.getDifference(origCal, this.calendar.getPattern().getIntervalTypeId());
            }
            newClip.tsData.add(new ArrayList(this.tsData.get(i)));
            ++newClip.tsDirSize;
        }
        return newClip;
    }

    private long readTimeseriesID(IfmxUDTSQLInput stream) throws SQLException {
        long s = 0xFFFFFFFFL;
        int i1 = stream.readInt();
        int i2 = stream.readInt();
        this.amInstID = ((s & (long)i1) << 32) + ((long)i2 & s);
        return this.amInstID;
    }

    private void readContainerName(IfmxUDTSQLInput stream) throws SQLException {
        String temp;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 128 && (temp = stream.readString(1)).length() > 0; ++i) {
            sb.append(temp);
        }
        this.amTSCont = sb.toString();
    }

    private void readRowTypeName(String sqlName) {
        int start = sqlName.indexOf(40);
        int end = sqlName.indexOf(41);
        this.sqlRowType = sqlName.substring(start + 1, end);
    }

    private void getElement() throws SQLException {
        this.getElementFromTSStruct(this.cursor);
    }

    private void initTimeSeries(IfmxUDTSQLInput stream) throws SQLException {
        this.tsTraceMessage("IfmxTimeSeries: Entered initTimeSeries");
        this.timeseriesRowType = TimeSeriesRowType.createTimeSeriesRowType(this.sqlRowType, null, this.metaData);
        this.tsData = new ArrayList<List<Object>>(this.tsDirSize);
        for (int elementIndex = 0; elementIndex < this.tsDirSize; ++elementIndex) {
            this.tsElementData = this.getElementFromStream(elementIndex, stream);
            this.tsData.add(this.tsElementData);
        }
        this.tsTraceMessage("IfmxTimeSeries: Exited initTimeSeries");
    }

    private void getElementFromTSStruct(int elemOffset) throws SQLException {
        this.tsElementData = this.tsData.get(elemOffset);
    }

    private List<Object> getElementFromStream(int elementOffset, IfmxUDTSQLInput streamInput) throws SQLException {
        if (elementOffset < this.tsImFirstOff) {
            return this.makeEmptyElement();
        }
        int directoryOffset = this.tsImFirstOff != 0 ? (elementOffset - this.tsImFirstOff + 1) * 8 : (elementOffset + 1) * 8;
        streamInput.setCurrentPosition(this.length - directoryOffset);
        this.elemOffset = streamInput.readInt();
        this.elemLength = streamInput.readInt();
        if (this.elemOffset == -1) {
            return this.makeEmptyElement();
        }
        streamInput.setCurrentPosition(this.start + this.elemOffset);
        streamInput.setAutoAlignment(false);
        int numCols = this.metaData.getColumnCount();
        this.tsElementData = new ArrayList<Object>(numCols + 2);
        this.tsTraceMessage("IfmxTimeSeries: The number of columns read is " + numCols + "\n");
        TSElementHeader header = new TSElementHeader(numCols);
        header.readStream(streamInput);
        this.tsElementData.add(header);
        for (int fieldIndex = 1; fieldIndex <= numCols; ++fieldIndex) {
            if (!header.isColumnNull(fieldIndex)) {
                Object c;
                TimeSeriesField<?> field = this.timeseriesRowType.getField(fieldIndex);
                if (field == null) {
                    String message = MessageFormat.format("No timeseries field type is associated with field index {0}", fieldIndex);
                    throw new SQLException(message);
                }
                try {
                    c = field.getFieldDefinition().read(streamInput, this.metaData, fieldIndex);
                }
                catch (Exception e) {
                    String message = MessageFormat.format("An exception was thrown while reading field ''{0}'' at field index {1}", field.getFieldName(), fieldIndex);
                    throw new SQLException(message, e);
                }
                this.tsElementData.add(c);
                continue;
            }
            this.tsElementData.add(null);
        }
        int footerStartPosition = this.start + this.elemOffset + this.elemLength - 1;
        if (footerStartPosition != streamInput.getCurrentPosition()) {
            streamInput.setCurrentPosition(footerStartPosition);
        }
        TSElementFooter footer = new TSElementFooter();
        footer.readStream(streamInput);
        this.tsElementData.add(footer);
        return this.tsElementData;
    }

    private List<Object> makeEmptyElement() throws SQLException {
        int columns = this.metaData.getColumnCount();
        this.tsElementData = new ArrayList<Object>(columns + 2);
        TSElementHeader header = new TSElementHeader(columns);
        this.tsElementData.add(header);
        for (int index = 1; index <= columns; ++index) {
            header.setNull(index);
            this.tsElementData.add(null);
        }
        TSElementFooter footer = new TSElementFooter();
        footer.setNull();
        this.tsElementData.add(footer);
        return this.tsElementData;
    }

    private void writeTSHeader(IfmxUDTSQLOutput wrkStream) throws SQLException {
        int start = wrkStream.getCurrentPosition();
        wrkStream.writeInt(0);
        wrkStream.writeByte(this.version);
        wrkStream.writeByte(this.spare1);
        this.writeAlign(wrkStream, 2);
        this.tsFlagsRef = wrkStream.getCurrentPosition();
        short tsFlags = !this.isRegular() ? (short)1 : 0;
        wrkStream.writeShort(tsFlags);
        wrkStream.writeInt(this.offset);
        wrkStream.writeInt(this.originDelta);
        wrkStream.writeInt(this.calId);
        wrkStream.writeShort(this.expandLimit);
        wrkStream.writeShort(this.spare2);
        this.typeID.writeToStream(wrkStream);
        wrkStream.writeInt(4);
        wrkStream.writeInt(4);
        this.writeAlign(wrkStream, 4);
        this.amStart = wrkStream.getCurrentPosition();
        wrkStream.writeInt(0);
        wrkStream.writeByte(this.amVer);
        wrkStream.writeByte(this.amSpare);
        this.writeAlign(wrkStream, 2);
        this.tsAmFlagsRef = wrkStream.getCurrentPosition();
        short tsAmFlags = !this.isRegular() ? (short)5 : 1;
        if (this.bigintflag != 0) {
            tsAmFlags = (short)(tsAmFlags | 0x20);
        }
        wrkStream.writeShort(tsAmFlags);
        this.writeTimeseriesID(wrkStream);
        wrkStream.writeInt(this.amPartitionID);
        this.amTypeID.writeToStream(wrkStream);
        wrkStream.writeShort(this.amSpare2);
        wrkStream.writeShort(this.amElemSize);
        if (this.amTSCont != null) {
            wrkStream.writeString(this.amTSCont, this.amTSCont.length());
        }
        wrkStream.writeByte((byte)0);
        this.writeAlign(wrkStream, 4);
        this.amInMemStart = wrkStream.getCurrentPosition();
        wrkStream.writeInt(0);
        if (this.createHeader) {
            wrkStream.writeInt(Integer.MAX_VALUE);
        } else {
            wrkStream.writeInt(this.tsImFirstOff);
        }
        this.writeAlign(wrkStream, 4);
        this.amInMemRef = wrkStream.getCurrentPosition();
        wrkStream.writeInt(0);
        wrkStream.writeInt(this.tsImFreeOff);
        if (this.createHeader) {
            this.tsTraceMessage("IfmxTimeSeries: Only creating the ts header!");
            wrkStream.writeInt(0);
        } else {
            this.tsTraceMessage("IfmxTimeSeries: Wrote " + this.tsDirSize + " as the dir size");
            wrkStream.writeInt(this.tsDirSize);
        }
        this.writeAlign(wrkStream, 2);
        this.tsImFlagsRef = wrkStream.getCurrentPosition();
        wrkStream.writeInt(this.tsImNext64);
        int amFinish = wrkStream.getCurrentPosition();
        wrkStream.setCurrentPosition(this.amStart);
        wrkStream.writeInt(amFinish - this.amStart);
        wrkStream.setCurrentPosition(this.amInMemRef);
        wrkStream.writeInt(amFinish - this.amInMemStart);
        if (this.createHeader) {
            wrkStream.writeInt(amFinish - this.amInMemStart);
        }
        wrkStream.setCurrentPosition(start);
        wrkStream.writeInt(amFinish - start);
        wrkStream.setCurrentPosition(amFinish);
    }

    private void writeTimeseriesID(IfmxUDTSQLOutput stream) throws SQLException {
        int i1 = (int)(this.amInstID >> 32);
        int i2 = (int)(this.amInstID & 0xFFFFFFFFL);
        stream.writeInt(i1);
        stream.writeInt(i2);
    }

    private void writeTSData(IfmxUDTSQLOutput stream) throws SQLException {
        int i;
        if (this.tsDirSize == 0) {
            return;
        }
        this.beforeFirst();
        this.timeseriesRowType = TimeSeriesRowType.createTimeSeriesRowType(this.sqlRowType, null, this.metaData);
        int[] dir = new int[this.tsDirSize];
        int[] dirElemSize = new int[this.tsDirSize];
        this.writeAlign(stream, 4);
        stream.setAutoAlignment(false);
        for (i = 0; i < this.tsDirSize; ++i) {
            this.tsTraceMessage("IfmxTimeSeries: Writing " + i + " element");
            this.next();
            this.tsTraceMessage("IfmxTimeSeries: Before get position");
            dir[i] = stream.getCurrentPosition();
            this.tsTraceMessage("IfmxTimeSeries: The current stream position is " + dir[i]);
            this.writeElement(stream);
            dirElemSize[i] = stream.getCurrentPosition() - dir[i];
        }
        stream.setAutoAlignment(true);
        for (i = dir.length - 1; i >= 0; --i) {
            stream.writeInt(dir[i] - this.amInMemStart);
            stream.writeInt(dirElemSize[i]);
        }
    }

    private void writeElement(IfmxUDTSQLOutput stream) throws SQLException {
        int fieldIndex = 0;
        this.tsTraceMessage("IfmxTimeSeries: Before get header");
        TSElementHeader header = (TSElementHeader)this.tsElementData.get(0);
        if (header == null) {
            throw new SQLException("Internal error writing element header!");
        }
        header.writeStream(stream);
        this.tsTraceMessage("IfmxTimeSeries: The header is " + header);
        try {
            for (fieldIndex = 1; fieldIndex <= this.metaData.getColumnCount(); ++fieldIndex) {
                if (header.isColumnNull(fieldIndex)) continue;
                TimeSeriesField<?> field = this.timeseriesRowType.getField(fieldIndex);
                field.getFieldDefinition().write(stream, this.tsElementData.get(fieldIndex));
            }
        }
        catch (Exception e) {
            throw new SQLException("Unable to write timeseries to stream", e);
        }
        this.tsTraceMessage("IfmxTimeSeries: After writing to stream");
        TSElementFooter footer = (TSElementFooter)this.tsElementData.get(fieldIndex);
        footer.writeStream(stream);
        stream.writeByte((byte)4);
        stream.writeByte((byte)0);
        this.tsTraceMessage("IfmxTimeSeries: After writing footer");
    }

    private void updateLocalElement() {
        if (this.insertPhase == InsertPhase.IDLE) {
            if (this.cursor < 0 || this.cursor >= this.tsData.size()) {
                throw new IndexOutOfBoundsException(MessageFormat.format("The current cursor position, {0}, is outside the valid range for the TimeSeries data (0 <= cursor < {1})", this.cursor, this.tsData.size()));
            }
            this.tsData.set(this.cursor, this.tsElementData);
        } else if (this.insertPhase == InsertPhase.ADD_ELEMENT_DATA_TO_TS) {
            this.tsData.add(this.tsElementData);
            this.tsDirSize = this.tsData.size();
            this.insertPhase = InsertPhase.IN_PROGRESS;
        }
    }

    private int getElementSize() {
        return this.metaData.getColumnCount() * 8;
    }

    private int getContainerBigIntFlag(Connection connection, String containerName) throws SQLException {
        int flag = 0;
        String sql = "SELECT BITAND(flags, 4) FROM TSContainerTable WHERE name = ?";
        try (PreparedStatement pstmt = connection.prepareStatement("SELECT BITAND(flags, 4) FROM TSContainerTable WHERE name = ?");){
            pstmt.setString(1, containerName);
            try (ResultSet resultSet = pstmt.executeQuery();){
                if (resultSet.next()) {
                    flag = resultSet.getInt(1);
                }
            }
        }
        catch (SQLException e) {
            throw new SQLException("Cannot extract container flags!", e);
        }
        return flag;
    }

    private int getContainerPartitionID(Connection connection, String containerName) throws SQLException {
        int partitionId = -1;
        String sql = "SELECT partitionDesc::lvarchar FROM TSContainerTable WHERE name = ?";
        try (PreparedStatement pstmt = connection.prepareStatement("SELECT partitionDesc::lvarchar FROM TSContainerTable WHERE name = ?");){
            pstmt.setString(1, containerName);
            try (ResultSet resultSet = pstmt.executeQuery();){
                if (resultSet.next()) {
                    String partDescriptor = resultSet.getString(1);
                    StringTokenizer parser = new StringTokenizer(partDescriptor);
                    String t = null;
                    int num = parser.countTokens();
                    for (int i = 0; i < num; ++i) {
                        t = parser.nextToken();
                    }
                    partitionId = Integer.parseInt(t);
                }
            }
        }
        catch (SQLException e) {
            throw new SQLException("Cannot extract the partition ID!", e);
        }
        return partitionId;
    }

    private void writeAlign(IfmxUDTSQLOutput stream, int alignment) throws SQLException {
        int nbToSkip = 0;
        this.tsTraceMessage("IfmxTimeSeries: Entered writeAlign");
        try {
            nbToSkip = (stream.getCurrentPosition() + 4 + (alignment - 1) & ~(alignment - 1)) - (stream.getCurrentPosition() + 4);
            this.tsTraceMessage("IfmxTimeSeries: Aligning write stream by " + nbToSkip);
            for (int i = 0; i < nbToSkip; ++i) {
                stream.writeByte((byte)0);
            }
        }
        catch (SQLException e) {
            throw new SQLException("Internal timeseries error - cannot align stream!");
        }
        this.tsTraceMessage("IfmxTimeSeries: Exiting writeAlign");
    }

    private void tsTraceMessage(String message) {
        logger.trace(message);
    }

    @Override
    public void updateRef(int fieldIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateBlob(int fieldIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateClob(int fieldIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateClob(int fieldIndex, Reader reader, long len) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long len) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateNClob(int fieldIndex, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateNClob(int fieldIndex, Reader reader, long len) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long len) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public URL getURL(int fieldIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public RowId getRowId(int fieldIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateRowId(int fieldIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public Reader getNCharacterStream(int fieldIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public NClob getNClob(int fieldIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public String getNString(int fieldIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public SQLXML getSQLXML(int fieldIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateSQLXML(int fieldIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateNCharacterStream(int fieldIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateArray(int fieldIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateAsciiStream(int fieldIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateAsciiStream(int fieldIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateAsciiStream(int fieldIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateBigDecimal(int fieldIndex, BigDecimal value) throws SQLException {
        this.checkBeforeUpdate(fieldIndex);
        try {
            TimeSeriesField<?> field = this.timeseriesRowType.getField(fieldIndex);
            Object object = field.getFieldDefinition().convertValueTo(value);
            this.tsElementData.set(fieldIndex, object);
            this.updateLocalElement();
        }
        catch (Exception e) {
            throw new SQLException(MessageFormat.format("Unable to update field {0}", fieldIndex), e);
        }
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal value) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), value);
    }

    @Override
    public void updateBinaryStream(int fieldIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateBinaryStream(int fieldIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateBinaryStream(int fieldIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateBlob(int fieldIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateCharacterStream(int fieldIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateNCharacterStream(int fieldIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateNString(int fieldIndex, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateCharacterStream(int fieldIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateBlob(int fieldIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateClob(int fieldIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateNClob(int fieldIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public void insertRow() throws SQLException {
        this.insertUsingPreparedStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertUsingPreparedStatement() throws SQLException {
        String sql = MessageFormat.format("UPDATE {0} SET {1}=PutElem({1}, ?) WHERE {2}", this.tableName, this.timeseriesColumnName, this.whereClause);
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(sql);){
            preparedStatement.setObject(1, this.createRowStruct());
            if (this.whereClauseHostVariables != null) {
                for (int i = 0; i < this.whereClauseHostVariables.length; ++i) {
                    preparedStatement.setObject(i + 2, this.whereClauseHostVariables[i]);
                }
            }
            preparedStatement.execute();
        }
        finally {
            this.insertPhase = InsertPhase.IDLE;
        }
    }

    Struct createRowStruct() throws SQLException {
        Object[] values = new Object[this.metaData.getColumnCount()];
        values[0] = this.getTimestamp(1);
        for (int i = 1; i < this.metaData.getColumnCount(); ++i) {
            values[i] = this.tsElementData.get(i + 1);
        }
        IfxTSGenericRow genericRow = this.timeseriesRowType != null ? new IfxTSGenericRow(this.timeseriesRowType, values) : new IfxTSGenericRow(this.sqlRowType, values);
        return genericRow;
    }

    @Override
    public void updateRow() throws SQLException {
        if (this.wasNull()) {
            throw new SQLException("Cannot update a null element!");
        }
        if (this.isDeleted()) {
            throw new SQLException("Cannot update a deleted element");
        }
        this.insertUsingPreparedStatement();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.deleteUsingPreparedStatement();
    }

    private void deleteUsingPreparedStatement() throws SQLException {
        String sql = MessageFormat.format("UPDATE {0} SET {1}=DelElem({1}, ?) WHERE {2}", this.tableName, this.timeseriesColumnName, this.whereClause);
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(sql);){
            preparedStatement.setObject(1, this.getTimestamp(1));
            if (this.whereClauseHostVariables != null) {
                for (int i = 0; i < this.whereClauseHostVariables.length; ++i) {
                    preparedStatement.setObject(i + 2, this.whereClauseHostVariables[i]);
                }
            }
            preparedStatement.execute();
        }
    }

    public IfxBSONObject toBson() throws SQLException {
        return this.toBson(true, 100);
    }

    public IfxBSONObject toBson(boolean includeMetaData) throws SQLException {
        return this.toBson(includeMetaData, 100);
    }

    public IfxBSONObject toBson(int limit) throws SQLException {
        return this.toBson(true, limit);
    }

    public IfxBSONObject toBson(boolean includeMetData, int limit) throws SQLException {
        IfxBSONObject result = new IfxBSONObject();
        ResultSetMetaData metadata = this.getMetaData();
        if (includeMetData) {
            if (this.isRegular()) {
                result.append("type", "regular");
                result.append("origin", new java.util.Date(this.getOrigin().getTime()));
                result.append("pattern", this.getCalendar().getPattern().toBson());
            } else {
                result.append("type", "irregular");
            }
        }
        boolean dataTruncated = false;
        int count = 0;
        ArrayList<IfxBSONObject> rows = new ArrayList<IfxBSONObject>();
        while (this.next()) {
            if (limit >= 0 && count >= limit) {
                dataTruncated = true;
                this.relative(-1);
                break;
            }
            IfxBSONObject row = new IfxBSONObject();
            for (int columnIndex = 1; columnIndex <= metadata.getColumnCount(); ++columnIndex) {
                row.put(metadata.getColumnLabel(columnIndex), this.getObject(columnIndex));
            }
            rows.add(row);
            ++count;
        }
        result.append("elements", rows);
        result.append("elementsTruncated", dataTruncated);
        return result;
    }

    private static class TSTypeID {
        private short ti_spare = 0;
        private short ti_type = (short)4118;
        private int xid;

        TSTypeID() {
        }

        protected void readFromStream(IfmxUDTSQLInput stream) throws SQLException {
            this.ti_type = stream.readShort();
            this.ti_spare = stream.readShort();
            this.xid = stream.readInt();
            if (this.ti_spare != 0) {
                this.ti_type = this.ti_spare;
                this.ti_spare = 0;
            }
        }

        protected void writeToStream(IfmxUDTSQLOutput stream) throws SQLException {
            short tmp = this.ti_type;
            stream.writeInt(tmp);
            stream.writeInt(this.xid);
        }

        protected void setTiSpare(short x) {
            this.ti_spare = x;
        }

        protected void setTiType(short x) {
            this.ti_type = x;
        }

        protected void setXid(int x) {
            this.xid = x;
        }

        public String toString() {
            return "TSTypeID :\n\t type = " + this.ti_type + "\n\t spare = " + this.ti_spare + "\n\t xid = " + this.xid + "\n";
        }
    }

    private static class TSElementFooter {
        byte footer = 0;

        TSElementFooter() {
        }

        protected void readStream(IfmxUDTSQLInput stream) throws SQLException {
            this.footer = stream.readByte();
            this.footer = (byte)(this.footer | 4);
        }

        protected void writeStream(IfmxUDTSQLOutput stream) throws SQLException {
            stream.writeByte(this.footer);
        }

        private void checkFooter() throws SQLException {
            if (this.footer == -1) {
                throw new SQLException("Internal error, element footer is not assigned!");
            }
        }

        protected boolean isHidden() throws SQLException {
            this.checkFooter();
            return (this.footer & 8) != 0;
        }

        protected boolean isNull() throws SQLException {
            this.checkFooter();
            return (this.footer & 4) == 0;
        }

        protected boolean isDeleted() throws SQLException {
            this.checkFooter();
            return (this.footer & 0x10) == 1;
        }

        protected void setNull() throws SQLException {
            this.checkFooter();
            this.footer = (byte)(this.footer & 0xFFFFFFFB);
        }
    }

    private static class TSElementHeader {
        byte[] header = null;

        TSElementHeader(int numCols) {
            int a = numCols / 8;
            int b = numCols % 8;
            int c = a == 0 ? 1 : (a > 0 && b == 0 ? a : a + 1);
            this.header = new byte[c];
        }

        protected void readStream(IfmxUDTSQLInput stream) throws SQLException {
            byte[] tmp = stream.readBytes(this.header.length);
            System.arraycopy(tmp, 0, this.header, 0, this.header.length);
        }

        protected void writeStream(IfmxUDTSQLOutput stream) throws SQLException {
            for (int i = 0; i < this.header.length; ++i) {
                stream.writeByte(this.header[i]);
            }
        }

        protected boolean isColumnNull(int fieldIndex) throws SQLException {
            int realIndex = fieldIndex - 1;
            int headerIndex = realIndex == 0 ? 0 : realIndex / 8;
            if (headerIndex > this.header.length) {
                throw new SQLException("Creating header byte!");
            }
            int power = realIndex - 8 * headerIndex;
            int nullColumn = (Integer)powersOfTwoCache.getValue(power);
            return (this.header[headerIndex] & nullColumn) != 0;
        }

        protected void setNull(int fieldIndex) throws SQLException {
            int realIndex = fieldIndex - 1;
            int c = realIndex == 0 ? 0 : realIndex / 8;
            if (c > this.header.length) {
                throw new SQLException("setting column null");
            }
            int nullColumn = (Integer)powersOfTwoCache.getValue(realIndex);
            this.header[c] = (byte)(this.header[c] | nullColumn);
        }
    }

    public static final class Builder {
        private Connection connection = null;
        private String tableName = null;
        private String calendarName = null;
        private String containerName = null;
        private String timeseriesColumnName = null;
        private boolean regular = false;
        private Map<String, Object> whereClauseMap = new LinkedHashMap<String, Object>();
        private Timestamp origin = null;
        private int threshold = 0;

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder calendarName(String calendarName) {
            this.calendarName = calendarName;
            return this;
        }

        public Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public Builder regular(boolean regular) {
            this.regular = regular;
            return this;
        }

        public Builder timeseriesColumnName(String timeseriesColumnName) {
            this.timeseriesColumnName = timeseriesColumnName;
            return this;
        }

        public Builder origin(Timestamp origin) {
            this.origin = origin;
            return this;
        }

        public Builder addToWhereClause(String key, Object value) {
            this.whereClauseMap.put(key, value);
            return this;
        }

        public Builder addToWhereClause(String[] keys, Object[] values) {
            if (keys == null) {
                throw new IllegalArgumentException("the keys must not be null");
            }
            if (values == null) {
                throw new IllegalArgumentException("the values must not be null");
            }
            if (keys.length != values.length) {
                throw new IllegalArgumentException(MessageFormat.format("the keys and values must have the same length (keys={0}, values={1})", keys.length, values.length));
            }
            for (int i = 0; i < keys.length; ++i) {
                this.whereClauseMap.put(keys[i], values[i]);
            }
            return this;
        }

        public Builder clearWhereClause() {
            this.whereClauseMap.clear();
            return this;
        }

        public Builder removeFromWhereClause(String key) {
            this.whereClauseMap.remove(key);
            return this;
        }

        public Builder connection(Connection connection) {
            this.connection = connection;
            return this;
        }

        public IfmxTimeSeries selectTimeSeries() throws SQLException {
            block34: {
                String sql = this.createSelectPreparedStatementSql();
                try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
                    if (this.whereClauseMap.size() > 0) {
                        int i = 1;
                        for (Map.Entry<String, Object> entry : this.whereClauseMap.entrySet()) {
                            pstmt.setObject(i++, entry.getValue());
                        }
                    }
                    ResultSet resultSet = pstmt.executeQuery();
                    Object object = null;
                    try {
                        if (resultSet.next()) {
                            Object o = resultSet.getObject(1);
                            if (o instanceof IfmxTimeSeries) {
                                IfmxTimeSeries ts = (IfmxTimeSeries)o;
                                ts.bindForUpdatableResultSet(this.connection, this.tableName, this.timeseriesColumnName, this.whereClauseMap);
                                IfmxTimeSeries ifmxTimeSeries = ts;
                                return ifmxTimeSeries;
                            }
                            break block34;
                        }
                        throw new IllegalArgumentException(MessageFormat.format("the query ''{0}'' did not return any rows", sql));
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (resultSet != null) {
                            if (object != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                resultSet.close();
                            }
                        }
                    }
                }
            }
            return null;
        }

        private String createSelectPreparedStatementSql() {
            if (this.timeseriesColumnName == null) {
                throw new IllegalArgumentException("the timeseries column name must not be null");
            }
            if (this.timeseriesColumnName.length() == 0) {
                throw new IllegalArgumentException("the timeseries column name must not be empty");
            }
            if (this.tableName == null) {
                throw new IllegalArgumentException("the table name must not be null");
            }
            if (this.tableName.length() == 0) {
                throw new IllegalArgumentException("the table name must not be empty");
            }
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT ");
            sb.append(this.timeseriesColumnName);
            sb.append(" FROM ");
            sb.append(this.tableName);
            if (this.whereClauseMap.size() > 0) {
                sb.append(" WHERE ");
                boolean afterFirst = false;
                for (String key : this.whereClauseMap.keySet()) {
                    if (afterFirst) {
                        sb.append(" AND ");
                    }
                    sb.append(key);
                    sb.append("=?");
                    afterFirst = true;
                }
            }
            return sb.toString();
        }

        public IfmxTimeSeries createTimeSeries() throws SQLException {
            if (this.connection == null) {
                throw new IllegalArgumentException("the connection must not be null");
            }
            if (this.timeseriesColumnName == null) {
                throw new IllegalArgumentException("the timeseries column name must not be null");
            }
            if (this.timeseriesColumnName.length() == 0) {
                throw new IllegalArgumentException("the timeseries column name must not be empty");
            }
            if (this.tableName == null) {
                throw new IllegalArgumentException("the table name must not be null");
            }
            if (this.tableName.length() == 0) {
                throw new IllegalArgumentException("the table name must not be empty");
            }
            if (this.calendarName == null) {
                throw new IllegalArgumentException("the calendar name must not be null");
            }
            if (this.calendarName.length() == 0) {
                throw new IllegalArgumentException("the calendar name must not be empty");
            }
            if (this.origin == null) {
                throw new IllegalArgumentException("the origin must not be null");
            }
            String sql = this.createInsertPreparedStatement();
            try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
                int i = 1;
                for (Map.Entry<String, Object> entry : this.whereClauseMap.entrySet()) {
                    pstmt.setObject(i++, entry.getValue());
                }
                pstmt.executeUpdate();
            }
            return this.selectTimeSeries();
        }

        private String createInsertPreparedStatement() {
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT INTO ");
            sb.append(this.tableName);
            sb.append('(');
            boolean afterFirst = false;
            for (String key : this.whereClauseMap.keySet()) {
                if (afterFirst) {
                    sb.append(',');
                }
                sb.append(key);
                afterFirst = true;
            }
            if (this.whereClauseMap.size() > 0) {
                sb.append(',');
            }
            sb.append(this.timeseriesColumnName);
            sb.append(") values (");
            for (int i = 0; i < this.whereClauseMap.size(); ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append('?');
            }
            if (this.whereClauseMap.size() > 0) {
                sb.append(", ");
            }
            sb.append("'origin(");
            sb.append(this.origin.toString());
            sb.append("), calendar(");
            sb.append(this.calendarName);
            sb.append("), container(");
            if (this.containerName != null) {
                sb.append(this.containerName);
            }
            sb.append("), threshold(");
            sb.append(this.threshold);
            sb.append("), ");
            if (this.regular) {
                sb.append("regular");
            } else {
                sb.append("irregular");
            }
            sb.append(", []");
            sb.append("')");
            return sb.toString();
        }
    }

    private static enum InsertPhase {
        IDLE,
        ADD_ELEMENT_DATA_TO_TS,
        IN_PROGRESS;

    }
}

