/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.udt.timeseries.field;

import com.informix.jdbc.udt.timeseries.field.AbstractTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.TimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.TimeSeriesFieldFactory;
import com.informix.jdbc.udt.timeseries.field.definition.DecimalTimeSeriesFieldDefinition;
import com.informix.jdbc.udt.timeseries.field.definition.TimeSeriesFieldDefinition;
import java.math.BigDecimal;

public class DecimalTimeSeriesField
extends AbstractTimeSeriesField<BigDecimal>
implements TimeSeriesField<BigDecimal> {
    public DecimalTimeSeriesField(String fieldName) {
        super(fieldName, new DecimalTimeSeriesFieldDefinition());
    }

    public DecimalTimeSeriesField(String fieldName, int precision) {
        super(fieldName, new DecimalTimeSeriesFieldDefinition(precision));
    }

    public DecimalTimeSeriesField(String fieldName, int precision, int scale) {
        super(fieldName, new DecimalTimeSeriesFieldDefinition(precision, scale));
    }

    protected DecimalTimeSeriesField(String fieldName, TimeSeriesFieldDefinition<BigDecimal> fieldDefinition) {
        super(fieldName, fieldDefinition);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DecimalTimeSeriesField [fieldName=");
        builder.append(this.fieldName);
        builder.append(", definition=");
        builder.append(this.definition);
        builder.append(']');
        return builder.toString();
    }

    public static class Factory
    implements TimeSeriesFieldFactory<BigDecimal> {
        @Override
        public TimeSeriesField<BigDecimal> parse(String s) {
            String trimmed = s.trim();
            int index = trimmed.indexOf(32);
            String fieldName = trimmed.substring(0, index);
            String fieldDefArg = trimmed.substring(index + 1);
            return new DecimalTimeSeriesField(fieldName, DecimalTimeSeriesFieldDefinition.parseFieldDefinition(fieldDefArg));
        }
    }
}

