/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.udt.timeseries.field.definition;

import com.informix.jdbc.IfmxUDTSQLInput;
import com.informix.jdbc.IfmxUDTSQLOutput;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.udt.timeseries.field.definition.AbstractInformixFieldDefinition;
import com.informix.jdbc.udt.timeseries.field.definition.ObjectConversionUtilities;
import com.informix.jdbc.udt.timeseries.field.definition.TimeSeriesFieldDefinition;
import com.informix.jdbc.udt.timeseries.field.definition.TimeSeriesFieldDefinitionFactory;
import com.informix.jdbc.udt.timeseries.field.definition.TimeSeriesFieldType;
import java.sql.SQLException;
import java.text.MessageFormat;

public class SmallFloatTimeSeriesFieldDefinition
extends AbstractInformixFieldDefinition<Float>
implements TimeSeriesFieldDefinition<Float> {
    public SmallFloatTimeSeriesFieldDefinition() {
        super(TimeSeriesFieldType.FLOAT);
    }

    @Override
    public Float read(IfmxUDTSQLInput stream, IfxResultSetMetaData metaData, Integer index) throws SQLException {
        return Float.valueOf(stream.readFloat());
    }

    public static SmallFloatTimeSeriesFieldDefinition parseFieldDefinition(String s) {
        String trimmed = s.trim();
        if (trimmed.equalsIgnoreCase(TimeSeriesFieldType.FLOAT.getInformixTypeName())) {
            return new SmallFloatTimeSeriesFieldDefinition();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void write(IfmxUDTSQLOutput stream, Float value) throws SQLException {
        stream.writeFloat(value.floatValue());
    }

    @Override
    public String convertValueToString(Object value) {
        if (value == null) {
            return "null::smallfloat";
        }
        if (value instanceof Float) {
            return ((Float)value).toString() + "::" + this.toSqlString();
        }
        throw new IllegalArgumentException(MessageFormat.format("the value must be of type {0} (was {1})", Float.class, value.getClass()));
    }

    @Override
    public Float convertValueTo(Object value) throws IllegalArgumentException {
        return ObjectConversionUtilities.convertObjectToFloat(value);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SmallFloatTimeSeriesFieldDefinition []");
        return builder.toString();
    }

    public static class Factory
    implements TimeSeriesFieldDefinitionFactory<Float> {
        @Override
        public TimeSeriesFieldDefinition<Float> parse(String s) {
            return SmallFloatTimeSeriesFieldDefinition.parseFieldDefinition(s);
        }
    }
}

