/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbcx;

import com.informix.jdbc.IfxJSON;
import com.informix.jdbc.udt.Binary18;
import com.informix.jdbc.udt.BinaryVar;
import com.informix.jdbc.udt.StringUDT;
import com.informix.jdbc.udt.timeseries.IfmxCalendar;
import com.informix.jdbc.udt.timeseries.IfmxCalendarPattern;
import com.informix.jdbc.udt.timeseries.IfmxTimeSeries;
import com.informix.jdbcx.TypeMapBuilder;
import com.informix.util.CaseMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class TypeMapFactory {
    private static final Map<String, Class<?>> DEFAULT_MAP = new LinkedHashMap();
    private static TypeMapBuilder BUILDER = isDelimIdent -> {
        HashMap<String, Class<Object>> userMap = null;
        userMap = isDelimIdent ? new HashMap() : new CaseMap(isDelimIdent);
        userMap.putAll(DEFAULT_MAP);
        return userMap;
    };

    public static void setCustomTypeMap(Map<String, Class<?>> map) {
        DEFAULT_MAP.clear();
        DEFAULT_MAP.putAll(map);
    }

    public static void setCustomType(String name, Class<?> type) {
        DEFAULT_MAP.put(name, type);
    }

    public static Map<String, Class<?>> createMap(boolean isDelimIdent) {
        return BUILDER.getTypeMap(isDelimIdent);
    }

    public static void setCustomTypeBuilder(TypeMapBuilder builder) {
        BUILDER = builder;
    }

    private TypeMapFactory() {
    }

    static {
        try {
            DEFAULT_MAP.put("bson", Class.forName("com.informix.jdbc.IfxBSONObject"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DEFAULT_MAP.put("json", IfxJSON.class);
        DEFAULT_MAP.put("binary18", Binary18.class);
        DEFAULT_MAP.put("binaryvar", BinaryVar.class);
        DEFAULT_MAP.put("timeseries", IfmxTimeSeries.class);
        DEFAULT_MAP.put("calendarpattern", IfmxCalendarPattern.class);
        DEFAULT_MAP.put("calendar", IfmxCalendar.class);
        DEFAULT_MAP.put("longlvarchar", StringUDT.class);
        DEFAULT_MAP.put("biglvarchar", StringUDT.class);
        DEFAULT_MAP.put("smartvarchar", StringUDT.class);
    }
}

