/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jns;

import com.informix.jns.ServerGroup;
import com.informix.jns.ServerInfo;
import com.informix.lang.Messages;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class FileSqlhosts {
    final String bGroupOpt = "g";
    final String eGroupOpt = "e";
    final char cmtChar = (char)35;
    final List<ServerInfo> srvrVect = new ArrayList<ServerInfo>();
    final Map<String, ServerInfo> srvrList = new HashMap<String, ServerInfo>();
    final Map<String, Vector<ServerInfo>> grpList = new HashMap<String, Vector<ServerInfo>>();

    public FileSqlhosts(String fileName) throws SQLException {
        InputStreamReader frdr = null;
        try {
            URL url = new URL(fileName);
            frdr = new InputStreamReader(url.openStream());
        }
        catch (MalformedURLException e) {
            try {
                frdr = new FileReader(fileName);
            }
            catch (Exception ex) {
                throw Messages.getAsfException(-25553);
            }
        }
        catch (Exception e2) {
            throw Messages.getAsfException(-25553);
        }
        try (BufferedReader bfr = new BufferedReader(frdr);){
            String sline;
            while ((sline = bfr.readLine()) != null) {
                if (this.isBlank(sline) || this.isComment(sline)) continue;
                ServerInfo srvr = this.parseToSrvrInfo(sline);
                this.srvrVect.add(srvr);
                this.srvrList.put(srvr.getSname(), srvr);
            }
        }
        catch (Exception e) {
            Messages.getAsfException(-25556);
        }
        this.collectGroups();
    }

    private void collectGroups() {
        int scount = this.srvrVect.size();
        for (int i = 0; i < scount; ++i) {
            ServerInfo srvrC = this.srvrVect.get(i);
            if (!srvrC.isGroupEntry()) continue;
            Vector<ServerInfo> gvect = new Vector<ServerInfo>();
            String gName = srvrC.getSname();
            String eGname = srvrC.getOption("e");
            boolean eGflag = eGname != null;
            for (int j = i + 1; j < scount; ++j) {
                ServerInfo tsrvr = this.srvrVect.get(j);
                String tname = tsrvr.getSname();
                String goptName = tsrvr.getOption("g");
                if (gName.equalsIgnoreCase(goptName)) {
                    gvect.addElement(tsrvr);
                }
                if (eGflag && eGname.equalsIgnoreCase(tname) || !eGflag && !gName.equalsIgnoreCase(goptName)) break;
            }
            this.grpList.put(gName, gvect);
        }
    }

    public ServerInfo getServer(String sname) throws SQLException {
        ServerInfo sinfo = this.srvrList.get(sname);
        if (sinfo != null) {
            return sinfo;
        }
        throw Messages.getAsfException(-25555, sname);
    }

    public ServerGroup getServerGroup(String sname) {
        ArrayList<String> nvect = new ArrayList<String>();
        for (ServerInfo server : this.grpList.get(sname)) {
            nvect.add(server.getSname());
        }
        return new ServerGroup(nvect);
    }

    public ServerGroup listServers() {
        return new ServerGroup(new ArrayList<String>(this.srvrList.keySet()));
    }

    private boolean isBlank(String line) {
        String nline = line.trim();
        return nline.length() == 0;
    }

    private boolean isComment(String line) {
        String nline = line.trim();
        return nline.charAt(0) == '#';
    }

    private ServerInfo parseToSrvrInfo(String line) {
        String sname = "";
        String ntype = "";
        String hname = "";
        String pname = "";
        String opts = "";
        StringTokenizer stok = new StringTokenizer(line);
        sname = stok.nextToken();
        ntype = stok.nextToken();
        if (stok.hasMoreElements()) {
            hname = stok.nextToken();
        }
        if (stok.hasMoreElements()) {
            pname = stok.nextToken();
        }
        while (stok.hasMoreElements()) {
            opts = opts + stok.nextToken() + " ";
        }
        ServerInfo sinfo = new ServerInfo(sname, ntype, hname, pname, opts);
        return sinfo;
    }
}

