/*
 * Decompiled with CFR 0.152.
 */
package com.informix.lang;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class JdbcCharacterSets {
    public static final ThreadLocal<Map<Charset, CharsetDecoder>> LOCAL_DECODERS = ThreadLocal.withInitial(HashMap::new);
    public static final ThreadLocal<Map<Charset, CharsetEncoder>> LOCAL_ENCODERS = ThreadLocal.withInitial(HashMap::new);
    public static final String NO_ENCODING = "NOENCODING";
    static final String ENC_ISO2022CN = "ISO2022CN";
    public static final String ENC_ISO2022CN_GB = "ISO2022CN_GB";

    private JdbcCharacterSets() {
    }

    public static CharsetDecoder getCharsetDecoder(Charset dbEnc) {
        return LOCAL_DECODERS.get().computeIfAbsent(dbEnc, key -> {
            CharsetDecoder decoder = key.newDecoder();
            decoder.onMalformedInput(CodingErrorAction.REPORT);
            decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            return decoder;
        });
    }

    public static CharsetEncoder getCharsetEncoder(Charset dbEnc) {
        return LOCAL_ENCODERS.get().computeIfAbsent(dbEnc, key -> {
            CharsetEncoder encoder = key.newEncoder();
            encoder.onMalformedInput(CodingErrorAction.REPORT);
            encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            return encoder;
        });
    }

    public static Charset getCharset(String dbEnc) {
        if (dbEnc == null || dbEnc.equalsIgnoreCase(NO_ENCODING)) {
            return StandardCharsets.ISO_8859_1;
        }
        if (dbEnc.equalsIgnoreCase(ENC_ISO2022CN_GB)) {
            return Charset.forName(ENC_ISO2022CN);
        }
        return Charset.forName(dbEnc);
    }
}

