/*
 * Decompiled with CFR 0.152.
 */
package com.informix.util;

import com.informix.util.Trace;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class JdbcLogger {
    private static final String REGEX = "\\{\\}";
    private static final ThreadLocal<Pattern> LOGGER_PATTERN = ThreadLocal.withInitial(() -> Pattern.compile(REGEX));
    private final Logger logger;

    public static JdbcLogger getLogger(Class<?> c) {
        return new JdbcLogger(c.getCanonicalName());
    }

    private static String processString(String str, Object ... obs) {
        for (int i = 0; i < obs.length && str.contains("{}"); ++i) {
            str = LOGGER_PATTERN.get().matcher(str).replaceFirst(obs[i].toString());
        }
        return str;
    }

    public JdbcLogger(Class<?> c) {
        this(c.getCanonicalName());
    }

    public JdbcLogger(String name) {
        this.logger = Logger.getLogger(name);
    }

    public void debug(String msg) {
        this.logger.finer(msg);
    }

    public void debug(String msg, Object o1) {
        this.logger.log(Level.FINER, () -> JdbcLogger.processString(msg, o1));
    }

    public void debug(String msg, Object o1, Object o2) {
        this.logger.log(Level.FINER, () -> JdbcLogger.processString(msg, o1, o2));
    }

    public void debug(String msg, Object o1, Object o2, Object o3) {
        this.logger.log(Level.FINER, () -> JdbcLogger.processString(msg, o1, o2, o3));
    }

    public void debug(Trace.Marker m, String msg) {
        this.log(Level.FINER, m, msg);
    }

    public void debug(Trace.Marker m, String msg, Object o1) {
        this.log(Level.FINER, m, msg, o1);
    }

    public void debug(Trace.Marker m, String msg, Object o1, Object o2) {
        this.log(Level.FINER, m, msg, o1, o2);
    }

    public void debug(Trace.Marker m, String msg, Object o1, Object o2, Object o3) {
        this.log(Level.FINER, m, msg, o1, o2, o3);
    }

    public void debug(Trace.Marker m, String msg, Object o1, Object o2, Object o3, Object o4) {
        this.log(Level.FINER, m, msg, o1, o2, o3, o4);
    }

    public void error(String msg) {
        this.logger.severe(msg);
    }

    public void error(String msg, Throwable t) {
        this.logger.log(Level.WARNING, msg, t);
    }

    public void error(String msg, Object o1, Object o2) {
        this.logger.log(Level.SEVERE, () -> JdbcLogger.processString(msg, o1, o2));
    }

    public void error(String msg, Object o1, Throwable t) {
        this.logger.log(Level.WARNING, JdbcLogger.processString(msg, o1), t);
    }

    public void error(String msg, Object o1) {
        this.logger.log(Level.INFO, () -> JdbcLogger.processString(msg, o1));
    }

    public void error(Trace.Marker m, String msg) {
        this.log(Level.SEVERE, m, msg);
    }

    public void error(Trace.Marker m, String msg, Object o1) {
        this.log(Level.SEVERE, m, msg, o1);
    }

    public void error(Trace.Marker m, String msg, Object o1, Object o2) {
        this.log(Level.SEVERE, m, msg, o1, o2);
    }

    public void error(Trace.Marker m, String msg, Object o1, Object o2, Object o3) {
        this.log(Level.SEVERE, m, msg, o1, o2, o3);
    }

    public void info(String msg) {
        this.logger.info(msg);
    }

    public void info(String msg, Object o1) {
        this.log(Level.INFO, msg, o1);
    }

    public void info(String msg, Object o1, Object o2) {
        this.log(Level.INFO, msg, o1, o2);
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINER);
    }

    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    public void log(Level level, String msg) {
        this.logger.log(level, msg);
    }

    public void log(Level level, String msg, Object o1) {
        this.logger.log(level, () -> JdbcLogger.processString(msg, o1));
    }

    public void log(Level level, String msg, Object o1, Object o2) {
        this.logger.log(level, () -> JdbcLogger.processString(msg, o1, o2));
    }

    public void log(Level level, String msg, Object o1, Object o2, Object o3) {
        this.logger.log(level, () -> JdbcLogger.processString(msg, o1, o2, o3));
    }

    public void log(Level level, String msg, Object o1, Object o2, Object o3, Object o4) {
        this.logger.log(level, () -> JdbcLogger.processString(msg, o1, o2, o3, o4));
    }

    public void log(Level level, String msg, Object o1, Object o2, Object o3, Object o4, Object o5) {
        this.logger.log(level, () -> JdbcLogger.processString(msg, o1, o2, o3, o4, o5));
    }

    public void log(Level level, Trace.Marker m, String msg) {
        if (this.logger.isLoggable(level)) {
            this.log(level, m + " " + msg);
        }
    }

    public void log(Level level, Trace.Marker m, String msg, Object o1) {
        if (this.logger.isLoggable(level)) {
            this.log(level, m + " " + msg, o1);
        }
    }

    public void log(Level level, Trace.Marker m, String msg, Object o1, Object o2) {
        if (this.logger.isLoggable(level)) {
            this.log(level, m + " " + msg, o1, o2);
        }
    }

    public void log(Level level, Trace.Marker m, String msg, Object o1, Object o2, Object o3) {
        if (this.logger.isLoggable(level)) {
            this.log(level, m + " " + msg, o1, o2, o3);
        }
    }

    public void log(Level level, Trace.Marker m, String msg, Object o1, Object o2, Object o3, Object o4) {
        if (this.logger.isLoggable(level)) {
            this.log(level, m + " " + msg, o1, o2, o3, o4);
        }
    }

    public void log(Level level, Trace.Marker m, String msg, Object o1, Object o2, Object o3, Object o4, Object o5) {
        if (this.logger.isLoggable(level)) {
            this.log(level, m + " " + msg, o1, o2, o3, o4, o5);
        }
    }

    public void trace(String msg) {
        this.logger.finest(msg);
    }

    public void trace(String msg, Object o1) {
        this.logger.log(Level.FINEST, () -> JdbcLogger.processString(msg, o1));
    }

    public void trace(String msg, Object o1, Object o2) {
        this.logger.log(Level.FINEST, () -> JdbcLogger.processString(msg, o1, o2));
    }

    public void trace(Trace.Marker m, String msg) {
        this.log(Level.FINEST, m, msg);
    }

    public void trace(Trace.Marker m, String msg, Object o1) {
        this.log(Level.FINEST, m, msg, o1);
    }

    public void trace(Trace.Marker m, String msg, Object o1, Object o2) {
        this.log(Level.FINEST, m, msg, o1, o2);
    }

    public void trace(Trace.Marker m, String msg, Object o1, Object o2, Object o3) {
        this.log(Level.FINEST, m, msg, o1, o2, o3);
    }

    public void trace(Trace.Marker m, String msg, Object o1, Object o2, Object o3, Object o4) {
        this.log(Level.FINEST, m, msg, o1, o2, o3, o4);
    }

    public void trace(Trace.Marker m, String msg, Object o1, Object o2, Object o3, Object o4, Object o5) {
        this.log(Level.FINEST, m, msg, o1, o2, o3, o4, o5);
    }

    public void warn(String msg) {
        this.logger.warning(msg);
    }

    public void warn(String msg, Object o1) {
        this.logger.log(Level.WARNING, () -> JdbcLogger.processString(msg, o1));
    }

    public void warn(String msg, Object o1, Throwable t) {
        this.logger.log(Level.WARNING, JdbcLogger.processString(msg, o1), t);
    }

    public void warn(Trace.Marker m, String msg) {
        this.log(Level.WARNING, m, msg);
    }

    public void warn(Trace.Marker m, String msg, Object o) {
        this.log(Level.WARNING, m, msg, o);
    }
}

