/*
 * Decompiled with CFR 0.152.
 */
package com.informix.util;

import com.informix.util.JdbcLogger;
import com.informix.util.TraceFlag;
import java.util.logging.Logger;

public class Trace {
    public static final Marker C_S_MARKER = new Marker("[ SQLI C->S ]");
    public static final Marker S_C_MARKER = new Marker("[ SQLI S->C ]");
    private int clientServer = 0;
    private int serverClient = 0;

    public static final Object getLoggerForClass(Class<?> clazz) {
        return JdbcLogger.getLogger(clazz);
    }

    public void writeTrace(Object logger, int levelNum, String stringInfo) {
        this.printLog(logger, stringInfo, levelNum);
    }

    public void writeTrace(Object logger, int levelNum, String stringInfo, String data) {
        this.writeTrace(logger, levelNum, stringInfo + data);
    }

    public void writeTrace(Object logger, int levelNum, String stringInfo, int data) {
        this.writeTrace(logger, levelNum, stringInfo + data);
    }

    public void writeTrace(Object logger, int levelNum, String stringInfo, short data) {
        this.writeTrace(logger, levelNum, stringInfo + data);
    }

    public void writeTrace(Object logger, int levelNum, String stringInfo, long data) {
        this.writeTrace(logger, levelNum, stringInfo + data);
    }

    public void writeTrace(Object logger, int levelNum, String stringInfo, boolean data) {
        this.writeTrace(logger, levelNum, stringInfo + data);
    }

    public static String toHexString(byte[] byteData) {
        StringBuilder sb = new StringBuilder();
        for (byte b : byteData) {
            sb.append(String.format("%02X ", b).toLowerCase());
        }
        return sb.toString();
    }

    protected void printLog(Object loggerFromClass, String msg, int levelNum) {
        if (loggerFromClass instanceof Logger) {
            ((Logger)loggerFromClass).log(TraceFlag.mapLevel(levelNum), msg);
        } else if (loggerFromClass instanceof JdbcLogger) {
            ((JdbcLogger)loggerFromClass).log(TraceFlag.mapLevel(levelNum), msg);
        } else {
            Logger.getLogger("com.informix.jdbc").log(TraceFlag.mapLevel(levelNum), msg);
        }
    }

    public int getClientServerMessageCount() {
        return this.clientServer;
    }

    public int getServerClientMessageCount() {
        return this.serverClient;
    }

    public static class Marker {
        private final String markerName;

        public Marker(String markerName) {
            this.markerName = markerName;
        }

        public String toString() {
            return this.markerName;
        }
    }
}

