/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import com.informix.asf.ASFException;
import com.informix.jns.FileSqlhosts;
import com.informix.jns.ServerGroup;
import com.informix.jns.ServerInfo;
import com.informix.lang.Messages;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;

public class JnsObject {
    private String ipAddr = null;
    private String portNo = null;
    private int PortNumber = 0;
    private int groupCount = 0;
    private String gServerName = null;
    ServerGroup myGroup = null;
    private boolean isOptionC_One = false;

    public boolean getIfOptionC_One() {
        return this.isOptionC_One;
    }

    public void JnsLookup(String servername, Properties optProps) throws SQLException {
        String Option = null;
        FileSqlhosts mySqlhosts = new FileSqlhosts(optProps.getProperty("sqlHostPath"));
        ServerInfo myServerInfo = mySqlhosts.getServer(servername);
        if (myServerInfo.isGroupEntry()) {
            this.myGroup = mySqlhosts.getServerGroup(servername);
            Option = myServerInfo.getOption("c");
            this.groupCount = this.myGroup.size();
            if (Option != null && Option.equals("1") && this.groupCount > 1) {
                this.isOptionC_One = true;
                Random generator = new Random();
                int randomNo = generator.nextInt(this.groupCount);
                this.gServerName = this.myGroup.elementAt(randomNo);
            } else {
                this.gServerName = this.myGroup.nextElement();
            }
            myServerInfo = mySqlhosts.getServer(this.gServerName);
        }
        this.ipAddr = myServerInfo.getHostname().replaceFirst("^\\*", "");
        this.portNo = myServerInfo.getService();
        try {
            this.PortNumber = Integer.parseInt(this.portNo);
        }
        catch (NumberFormatException nfe) {
            int poNo = -1;
            poNo = JnsObject.getServiceByName(this.portNo);
            if (poNo == -1) {
                String msg = Messages.getMessage(-931, this.portNo);
                throw new ASFException(-931, msg);
            }
            this.PortNumber = poNo;
        }
    }

    public ServerGroup getServerGroup() {
        return this.myGroup;
    }

    public int getGroupCount() {
        return this.groupCount;
    }

    public String getServerName() {
        return this.gServerName;
    }

    public String getIPAddr() {
        return this.ipAddr;
    }

    public String getPortNo() {
        return this.portNo;
    }

    public int getPortNumber() {
        return this.PortNumber;
    }

    public static int getServiceByName(String serviceName) {
        int port = -1;
        String servicesFilename = JnsObject.getServicesFileName();
        try {
            String servLine;
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(servicesFilename)));
            while ((servLine = br.readLine()) != null && port == -1) {
                if (servLine.length() == 0 || servLine.charAt(0) == '#') continue;
                port = JnsObject.parseServicesLine(servLine, serviceName);
            }
            br.close();
            return port;
        }
        catch (IOException ioe) {
            return -1;
        }
    }

    private static String getServicesFileName() {
        if (System.getProperty("os.name").startsWith("Windows")) {
            return System.getenv("SystemRoot") + "\\system32\\drivers\\etc\\services";
        }
        return "/etc/services";
    }

    private static int parseServicesLine(String line, String serviceName) {
        StringTokenizer st = new StringTokenizer(line, " \t/");
        if (!st.hasMoreTokens()) {
            return -1;
        }
        String name = st.nextToken().trim();
        if (!st.hasMoreTokens()) {
            return -1;
        }
        String portNum = st.nextToken().trim();
        if (!st.hasMoreTokens()) {
            return -1;
        }
        String portType = st.nextToken().trim();
        if (name.equals(serviceName) && portType.equalsIgnoreCase("tcp")) {
            try {
                return Integer.parseInt(portNum);
            }
            catch (NumberFormatException nfe) {
                return -1;
            }
        }
        return -1;
    }
}

