/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxUDTInput;
import com.informix.jdbc.IfxUDTOutput;
import com.informix.jdbc.types.bson.DBBson;
import com.informix.jdbc.udt.bson.IfxValueCodecProvider;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.BSONObject;
import org.bson.BsonBinaryReader;
import org.bson.BsonDocument;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.ByteBuf;
import org.bson.Document;
import org.bson.EnhancedBsonBinaryReader;
import org.bson.EnhancedBsonBinaryWriter;
import org.bson.RawBsonDocument;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.DocumentCodecProvider;
import org.bson.codecs.Encoder;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.RawBsonDocumentCodec;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;
import org.bson.json.IfxDocumentCodec;
import org.bson.json.IfxJsonReader;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;
import org.bson.json.RestJsonWriter;

public class IfxBSONObject
implements DBBson {
    public static final CodecRegistry REGISTRY = CodecRegistries.fromProviders(Arrays.asList(new ValueCodecProvider(), new IfxValueCodecProvider(), new BsonValueCodecProvider(), new DocumentCodecProvider()));
    private static final JsonWriterSettings JSON_WRITER_SETTINGS_RELAXED = JsonWriterSettings.builder().indent(false).outputMode(JsonMode.RELAXED).build();
    private static final JsonWriterSettings JSON_WRITER_SETTINGS_EXTENDED = JsonWriterSettings.builder().indent(false).outputMode(JsonMode.EXTENDED).build();
    private static final EncoderContext ENCODER_CONTEXT = EncoderContext.builder().isEncodingCollectibleDocument(true).build();
    private static final ThreadLocal<DocumentCodec> CODEC = ThreadLocal.withInitial(() -> new IfxDocumentCodec(REGISTRY));
    protected RawBsonDocument rawDocument = null;
    private Set<String> cachedKeys = null;
    private JsonWriterSettings writerSettings = JSON_WRITER_SETTINGS_RELAXED;
    protected Document bsonObject = null;

    public static IfxBSONObject parse(String json) {
        IfxJsonReader bsonReader = new IfxJsonReader(json);
        return new IfxBSONObject(CODEC.get().decode((BsonReader)bsonReader, DecoderContext.builder().build()));
    }

    public IfxBSONObject() {
        this.bsonObject = new Document();
    }

    public IfxBSONObject(String key, Object value) {
        this(new Document(key, value));
    }

    public IfxBSONObject(byte[] bytes) {
        this(bytes, false);
    }

    public IfxBSONObject(RawBsonDocument document) {
        this.rawDocument = document;
    }

    public IfxBSONObject(byte[] bytes, boolean copyBytes) {
        if (copyBytes) {
            byte[] newBytes = new byte[bytes.length];
            System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
            this.rawDocument = new RawBsonDocument(newBytes);
        } else {
            this.rawDocument = new RawBsonDocument(bytes);
        }
    }

    public IfxBSONObject(byte[] bytes, boolean copyBytes, JsonMode jsonFormat) {
        this(bytes, copyBytes);
        this.setJsonFormat(jsonFormat);
    }

    public IfxBSONObject(byte[] bytes, JsonMode jsonFormat) {
        this(bytes, false, jsonFormat);
    }

    public IfxBSONObject(Document bsonObject) {
        this.bsonObject = bsonObject;
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return "bson";
    }

    @Override
    public void readSQL(SQLInput stream, String typeName) throws SQLException {
        IfxUDTInput input = (IfxUDTInput)stream;
        this.setBytes(input.readBytes(input.length()));
    }

    @Override
    public void writeSQL(SQLOutput stream) throws SQLException {
        this.ensureRawDocument();
        IfxUDTOutput outStream = (IfxUDTOutput)stream;
        ByteBuf buffer = this.rawDocument.getByteBuffer();
        outStream.write(buffer.array(), buffer.limit());
    }

    @Override
    public void ensureRawDocument() {
        if (this.rawDocument == null) {
            if (this.bsonObject == null) {
                this.bsonObject = new Document();
            }
            this.cachedKeys = null;
            BasicOutputBuffer buffer = new BasicOutputBuffer();
            try (EnhancedBsonBinaryWriter writer = new EnhancedBsonBinaryWriter((BsonOutput)buffer);){
                CODEC.get().encode((BsonWriter)writer, this.bsonObject, EncoderContext.builder().build());
                this.rawDocument = new RawBsonDocument(buffer.getInternalBuffer(), 0, buffer.getPosition());
            }
        }
        this.bsonObject = null;
    }

    protected void ensureBsonObject() {
        this.ensureBsonObject(false);
    }

    protected void ensureBsonObject(boolean recursive) {
        if (this.bsonObject == null) {
            if (this.rawDocument != null) {
                if (recursive) {
                    BsonBinaryReader reader = new BsonBinaryReader(this.rawDocument.getByteBuffer().asNIO());
                    this.bsonObject = CODEC.get().decode((BsonReader)reader, DecoderContext.builder().build());
                } else {
                    EnhancedBsonBinaryReader reader = new EnhancedBsonBinaryReader(this.rawDocument.getByteBuffer().asNIO());
                    this.bsonObject = CODEC.get().decode((BsonReader)reader, DecoderContext.builder().build());
                }
            } else {
                this.bsonObject = new Document();
            }
        }
        this.rawDocument = null;
    }

    @Override
    public byte[] getBytes() {
        this.ensureRawDocument();
        byte[] toReturn = new byte[this.rawDocument.getByteBuffer().limit()];
        this.rawDocument.getByteBuffer().get(toReturn);
        return toReturn;
    }

    @Override
    public void setBytes(byte[] bytes) {
        this.rawDocument = new RawBsonDocument(bytes);
        this.bsonObject = null;
    }

    @Override
    public void setRawDocument(RawBsonDocument doc) {
        this.rawDocument = doc;
        this.bsonObject = null;
    }

    @Override
    public void setDocument(Document bsonObject) {
        if (bsonObject == null) {
            throw new NullPointerException("The bsonObject must not be null");
        }
        this.bsonObject = bsonObject;
        this.rawDocument = null;
    }

    @Override
    public void setBSONObject(BSONObject bsonObject) {
        if (bsonObject == null) {
            throw new NullPointerException("The bsonObject must not be null");
        }
        this.bsonObject = new Document(bsonObject.toMap());
        this.rawDocument = null;
    }

    public static IfxBSONObject ensureIfxBSONObject(Object o) {
        if (o == null) {
            throw new NullPointerException("The object must not be null");
        }
        if (o instanceof IfxBSONObject) {
            return (IfxBSONObject)o;
        }
        if (o instanceof Document) {
            return new IfxBSONObject((Document)o);
        }
        if (o instanceof RawBsonDocument) {
            return new IfxBSONObject((RawBsonDocument)o);
        }
        throw new IllegalArgumentException(MessageFormat.format("The specified object is not of type {0} and does not implement the interface {1}", IfxBSONObject.class.getSimpleName(), Document.class.getSimpleName()));
    }

    public String toString() {
        if (this.bsonObject != null) {
            return this.bsonObject.toJson(this.writerSettings, (Encoder)CODEC.get());
        }
        return this.rawDocument.toJson(this.writerSettings);
    }

    @Override
    public String toJson() {
        if (this.bsonObject != null) {
            RestJsonWriter writer = new RestJsonWriter(this.writerSettings);
            CODEC.get().encode((BsonWriter)writer, this.bsonObject, ENCODER_CONTEXT);
            return writer.getJson();
        }
        RestJsonWriter writer = new RestJsonWriter(this.writerSettings);
        new RawBsonDocumentCodec().encode((BsonWriter)writer, this.rawDocument, ENCODER_CONTEXT);
        return writer.getJson();
    }

    @Override
    public Object put(String key, Object v) {
        this.ensureBsonObject();
        return this.bsonObject.put(key, v);
    }

    @Override
    public Map<String, Object> toMap() {
        this.ensureBsonObject();
        for (Map.Entry entry : this.bsonObject.entrySet()) {
            if (entry.getValue() instanceof Document) {
                entry.setValue(new IfxBSONObject((Document)entry.getValue()));
            }
            if (!(entry.getValue() instanceof List)) continue;
            this.convertListToIfxBSONObject((List)entry.getValue());
        }
        return this.bsonObject;
    }

    @Override
    public boolean containsKey(String s) {
        if (this.rawDocument != null) {
            return this.keySet().contains(s);
        }
        return this.bsonObject.containsKey((Object)s);
    }

    @Override
    public boolean containsField(String s) {
        return this.containsKey(s);
    }

    @Override
    public Set<String> keySet() {
        if (this.bsonObject != null) {
            return this.bsonObject.keySet();
        }
        if (this.cachedKeys == null) {
            this.cachedKeys = new LinkedHashSet<String>();
            try (BsonReader bsonReader = this.rawDocument.asBsonReader();){
                bsonReader.readStartDocument();
                BsonType currentType = bsonReader.readBsonType();
                while (currentType != BsonType.END_OF_DOCUMENT) {
                    this.cachedKeys.add(bsonReader.readName());
                    bsonReader.skipValue();
                    currentType = bsonReader.readBsonType();
                }
            }
        }
        return this.cachedKeys;
    }

    @Override
    public int hashCode() {
        if (this.bsonObject != null) {
            return this.bsonObject.hashCode();
        }
        return this.rawDocument.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof IfxBSONObject) {
            if (this.rawDocument != null) {
                return this.rawDocument.equals((Object)((IfxBSONObject)o).getRawDocument());
            }
            return this.bsonObject.equals((Object)((IfxBSONObject)o).getDocument());
        }
        return false;
    }

    @Override
    public int size() {
        if (this.rawDocument != null) {
            return this.keySet().size();
        }
        return this.bsonObject.size();
    }

    @Override
    public boolean isEmpty() {
        if (this.rawDocument != null) {
            return this.rawDocument.isEmpty();
        }
        return this.bsonObject.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.rawDocument != null) {
            return this.keySet().contains(key);
        }
        return this.bsonObject.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.ensureBsonObject();
        return this.bsonObject.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.getObject(key);
    }

    public Object get(String key) {
        return this.getObject(key);
    }

    private Object getObject(Object key) {
        this.ensureBsonObject();
        Object o = this.bsonObject.get(key);
        if (o instanceof IfxBSONObject) {
            ((IfxBSONObject)o).setJsonFormat(this.getJsonFormat());
        } else {
            if (o instanceof Document) {
                IfxBSONObject bson = new IfxBSONObject((Document)o);
                bson.setJsonFormat(this.getJsonFormat());
                return bson;
            }
            if (o instanceof List) {
                this.convertListToIfxBSONObject((List)o);
            }
        }
        return o;
    }

    private void convertListToIfxBSONObject(List<Object> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof Document)) continue;
            list.set(i, new IfxBSONObject((Document)list.get(i)));
        }
    }

    @Override
    public Object remove(Object key) {
        this.ensureBsonObject();
        Object o = this.bsonObject.remove(key);
        if (o instanceof IfxBSONObject) {
            ((IfxBSONObject)o).setJsonFormat(this.getJsonFormat());
            return o;
        }
        if (o instanceof Document) {
            IfxBSONObject bson = new IfxBSONObject((Document)o);
            bson.setJsonFormat(this.getJsonFormat());
            return bson;
        }
        return o;
    }

    @Override
    public Collection<Object> values() {
        this.ensureBsonObject();
        return this.bsonObject.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        this.ensureBsonObject();
        return this.bsonObject.entrySet();
    }

    @Override
    public void putAll(Map m) {
        this.ensureBsonObject();
        this.bsonObject.putAll(m);
    }

    @Override
    public Document getDocument() {
        return this.getDocument(true);
    }

    @Override
    public Document getDocument(boolean recursive) {
        this.ensureBsonObject(recursive);
        return this.bsonObject;
    }

    @Override
    public IfxBSONObject getDocument(String key) {
        if (this.rawDocument != null) {
            BsonDocument o = this.rawDocument.getDocument((Object)key);
            if (o instanceof RawBsonDocument) {
                ByteBuf buf = ((RawBsonDocument)o).getByteBuffer();
                byte[] bytes = new byte[buf.remaining()];
                buf.get(bytes);
                return new IfxBSONObject(bytes, this.getJsonFormat());
            }
            throw new UnsupportedOperationException("Cannot return document of type: " + o.getClass().getCanonicalName());
        }
        Object o = this.bsonObject.get((Object)key);
        if (o == null) {
            return null;
        }
        if (o instanceof Document) {
            IfxBSONObject bson = new IfxBSONObject((Document)o);
            bson.setJsonFormat(this.getJsonFormat());
            return bson;
        }
        if (o instanceof IfxBSONObject) {
            ((IfxBSONObject)o).setJsonFormat(this.getJsonFormat());
            return (IfxBSONObject)o;
        }
        throw new UnsupportedOperationException("Cannot return document of type: " + o.getClass().getCanonicalName());
    }

    @Override
    public RawBsonDocument getRawDocument() {
        this.ensureRawDocument();
        return this.rawDocument;
    }

    @Override
    public IfxBSONObject append(String key, Object value) {
        this.put(key, value);
        return this;
    }

    @Override
    public int getInt(String key) {
        if (this.rawDocument != null) {
            return this.rawDocument.getInt32((Object)key).getValue();
        }
        return this.bsonObject.getInteger((Object)key);
    }

    @Override
    public long getLong(String key) {
        if (this.rawDocument != null) {
            return this.rawDocument.getInt64((Object)key).getValue();
        }
        return this.bsonObject.getLong((Object)key);
    }

    @Override
    public double getDouble(String key) {
        if (this.rawDocument != null) {
            return this.rawDocument.getDouble((Object)key).getValue();
        }
        return this.bsonObject.getDouble((Object)key);
    }

    @Override
    public String getString(String key) {
        if (this.rawDocument != null) {
            BsonValue value = this.rawDocument.get((Object)key);
            return value == null ? null : value.asString().getValue();
        }
        return this.bsonObject.getString((Object)key);
    }

    public boolean getBoolean(String key) {
        if (this.rawDocument != null) {
            return this.rawDocument.getBoolean((Object)key).getValue();
        }
        return this.bsonObject.getBoolean((Object)key);
    }

    @Override
    public boolean isRawDocument() {
        return this.rawDocument != null;
    }

    @Override
    public String getFirstKey() {
        if (this.rawDocument != null) {
            if (this.cachedKeys != null && !this.cachedKeys.isEmpty()) {
                return this.cachedKeys.iterator().next();
            }
            return this.rawDocument.getFirstKey();
        }
        return (String)this.bsonObject.keySet().iterator().next();
    }

    @Override
    public void putAll(BSONObject o) {
        this.putAll(o.toMap());
    }

    @Override
    public Object removeField(String key) {
        return this.remove(key);
    }

    @Override
    public void clear() {
        this.rawDocument = null;
        this.bsonObject = new Document();
    }

    @Override
    public IfxBSONObject setJsonFormat(JsonMode mode) {
        this.writerSettings = mode == JsonMode.EXTENDED ? JSON_WRITER_SETTINGS_EXTENDED : JSON_WRITER_SETTINGS_RELAXED;
        return this;
    }

    @Override
    public JsonMode getJsonFormat() {
        return this.writerSettings.getOutputMode();
    }
}

