/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxUDTInput;
import com.informix.jdbc.IfxUDTOutput;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.lang.Messages;
import java.io.ByteArrayOutputStream;
import java.sql.SQLException;

abstract class IfxBaseType
extends IfxObject {
    protected static final int UDT_FLAG_SIZE = 1;
    protected static final int UDT_LENGTH_SIZE = 4;
    protected IfxUDTInput inputStream = null;
    protected final IfxUDTOutput outputStream = new IfxUDTOutput();

    IfxBaseType() {
    }

    @Override
    public void setConnection(IfxConnection conn) {
        super.setConnection(conn);
        this.outputStream.setConnection(conn);
    }

    @Override
    public void fromIfx(byte[] b) throws SQLException {
        this.fromIfx(b, 0, b.length);
    }

    @Override
    public void fromIfx(byte[] b, int offset, int blength) throws SQLException {
        int index = offset;
        if (b[index] == 1) {
            this.nullify();
        } else {
            try {
                int length = IfxToJavaType.IfxToJavaInt(b, ++index);
                this.inputStream = new IfxUDTInput(this.conn, b, index += 4, length);
                this.unnullify();
            }
            catch (Exception e) {
                throw Messages.getSQLException(e, -79716);
            }
        }
    }

    @Override
    public byte[] toIfx() throws SQLException {
        ByteArrayOutputStream bStream = new ByteArrayOutputStream();
        int index = 0;
        if (this.isNull()) {
            byte[] bNull = new byte[]{1};
            bStream.write(bNull, index++, bNull.length);
            this.outputStream.reset();
        }
        byte[] b = JavaToIfxType.JavaToIfxInt(this.outputStream.length());
        bStream.write(b, index, b.length);
        bStream.write(this.outputStream.toByteArray(), 0, this.outputStream.length());
        return bStream.toByteArray();
    }

    @Override
    public byte[] toIfxTuple() throws SQLException {
        ByteArrayOutputStream bStream = new ByteArrayOutputStream();
        byte[] bNull = new byte[]{this.isNull() ? (byte)1 : 0};
        bStream.write(bNull, 0, 1);
        byte[] b = JavaToIfxType.JavaToIfxInt(this.outputStream.length());
        bStream.write(b, 0, b.length);
        bStream.write(this.outputStream.toByteArray(), 0, this.outputStream.length());
        return bStream.toByteArray();
    }
}

