/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxArray;
import com.informix.jdbc.IfxComplex;
import com.informix.jdbc.IfxComplexOutput;
import com.informix.lang.Messages;
import com.informix.util.TraceFlag;
import java.sql.Array;
import java.sql.SQLException;
import java.util.Collection;

public class IfxCollection
extends IfxComplex {
    public IfxCollection() throws SQLException {
        this.outputStream = new IfxComplexOutput(false, false);
    }

    @Override
    public void fromObject(Object data) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxCollection.fromObject(Object) called");
        }
        if (this.outputStream == null) {
            throw Messages.getSQLException(-79716, this.conn);
        }
        this.outputStream.reset();
        this.outputStream.setConnection(this.conn);
        if (data == null) {
            if (TraceFlag.isTraceEnabled()) {
                this.writeTrace(2, "    data is null");
            }
            this.nullify();
        } else {
            this.outputStream.setTypeMap(this.typeMap);
            if (data.getClass().isArray()) {
                IfxArray arr = new IfxArray(data, this.conn);
                data = arr;
            }
            if (data instanceof Array) {
                if (TraceFlag.isTraceEnabled()) {
                    this.writeTrace(2, "    data is instance of java.sql.Array");
                }
                this.outputStream.writeCollection((Array)data);
                this.unnullify();
            } else if (data instanceof Collection) {
                if (TraceFlag.isTraceEnabled()) {
                    this.writeTrace(2, "    data is instance of java.util.Collection");
                }
                this.outputStream.writeCollection((Collection)data);
                this.unnullify();
            } else {
                if (TraceFlag.isTraceEnabled()) {
                    this.writeTrace(2, "    fromObject(Object) object unknown");
                    this.writeTrace(2, "    object: " + data.getClass().getName());
                }
                throw Messages.getSQLException(-79728, this.conn);
            }
            String s = this.outputStream.getExtendedName();
            super.setExtendedTypeName(s);
        }
        this.setIfxType(44);
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxCollection.fromObject(Object) exited");
        }
    }

    @Override
    public void fromObject(Object data, String type) throws SQLException {
        this.outputStream = new IfxComplexOutput(false, type, this.conn);
        this.fromObject(data);
    }

    @Override
    public Collection<?> toObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        this.inputStream.setTypeMap(this.typeMap);
        return this.inputStream.readCollection();
    }

    public Array toArray() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.inputStream.readIfxArray();
    }
}

