/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.lang.Messages;
import com.informix.util.dateUtil;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

public class IfxDate
extends IfxObject {
    private Date value = null;
    public static final int IFX_DATE_NULL = Integer.MIN_VALUE;

    IfxDate() throws SQLException {
        this.setIfxType(7);
    }

    IfxDate(Date date) throws SQLException {
        this.setIfxType(7);
        this.value = date;
        if (this.value == null) {
            this.nullify();
        } else {
            this.unnullify();
        }
    }

    public Date value() {
        return this.value;
    }

    @Override
    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public byte[] toIfx() {
        return JavaToIfxType.JavaToIfxDate(this.value);
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] ret = new byte[4];
            ret[0] = -128;
            return ret;
        }
        return JavaToIfxType.JavaToIfxDate(this.value);
    }

    @Override
    public void fromIfx(byte[] b) {
        this.fromIfx(b, 0, b.length);
    }

    @Override
    public void fromIfx(byte[] b, int offset, int length) {
        this.value = IfxToJavaType.IfxToJavaDate(b, offset);
        if (this.value == null) {
            this.nullify();
        } else {
            this.unnullify();
        }
    }

    @Override
    public String toString() {
        String dateStr = null;
        if (this.isNull()) {
            return null;
        }
        try {
            dateStr = dateUtil.convertDateStr(this.value, this.conn);
        }
        catch (SQLException e) {
            dateStr = null;
            return null;
        }
        return dateStr;
    }

    @Override
    public void fromString(String str) throws SQLException {
        if (str == null) {
            this.nullify();
            return;
        }
        try {
            this.value = dateUtil.convertDateObj(str.trim(), this.conn);
            this.unnullify();
        }
        catch (IllegalArgumentException e) {
            this.nullify();
            throw Messages.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    @Override
    public Timestamp toTimestamp() {
        if (this.isNull()) {
            return null;
        }
        return new Timestamp(this.value.getTime());
    }

    @Override
    public void fromTimestamp(Timestamp timestamp) {
        if (timestamp == null) {
            this.nullify();
        } else {
            this.value = new Date(timestamp.getTime());
            this.unnullify();
        }
    }

    public void fromLocalTime(LocalTime time) throws SQLException {
        if (time == null) {
            this.nullify();
        } else {
            this.fromTime(Time.valueOf(time));
        }
    }

    public void fromLocalDate(LocalDate date) {
        if (date == null) {
            this.nullify();
        } else {
            this.value = Date.valueOf(date);
            this.unnullify();
        }
    }

    public void fromLocalDateTime(LocalDateTime date) {
        if (date == null) {
            this.nullify();
        } else {
            this.fromTimestamp(Timestamp.valueOf(date));
        }
    }

    @Override
    public Date toDate() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public void fromDate(Date date) {
        if (date == null) {
            this.nullify();
        } else {
            this.value = date;
            this.unnullify();
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this.isNull() || other == null || !(other instanceof IfxDate)) {
            return false;
        }
        IfxDate otherDate = (IfxDate)other;
        if (otherDate.isNull()) {
            return false;
        }
        return this.value.equals(otherDate.value);
    }

    @Override
    public String toUnloadString() {
        return this.toString();
    }
}

