/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;

public class IfxDecimal
extends IfxObject {
    private BigDecimal value = null;
    private short encodedLength = 0;
    protected short dec_exp = 0;
    protected short dec_pos = (short)-1;
    protected short dec_ndgts = 0;
    protected byte[] dec_dgts;
    public static final String digChar = "0123456789";
    public static final int DECSIZE = 16;
    public static final short DECPOSNULL = -1;
    public static final short DECPOSPOSITIVE = 1;
    public static final short DECPOSNEGATIVE = 0;
    public static final short DECEXPZERO = -64;
    public static final short BYTESHIFT = 8;
    public static final short BYTEMASK = 255;
    public static final short BYTESIGNED = 128;
    public static final short BYTEMASK7 = 127;

    public IfxDecimal() {
        this.setIfxType(5);
    }

    public IfxDecimal(BigDecimal n) {
        this.encodedLength = 0;
        this.setIfxType(5);
        if (n == null) {
            this.nullify();
        } else {
            this.value = n;
            this.unnullify();
        }
    }

    public IfxDecimal(byte[] b) {
        this.encodedLength = 0;
        this.setIfxType(5);
        this.convBigDecimal(b, 0, b.length);
    }

    @Override
    public byte[] toIfx() {
        if (this.isNull()) {
            byte[] cp = new byte[4];
            return cp;
        }
        short lc_dec_pos = this.dec_pos;
        short lc_dec_exp = this.dec_exp;
        short lc_dec_ndgts = this.dec_ndgts;
        byte[] lc_dec_dgts = this.dec_dgts;
        short lc_encodedLength = this.encodedLength;
        this.convFromBigDecimal(this.value);
        this.unnullify();
        byte[] temp = this.convIfx(true);
        this.dec_pos = lc_dec_pos;
        this.dec_exp = lc_dec_exp;
        this.dec_ndgts = lc_dec_ndgts;
        this.dec_dgts = lc_dec_dgts;
        this.encodedLength = lc_encodedLength;
        return temp;
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            int len = ((this.encodedLength >> 8 & 0xFF) + (this.encodedLength & 0xFF & 1) + 3) / 2 - 1 + 1;
            byte[] b = new byte[len];
            return b;
        }
        this.convFromBigDecimal(this.value);
        return this.convIfx(false);
    }

    @Override
    public void fromIfx(byte[] b, short prec) {
        this.fromIfx(b, 0, b.length, prec);
    }

    @Override
    public void fromIfx(byte[] b, int offset, int length, short prec) {
        this.encodedLength = prec;
        this.convBigDecimal(b, offset, length);
        if (this.value == null) {
            this.nullify();
        } else {
            this.unnullify();
        }
    }

    @Override
    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public byte toByte() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (byte)this.value.doubleValue();
    }

    @Override
    public void fromByte(Byte val) throws SQLException {
        this.encodedLength = 0;
        if (val == null) {
            this.nullify();
        } else {
            this.fromByte((byte)val);
        }
    }

    public void fromByte(Byte val, int scale) throws SQLException {
        this.encodedLength = 0;
        if (val == null) {
            this.nullify();
        } else {
            this.fromByte((byte)val);
            this.value = this.value.setScale(scale, 4);
        }
    }

    @Override
    public void fromByte(byte val) throws SQLException {
        this.encodedLength = 0;
        this.value = new BigDecimal((double)val);
        this.unnullify();
    }

    @Override
    public short toShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return (short)this.value.doubleValue();
    }

    @Override
    public void fromShort(Short val) throws SQLException {
        this.encodedLength = (short)1280;
        if (val == null) {
            this.nullify();
        } else {
            this.fromShort((short)val);
        }
    }

    public void fromShort(Short val, int scale) throws SQLException {
        this.encodedLength = (short)(1280 + scale);
        if (val == null) {
            this.nullify();
        } else {
            this.fromShort((short)val);
            this.value = this.value.setScale(scale, 4);
        }
    }

    @Override
    public void fromShort(short val) throws SQLException {
        this.encodedLength = (short)1280;
        this.value = new BigDecimal((double)val);
        this.unnullify();
    }

    @Override
    public int toInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return this.value.intValue();
    }

    @Override
    public void fromInt(Integer val) throws SQLException {
        this.encodedLength = (short)2560;
        if (val == null) {
            this.nullify();
        } else {
            this.fromInt((int)val);
        }
    }

    public void fromInt(Integer val, int scale) throws SQLException {
        this.encodedLength = (short)(2560 + scale);
        if (val == null) {
            this.nullify();
        } else {
            this.fromInt((int)val);
            this.value = this.value.setScale(scale, 4);
        }
    }

    @Override
    public void fromInt(int val) throws SQLException {
        this.encodedLength = (short)2560;
        this.value = new BigDecimal((double)val);
        this.unnullify();
    }

    @Override
    public long toLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        return this.value.longValue();
    }

    @Override
    public void fromLong(Long val) throws SQLException {
        this.encodedLength = (short)4864;
        if (val == null) {
            this.nullify();
        } else {
            this.fromLong((long)val);
        }
    }

    public void fromLong(Long val, int scale) throws SQLException {
        this.encodedLength = (short)(4864 + scale);
        if (val == null) {
            this.nullify();
        } else {
            this.fromLong((long)val);
            this.value = this.value.setScale(scale, 4);
        }
    }

    @Override
    public void fromLong(long val) throws SQLException {
        this.encodedLength = (short)4864;
        this.value = new BigDecimal(Long.toString(val));
        this.unnullify();
    }

    @Override
    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.value.floatValue();
    }

    @Override
    public void fromFloat(Float val) throws SQLException {
        this.encodedLength = 0;
        if (val == null) {
            this.nullify();
        } else {
            this.fromFloat(val.floatValue());
        }
    }

    public void fromFloat(Float val, int scale) throws SQLException {
        this.encodedLength = 0;
        if (val == null) {
            this.nullify();
        } else {
            this.value = new BigDecimal(val.toString());
            this.value = this.value.setScale(scale, 4);
            this.unnullify();
        }
    }

    @Override
    public void fromFloat(float val) throws SQLException {
        this.encodedLength = 0;
        this.value = new BigDecimal(Float.toString(val));
        this.unnullify();
    }

    @Override
    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this.value.doubleValue();
    }

    @Override
    public void fromDouble(Double val) throws SQLException {
        this.encodedLength = 0;
        if (val == null) {
            this.nullify();
        } else {
            this.fromDouble((double)val);
        }
    }

    public void fromDouble(Double val, int scale) throws SQLException {
        this.encodedLength = 0;
        if (val == null) {
            this.nullify();
        } else {
            this.value = new BigDecimal(val.toString());
            this.value = this.value.setScale(scale, 4);
            this.unnullify();
        }
    }

    @Override
    public void fromDouble(double val) throws SQLException {
        this.encodedLength = 0;
        this.value = new BigDecimal(Double.toString(val));
        this.unnullify();
    }

    @Override
    public BigDecimal toDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public void fromDecimal(BigDecimal val) throws SQLException {
        this.encodedLength = 0;
        if (val == null) {
            this.nullify();
        } else {
            this.value = val;
            this.unnullify();
        }
    }

    @Override
    public void fromDecimal(BigDecimal val, int scale) throws SQLException {
        this.encodedLength = 0;
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.setScale(scale, 4);
            this.unnullify();
        }
    }

    public void fromDecimal(BigDecimal val, int scale, short encodedLength) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.setScale(scale, 4);
            this.encodedLength = encodedLength;
            this.unnullify();
        }
    }

    @Override
    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.value.intValue() != 0;
    }

    @Override
    public void fromBoolean(Boolean val) throws SQLException {
        this.encodedLength = 0;
        if (val == null) {
            this.nullify();
        } else {
            this.fromBoolean((boolean)val);
        }
    }

    public void fromBoolean(Boolean val, int scale) throws SQLException {
        this.encodedLength = 0;
        if (val == null) {
            this.nullify();
        } else {
            this.fromBoolean((boolean)val);
            this.value = this.value.setScale(scale, 4);
        }
    }

    @Override
    public void fromBoolean(boolean val) throws SQLException {
        this.encodedLength = 0;
        this.value = new BigDecimal((double)(val ? 1 : 0));
        this.unnullify();
    }

    @Override
    public String toString() {
        if (this.isNull()) {
            return null;
        }
        return this.value.toString();
    }

    @Override
    public void fromString(String str) throws SQLException {
        this.encodedLength = 0;
        if (str == null) {
            this.nullify();
        } else {
            this.value = new BigDecimal(str.trim());
            this.unnullify();
        }
    }

    public void fromString(String str, int scale) throws SQLException {
        this.encodedLength = 0;
        if (str == null) {
            this.nullify();
        } else {
            this.value = new BigDecimal(str.trim());
            this.value = this.value.setScale(scale, 4);
            this.unnullify();
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this.isNull() || other == null) {
            return false;
        }
        return other instanceof IfxDecimal && this.value.equals(((IfxDecimal)other).value);
    }

    public int getScale() {
        return this.value.scale();
    }

    @Override
    public short getEncodedLength() {
        if (this.encodedLength == 0 && !this.isNull) {
            this.computeEncodedLength();
            return this.encodedLength;
        }
        return this.encodedLength;
    }

    @Override
    public void setEncodedLength(int encodedLength) {
        this.encodedLength = (short)encodedLength;
    }

    private void convBigDecimal(byte[] b, int offset, int length) {
        String digitString;
        int start = offset;
        if (b[start] == 0 && b[start + 1] == 0) {
            this.value = null;
            return;
        }
        this.dec_ndgts = offset == 0 ? (short)(length - start - 1) : (short)(((this.encodedLength >> 8 & 0xFF) + (this.encodedLength & 0xFF & 1) + 3) / 2 - 1);
        this.dec_dgts = new byte[this.dec_ndgts];
        IfxDecimal.bycopy(b, start + 1, this.dec_dgts, 0);
        short expon = b[start];
        this.dec_pos = 1;
        if ((expon & 0x80) == 0) {
            IfxDecimal.decComplement(this.dec_dgts, 0);
            expon = (short)(expon ^ 0x7F);
            this.dec_pos = 0;
        }
        this.dec_exp = expon = (short)((expon & 0x7F) - 64);
        int[] scale = new int[1];
        if (this.encodedLength != 0) {
            scale[0] = IfxDecimal.precDec(this.encodedLength);
            if (scale[0] == 255) {
                scale[0] = -1;
            }
        } else {
            scale[0] = -1;
        }
        this.value = (digitString = this.stringValue(scale)) == null ? null : new BigDecimal(new BigInteger(digitString), scale[0]);
        if (this.value == null) {
            this.nullify();
        } else {
            this.unnullify();
        }
    }

    private void convFromBigDecimal(BigDecimal value) {
        int j;
        int first = 0;
        int exp = 0;
        int upnxt = 0;
        boolean zero = false;
        this.dec_pos = 1;
        String str = value.unscaledValue().toString();
        int scale = value.scale();
        int buflen = str.length();
        char nxt = str.charAt(0);
        if (nxt == '-') {
            this.dec_pos = 0;
            ++first;
            --buflen;
        } else if (nxt == '+') {
            ++first;
            --buflen;
        }
        exp = buflen - scale;
        if (value.compareTo(BigDecimal.ZERO) == 0) {
            this.dec_exp = (short)-64;
        } else if (exp % 2 != 0) {
            ++buflen;
            this.dec_exp = (short)((exp + 1) / 2);
            upnxt = 1;
            zero = true;
        } else {
            this.dec_exp = (short)(exp / 2);
        }
        byte[] unpack = new byte[buflen];
        for (int i = first; i < str.length(); ++i) {
            int ind = digChar.indexOf(str.charAt(i));
            unpack[upnxt] = (byte)ind;
            ++upnxt;
        }
        buflen = (unpack = this.adjust(unpack, zero, first, str, value)).length;
        this.dec_ndgts = buflen % 2 == 1 ? (short)(buflen / 2 + 1) : (short)(buflen / 2);
        this.dec_dgts = new byte[this.dec_ndgts];
        for (j = 0; j < buflen / 2; ++j) {
            this.dec_dgts[j] = (byte)(unpack[2 * j] * 10 + unpack[2 * j + 1]);
        }
        if (buflen % 2 == 1) {
            this.dec_dgts[j] = (byte)(unpack[2 * j] * 10);
        }
        if (this.encodedLength == 0) {
            this.computeEncodedLength();
        } else {
            this.dec_ndgts = (short)(((this.encodedLength >> 8 & 0xFF) + (this.encodedLength & 0xFF & 1) + 3) / 2 - 1);
        }
    }

    private byte[] adjust(byte[] unpack, boolean zero, int first, String str, BigDecimal value) {
        int ndgtsGood;
        int totalDigits;
        int scale = 0;
        if (this.encodedLength != 0) {
            totalDigits = IfxDecimal.precTot(this.encodedLength);
            ndgtsGood = totalDigits / 2;
            if (totalDigits % 2 == 1) {
                ++ndgtsGood;
            }
            scale = IfxDecimal.precDec(this.encodedLength) / 2;
        } else {
            totalDigits = 32;
            ndgtsGood = 16;
        }
        byte[] b = unpack;
        int truelen = zero ? unpack.length - 1 : unpack.length;
        if (truelen > totalDigits) {
            BigInteger bi = value.unscaledValue().abs();
            BigInteger biTen = new BigInteger("10");
            BigInteger biDivide = new BigInteger("1");
            for (int i = 0; i < truelen - totalDigits; ++i) {
                biDivide = biDivide.multiply(biTen);
            }
            BigInteger[] biAndRemainder = bi.divideAndRemainder(biDivide);
            int remainder = 0;
            int offset = 0;
            if (zero) {
                ++offset;
            }
            if (unpack.length > totalDigits + offset) {
                remainder = unpack[totalDigits + offset];
            }
            remainder *= 10;
            if (unpack.length > totalDigits + offset + 1) {
                remainder += unpack[totalDigits + offset + 1];
            }
            if (remainder >= 50) {
                biAndRemainder[0] = biAndRemainder[0].add(new BigInteger("1"));
            }
            String tmpStr = biAndRemainder[0].toString();
            int index = 0;
            if (zero || str.charAt(first) == '0') {
                ++index;
            }
            byte[] newB = null;
            newB = zero ? (totalDigits == 0 ? new byte[totalDigits + 2] : new byte[totalDigits + 1]) : new byte[totalDigits];
            int i = 0;
            while (i < tmpStr.length()) {
                int ind = digChar.indexOf(tmpStr.charAt(i));
                if (ind != -1) {
                    newB[index] = (byte)ind;
                }
                ++i;
                ++index;
            }
            b = newB;
        } else if (unpack.length < totalDigits && scale != 0 && this.encodedLength != 0) {
            b = new byte[totalDigits];
            System.arraycopy(unpack, 0, b, 0, unpack.length);
        }
        return b;
    }

    protected void computeEncodedLength() {
        if (this.dec_ndgts == 0 || this.dec_pos == -1) {
            this.encodedLength = 0;
            return;
        }
        int scale = 2 * (this.dec_ndgts - this.dec_exp);
        int prec = 2 * this.dec_ndgts;
        if (this.dec_dgts[this.dec_ndgts - 1] % 10 == 0) {
            --scale;
            --prec;
        }
        if (this.dec_dgts[0] < 10) {
            --prec;
        }
        if (scale < 0) {
            prec += -scale;
            scale = 0;
        }
        this.encodedLength = (short)(((byte)prec << 8) + scale);
    }

    protected int extractExponent(String num, int start) {
        int i;
        int exp = 0;
        boolean sign = true;
        for (i = start; i < num.length() && num.charAt(i) != 'E'; ++i) {
        }
        if (i == num.length()) {
            return exp;
        }
        if (num.charAt(++i) == '+') {
            ++i;
        } else if (num.charAt(i) == '-') {
            ++i;
            sign = false;
        }
        for (int j = i; j < num.length(); ++j) {
            exp = exp * 10 + digChar.indexOf(num.charAt(j));
        }
        return sign ? exp : -exp;
    }

    private byte[] convIfx(boolean prependLength) {
        int prep = prependLength ? 2 : 0;
        byte[] cp = new byte[this.dec_ndgts + 1 + prep];
        boolean bp = false;
        if (prependLength) {
            int len = this.dec_ndgts + 1;
            cp[0] = (byte)(len >> 8 & 0xFF);
            cp[1] = (byte)(len & 0xFF);
        }
        if (this.dec_pos == -1) {
            return cp;
        }
        cp[prep] = (byte)(this.dec_exp + 64 & 0x7F);
        IfxDecimal.bycopy(this.dec_dgts, 0, cp, prep + 1);
        if (this.dec_pos == 0) {
            if (this.dec_ndgts == 0) {
                int n = prep;
                cp[n] = (byte)(cp[n] | 0x80);
            } else {
                IfxDecimal.decComplement(cp, 1 + prep);
                int n = prep;
                cp[n] = (byte)(cp[n] ^ 0x7F);
            }
        } else {
            int n = prep;
            cp[n] = (byte)(cp[n] | 0x80);
        }
        return cp;
    }

    private static char[] charfill(char[] b, int from, int to, char f) {
        for (int i = from; i <= to && i < b.length; ++i) {
            b[i] = f;
        }
        return b;
    }

    private static void bycopy(byte[] from, int fromStart, byte[] to, int toStart) {
        int j = toStart;
        for (int i = fromStart; i < from.length && j < to.length; ++i, ++j) {
            to[j] = from[i];
        }
    }

    private static void charcopy(char[] from, int fromStart, int fromEnd, char[] to, int toStart) {
        int j = toStart;
        for (int i = fromStart; i < from.length && i <= fromEnd && j < to.length; ++i, ++j) {
            to[j] = from[i];
        }
    }

    private static byte[] decComplement(byte[] b, int start) {
        int digit = 100;
        for (int bp = b.length - 1; bp >= start; --bp) {
            if (b[bp] == 0 && digit == 100) continue;
            b[bp] = (byte)(digit - b[bp]);
            digit = 99;
        }
        return b;
    }

    private char[] sigdigToChar() {
        char[] digits = new char[this.dec_ndgts * 2];
        for (int i = 0; i < this.dec_ndgts; ++i) {
            digits[i * 2] = digChar.charAt(this.dec_dgts[i] / 10);
            digits[i * 2 + 1] = digChar.charAt(this.dec_dgts[i] % 10);
        }
        return digits;
    }

    private String stringValue(int[] scale) {
        int i;
        char[] buf;
        int bufsize;
        int sigDigCnt;
        if (this.dec_pos == -1) {
            return null;
        }
        if (this.dec_ndgts <= 0) {
            if (scale[0] == -1) {
                scale[0] = 0;
            }
            return "0";
        }
        int exp = this.dec_exp * 2;
        int sign = 0;
        int tzeros = 0;
        int lzeros = 0;
        boolean round_check = false;
        if (scale[0] == -1) {
            if (sigDigCnt > exp) {
                for (sigDigCnt = this.dec_ndgts * 2; sigDigCnt > 0; sigDigCnt -= 2) {
                    if (sigDigCnt > exp + 1 && this.dec_dgts[sigDigCnt / 2 - 1] == 0) {
                        continue;
                    }
                    if (sigDigCnt < exp + 1 || this.dec_dgts[sigDigCnt / 2 - 1] % 10 != 0) break;
                    --sigDigCnt;
                    break;
                }
                if (sigDigCnt <= 0) {
                    scale[0] = 0;
                    return "0";
                }
                scale[0] = sigDigCnt - exp;
            } else {
                scale[0] = 0;
                tzeros = exp - sigDigCnt;
            }
            bufsize = sigDigCnt + tzeros;
        } else if (scale[0] == sigDigCnt - exp) {
            bufsize = sigDigCnt;
        } else if (scale[0] > sigDigCnt - exp) {
            tzeros = scale[0] - (sigDigCnt - exp);
            if (exp < 0) {
                lzeros = -exp;
                bufsize = scale[0];
            } else {
                bufsize = sigDigCnt + tzeros;
            }
        } else if (exp >= 0) {
            bufsize = exp + scale[0];
            round_check = true;
        } else {
            if (-exp > scale[0]) {
                return "0";
            }
            bufsize = scale[0];
            lzeros = -exp;
            round_check = true;
        }
        if (this.dec_pos == 0) {
            buf = new char[1 + bufsize];
            buf[0] = 45;
            sign = 1;
        } else {
            buf = new char[bufsize];
        }
        if (lzeros > 0) {
            IfxDecimal.charfill(buf, sign, sign + lzeros - 1, '0');
        }
        for (i = 0; i < this.dec_ndgts && sign + lzeros + i * 2 + 1 < buf.length; ++i) {
            buf[sign + lzeros + i * 2] = digChar.charAt(this.dec_dgts[i] / 10);
            buf[sign + lzeros + i * 2 + 1] = digChar.charAt(this.dec_dgts[i] % 10);
        }
        if (sign + lzeros + i * 2 < buf.length && i < this.dec_ndgts) {
            buf[sign + lzeros + i * 2] = digChar.charAt(this.dec_dgts[i] / 10);
        }
        if (tzeros > 0) {
            IfxDecimal.charfill(buf, sign + lzeros + sigDigCnt, buf.length - 1, '0');
        } else if (round_check) {
            boolean roundloop = false;
            if (sign + lzeros + i * 2 < buf.length) {
                if (this.dec_dgts[i] % 10 >= 5) {
                    if (this.dec_dgts[i] / 10 == 9) {
                        buf[sign + lzeros + i * 2] = 48;
                        roundloop = true;
                    } else {
                        buf[sign + lzeros + i * 2] = digChar.charAt(digChar.indexOf(buf[sign + lzeros + i * 2]) + 1);
                    }
                }
            } else if (this.dec_dgts[i] / 10 >= 5) {
                roundloop = true;
            }
            if (roundloop) {
                int j;
                for (j = sign + lzeros + (i - 1) * 2 + 1; j >= sign; --j) {
                    if (buf[j] != '9') {
                        buf[j] = digChar.charAt(digChar.indexOf(buf[j]) + 1);
                        break;
                    }
                    buf[j] = 48;
                }
                if (j < sign) {
                    char[] buf1 = new char[buf.length + 1];
                    int k = 0;
                    if (sign == 1) {
                        buf1[k++] = 45;
                    }
                    buf1[k++] = 49;
                    while (k < buf1.length) {
                        buf1[k] = 48;
                        ++k;
                    }
                    return new String(buf1);
                }
            }
        }
        return new String(buf);
    }

    private static char[] trimZerosFB(char[] ibuf, int start) {
        int right;
        int left;
        for (left = start; left < ibuf.length && ibuf[left] == '0'; ++left) {
        }
        if (left == ibuf.length) {
            char[] obuf2 = new char[2];
            obuf2[1] = 48;
            return obuf2;
        }
        for (right = ibuf.length - 1; right >= left && ibuf[right] == '0'; --right) {
        }
        char[] obuf = new char[right - left + 2];
        int j = 1;
        int i = left;
        while (i <= right) {
            obuf[j] = ibuf[i];
            ++i;
            ++j;
        }
        return obuf;
    }

    protected static int precTot(int length) {
        return length >> 8 & 0xFF;
    }

    protected static int precDec(int length) {
        return length & 0xFF;
    }

    protected static int decLength(int length) {
        int tot = IfxDecimal.precTot(length);
        int prec = IfxDecimal.precDec(length);
        int len = (tot + (prec & 1) + 3) / 2;
        return len;
    }

    protected static String getIfxTypeName(int length) {
        int precdec = IfxDecimal.precDec(length);
        if (precdec == 255) {
            return "decimal(16)";
        }
        return "decimal(" + IfxDecimal.precTot(length) + ", " + precdec + ")";
    }
}

